/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.DisposableEditorPanel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ssh.common.ServerDescription;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.EditorAdapter;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import icons.WebDeploymentIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTransferToolWindow {
    @NonNls
    public static final String ID = "File Transfer";
    public static final DeploymentNotifier.ToolWindowIdProvider ID_PROVIDER = new DeploymentNotifier.ToolWindowIdProvider("File Transfer");
    private static final Key<EditorAdapter> EDITOR_KEY = Key.create((String)"EDITOR_ADAPTER");
    private static final int BUFFER_SIZE = 0x100000;

    public static void printWithTimestamp(@Nullable Project project, Mappable config, String text, ConsoleViewContentType contentType, PublishConfig.TraceLevel traceLevel) {
        if (traceLevel.enabled(contentType)) {
            FileTransferToolWindow.printWithTimestamp(project, config, text, contentType);
        }
    }

    public static void printWithTimestamp(@Nullable Project project, Mappable config, String text, ConsoleViewContentType contentType) {
        String message = "[" + DateFormatUtil.formatDateTime((long)Clock.getTime()) + "] " + text;
        FileTransferToolWindow.print(project, config, message, contentType);
    }

    public static void print(@Nullable Project project, @Nullable ServerDescription config, String text, ConsoleViewContentType contentType) {
        if (project == null || project.isDisposed() || project.isDefault()) {
            return;
        }
        Runnable r = () -> {
            if (project.isDisposed() || project.isDefault()) {
                return;
            }
            Content content = FileTransferToolWindow.getToolWindowContent(project, config, contentType == ConsoleViewContentType.ERROR_OUTPUT, contentType == ConsoleViewContentType.ERROR_OUTPUT);
            ((EditorAdapter)content.getUserData(EDITOR_KEY)).appendString(text, contentType.getAttributes());
        };
        ApplicationManager.getApplication().invokeLater(r);
    }

    private static Content getToolWindowContent(@NotNull Project project, @Nullable ServerDescription server, boolean show, boolean select) {
        ToolWindow toolWindow;
        if (project == null) {
            FileTransferToolWindow.$$$reportNull$$$0(0);
        }
        if ((toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ID)) == null) {
            toolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow(ID, true, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
            toolWindow.setAvailable(true, null);
            toolWindow.setIcon(WebDeploymentIcons.TransferToolWindow);
            toolWindow.setToHideOnEmptyContent(true);
            toolWindow.show(null);
        } else if (show) {
            toolWindow.show(null);
        }
        return FileTransferToolWindow.findOrCreateContent(project, toolWindow, server, select);
    }

    private static Content findOrCreateContent(@NotNull Project project, ToolWindow toolWindow, @Nullable ServerDescription server, boolean select) {
        if (project == null) {
            FileTransferToolWindow.$$$reportNull$$$0(1);
        }
        String serverName = server != null ? server.getName() : ID;
        Content content = toolWindow.getContentManager().findContent(serverName);
        if (content == null) {
            EditorFactory editorFactory = EditorFactory.getInstance();
            Document document = editorFactory.createDocument((CharSequence)"");
            document.setCyclicBufferSize(0x100000);
            final Editor editor = editorFactory.createViewer(document, project);
            EditorSettings editorSettings = editor.getSettings();
            editorSettings.setLineMarkerAreaShown(false);
            editorSettings.setIndentGuidesShown(false);
            editorSettings.setLineNumbersShown(false);
            editorSettings.setFoldingOutlineShown(false);
            editorSettings.setRightMarginShown(false);
            ((EditorEx)editor).installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(){

                public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DefaultActionGroup group = new DefaultActionGroup();
                    group.add((AnAction)new ClearAllAction(editor));
                    group.add((AnAction)new CopyAction(editor));
                    group.addSeparator();
                    ActionManager actionManager = ActionManager.getInstance();
                    group.add(actionManager.getAction("CompareClipboardWithSelection"));
                    return group;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/webDeployment/ui/FileTransferToolWindow$1", "getActionGroup"));
                }
            });
            editor.setBorder(null);
            content = ContentFactory.SERVICE.getInstance().createContent((JComponent)new DisposableEditorPanel(editor), serverName, true);
            content.setIcon(server != null ? server.getIcon() : WebDeploymentIcons.Ftp);
            content.putUserData(EDITOR_KEY, (Object)new EditorAdapter(editor, project, true));
            toolWindow.getContentManager().addContent(content);
        }
        if (select) {
            toolWindow.getContentManager().setSelectedContent(content);
        }
        return content;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/FileTransferToolWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getToolWindowContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrCreateContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CopyAction
    extends AnAction {
        private final Editor myEditor;

        private CopyAction(Editor editor) {
            super(editor != null && editor.getSelectionModel().hasSelection() ? ExecutionBundle.message((String)"copy.selected.content.action.name", (Object[])new Object[0]) : ExecutionBundle.message((String)"copy.content.action.name", (Object[])new Object[0]));
            this.myEditor = editor;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            if (this.myEditor.getSelectionModel().hasSelection()) {
                this.myEditor.getSelectionModel().copySelectionToClipboard();
            } else {
                this.myEditor.getSelectionModel().setSelection(0, this.myEditor.getDocument().getTextLength());
                this.myEditor.getSelectionModel().copySelectionToClipboard();
                this.myEditor.getSelectionModel().removeSelection();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/FileTransferToolWindow$CopyAction", "actionPerformed"));
        }
    }

    private static class ClearAllAction
    extends AnAction {
        private final Editor myEditor;

        private ClearAllAction(Editor editor) {
            super(ExecutionBundle.message((String)"clear.all.from.console.action.name", (Object[])new Object[0]));
            this.myEditor = editor;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAllAction.$$$reportNull$$$0(0);
            }
            final Document document = this.myEditor.getDocument();
            ApplicationManager.getApplication().runWriteAction((Runnable)new DocumentRunnable(document, this.myEditor.getProject()){

                public void run() {
                    CommandProcessor.getInstance().executeCommand(myEditor.getProject(), () -> document.deleteString(0, document.getTextLength()), null, (Object)DocCommandGroupId.noneGroupId((Document)document));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/FileTransferToolWindow$ClearAllAction", "actionPerformed"));
        }
    }
}

