/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ConjunctionPredicate;
import org.jetbrains.annotations.NotNull;

public class JSFlipConjunctionIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        JSBinaryExpression binaryExpression = (JSBinaryExpression)element;
        IElementType sign = binaryExpression.getOperationSign();
        return this.getText(sign == JSTokenTypes.ANDAND ? "&&" : "||");
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ConjunctionPredicate conjunctionPredicate = new ConjunctionPredicate();
        if (conjunctionPredicate == null) {
            JSFlipConjunctionIntention.$$$reportNull$$$0(0);
        }
        return conjunctionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSFlipConjunctionIntention.$$$reportNull$$$0(1);
        }
        JSBinaryExpression binaryExpression = (JSBinaryExpression)element;
        IElementType sign = binaryExpression.getOperationSign();
        JSBinaryExpression exp = ConjunctionPredicate.getTopConjunction(binaryExpression, sign);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)this.flipExpression((JSExpression)exp, sign, binaryExpression.getOperationNode()));
    }

    private String flipExpression(JSExpression exp, IElementType conjunctionType, ASTNode node) {
        if (ConjunctionPredicate.isConjunctionExpression((JSElement)exp, conjunctionType)) {
            JSBinaryExpression andExpression = (JSBinaryExpression)exp;
            return this.flipExpression(andExpression.getROperand(), conjunctionType, node) + ' ' + node.getText() + ' ' + this.flipExpression(andExpression.getLOperand(), conjunctionType, node);
        }
        return exp.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/bool/JSFlipConjunctionIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/bool/JSFlipConjunctionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

