/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ComparisonPredicate;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NotNull;

public class JSNegateComparisonIntention
extends JSMutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        JSBinaryExpression expression = (JSBinaryExpression)element;
        String operatorText = "";
        String negatedOperatorText = "";
        if (expression != null) {
            IElementType sign = expression.getOperationSign();
            operatorText = ComparisonUtils.getOperatorText((IElementType)sign);
            negatedOperatorText = ComparisonUtils.getNegatedOperatorText((IElementType)sign);
        }
        if (operatorText.equals(negatedOperatorText)) {
            return this.getSuffixedDisplayName("equals", operatorText);
        }
        return this.getSuffixedDisplayName("not-equals", operatorText, negatedOperatorText);
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ComparisonPredicate comparisonPredicate = new ComparisonPredicate();
        if (comparisonPredicate == null) {
            JSNegateComparisonIntention.$$$reportNull$$$0(0);
        }
        return comparisonPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSNegateComparisonIntention.$$$reportNull$$$0(1);
        }
        JSBinaryExpression exp = (JSBinaryExpression)element;
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType sign = exp.getOperationSign();
        String negatedOperator = ComparisonUtils.getNegatedOperatorText((IElementType)sign);
        String lhsText = lhs.getText();
        assert (rhs != null);
        ConditionalUtils.replaceExpressionWithNegatedExpressionString((JSExpression)exp, lhsText + negatedOperator + rhs.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/bool/JSNegateComparisonIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/bool/JSNegateComparisonIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

