/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.lang.ecmascript6.psi.impl.ES6FieldStatementImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.initialization.JSSplitDeclarationAndInitializationIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReplaceConditionalWithIfIntention
extends JSMutablyNamedIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = element -> {
            if (!(element instanceof JSConditionalExpression)) {
                return false;
            }
            JSConditionalExpression condExpr = (JSConditionalExpression)element;
            JSSourceElement statementCandidate = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)condExpr, (Class[])new Class[]{JSStatement.class, JSFunction.class});
            if (!(statementCandidate instanceof JSStatement) || statementCandidate instanceof ES6FieldStatementImpl) {
                return false;
            }
            return condExpr.getCondition() != null && condExpr.getThen() != null && condExpr.getElse() != null;
        };
        if (jSElementPredicate == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(0);
        }
        return jSElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(1);
        }
        JSConditionalExpression conditional = (JSConditionalExpression)element;
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        JSExpression topExpression = JSReplaceConditionalWithIfIntention.getTopExpressionInStatement(conditional);
        assert (statement != null);
        if (topExpression.getParent() instanceof JSInitializerOwner && topExpression.getParent().getParent() == statement && statement instanceof JSVarStatement) {
            String prefix;
            JSVarStatement varStatement = (JSVarStatement)statement;
            JSInitializerOwner declaration = (JSInitializerOwner)topExpression.getParent();
            JSExpression initializer = declaration.getInitializer();
            if (initializer == null) {
                return;
            }
            String postfix = JSCodeStyleSettings.getSemicolon((PsiElement)declaration);
            if (declaration instanceof JSDestructuringElement) {
                JSDestructuringContainer target = ((JSDestructuringElement)declaration).getTarget();
                if (target instanceof JSDestructuringObject) {
                    prefix = "(" + target.getText();
                    postfix = ")" + postfix;
                } else {
                    prefix = target.getText();
                }
            } else {
                prefix = declaration.getName();
            }
            List allVars = declaration instanceof JSVariable ? Collections.singletonList((JSVariable)declaration) : SyntaxTraverser.psiTraverser((PsiElement)declaration).filter(JSVariable.class).toList();
            Set varNames = ContainerUtil.map2Set((Collection)allVars, v -> v.getName());
            LinkedList<JSInitializerOwner> after = new LinkedList<JSInitializerOwner>();
            boolean occurred = false;
            boolean isConst = varStatement.getVarKeyword() == JSVarStatement.VarKeyword.CONST;
            for (JSInitializerOwner statementDeclaration : varStatement.getDeclarations()) {
                if (statementDeclaration == declaration) {
                    occurred = true;
                    continue;
                }
                if (!occurred) continue;
                JSExpression expression = statementDeclaration.getInitializer();
                if (!isConst && !SyntaxTraverser.psiTraverser((PsiElement)expression).filter(JSReferenceExpression.class).filter(e -> JSReplaceConditionalWithIfIntention.isSuitableReference(allVars, varNames, e)).isNotEmpty()) continue;
                after.add(statementDeclaration);
            }
            if (!after.isEmpty()) {
                String statementText = Objects.requireNonNull(varStatement.getVarKeyword()).getText() + " " + StringUtil.join(after, e -> e.getText(), (String)", ") + JSCodeStyleSettings.getSemicolon((PsiElement)varStatement);
                varStatement.getParent().addAfter((PsiElement)JSPsiElementFactory.createJSStatement((String)statementText, (PsiElement)statement), (PsiElement)varStatement);
                for (JSInitializerOwner owner : after) {
                    owner.delete();
                }
            }
            String assignmentText = JSReplaceConditionalWithIfIntention.getReplacementText(prefix + " = ", postfix, conditional, (JSElement)initializer);
            String declarationText = JSSplitDeclarationAndInitializationIntention.getDeclarationStatementText(varStatement, (Condition<? super JSVariable>)((Condition)variable -> PsiTreeUtil.isAncestor((PsiElement)declaration, (PsiElement)variable, (boolean)false)));
            JSStatement declarationStatement = JSPsiElementFactory.createJSStatement((String)declarationText, (PsiElement)varStatement);
            JSStatement assignmentStatement = JSPsiElementFactory.createJSStatement((String)assignmentText, (PsiElement)declaration);
            declarationStatement = varStatement.replace(declarationStatement);
            JSChangeUtil.doAddAfter((PsiElement)declarationStatement.getParent(), (PsiElement)assignmentStatement, (PsiElement)declarationStatement);
        } else {
            JSRefactoringUtil.replaceStatementAndReformat((JSStatement)statement, (String)JSReplaceConditionalWithIfIntention.getReplacementText("", "", conditional, (JSElement)statement));
        }
    }

    private static boolean isSuitableReference(List<JSVariable> allVars, Set<String> varNames, JSReferenceExpression e) {
        return e.getQualifier() == null && varNames.contains(e.getReferenceName()) && allVars.contains(e.resolve());
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        JSSourceElement statementCandidate = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSStatement.class, JSFunction.class});
        if (statementCandidate instanceof JSVarStatement && ((JSVarStatement)statementCandidate).getVarKeyword() == JSVarStatement.VarKeyword.CONST) {
            return JSIntentionBundle.message("conditional.replace-conditional-with-if.let.display-name", new Object[0]);
        }
        return JSIntentionBundle.message("conditional.replace-conditional-with-if.display-name", new Object[0]);
    }

    @NotNull
    private static JSExpression getTopExpressionInStatement(@NotNull JSConditionalExpression conditional) {
        if (conditional == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(2);
        }
        JSConditionalExpression result = conditional;
        while (true) {
            JSExpression next;
            if ((next = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)result, JSExpression.class, (boolean)true, (Class[])new Class[]{JSSourceElement.class})) == null) {
                JSConditionalExpression jSConditionalExpression = result;
                if (jSConditionalExpression == null) {
                    JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(3);
                }
                return jSConditionalExpression;
            }
            result = next;
        }
    }

    @NotNull
    private static String getReplacementText(@NotNull String prefix, String postfix, @NotNull JSConditionalExpression conditional, @NotNull JSElement toReplace) {
        if (prefix == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(4);
        }
        if (conditional == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(5);
        }
        if (toReplace == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(6);
        }
        String statementText = toReplace.getText();
        String conditionalText = JSUtils.getTopmostParenthesizedOrSelf((JSExpression)conditional).getText();
        int conditionalIndex = statementText.indexOf(conditionalText);
        String statementStart = statementText.substring(0, conditionalIndex);
        String statementEnd = statementText.substring(conditionalIndex + conditionalText.length());
        String condition = JSReplaceConditionalWithIfIntention.getNonNullExpression(conditional.getCondition());
        String thenExpression = JSReplaceConditionalWithIfIntention.getNonNullExpression(conditional.getThen());
        String elseExpression = JSReplaceConditionalWithIfIntention.getNonNullExpression(conditional.getElse());
        String string = "if (" + condition + ") {" + prefix + statementStart + thenExpression + statementEnd + postfix + "} else {" + prefix + statementStart + elseExpression + statementEnd + postfix + '}';
        if (string == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String getNonNullExpression(@Nullable JSExpression condition) {
        JSExpression expression = JSParenthesesUtils.stripParentheses((JSExpression)condition);
        String string = expression != null ? expression.getText() : "";
        if (string == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/conditional/JSReplaceConditionalWithIfIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditional";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/conditional/JSReplaceConditionalWithIfIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopExpressionInStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonNullExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTopExpressionInStatement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

