/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import java.net.InetAddress;
import java.util.regex.Pattern;

public final class NetUtil {
    private static final Pattern IPV4_PATTERN = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])", 2);
    private static final Pattern IPV6_PATTERN = Pattern.compile("([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}", 2);

    private NetUtil() {
    }

    public static String getHostName(String _ipAddress) {
        try {
            InetAddress addr = InetAddress.getByName(_ipAddress);
            return addr.getHostName();
        }
        catch (Exception _ex) {
            return _ipAddress;
        }
    }

    public static boolean isIPv4Address(String _ipAddress) {
        return IPV4_PATTERN.matcher(_ipAddress).matches();
    }

    public static boolean isIPv6Address(String _ipAddress) {
        return IPV6_PATTERN.matcher(_ipAddress).matches();
    }

    public static boolean isIPv4orIPv6Address(String _ipAddress) {
        return IPV4_PATTERN.matcher(_ipAddress).matches() || IPV6_PATTERN.matcher(_ipAddress).matches();
    }
}

