/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins.ruby;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.ide.navigation.plugins.PuppetExtFunctionInfo;
import com.intellij.lang.puppet.ide.navigation.plugins.ruby.RubyFunctionIndexer;
import com.intellij.lang.puppet.ide.navigation.plugins.ruby.RubyTypeIndexer;
import com.intellij.lang.puppet.psi.PuppetLazyProxyLightElement;
import com.intellij.lang.puppet.psi.resolve.PuppetNamedPsiElementProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetRubyPluginsIndex
extends FileBasedIndexExtension<EntryKey, PuppetExtFunctionInfo> {
    public static final ID<EntryKey, PuppetExtFunctionInfo> KEY = ID.create((String)"PuppetRubyPluginsIndex");
    private static final MyKeyDescriptor KEY_DESCRIPTOR = new MyKeyDescriptor();
    private static final int VERSION = 2;
    private static final String EXT_RUBY = "rb";

    @NotNull
    public ID<EntryKey, PuppetExtFunctionInfo> getName() {
        ID<EntryKey, PuppetExtFunctionInfo> iD = KEY;
        if (iD == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<EntryKey, PuppetExtFunctionInfo, FileContent> getIndexer() {
        DataIndexer<EntryKey, PuppetExtFunctionInfo, FileContent> dataIndexer = new DataIndexer<EntryKey, PuppetExtFunctionInfo, FileContent>(){

            @NotNull
            public Map<EntryKey, PuppetExtFunctionInfo> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                VirtualFile file = inputData.getFile();
                SymbolType symbolType = PuppetRubyPluginsIndex.getSymbolTypeByFileLocation(file);
                assert (symbolType != null) : "Input filter should have filtered this!";
                Map map = symbolType.myIndexer.map((Object)inputData);
                if (map == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<EntryKey> getKeyDescriptor() {
        MyKeyDescriptor myKeyDescriptor = KEY_DESCRIPTOR;
        if (myKeyDescriptor == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(2);
        }
        return myKeyDescriptor;
    }

    @NotNull
    public DataExternalizer<PuppetExtFunctionInfo> getValueExternalizer() {
        DataExternalizer<PuppetExtFunctionInfo> dataExternalizer = PuppetExtFunctionInfo.EXTERNALIZER;
        if (dataExternalizer == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = file -> {
            if (!EXT_RUBY.equals(file.getExtension())) {
                return false;
            }
            return PuppetRubyPluginsIndex.getSymbolTypeByFileLocation(file) != null;
        };
        if (inputFilter == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 2;
    }

    public static List<PsiElement> findElementsByKey(@NotNull SymbolType type, @NotNull String key, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (type == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(5);
        }
        if (key == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(7);
        }
        if (searchScope == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(8);
        }
        List<PuppetExtFunctionInfo> values = PuppetRubyPluginsIndex.getSymbolsByKey(type, key, searchScope);
        return ContainerUtil.mapNotNull(values, info -> PuppetRubyPluginsIndex.getLightProxyElement(project, key, info.getContainingFile(), info.getOffsetInFile(), type));
    }

    @NotNull
    public static List<PuppetExtFunctionInfo> getSymbolsByKey(@NotNull SymbolType type, @NotNull String key, @NotNull GlobalSearchScope searchScope) {
        if (type == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(9);
        }
        if (key == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(11);
        }
        List list = FileBasedIndex.getInstance().getValues(KEY, (Object)new EntryKey(type, key), searchScope);
        if (list == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(12);
        }
        return list;
    }

    public static void processElementParameters(@NotNull SymbolType type, @NotNull String key, @NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull PuppetNamedPsiElementProcessor processor) {
        if (type == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(13);
        }
        if (key == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(14);
        }
        if (project == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(17);
        }
        for (PuppetExtFunctionInfo typeInfo : PuppetRubyPluginsIndex.getSymbolsByKey(type, key, searchScope)) {
            for (PuppetExtFunctionInfo.PuppetExtParamInfo info : typeInfo.getParamInfos()) {
                String paramName = info.getParamName();
                processor.executeWithName(paramName, PuppetRubyPluginsIndex.getLightProxyElement(project, paramName, typeInfo.getContainingFile(), info.getOffsetInFile(), type));
            }
        }
    }

    @NotNull
    private static PsiElement getLightProxyElement(@NotNull Project project, @NotNull String name, @NotNull String fileUrl, int offset, SymbolType type) {
        if (project == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(18);
        }
        if (name == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(19);
        }
        if (fileUrl == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(20);
        }
        PuppetLazyProxyLightElement puppetLazyProxyLightElement = new PuppetLazyProxyLightElement(project, name, fileUrl, offset, type.getTypeName());
        if (puppetLazyProxyLightElement == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(21);
        }
        return puppetLazyProxyLightElement;
    }

    public static void processAllElements(@NotNull SymbolType symbolType, @NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull PuppetNamedPsiElementProcessor processor) {
        if (symbolType == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(22);
        }
        if (project == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(23);
        }
        if (searchScope == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(25);
        }
        FileBasedIndex.getInstance().processAllKeys(KEY, s -> {
            if (((EntryKey)s).mySymbolType != symbolType) {
                return true;
            }
            for (PsiElement targetElement : PuppetRubyPluginsIndex.findElementsByKey(symbolType, ((EntryKey)s).mySymbolName, project, searchScope)) {
                processor.executeWithName(((EntryKey)s).mySymbolName, targetElement);
            }
            return true;
        }, project);
    }

    @Nullable
    private static SymbolType getSymbolTypeByFileLocation(@NotNull VirtualFile file) {
        if (file == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(26);
        }
        assert (!file.isDirectory());
        for (SymbolType type : SymbolType.values()) {
            if (!PuppetRubyPluginsIndex.isInLocationForType(file, type)) continue;
            return type;
        }
        return null;
    }

    private static boolean isInLocationForType(@NotNull VirtualFile file, @NotNull SymbolType type) {
        if (file == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(27);
        }
        if (type == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(28);
        }
        Collection locations = type.myLocations;
        VirtualFile currentDir = file;
        block0: for (List location : locations) {
            for (int i = location.size() - 1; i >= 0; --i) {
                VirtualFile nextDir = currentDir.getParent();
                if (nextDir == null || !nextDir.getName().equals(location.get(i))) continue block0;
                currentDir = nextDir;
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 15: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolType";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolsByKey";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightProxyElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByKey";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolsByKey";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processElementParameters";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLightProxyElement";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processAllElements";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolTypeByFileLocation";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isInLocationForType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class EntryKey {
        @NotNull
        private final SymbolType mySymbolType;
        @NotNull
        private final String mySymbolName;

        EntryKey(@NotNull SymbolType symbolType, @NotNull String symbolName) {
            if (symbolType == null) {
                EntryKey.$$$reportNull$$$0(0);
            }
            if (symbolName == null) {
                EntryKey.$$$reportNull$$$0(1);
            }
            this.mySymbolType = symbolType;
            this.mySymbolName = symbolName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryKey key = (EntryKey)o;
            if (this.mySymbolType != key.mySymbolType) {
                return false;
            }
            return this.mySymbolName.equals(key.mySymbolName);
        }

        public int hashCode() {
            int result = this.mySymbolType.name().hashCode();
            result = 31 * result + this.mySymbolName.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbolType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbolName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$EntryKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyKeyDescriptor
    implements KeyDescriptor<EntryKey> {
        private MyKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, EntryKey value) throws IOException {
            if (out == null) {
                MyKeyDescriptor.$$$reportNull$$$0(0);
            }
            out.writeUTF(value.mySymbolType.name());
            out.writeUTF(value.mySymbolName);
        }

        public EntryKey read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyKeyDescriptor.$$$reportNull$$$0(1);
            }
            String typeName = in.readUTF();
            String symbolName = in.readUTF();
            return new EntryKey(SymbolType.valueOf(typeName), symbolName);
        }

        public int getHashCode(EntryKey value) {
            return value.hashCode();
        }

        public boolean isEqual(EntryKey val1, EntryKey val2) {
            return val1.equals(val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$MyKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum SymbolType {
        FUNCTION(Arrays.asList(Arrays.asList("lib", "puppet", "parser", "functions"), Arrays.asList("lib", "stubs")), new RubyFunctionIndexer(), PuppetBundle.message("puppet.type.names.function_definition", new Object[0])),
        TYPE(Collections.singletonList(Arrays.asList("lib", "puppet", "type")), new RubyTypeIndexer(), PuppetBundle.message("puppet.type.names.resource_definition", new Object[0]));

        @NotNull
        private final Collection<List<String>> myLocations;
        @NotNull
        private final DataIndexer<EntryKey, PuppetExtFunctionInfo, FileContent> myIndexer;
        @NotNull
        private final String myTypeName;

        private SymbolType(@NotNull Collection<List<String>> locations, DataIndexer<EntryKey, PuppetExtFunctionInfo, FileContent> indexer, String typeName) {
            if (locations == null) {
                SymbolType.$$$reportNull$$$0(0);
            }
            if (indexer == null) {
                SymbolType.$$$reportNull$$$0(1);
            }
            if (typeName == null) {
                SymbolType.$$$reportNull$$$0(2);
            }
            this.myLocations = locations;
            this.myIndexer = indexer;
            this.myTypeName = typeName;
        }

        @NotNull
        public String getTypeName() {
            String string = this.myTypeName;
            if (string == null) {
                SymbolType.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locations";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$SymbolType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$SymbolType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

