/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0006H\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0014J\b\u0010\u0012\u001a\u00020\fH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0016J\b\u0010\u0015\u001a\u00020\fH\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/lang/MarkdownFileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "eventSystemEnabled", "", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "myRelevantLanguages", "Lgnu/trove/THashSet;", "Lcom/intellij/lang/Language;", "cloneInner", "fileCopy", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "getBaseLanguage", "getLanguages", "", "getTemplateDataLanguage", "intellij.markdown"})
public final class MarkdownFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private final THashSet<Language> myRelevantLanguages;

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        if (lang == MarkdownLanguage.INSTANCE) {
            return (PsiFile)new MarkdownFile((FileViewProvider)this);
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition == null) {
            return null;
        }
        ParserDefinition parserDefinition2 = parserDefinition;
        PsiFile psiFile = parserDefinition2.createFile((FileViewProvider)this);
        if (lang == this.getTemplateDataLanguage() && psiFile instanceof PsiFileImpl) {
            ((PsiFileImpl)psiFile).setContentElementType((IElementType)MarkdownElementTypes.MARKDOWN_TEMPLATE_DATA);
        }
        return psiFile;
    }

    @NotNull
    public Language getBaseLanguage() {
        MarkdownLanguage markdownLanguage = MarkdownLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)markdownLanguage), (String)"MarkdownLanguage.INSTANCE");
        return markdownLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        return (Set)this.myRelevantLanguages;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = StdLanguages.HTML;
        Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"StdLanguages.HTML");
        return language;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkParameterIsNotNull((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManagerEx, (String)"manager");
        return new MarkdownFileViewProvider((PsiManager)psiManagerEx, fileCopy, false);
    }

    public MarkdownFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        super(manager, virtualFile, eventSystemEnabled);
        this.myRelevantLanguages = new THashSet();
        this.myRelevantLanguages.add((Object)this.getBaseLanguage());
        this.myRelevantLanguages.add((Object)this.getTemplateDataLanguage());
    }
}

