/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFenceCacheableProvider;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFencePluginGeneratingProvider;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.ui.preview.MarkdownCodeFencePluginCacheCollector;
import org.intellij.plugins.markdown.ui.preview.MarkdownUtil;
import org.jetbrains.annotations.NotNull;

public class MarkdownCodeFencePluginCache
implements Disposable {
    @NotNull
    public static final String MARKDOWN_FILE_PATH_KEY = "markdown-md5-file-path";
    @NotNull
    private final Alarm myAlarm = new Alarm((Disposable)this);
    @NotNull
    private final Collection<MarkdownCodeFencePluginCacheCollector> myCodeFencePluginCaches = ContainerUtil.newConcurrentSet();
    @NotNull
    private final Collection<File> myAdditionalCacheToDelete = ContainerUtil.newConcurrentSet();

    public static MarkdownCodeFencePluginCache getInstance() {
        return (MarkdownCodeFencePluginCache)ServiceManager.getService(MarkdownCodeFencePluginCache.class);
    }

    public MarkdownCodeFencePluginCache() {
        this.scheduleClearCache();
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (MarkdownFileType.INSTANCE == event.getFile().getFileType()) {
                    MarkdownCodeFencePluginCache.this.myAdditionalCacheToDelete.addAll(MarkdownCodeFencePluginCache.processSourceFileToDelete(event.getFile(), ContainerUtil.emptyList()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/plugins/markdown/ui/preview/MarkdownCodeFencePluginCache$1", "fileDeleted"));
            }
        });
    }

    private static List<File> getPluginSystemPaths() {
        return Arrays.stream(MarkdownCodeFencePluginGeneratingProvider.Companion.getEP_NAME().getExtensions()).filter(MarkdownCodeFenceCacheableProvider.class::isInstance).map(MarkdownCodeFenceCacheableProvider.class::cast).map(provider -> new File(provider.getCacheRootPath())).collect(Collectors.toList());
    }

    public Collection<File> collectFilesToRemove() {
        return this.myCodeFencePluginCaches.stream().flatMap(cacheProvider -> MarkdownCodeFencePluginCache.processSourceFileToDelete(cacheProvider.getFile(), cacheProvider.getAliveCachedFiles()).stream()).collect(Collectors.toList());
    }

    private static Collection<File> processSourceFileToDelete(@NotNull VirtualFile sourceFile, @NotNull Collection<File> aliveCachedFiles) {
        if (sourceFile == null) {
            MarkdownCodeFencePluginCache.$$$reportNull$$$0(0);
        }
        if (aliveCachedFiles == null) {
            MarkdownCodeFencePluginCache.$$$reportNull$$$0(1);
        }
        HashSet<File> filesToDelete = new HashSet<File>();
        for (File codeFencePluginSystemPath : MarkdownCodeFencePluginCache.getPluginSystemPaths()) {
            for (File sourceFileCacheDirectory : MarkdownCodeFencePluginCache.getChildren(codeFencePluginSystemPath)) {
                if (MarkdownCodeFencePluginCache.isCachedSourceFile(sourceFileCacheDirectory, sourceFile) && aliveCachedFiles.isEmpty()) {
                    filesToDelete.add(sourceFileCacheDirectory);
                    continue;
                }
                for (File imgFile : MarkdownCodeFencePluginCache.getChildren(sourceFileCacheDirectory)) {
                    if (!MarkdownCodeFencePluginCache.isCachedSourceFile(sourceFileCacheDirectory, sourceFile) || aliveCachedFiles.contains(imgFile)) continue;
                    filesToDelete.add(imgFile);
                }
            }
        }
        return filesToDelete;
    }

    @NotNull
    private static File[] getChildren(@NotNull File directory) {
        File[] files;
        if (directory == null) {
            MarkdownCodeFencePluginCache.$$$reportNull$$$0(2);
        }
        File[] fileArray = (files = directory.listFiles()) != null ? files : ArrayUtilRt.EMPTY_FILE_ARRAY;
        if (fileArray == null) {
            MarkdownCodeFencePluginCache.$$$reportNull$$$0(3);
        }
        return fileArray;
    }

    private static boolean isCachedSourceFile(@NotNull File sourceFileDir, @NotNull VirtualFile sourceFile) {
        if (sourceFileDir == null) {
            MarkdownCodeFencePluginCache.$$$reportNull$$$0(4);
        }
        if (sourceFile == null) {
            MarkdownCodeFencePluginCache.$$$reportNull$$$0(5);
        }
        return sourceFileDir.getName().equals(MarkdownUtil.INSTANCE.md5(sourceFile.getPath(), MARKDOWN_FILE_PATH_KEY));
    }

    public void registerCacheProvider(@NotNull MarkdownCodeFencePluginCacheCollector cacheCollector) {
        if (cacheCollector == null) {
            MarkdownCodeFencePluginCache.$$$reportNull$$$0(6);
        }
        this.myCodeFencePluginCaches.add(cacheCollector);
    }

    private void scheduleClearCache() {
        this.myAlarm.addRequest(() -> {
            Set filesToDelete = ContainerUtil.union(this.myAdditionalCacheToDelete, this.collectFilesToRemove());
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> FileUtil.asyncDelete((Collection)filesToDelete)));
            this.clear();
            this.scheduleClearCache();
        }, Registry.intValue((String)"markdown.clear.cache.interval"));
    }

    private void clear() {
        this.myAdditionalCacheToDelete.clear();
        this.myCodeFencePluginCaches.clear();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myAlarm);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliveCachedFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/MarkdownCodeFencePluginCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownCodeFencePluginCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processSourceFileToDelete";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCachedSourceFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerCacheProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

