/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DigestUtil;
import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkdownParser;
import org.intellij.plugins.markdown.lang.parser.GFMCommentAwareFlavourDescriptor;
import org.intellij.plugins.markdown.lang.parser.MarkdownParserManager;
import org.intellij.plugins.markdown.ui.preview.IntelliJImageGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownCodeFencePluginCache;
import org.intellij.plugins.markdown.ui.preview.MarkdownCodeFencePluginCacheCollector;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u001a\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\f\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/MarkdownUtil;", "", "()V", "generateMarkdownHtml", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "project", "Lcom/intellij/openapi/project/Project;", "md5", "buffer", "key", "intellij.markdown"})
public final class MarkdownUtil {
    public static final MarkdownUtil INSTANCE;

    @NotNull
    public final String md5(@Nullable String buffer, @NonNls @NotNull String key) {
        byte[] byArray;
        byte[] byArray2;
        MessageDigest messageDigest;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        MessageDigest md5 = DigestUtil.md5();
        MessageDigest messageDigest2 = Objects.requireNonNull(md5);
        String string = buffer;
        if (string != null) {
            String string2 = string;
            object = Charsets.UTF_8;
            messageDigest = messageDigest2;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray3 = string3.getBytes((Charset)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
            byArray2 = byArray3;
            messageDigest2 = messageDigest;
            byArray = byArray2;
        } else {
            byArray = null;
        }
        messageDigest2.update(byArray);
        object = key;
        Charset charset = Charsets.UTF_8;
        messageDigest = md5;
        boolean bl = false;
        byte[] byArray4 = ((String)object).getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"(this as java.lang.String).getBytes(charset)");
        byArray2 = byArray4;
        byte[] code = messageDigest.digest(byArray2);
        BigInteger bi = new BigInteger(code).abs();
        String string4 = bi.abs().toString(16);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"bi.abs().toString(16)");
        return string4;
    }

    @NotNull
    public final String generateMarkdownHtml(@NotNull VirtualFile file, @NotNull String text, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        VirtualFile parent = file.getParent();
        URI baseUri = parent != null ? new File(parent.getPath()).toURI() : null;
        GFMCommentAwareFlavourDescriptor gFMCommentAwareFlavourDescriptor = MarkdownParserManager.FLAVOUR;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gFMCommentAwareFlavourDescriptor), (String)"MarkdownParserManager.FLAVOUR");
        ASTNode parsedTree = new MarkdownParser((MarkdownFlavourDescriptor)gFMCommentAwareFlavourDescriptor).buildMarkdownTreeFromString(text);
        MarkdownCodeFencePluginCacheCollector cacheCollector = new MarkdownCodeFencePluginCacheCollector(file);
        LinkMap linkMap = LinkMap.Builder.buildLinkMap(parsedTree, (CharSequence)text);
        Map map = MapsKt.toMutableMap(MarkdownParserManager.FLAVOUR.createHtmlGeneratingProviders(linkMap, baseUri));
        Map<IElementType, GeneratingProvider> map2 = MarkdownParserManager.CODE_FENCE_PLUGIN_FLAVOUR.createHtmlGeneratingProviders(cacheCollector);
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"MarkdownParserManager.CO\u2026Providers(cacheCollector)");
        map.putAll(map2);
        if (project != null) {
            map.put(MarkdownElementTypes.IMAGE, new IntelliJImageGeneratingProvider(linkMap, baseUri, project));
        }
        String html = HtmlGenerator.generateHtml$default((HtmlGenerator)new HtmlGenerator(text, parsedTree, map, true), null, (int)1, null);
        MarkdownCodeFencePluginCache.getInstance().registerCacheProvider(cacheCollector);
        return html;
    }

    private MarkdownUtil() {
    }

    static {
        MarkdownUtil markdownUtil;
        INSTANCE = markdownUtil = new MarkdownUtil();
    }
}

