/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AsyncUpdateAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.merge.PerforceMergeProvider;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class ResolveAllAction
extends AsyncUpdateAction<VcsContext>
implements DumbAware {
    protected VcsContext prepareDataFromContext(@NotNull AnActionEvent e) {
        if (e == null) {
            ResolveAllAction.$$$reportNull$$$0(0);
        }
        return VcsContextFactory.SERVICE.getInstance().createCachedContextOn(e);
    }

    protected void performUpdate(@NotNull Presentation presentation, VcsContext context) {
        Project project;
        if (presentation == null) {
            ResolveAllAction.$$$reportNull$$$0(1);
        }
        presentation.setEnabledAndVisible((project = context.getProject()) != null);
        if (project == null) {
            return;
        }
        AbstractVcs[] allActiveVcss = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
        boolean found = false;
        for (AbstractVcs vcs : allActiveVcss) {
            if (!"Perforce".equals(vcs.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.notVisible(presentation);
            return;
        }
        PerforceSettings settings = PerforceSettings.getSettings(project);
        if (!settings.ENABLED) {
            presentation.setEnabled(false);
            return;
        }
        Collection<P4Connection> allConnections = settings.getAllConnections();
        for (P4Connection connection : allConnections) {
            try {
                if (settings.getServerVersionCached(connection) >= 2004L) continue;
                this.notVisible(presentation);
                return;
            }
            catch (VcsException e) {
                this.notVisible(presentation);
                return;
            }
        }
    }

    private void notVisible(Presentation presentation) {
        presentation.setEnabledAndVisible(false);
    }

    protected boolean forceSyncUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            ResolveAllAction.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ResolveAllAction.$$$reportNull$$$0(3);
        }
        VcsContext context = VcsContextFactory.SERVICE.getInstance().createCachedContextOn(e);
        try {
            final ArrayList<VirtualFile> filesToResolveUnderProject = new ArrayList<VirtualFile>();
            final PerforceVcs vcs = PerforceVcs.getInstance(context.getProject());
            final PerforceRunner runner = PerforceRunner.getInstance(context.getProject());
            final ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)context.getProject());
            VcsUtil.runVcsProcessWithProgress((VcsRunnable)new VcsRunnable(){

                public void run() throws VcsException {
                    Collection<Pair<P4Connection, Collection<VirtualFile>>> rootsByConnections = vcs.getRootsByConnections();
                    for (Pair<P4Connection, Collection<VirtualFile>> pair : rootsByConnections) {
                        for (VirtualFile root : (Collection)pair.getSecond()) {
                            for (VirtualFile file : runner.getResolvedWithConflicts((P4Connection)pair.getFirst(), root)) {
                                if (vcsManager.getVcsFor(file) != vcs) continue;
                                filesToResolveUnderProject.add(file);
                            }
                        }
                    }
                }
            }, (String)PerforceBundle.message((String)"message.searching.for.files.to.resolve", (Object[])new Object[0]), (boolean)false, (Project)context.getProject());
            if (filesToResolveUnderProject.size() == 0) {
                Messages.showInfoMessage((String)PerforceBundle.message((String)"message.text.no.files.to.resolve", (Object[])new Object[0]), (String)PerforceBundle.message((String)"message.title.resolve", (Object[])new Object[0]));
            } else {
                new PerforceMergeProvider(context.getProject()).showMergeDialog(filesToResolveUnderProject);
            }
        }
        catch (VcsException e1) {
            Messages.showErrorDialog((String)e1.getLocalizedMessage(), (String)PerforceBundle.message((String)"message.title.resolve", (Object[])new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/actions/ResolveAllAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareDataFromContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "performUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "forceSyncUpdate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

