/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.settings;

import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.circular.CircularLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.organic.SmartOrganicLayouter;
import com.intellij.openapi.graph.layout.orthogonal.DirectedOrthogonalLayouter;
import com.intellij.openapi.graph.layout.orthogonal.OrthogonalLayouter;
import com.intellij.openapi.graph.layout.tree.BalloonLayouter;
import com.intellij.openapi.graph.layout.tree.HVTreeLayouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public enum DiagramLayout {
    BALLOON,
    CIRCULAR,
    HIERARCHIC_GROUP,
    ORGANIC,
    ORTHOGONAL,
    DIRECTED_ORTHOGONAL,
    TREE;


    @NotNull
    public static DiagramLayout getDefault() {
        DiagramLayout diagramLayout = HIERARCHIC_GROUP;
        if (diagramLayout == null) {
            DiagramLayout.$$$reportNull$$$0(0);
        }
        return diagramLayout;
    }

    @NotNull
    public static DiagramLayout getCurrentLayout(@NotNull GraphSettings settings) {
        Layouter layouter;
        if (settings == null) {
            DiagramLayout.$$$reportNull$$$0(1);
        }
        if ((layouter = settings.getCurrentLayouter()) instanceof HierarchicGroupLayouter) {
            DiagramLayout diagramLayout = HIERARCHIC_GROUP;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(2);
            }
            return diagramLayout;
        }
        if (layouter instanceof CircularLayouter) {
            DiagramLayout diagramLayout = CIRCULAR;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(3);
            }
            return diagramLayout;
        }
        if (layouter instanceof DirectedOrthogonalLayouter) {
            DiagramLayout diagramLayout = DIRECTED_ORTHOGONAL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(4);
            }
            return diagramLayout;
        }
        if (layouter instanceof SmartOrganicLayouter) {
            DiagramLayout diagramLayout = ORTHOGONAL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(5);
            }
            return diagramLayout;
        }
        if (layouter instanceof OrthogonalLayouter) {
            DiagramLayout diagramLayout = ORTHOGONAL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(6);
            }
            return diagramLayout;
        }
        if (layouter instanceof BalloonLayouter) {
            DiagramLayout diagramLayout = BALLOON;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(7);
            }
            return diagramLayout;
        }
        if (layouter instanceof HVTreeLayouter) {
            DiagramLayout diagramLayout = TREE;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(8);
            }
            return diagramLayout;
        }
        DiagramLayout diagramLayout = HIERARCHIC_GROUP;
        if (diagramLayout == null) {
            DiagramLayout.$$$reportNull$$$0(9);
        }
        return diagramLayout;
    }

    @NotNull
    public Layouter getLayouter(@NotNull GraphSettings settings) {
        if (settings == null) {
            DiagramLayout.$$$reportNull$$$0(10);
        }
        switch (this) {
            case BALLOON: {
                BalloonLayouter balloonLayouter = settings.getBalloonLayouter();
                if (balloonLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(11);
                }
                return balloonLayouter;
            }
            case CIRCULAR: {
                CircularLayouter circularLayouter = settings.getCircularLayouter();
                if (circularLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(12);
                }
                return circularLayouter;
            }
            case DIRECTED_ORTHOGONAL: {
                DirectedOrthogonalLayouter directedOrthogonalLayouter = settings.getDirectedOrthogonalLayouter();
                if (directedOrthogonalLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(13);
                }
                return directedOrthogonalLayouter;
            }
            case ORGANIC: {
                SmartOrganicLayouter smartOrganicLayouter = settings.getOrganicLayouter();
                if (smartOrganicLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(14);
                }
                return smartOrganicLayouter;
            }
            case ORTHOGONAL: {
                OrthogonalLayouter orthogonalLayouter = settings.getOrthogonalLayouter();
                if (orthogonalLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(15);
                }
                return orthogonalLayouter;
            }
            case TREE: {
                HVTreeLayouter hVTreeLayouter = settings.getHVTreeLayouter();
                if (hVTreeLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(16);
                }
                return hVTreeLayouter;
            }
        }
        HierarchicGroupLayouter hierarchicGroupLayouter = settings.getGroupLayouter();
        if (hierarchicGroupLayouter == null) {
            DiagramLayout.$$$reportNull$$$0(17);
        }
        return hierarchicGroupLayouter;
    }

    public String getPresentableName() {
        return StringUtil.capitalizeWords((String)StringUtil.toLowerCase((String)this.name()).replaceAll("_", " "), (boolean)true);
    }

    public static DiagramLayout fromString(Object obj) {
        if (obj == null) {
            return DiagramLayout.getDefault();
        }
        String name = obj.toString();
        try {
            return DiagramLayout.valueOf(StringUtil.toUpperCase((String)name).replaceAll(" ", "_"));
        }
        catch (IllegalArgumentException e) {
            return DiagramLayout.getDefault();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/settings/DiagramLayout";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 1: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/settings/DiagramLayout";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLayout";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayouter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentLayout";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLayouter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

