/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.refactoring;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.ws.http.request.HttpRequestLanguage;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.http.request.refactoring.HttpMoveRequestProcessor;
import com.intellij.ws.http.request.refactoring.HttpMoveRequestSettings;
import com.intellij.ws.rest.client.RestClientBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpMoveRequestDelegate
extends MoveHandlerDelegate {
    private static final String REFACTORING_NAME = RestClientBundle.message("rest.client.refactoring.move.request.name", new Object[0]);
    private static final String DEFAULT_NAME = "http-request.http";

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (HttpMoveRequestDelegate.findHttpRequest(element) != null) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    @Nullable
    private static HttpRequestBlock findHttpRequest(@NotNull PsiElement element) {
        if (element == null) {
            HttpMoveRequestDelegate.$$$reportNull$$$0(0);
        }
        if (element.getContainingFile() instanceof HttpRequestPsiFile) {
            return (HttpRequestBlock)PsiTreeUtil.getParentOfType((PsiElement)element, HttpRequestBlock.class);
        }
        return null;
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        PsiFile file = element.getContainingFile();
        HttpRequestBlock toMove = HttpMoveRequestDelegate.findHttpRequest(element);
        if (toMove != null) {
            if (!file.isWritable()) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RestClientBundle.message("rest.client.refactoring.file.read.only", new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
                return true;
            }
            this.doMove(project, new PsiElement[]{toMove}, null, null);
            return true;
        }
        return false;
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        HttpRequestBlock request;
        ExtractHttpRequestFileDialog dialog;
        if (elements.length == 1 && elements[0] instanceof HttpRequestBlock && (dialog = new ExtractHttpRequestFileDialog(project, request = (HttpRequestBlock)elements[0])).showAndGet()) {
            new HttpMoveRequestProcessor(project, new HttpMoveRequestSettings(request, dialog.getTargetPath())).run();
        }
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            HttpMoveRequestDelegate.$$$reportNull$$$0(1);
        }
        return language == HttpRequestLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/refactoring/HttpMoveRequestDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findHttpRequest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExtractHttpRequestFileDialog
    extends DialogWrapper {
        private final TextFieldWithBrowseButton myPathTextField;
        private final Project myProject;
        private final HttpRequestBlock myRequest;

        protected ExtractHttpRequestFileDialog(@NotNull Project project, @NotNull HttpRequestBlock request) {
            if (project == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(0);
            }
            if (request == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(1);
            }
            super(project, false);
            this.myProject = project;
            this.myRequest = request;
            this.myPathTextField = new TextFieldWithBrowseButton();
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, false);
            String title = RestClientBundle.message("rest.client.refactoring.ui.browse.select.path", new Object[0]);
            String description = RestClientBundle.message("rest.client.refactoring.ui.browse.select.path.description", new Object[0]);
            this.myPathTextField.addBrowseFolderListener(title, description, project, descriptor);
            VirtualFile directory = ExtractHttpRequestFileDialog.getDefaultDirectory(project, request);
            if (directory != null) {
                this.myPathTextField.setText(directory.getPresentableUrl() + File.separator + HttpMoveRequestDelegate.DEFAULT_NAME);
            }
            this.setTitle(REFACTORING_NAME);
            this.init();
        }

        @Nullable
        private static VirtualFile getDefaultDirectory(@NotNull Project project, @NotNull HttpRequestBlock request) {
            PsiDirectory parentDirectory;
            PsiFile file;
            if (project == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(2);
            }
            if (request == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(3);
            }
            if ((file = request.getContainingFile()) != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file.getVirtualFile()) && (parentDirectory = file.getParent()) != null) {
                return parentDirectory.getVirtualFile();
            }
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            if (modules.length > 0) {
                ContentEntry[] contentEntries = ModuleRootManager.getInstance((Module)modules[0]).getContentEntries();
                return contentEntries.length > 0 ? contentEntries[0].getFile() : null;
            }
            return null;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            JLabel label = new JLabel(RestClientBundle.message("rest.client.refactoring.ui.path.label", new Object[0]));
            GridBag bag = new GridBag().insets((Insets)JBUI.insets((int)5)).anchor(17).fillCell().coverLine(1).coverColumn(1).weightx(0.0).weighty(0.0).setColumn(0).setLine(1);
            panel.add((Component)label, bag);
            panel.add((Component)this.myPathTextField, bag.weightx(1.0).setColumn(1));
            panel.setPreferredSize(new Dimension(350, -1));
            return panel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPathTextField;
        }

        @NotNull
        public String getTargetPath() {
            String string = this.myPathTextField.getText();
            if (string == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        protected ValidationInfo doValidate() {
            String path = PathUtil.toSystemIndependentName((String)this.getTargetPath());
            if (StringUtil.isEmpty((String)path)) {
                return new ValidationInfo(RestClientBundle.message("rest.client.refactoring.file.is.empty", new Object[0]), (JComponent)this.myPathTextField);
            }
            VirtualFile target = LocalFileSystem.getInstance().findFileByPath(path);
            if (target == null) {
                Optional<String> invalidSegment;
                VirtualFile parent = ExtractHttpRequestFileDialog.getExistingParent(path);
                if (parent == null || !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(parent)) {
                    return new ValidationInfo(RestClientBundle.message("rest.client.refactoring.not.inside.project", new Object[0]), (JComponent)this.myPathTextField);
                }
                String relativePath = FileUtil.getRelativePath((String)parent.getPath(), (String)path, (char)'/');
                if (StringUtil.isNotEmpty((String)relativePath) && (invalidSegment = StringUtil.split((String)relativePath, (String)"/").stream().filter(segment -> !PathUtil.isValidFileName((String)segment)).findFirst()).isPresent()) {
                    String message = RestClientBundle.message("rest.client.refactoring.file.not.valid.name", invalidSegment.get());
                    return new ValidationInfo(message, (JComponent)this.myPathTextField);
                }
            } else {
                if (target.isDirectory()) {
                    return new ValidationInfo(RestClientBundle.message("rest.client.refactoring.is.a.directory", new Object[0]), (JComponent)this.myPathTextField);
                }
                if (!ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(target)) {
                    return new ValidationInfo(RestClientBundle.message("rest.client.refactoring.not.inside.project", new Object[0]), (JComponent)this.myPathTextField);
                }
                PsiFile original = this.myRequest.getContainingFile();
                if (original != null && FileUtil.pathsEqual((String)original.getVirtualFile().getPath(), (String)target.getPath())) {
                    return new ValidationInfo(RestClientBundle.message("rest.client.refactoring.target.file.same.as.original", new Object[0]), (JComponent)this.myPathTextField);
                }
            }
            return super.doValidate();
        }

        @Nullable
        private static VirtualFile getExistingParent(@NotNull String path) {
            if (path == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(5);
            }
            VirtualFile parent = null;
            while (path.length() > 0 && parent == null) {
                path = PathUtil.getParentPath((String)path);
                parent = LocalFileSystem.getInstance().findFileByPath(path);
            }
            return parent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/refactoring/HttpMoveRequestDelegate$ExtractHttpRequestFileDialog";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/refactoring/HttpMoveRequestDelegate$ExtractHttpRequestFileDialog";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultDirectory";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getExistingParent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

