/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.config;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.ws.http.request.run.config.HttpRequestRunConfigurationType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestRuntimeConfigurationProducer
extends LazyRunConfigurationProducer<HttpRequestRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = HttpRequestRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull HttpRequestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Location location;
        if (configuration == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!((location = context.getLocation()) instanceof PsiLocation)) {
            return false;
        }
        PsiElement originalElement = location.getPsiElement();
        HttpRequest request = HttpRequestRuntimeConfigurationProducer.findHttpRequestElement(location.getPsiElement());
        if (request != null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
            if (virtualFile == null) {
                return false;
            }
            int index = HttpRequestRuntimeConfigurationProducer.getRequestIndex(request);
            if (index < 0) {
                return false;
            }
            HttpRequestRunConfiguration.Settings settings = configuration.getSettings();
            settings.setFilePath(virtualFile.getFileSystem().getProtocol().equals("jar") ? virtualFile.getUrl() : virtualFile.getPath());
            settings.setIndex(index);
            sourceElement.set((Object)request);
            configuration.setName(configuration.suggestedName());
            return true;
        }
        return false;
    }

    private static int getRequestIndex(@NotNull HttpRequest request) {
        if (request == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(4);
        }
        HttpRequestBlock[] blocks = HttpRequestPsiUtils.getRequestBlocks(request.getContainingFile());
        for (int i = 0; i < blocks.length; ++i) {
            HttpRequestBlock block = blocks[i];
            if (block.getRequest() != request) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean isConfigurationFromContext(@NotNull HttpRequestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        if (configuration == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (context == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(6);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PsiElement originalElement = location.getPsiElement();
        HttpRequest request = HttpRequestRuntimeConfigurationProducer.findHttpRequestElement(location.getPsiElement());
        if (request != null) {
            HttpRequestRunConfiguration.Settings settings = configuration.getSettings();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
            if (virtualFile == null || !FileUtil.pathsEqual((String)settings.getFilePath(), (String)virtualFile.getPath())) {
                return false;
            }
            int index = HttpRequestRuntimeConfigurationProducer.getRequestIndex(request);
            return settings.getIndex() == index;
        }
        return false;
    }

    @Nullable
    private static HttpRequest findHttpRequestElement(@Nullable PsiElement element) {
        if (element == null || DumbService.getInstance((Project)element.getProject()).isDumb()) {
            return null;
        }
        if (element instanceof PsiDirectory || !(element.getContainingFile() instanceof HttpRequestPsiFile)) {
            return null;
        }
        if (element instanceof PsiFile) {
            HttpRequestBlock[] blocks = HttpRequestPsiUtils.getRequestBlocks((PsiFile)element);
            return blocks.length == 1 ? blocks[0].getRequest() : null;
        }
        PsiElement psi = element instanceof PsiWhiteSpace ? element.getPrevSibling() : element;
        HttpRequestBlock block = (HttpRequestBlock)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psi, (Class[])new Class[]{HttpRequestBlock.class});
        return block != null ? block.getRequest() : null;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfigurationWithDefaultEnv(@NotNull ConfigurationContext context) {
        if (context == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(7);
        }
        RunManager runManager = RunManager.getInstance((Project)context.getProject());
        List configurations = this.getConfigurationSettingsList(runManager);
        for (RunnerAndConfigurationSettings configurationSettings : configurations) {
            HttpRequestRunConfiguration runConfiguration;
            RunConfiguration configuration = configurationSettings.getConfiguration();
            if (!(configuration instanceof HttpRequestRunConfiguration) || !(runConfiguration = (HttpRequestRunConfiguration)configuration).getSettings().isDefaultEnvironment() || !this.isConfigurationFromContext(runConfiguration, context)) continue;
            return configurationSettings;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/config/HttpRequestRuntimeConfigurationProducer";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/config/HttpRequestRuntimeConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRequestIndex";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findExistingConfigurationWithDefaultEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

