/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin.bddConfiguration;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.gherkin.PyBDDFramework;
import com.jetbrains.python.gherkin.api.PyGherkinApi;
import com.jetbrains.python.gherkin.bddConfiguration.PyBDDRunConfiguration;
import com.jetbrains.python.psi.PyUtil;
import java.io.File;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;

public abstract class PyBDDRunConfigurationProducer<T extends PyBDDRunConfiguration<?>>
extends LazyRunConfigurationProducer<T> {
    private static final String GHERKIN_EXTENSION = '.' + GherkinFileType.INSTANCE.getDefaultExtension();
    @NotNull
    private final Class<? extends PyBDDFramework> myFramework;

    protected PyBDDRunConfigurationProducer(@NotNull Class<? extends PyBDDFramework> framework) {
        if (framework == null) {
            PyBDDRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        this.myFramework = framework;
    }

    protected boolean setupConfigurationFromContext(@NotNull T configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement element;
        if (configuration == null) {
            PyBDDRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyBDDRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            PyBDDRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((element = (PsiElement)sourceElement.get()) == null) {
            return false;
        }
        String path = PyBDDRunConfigurationProducer.getPathByElement(element);
        if (path == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        PyBDDFramework framework = new PyGherkinApi(module).findFrameworkByClass(this.myFramework);
        if (framework == null) {
            return false;
        }
        if (framework.isExplicitlyNotRecommended(module)) {
            return false;
        }
        ((PyBDDRunConfiguration)((Object)configuration)).setWhatRun(path);
        String fileName = new File(path).getName();
        GherkinStepsHolder scenario = (GherkinStepsHolder)PsiTreeUtil.getParentOfType((PsiElement)element, GherkinStepsHolder.class);
        if (scenario != null) {
            ((PyBDDRunConfiguration)((Object)configuration)).setScenarios(scenario);
            configuration.setName(String.format("%s:%s", fileName, scenario.getScenarioName()));
        } else {
            configuration.setName(fileName);
        }
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull T configuration, @NotNull ConfigurationContext context) {
        PsiElement location;
        if (configuration == null) {
            PyBDDRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyBDDRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((location = context.getPsiLocation()) == null) {
            return false;
        }
        String path = PyBDDRunConfigurationProducer.getPathByElement(location);
        String[] run = ((PyBDDRunConfiguration)((Object)configuration)).getWhatRun();
        if (path == null || run.length != 1 || !path.equals(run[0])) {
            return false;
        }
        GherkinStepsHolder scenario = (GherkinStepsHolder)PsiTreeUtil.getParentOfType((PsiElement)location, GherkinStepsHolder.class);
        if (((PyBDDRunConfiguration)((Object)configuration)).getScenariosAsString().length == 0) {
            return scenario == null;
        }
        return scenario != null && ((PyBDDRunConfiguration)((Object)configuration)).getScenariosAsString()[0].equals(scenario.getScenarioName());
    }

    @Nullable
    private static String getPathByElement(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        if (element == null) {
            PyBDDRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiFileSystemItem && (virtualFile = ((PsiFileSystemItem)element).getVirtualFile()) != null && PyUtil.getSourceRoots((PsiElement)element).stream().noneMatch(o -> VfsUtilCore.isAncestor((VirtualFile)o, (VirtualFile)virtualFile, (boolean)false))) {
            return null;
        }
        virtualFile = null;
        if (element instanceof PsiDirectory && PyBDDRunConfigurationProducer.isDirectoryWithFeatures((PsiDirectory)element) || element instanceof GherkinFile) {
            virtualFile = ((PsiFileSystemItem)element).getVirtualFile();
        } else {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile instanceof GherkinFile) {
                virtualFile = containingFile.getVirtualFile();
            }
        }
        if (virtualFile != null) {
            return virtualFile.getCanonicalPath();
        }
        return null;
    }

    private static boolean isDirectoryWithFeatures(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PyBDDRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        return Arrays.stream(directory.getVirtualFile().getChildren()).anyMatch(o -> o.getName().endsWith(GHERKIN_EXTENSION));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/gherkin/bddConfiguration/PyBDDRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathByElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirectoryWithFeatures";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

