/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.Utils;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.uml.core.actions.DeleteSelectionWrapper;
import com.intellij.uml.utils.UmlBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JList;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class UmlViewStructure
extends DiagramAction {
    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlViewStructure.$$$reportNull$$$0(0);
        }
        final DiagramBuilder builder = UmlViewStructure.getBuilder((AnActionEvent)e);
        Project project = e.getProject();
        if (builder == null || project == null) {
            return;
        }
        HashMap names = new HashMap();
        for (Object node : builder.getNodeObjects()) {
            if (node instanceof DiagramNoteNode) continue;
            if (node instanceof DiagramNode) {
                names.put(node, Utils.getNodeName((DiagramNode)((DiagramNode)node)));
                continue;
            }
            names.put(node, "");
        }
        final JList list = UmlViewStructure.createList(builder);
        final Ref ref = new Ref(null);
        ActionListener elementRemover = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final Object value = list.getSelectedValue();
                int index = list.getSelectedIndex();
                if (value instanceof DiagramNode) {
                    new DeleteSelectionWrapper(null, builder){

                        public List<Node> getSelectedNodes() {
                            return Collections.singletonList(builder.getNode((DiagramNode)value));
                        }
                    }.actionPerformed(e);
                    builder.getDataModel().refreshDataModel();
                    builder.update(true, true);
                    ((FilteringListModel)list.getModel()).remove(index);
                    if (list.getModel().getSize() == 0) {
                        ((JBPopup)ref.get()).cancel();
                    }
                    list.setSelectedIndex(Math.max(0, index - 1));
                }
            }
        };
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder(list).setFilteringEnabled(o -> (String)names.get(o)).setResizable(true).setMovable(true).setTitle(UmlBundle.message("uml.structure.view", new Object[0])).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                Object value = list.getSelectedValue();
                if (value == null) {
                    return;
                }
                Graph2D graph = builder.getGraph();
                if (builder.isPopupMode()) {
                    for (Node n : graph.getNodeArray()) {
                        graph.setSelected(n, false);
                    }
                    Node node = builder.getNode((DiagramNode)value);
                    if (node != null) {
                        graph.setSelected(node, true);
                    }
                } else {
                    builder.getGraphBuilder().setZoom(1.0);
                    DiagramUtils.navigateTo((DiagramNode)((DiagramNode)value));
                }
                builder.getGraphBuilder().updateView();
            }
        }).registerKeyboardAction(KeyStroke.getKeyStroke(127, 0), elementRemover).registerKeyboardAction(KeyStroke.getKeyStroke(8, 0), elementRemover).setRequestFocus(true).createPopup();
        ref.set((Object)popup);
        Utils.showInGraphCenter((JBPopup)popup, (Graph2D)builder.getGraph());
    }

    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlViewStructure.$$$reportNull$$$0(1);
        }
        return false;
    }

    public String getActionName() {
        return "Show Diagram Structure";
    }

    private static JList createList(DiagramBuilder builder) {
        List nodes = Utils.getNodesExceptNotes((DiagramBuilder)builder);
        JBList list = new JBList(ArrayUtil.toObjectArray((Collection)nodes));
        list.setCellRenderer(new DefaultPsiElementCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object node, int index, boolean isSelected, boolean cellHasFocus) {
                SimpleColoredComponent component = new SimpleColoredComponent();
                if (isSelected) {
                    component.setBackground(UIUtil.getListSelectionBackground());
                    component.setForeground(UIUtil.getListSelectionForeground());
                }
                if (node instanceof DiagramNode) {
                    DiagramNode n = (DiagramNode)node;
                    component.setIcon(n.getIcon());
                    String name = Utils.getNodeName((DiagramNode)n);
                    if (name != null) {
                        component.append(name);
                    }
                }
                return component;
            }
        });
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/uml/core/actions/UmlViewStructure";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

