/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.psi.PsiClass;
import com.intellij.uml.java.JavaUmlCategoryManager;
import com.intellij.uml.java.actions.CreateNewFieldDialog;
import com.intellij.uml.java.actions.NewJavaClassElement;
import com.intellij.util.PlatformIcons;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;

public class NewJavaField
extends NewJavaClassElement {
    public NewJavaField() {
        super("Field", "Create new field", PlatformIcons.FIELD_ICON);
    }

    @Override
    public DiagramCategory getCategory() {
        return JavaUmlCategoryManager.FIELDS;
    }

    @Override
    public Runnable createWriteAction(PsiClass psiClass, DiagramBuilder builder) throws Exception {
        CreateNewFieldDialog dialog = new CreateNewFieldDialog(psiClass);
        JComponent view = builder.getView().getCanvasComponent();
        Point vP = view.getLocationOnScreen();
        Dimension dSize = dialog.getPreferredSize();
        Dimension vSize = view.getSize();
        Point p = new Point(vP.x + (vSize.height - dSize.height) / 2, vP.y + (vSize.width - dSize.width) / 2);
        dialog.setLocation(p);
        dialog.show();
        return dialog.getCreateAction();
    }

    public String getActionName() {
        return "Create new Java Field";
    }
}

