/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluator;
import com.intellij.codeInsight.TargetElementEvaluatorEx;
import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.TargetElementUtilExtender;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetElementUtil
extends TargetElementUtilBase {
    public static final int REFERENCED_ELEMENT_ACCEPTED = 1;
    public static final int ELEMENT_NAME_ACCEPTED = 2;
    public static final int LOOKUP_ITEM_ACCEPTED = 8;
    private static final LanguageExtension<TargetElementEvaluator> TARGET_ELEMENT_EVALUATOR = new LanguageExtension("com.intellij.targetElementEvaluator");

    public static TargetElementUtil getInstance() {
        return (TargetElementUtil)ServiceManager.getService(TargetElementUtil.class);
    }

    @Override
    public int getAllAccepted() {
        int result2 = 11;
        for (TargetElementUtilExtender each : TargetElementUtilExtender.EP_NAME.getExtensionList()) {
            result2 |= each.getAllAdditionalFlags();
        }
        return result2;
    }

    @Override
    public int getDefinitionSearchFlags() {
        int result2 = this.getAllAccepted();
        for (TargetElementUtilExtender each : TargetElementUtilExtender.EP_NAME.getExtensionList()) {
            result2 |= each.getAdditionalDefinitionSearchFlags();
        }
        return result2;
    }

    @Override
    public int getReferenceSearchFlags() {
        int result2 = this.getAllAccepted();
        for (TargetElementUtilExtender each : TargetElementUtilExtender.EP_NAME.getExtensionList()) {
            result2 |= each.getAdditionalReferenceSearchFlags();
        }
        return result2;
    }

    @Nullable
    public static PsiReference findReference(@NotNull Editor editor) {
        int offset;
        PsiReference result2;
        if (editor == null) {
            TargetElementUtil.$$$reportNull$$$0(0);
        }
        if ((result2 = TargetElementUtil.findReference(editor, offset = editor.getCaretModel().getOffset())) == null) {
            int expectedCaretOffset;
            int n = expectedCaretOffset = editor instanceof EditorEx ? ((EditorEx)editor).getExpectedCaretOffset() : offset;
            if (expectedCaretOffset != offset) {
                result2 = TargetElementUtil.findReference(editor, expectedCaretOffset);
            }
        }
        return result2;
    }

    @Nullable
    public static PsiReference findReference(@NotNull Editor editor, int offset) {
        Project project;
        if (editor == null) {
            TargetElementUtil.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        PsiReference ref = file2.findReferenceAt(TargetElementUtil.adjustOffset(file2, document, offset));
        if (ref == null) {
            return null;
        }
        int elementOffset = ref.getElement().getTextRange().getStartOffset();
        for (TextRange range2 : ReferenceRange.getRanges((PsiReference)ref)) {
            if (!range2.shiftRight(elementOffset).containsOffset(offset)) continue;
            return ref;
        }
        return null;
    }

    public static int adjustOffset(@Nullable PsiFile file2, Document document, int offset) {
        char charAt;
        CharSequence text2 = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!TargetElementUtil.isIdentifierPart(file2, text2, offset)) {
            --correctedOffset;
        }
        if (correctedOffset >= 0 && ((charAt = text2.charAt(correctedOffset)) == '\'' || charAt == '\"' || charAt == ')' || charAt == ']' || TargetElementUtil.isIdentifierPart(file2, text2, correctedOffset))) {
            return correctedOffset;
        }
        return offset;
    }

    private static boolean isIdentifierPart(@Nullable PsiFile file2, CharSequence text2, int offset) {
        TargetElementEvaluatorEx evaluator;
        if (file2 != null && (evaluator = TargetElementUtil.getElementEvaluatorsEx(file2.getLanguage())) != null && evaluator.isIdentifierPart(file2, text2, offset)) {
            return true;
        }
        return Character.isJavaIdentifierPart(text2.charAt(offset));
    }

    public static boolean inVirtualSpace(@NotNull Editor editor, int offset) {
        if (editor == null) {
            TargetElementUtil.$$$reportNull$$$0(2);
        }
        return offset == editor.getCaretModel().getOffset() && EditorUtil.inVirtualSpace(editor, editor.getCaretModel().getLogicalPosition());
    }

    @Nullable
    public static PsiElement findTargetElement(Editor editor, int flags) {
        int expectedCaretOffset;
        int offset = editor.getCaretModel().getOffset();
        PsiElement result2 = TargetElementUtil.getInstance().findTargetElement(editor, flags, offset);
        if (result2 != null) {
            return result2;
        }
        int n = expectedCaretOffset = editor instanceof EditorEx ? ((EditorEx)editor).getExpectedCaretOffset() : offset;
        if (expectedCaretOffset != offset) {
            return TargetElementUtil.getInstance().findTargetElement(editor, flags, expectedCaretOffset);
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement findTargetElement(@NotNull Editor editor, int flags, int offset) {
        PsiElement result2;
        TargetElementEvaluatorEx2 evaluator;
        if (editor == null) {
            TargetElementUtil.$$$reportNull$$$0(3);
        }
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = (result2 = this.doFindTargetElement(editor, flags, offset)) != null ? TargetElementUtil.getElementEvaluatorsEx2(result2.getLanguage()) : null;
        if (evaluator != null) {
            result2 = evaluator.adjustTargetElement(editor, offset, flags, result2);
        }
        return result2;
    }

    @Nullable
    private PsiElement doFindTargetElement(@NotNull Editor editor, int flags, int offset) {
        PsiElement referenceOrReferencedElement;
        PsiElement element;
        Project project;
        if (editor == null) {
            TargetElementUtil.$$$reportNull$$$0(4);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        if (BitUtil.isSet((int)flags, (int)8) && (element = TargetElementUtil.getTargetElementFromLookup(project)) != null) {
            return element;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        int adjusted = TargetElementUtil.adjustOffset(file2, document, offset);
        PsiElement element2 = file2.findElementAt(adjusted);
        if (BitUtil.isSet((int)flags, (int)1) && this.isAcceptableReferencedElement(element2, referenceOrReferencedElement = TargetElementUtil.getReferenceOrReferencedElement(file2, editor, flags, offset))) {
            return referenceOrReferencedElement;
        }
        if (element2 == null) {
            return null;
        }
        if (BitUtil.isSet((int)flags, (int)2)) {
            if (element2 instanceof PsiNamedElement) {
                return element2;
            }
            return this.getNamedElement(element2, adjusted - element2.getTextRange().getStartOffset());
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetElementFromLookup(Project project) {
        PsiElement psi;
        LookupElement item;
        LookupEx activeLookup = LookupManager.getInstance(project).getActiveLookup();
        if (activeLookup != null && (item = activeLookup.getCurrentItem()) != null && item.isValid() && (psi = CompletionUtil.getTargetElement(item)) != null && psi.isValid()) {
            return psi;
        }
        return null;
    }

    private boolean isAcceptableReferencedElement(@Nullable PsiElement element, @Nullable PsiElement referenceOrReferencedElement) {
        TargetElementEvaluatorEx2 evaluator;
        if (referenceOrReferencedElement == null || !referenceOrReferencedElement.isValid()) {
            return false;
        }
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = element != null ? TargetElementUtil.getElementEvaluatorsEx2(element.getLanguage()) : null;
        if (evaluator != null) {
            ThreeState answer = evaluator.isAcceptableReferencedElement(element, referenceOrReferencedElement);
            if (answer == ThreeState.YES) {
                return true;
            }
            if (answer == ThreeState.NO) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public PsiElement adjustElement(Editor editor, int flags, @Nullable PsiElement element, @Nullable PsiElement contextElement) {
        TargetElementEvaluatorEx2 evaluator;
        PsiElement langElement = element == null ? contextElement : element;
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = langElement != null ? TargetElementUtil.getElementEvaluatorsEx2(langElement.getLanguage()) : null;
        if (evaluator != null) {
            element = evaluator.adjustElement(editor, flags, element, contextElement);
        }
        return element;
    }

    @Nullable
    public PsiElement adjustReference(@NotNull PsiReference ref) {
        PsiElement element;
        TargetElementEvaluatorEx2 evaluator;
        if (ref == null) {
            TargetElementUtil.$$$reportNull$$$0(5);
        }
        return (evaluator = TargetElementUtil.getElementEvaluatorsEx2((element = ref.getElement()).getLanguage())) != null ? evaluator.adjustReference(ref) : null;
    }

    @Override
    @Nullable
    public PsiElement getNamedElement(@Nullable PsiElement element, int offsetInElement) {
        if (element == null) {
            return null;
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        ArrayList targets2 = new ArrayList();
        Consumer consumer = target2 -> {
            if (target2 instanceof PsiDeclaredTarget) {
                PsiDeclaredTarget declaredTarget = (PsiDeclaredTarget)target2;
                PsiElement navigationElement = declaredTarget.getNavigationElement();
                TextRange range2 = declaredTarget.getNameIdentifierRange();
                if (range2 != null && !range2.shiftRight(navigationElement.getTextRange().getStartOffset()).contains(element.getTextRange().getStartOffset() + offsetInElement)) {
                    return;
                }
            }
            targets2.add(target2);
        };
        int offset = offsetInElement;
        for (PsiElement parent = element; parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            for (PomDeclarationSearcher searcher : (PomDeclarationSearcher[])PomDeclarationSearcher.EP_NAME.getExtensions()) {
                searcher.findDeclarationsAt(parent, offset, consumer);
                if (targets2.isEmpty()) continue;
                PomTarget target3 = (PomTarget)targets2.get(0);
                return target3 == null ? null : PomService.convertToPsi((Project)element.getProject(), (PomTarget)target3);
            }
            offset += parent.getStartOffsetInParent();
        }
        return TargetElementUtil.getNamedElement(element);
    }

    @Nullable
    private static PsiElement getNamedElement(@Nullable PsiElement element) {
        PsiElement result2;
        if (element == null) {
            return null;
        }
        TargetElementEvaluatorEx2 evaluator = TargetElementUtil.getElementEvaluatorsEx2(element.getLanguage());
        if (evaluator != null && (result2 = evaluator.getNamedElement(element)) != null) {
            return result2;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, PsiNamedElement.class, (boolean)false);
        if (parent != null && !(parent instanceof PsiFile) && parent.getTextOffset() == element.getTextRange().getStartOffset() && (evaluator == null || evaluator.isAcceptableNamedParent(parent))) {
            return parent;
        }
        return null;
    }

    @Nullable
    private static PsiElement getReferenceOrReferencedElement(@NotNull PsiFile file2, @NotNull Editor editor, int flags, int offset) {
        if (file2 == null) {
            TargetElementUtil.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            TargetElementUtil.$$$reportNull$$$0(7);
        }
        PsiElement result2 = TargetElementUtil.doGetReferenceOrReferencedElement(editor, flags, offset);
        PsiElement languageElement = file2.findElementAt(offset);
        Language language = languageElement != null ? languageElement.getLanguage() : file2.getLanguage();
        TargetElementEvaluatorEx2 evaluator = TargetElementUtil.getElementEvaluatorsEx2(language);
        if (evaluator != null) {
            result2 = evaluator.adjustReferenceOrReferencedElement(file2, editor, offset, flags, result2);
        }
        return result2;
    }

    @Nullable
    private static PsiElement doGetReferenceOrReferencedElement(@NotNull Editor editor, int flags, int offset) {
        PsiElement element;
        PsiReference ref;
        if (editor == null) {
            TargetElementUtil.$$$reportNull$$$0(8);
        }
        if ((ref = TargetElementUtil.findReference(editor, offset)) == null) {
            return null;
        }
        Language language = ref.getElement().getLanguage();
        TargetElementEvaluator evaluator = (TargetElementEvaluator)TARGET_ELEMENT_EVALUATOR.forLanguage(language);
        if (evaluator != null && (element = evaluator.getElementByReference(ref, flags)) != null) {
            return element;
        }
        return ref.resolve();
    }

    @Override
    @NotNull
    public Collection<PsiElement> getTargetCandidates(@NotNull PsiReference reference2) {
        Collection<PsiElement> candidates;
        PsiElement refElement;
        TargetElementEvaluatorEx2 evaluator;
        if (reference2 == null) {
            TargetElementUtil.$$$reportNull$$$0(9);
        }
        if ((evaluator = TargetElementUtil.getElementEvaluatorsEx2((refElement = reference2.getElement()).getLanguage())) != null && (candidates = evaluator.getTargetCandidates(reference2)) != null) {
            Collection<PsiElement> collection = candidates;
            if (collection == null) {
                TargetElementUtil.$$$reportNull$$$0(10);
            }
            return collection;
        }
        if (reference2 instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference2).multiResolve(false);
            ArrayList<PsiElement> navigatableResults = new ArrayList<PsiElement>(results.length);
            for (ResolveResult r : results) {
                PsiElement element = r.getElement();
                if (!this.isNavigatableSource(element)) continue;
                navigatableResults.add(element);
            }
            ArrayList<PsiElement> arrayList = navigatableResults;
            if (arrayList == null) {
                TargetElementUtil.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        PsiElement resolved = reference2.resolve();
        if (resolved instanceof NavigationItem) {
            Set<PsiElement> set = Collections.singleton(resolved);
            if (set == null) {
                TargetElementUtil.$$$reportNull$$$0(12);
            }
            return set;
        }
        List<PsiElement> list2 = Collections.emptyList();
        if (list2 == null) {
            TargetElementUtil.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @Contract(value="null -> false")
    public boolean isNavigatableSource(@Nullable PsiElement element) {
        return EditSourceUtil.canNavigate((PsiElement)element) || element instanceof Navigatable && ((Navigatable)element).canNavigateToSource();
    }

    @Override
    public PsiElement getGotoDeclarationTarget(PsiElement element, PsiElement navElement) {
        PsiElement result2;
        TargetElementEvaluatorEx2 evaluator;
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = element != null ? TargetElementUtil.getElementEvaluatorsEx2(element.getLanguage()) : null;
        if (evaluator != null && (result2 = evaluator.getGotoDeclarationTarget(element, navElement)) != null) {
            return result2;
        }
        return navElement;
    }

    @Override
    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element) {
        TargetElementEvaluator evaluator;
        if (element == null) {
            TargetElementUtil.$$$reportNull$$$0(14);
        }
        return (evaluator = (TargetElementEvaluator)TARGET_ELEMENT_EVALUATOR.forLanguage(element.getLanguage())) == null || evaluator.includeSelfInGotoImplementation(element);
    }

    public boolean acceptImplementationForReference(@Nullable PsiReference reference2, @Nullable PsiElement element) {
        TargetElementEvaluatorEx2 evaluator = element != null ? TargetElementUtil.getElementEvaluatorsEx2((Language)ReadAction.compute(() -> ((PsiElement)element).getLanguage())) : null;
        return evaluator == null || evaluator.acceptImplementationForReference(reference2, element);
    }

    @Override
    @NotNull
    public SearchScope getSearchScope(Editor editor, @NotNull PsiElement element) {
        TargetElementEvaluatorEx2 evaluator;
        SearchScope result2;
        if (element == null) {
            TargetElementUtil.$$$reportNull$$$0(15);
        }
        SearchScope searchScope = result2 = (evaluator = TargetElementUtil.getElementEvaluatorsEx2(element.getLanguage())) != null ? evaluator.getSearchScope(editor, element) : null;
        if (result2 != null) {
            SearchScope searchScope2 = result2;
            if (searchScope2 == null) {
                TargetElementUtil.$$$reportNull$$$0(16);
            }
            return searchScope2;
        }
        PsiFile file2 = element.getContainingFile();
        SearchScope searchScope3 = PsiSearchHelper.getInstance((Project)element.getProject()).getUseScope((PsiElement)(file2 != null ? file2 : element));
        if (searchScope3 == null) {
            TargetElementUtil.$$$reportNull$$$0(17);
        }
        return searchScope3;
    }

    @Nullable
    private static TargetElementEvaluatorEx getElementEvaluatorsEx(@NotNull Language language) {
        TargetElementEvaluator result2;
        if (language == null) {
            TargetElementUtil.$$$reportNull$$$0(18);
        }
        return (result2 = (TargetElementEvaluator)TARGET_ELEMENT_EVALUATOR.forLanguage(language)) instanceof TargetElementEvaluatorEx ? (TargetElementEvaluatorEx)result2 : null;
    }

    @Nullable
    private static TargetElementEvaluatorEx2 getElementEvaluatorsEx2(@NotNull Language language) {
        TargetElementEvaluator result2;
        if (language == null) {
            TargetElementUtil.$$$reportNull$$$0(19);
        }
        return (result2 = (TargetElementEvaluator)TARGET_ELEMENT_EVALUATOR.forLanguage(language)) instanceof TargetElementEvaluatorEx2 ? (TargetElementEvaluatorEx2)result2 : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/TargetElementUtil";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/TargetElementUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetCandidates";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inVirtualSpace";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doFindTargetElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceOrReferencedElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doGetReferenceOrReferencedElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTargetCandidates";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "includeSelfInGotoImplementation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getElementEvaluatorsEx";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getElementEvaluatorsEx2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

