/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.AppearanceOptionsTopHitProvider;
import com.intellij.ide.ui.DaemonCodeAnalyzerOptionDescription;
import com.intellij.ide.ui.EditorOptionsTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UISimpleSettingsProvider
implements SearchTopHitProvider,
OptionsTopHitProvider.CoveredByToggleActions {
    private static final OptionDescription CYCLING_SCROLLING = AppearanceOptionsTopHitProvider.appearance("Cyclic scrolling", "cycleScrolling");
    private static final OptionDescription MEMORY_INDICATOR = AppearanceOptionsTopHitProvider.appearance("Show Memory Indicator", "showMemoryIndicator");
    private static final OptionDescription SHOW_MAIN_TOOLBAR = AppearanceOptionsTopHitProvider.appearance("Show Main Toolbar", "showMainToolbar");
    private static final OptionDescription SHOW_NAVIGATION_BAR = AppearanceOptionsTopHitProvider.appearance("Show Navigation Bar", "showNavigationBar");
    private static final OptionDescription HIDE_TOOL_STRIPES = AppearanceOptionsTopHitProvider.appearance("Hide Tool Window Bars", "hideToolStripes");
    private static final OptionDescription SHOW_STATUS_BAR = AppearanceOptionsTopHitProvider.appearance("Show Status Bar", "showStatusBar");
    private static final OptionDescription IS_BLOCK_CURSOR = EditorOptionsTopHitProvider.editor("Show Block Cursor", "IS_BLOCK_CURSOR");
    private static final OptionDescription IS_WHITESPACES_SHOWN = EditorOptionsTopHitProvider.editor("Show Whitespaces", "IS_WHITESPACES_SHOWN");
    private static final OptionDescription ARE_LINE_NUMBERS_SHOWN = EditorOptionsTopHitProvider.editor("Show Line Numbers", "ARE_LINE_NUMBERS_SHOWN");
    private static final OptionDescription SHOW_METHOD_SEPARATORS = new DaemonCodeAnalyzerOptionDescription("SHOW_METHOD_SEPARATORS", "Show Method Separators", "appearance");

    public void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (pattern == null) {
            UISimpleSettingsProvider.$$$reportNull$$$0(0);
        }
        if (collector == null) {
            UISimpleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (StringUtil.isBetween((String)(pattern = StringUtil.toLowerCase((String)pattern.trim())), (String)"cyc", (String)"cyclic ") || StringUtil.isBetween((String)pattern, (String)"scr", (String)"scroll ")) {
            collector.accept(CYCLING_SCROLLING);
        } else if (UISimpleSettingsProvider.patternContains(pattern, "memo")) {
            collector.accept(MEMORY_INDICATOR);
        } else if (StringUtil.isBetween((String)pattern, (String)"nav", (String)"navigation bar ") || StringUtil.isBetween((String)pattern, (String)"navb", (String)"navbar ")) {
            collector.accept(SHOW_NAVIGATION_BAR);
        } else if (StringUtil.isBetween((String)pattern, (String)"tool", (String)"toolbar ")) {
            collector.accept(SHOW_MAIN_TOOLBAR);
        } else if (StringUtil.isBetween((String)pattern, (String)"tool w", (String)"tool window bars") || StringUtil.isBetween((String)pattern, (String)"toolw", (String)"toolwindow ")) {
            collector.accept(HIDE_TOOL_STRIPES);
        } else if (StringUtil.isBetween((String)pattern, (String)"stat", (String)"status bar ")) {
            collector.accept(SHOW_STATUS_BAR);
        } else if (StringUtil.isBetween((String)pattern, (String)"curs", (String)"cursor ") || StringUtil.isBetween((String)pattern, (String)"block ", (String)"block cursor ") || StringUtil.isBetween((String)pattern, (String)"caret", (String)"caret ") || StringUtil.isBetween((String)pattern, (String)"block ", (String)"block caret ")) {
            collector.accept(IS_BLOCK_CURSOR);
        } else if (StringUtil.isBetween((String)pattern, (String)"whites", (String)"whitespaces ") || StringUtil.isBetween((String)pattern, (String)"show whi", (String)"show whitespaces ")) {
            collector.accept(IS_WHITESPACES_SHOWN);
        } else if (StringUtil.isBetween((String)pattern, (String)"line ", (String)"line numbers ") || StringUtil.isBetween((String)pattern, (String)"show li", (String)"show line numbers ")) {
            collector.accept(ARE_LINE_NUMBERS_SHOWN);
        } else if (StringUtil.isBetween((String)pattern, (String)"separa ", (String)"separators ") || StringUtil.isBetween((String)pattern, (String)"method s", (String)"method separators ")) {
            collector.accept(SHOW_METHOD_SEPARATORS);
        }
    }

    private static boolean patternContains(String pattern, String search2) {
        for (String s : pattern.split(" ")) {
            if (!s.contains(search2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "pattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "collector";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/ui/UISimpleSettingsProvider";
        objectArray[2] = "consumeTopHits";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

