/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutableSyntheticLibrary
extends SyntheticLibrary {
    private final Collection<VirtualFile> myBinaryRoots;
    private final Collection<VirtualFile> mySourceRoots;
    private final Set<VirtualFile> myExcludedRoots;
    private final Condition<VirtualFile> myExcludeCondition;

    ImmutableSyntheticLibrary(@NotNull Collection<VirtualFile> sourceRoots, @NotNull Collection<VirtualFile> binaryRoots, @NotNull Set<VirtualFile> excludedRoots, @Nullable Condition<VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(0);
        }
        if (binaryRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(1);
        }
        if (excludedRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(2);
        }
        this.mySourceRoots = ContainerUtil.unmodifiableOrEmptyCollection(sourceRoots);
        this.myBinaryRoots = ContainerUtil.unmodifiableOrEmptyCollection(binaryRoots);
        this.myExcludedRoots = ContainerUtil.unmodifiableOrEmptySet(excludedRoots);
        this.myExcludeCondition = excludeCondition;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSourceRoots() {
        Collection<VirtualFile> collection = this.mySourceRoots;
        if (collection == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getBinaryRoots() {
        Collection<VirtualFile> collection = this.myBinaryRoots;
        if (collection == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set = this.myExcludedRoots;
        if (set == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @Nullable
    public Condition<VirtualFile> getExcludeFileCondition() {
        return this.myExcludeCondition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSyntheticLibrary library = (ImmutableSyntheticLibrary)o;
        if (!this.mySourceRoots.equals(library.getSourceRoots())) {
            return false;
        }
        if (!this.myBinaryRoots.equals(library.getBinaryRoots())) {
            return false;
        }
        if (!this.myExcludedRoots.equals(library.getExcludedRoots())) {
            return false;
        }
        return Objects.equals(this.myExcludeCondition, library.getExcludeFileCondition());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mySourceRoots, this.myBinaryRoots, this.myExcludedRoots, this.myExcludeCondition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ImmutableSyntheticLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ImmutableSyntheticLibrary";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

