/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFilePointerContainerImpl
extends TraceableDisposable
implements VirtualFilePointerContainer,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer");
    private static final int UNINITIALIZED = -1;
    @NotNull
    private final ConcurrentList<VirtualFilePointer> myList;
    @NotNull
    private final ConcurrentList<VirtualFilePointer> myJarDirectories;
    @NotNull
    private final ConcurrentList<VirtualFilePointer> myJarRecursiveDirectories;
    @NotNull
    private final VirtualFilePointerManager myVirtualFilePointerManager;
    @NotNull
    private final Disposable myParent;
    private final VirtualFilePointerListener myListener;
    private volatile Trinity<String[], VirtualFile[], VirtualFile[]> myCachedThings;
    private volatile long myTimeStampOfCachedThings;
    @NonNls
    public static final String URL_ATTR = "url";
    private boolean myDisposed;
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    @NonNls
    public static final String JAR_DIRECTORY_ELEMENT = "jarDirectory";
    @NonNls
    public static final String RECURSIVE_ATTR = "recursive";
    private static final Trinity<String[], VirtualFile[], VirtualFile[]> EMPTY = Trinity.create((Object)ArrayUtilRt.EMPTY_STRING_ARRAY, (Object)VirtualFile.EMPTY_ARRAY, (Object)VirtualFile.EMPTY_ARRAY);

    VirtualFilePointerContainerImpl(@NotNull VirtualFilePointerManager manager, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2) {
        if (manager == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(1);
        }
        super(TRACE_CREATION && !ApplicationInfoImpl.isInStressTest());
        this.myList = ContainerUtil.createConcurrentList();
        this.myJarDirectories = ContainerUtil.createConcurrentList();
        this.myJarRecursiveDirectories = ContainerUtil.createConcurrentList();
        this.myTimeStampOfCachedThings = -1L;
        this.myVirtualFilePointerManager = manager;
        this.myParent = parentDisposable;
        this.myListener = listener2;
    }

    public void readExternal(@NotNull Element rootChild, @NotNull String childName, boolean externalizeJarDirectories) throws InvalidDataException {
        if (rootChild == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(2);
        }
        if (childName == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(3);
        }
        List urls = rootChild.getChildren(childName);
        this.addAll(ContainerUtil.map((Collection)urls, url -> url.getAttributeValue(URL_ATTR)));
        if (externalizeJarDirectories) {
            List jarDirs = rootChild.getChildren(JAR_DIRECTORY_ELEMENT);
            for (Element jarDir : jarDirs) {
                String url2 = jarDir.getAttributeValue(URL_ATTR);
                if (url2 == null) {
                    throw new InvalidDataException("path element without url: " + JDOMUtil.getValue((Object)jarDir));
                }
                boolean recursive = Boolean.valueOf(jarDir.getAttributeValue(RECURSIVE_ATTR, "false"));
                this.addJarDirectory(url2, recursive);
            }
        }
    }

    public void writeExternal(@NotNull Element element, @NotNull String childElementName, boolean externalizeJarDirectories) {
        if (element == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(4);
        }
        if (childElementName == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(5);
        }
        for (VirtualFilePointer pointer : this.myList) {
            String url = pointer.getUrl();
            Element rootPathElement = new Element(childElementName);
            rootPathElement.setAttribute(URL_ATTR, url);
            element.addContent(rootPathElement);
        }
        if (externalizeJarDirectories) {
            VirtualFilePointerContainerImpl.writeJarDirs(this.myJarDirectories, element, false);
            VirtualFilePointerContainerImpl.writeJarDirs(this.myJarRecursiveDirectories, element, true);
        }
    }

    private static void writeJarDirs(@NotNull List<? extends VirtualFilePointer> myJarDirectories, @NotNull Element element, boolean recursive) {
        if (myJarDirectories == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(6);
        }
        if (element == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(7);
        }
        ArrayList<? extends VirtualFilePointer> jarDirectories = new ArrayList<VirtualFilePointer>(myJarDirectories);
        Collections.sort(jarDirectories, Comparator.comparing(VirtualFilePointer::getUrl, String.CASE_INSENSITIVE_ORDER));
        for (VirtualFilePointer virtualFilePointer : jarDirectories) {
            String url = virtualFilePointer.getUrl();
            Element jarDirElement = new Element(JAR_DIRECTORY_ELEMENT);
            jarDirElement.setAttribute(URL_ATTR, url);
            jarDirElement.setAttribute(RECURSIVE_ATTR, Boolean.toString(recursive));
            element.addContent(jarDirElement);
        }
    }

    public void moveUp(@NotNull String url) {
        int index;
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(8);
        }
        if ((index = this.indexOf(url)) <= 0) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, (int)(index - 1), (int)index);
    }

    public void moveDown(@NotNull String url) {
        int index;
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(9);
        }
        if ((index = this.indexOf(url)) < 0 || index + 1 >= this.myList.size()) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, (int)index, (int)(index + 1));
    }

    private int indexOf(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(10);
        }
        for (int i = 0; i < this.myList.size(); ++i) {
            VirtualFilePointer pointer = (VirtualFilePointer)this.myList.get(i);
            if (!url.equals(pointer.getUrl())) continue;
            return i;
        }
        return -1;
    }

    public void killAll() {
        this.myList.clear();
    }

    public void add(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(11);
        }
        assert (!this.myDisposed);
        this.dropCaches();
        this.myList.addIfAbsent((Object)this.create(file2));
    }

    public void add(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(12);
        }
        assert (!this.myDisposed);
        this.dropCaches();
        this.myList.addIfAbsent((Object)this.create(url));
    }

    public void remove(@NotNull VirtualFilePointer pointer) {
        if (pointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(13);
        }
        assert (!this.myDisposed);
        this.dropCaches();
        boolean result2 = this.myList.remove((Object)pointer);
        LOG.assertTrue(result2);
    }

    @NotNull
    public List<VirtualFilePointer> getList() {
        assert (!this.myDisposed);
        List<VirtualFilePointer> list2 = Collections.unmodifiableList(this.myList);
        if (list2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(14);
        }
        return list2;
    }

    public void addAll(@NotNull VirtualFilePointerContainer that) {
        if (that == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(15);
        }
        assert (!this.myDisposed);
        this.dropCaches();
        this.addAll(Arrays.asList(that.getUrls()));
        List jarDups = ContainerUtil.map(((VirtualFilePointerContainerImpl)that).myJarDirectories, this::duplicate);
        List jarRecursiveDups = ContainerUtil.map(((VirtualFilePointerContainerImpl)that).myJarRecursiveDirectories, this::duplicate);
        this.myJarDirectories.addAllAbsent((Collection)jarDups);
        this.myJarRecursiveDirectories.addAllAbsent((Collection)jarRecursiveDups);
    }

    public void addAll(@NotNull Collection<String> urls) {
        if (urls == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(16);
        }
        this.myList.addAllAbsent((Collection)ContainerUtil.map(urls, url -> this.create((String)url)));
    }

    private void dropCaches() {
        this.myTimeStampOfCachedThings = -1L;
        this.myCachedThings = EMPTY;
    }

    @NotNull
    public String[] getUrls() {
        if (this.myTimeStampOfCachedThings == -1L) {
            String[] stringArray = (String[])this.myList.stream().map(VirtualFilePointer::getUrl).toArray(String[]::new);
            if (stringArray == null) {
                VirtualFilePointerContainerImpl.$$$reportNull$$$0(17);
            }
            return stringArray;
        }
        String[] stringArray = (String[])this.getOrCache().first;
        if (stringArray == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> getOrCache() {
        assert (!this.myDisposed);
        long timeStamp = this.myTimeStampOfCachedThings;
        Trinity<String[], VirtualFile[], VirtualFile[]> cached = this.myCachedThings;
        Trinity<String[], VirtualFile[], VirtualFile[]> trinity = timeStamp == this.myVirtualFilePointerManager.getModificationCount() ? cached : this.cacheThings();
        if (trinity == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(19);
        }
        return trinity;
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> cacheThings() {
        Trinity result2;
        if (this.myList.isEmpty() && this.myJarDirectories.isEmpty() && this.myJarRecursiveDirectories.isEmpty()) {
            result2 = EMPTY;
        } else {
            VirtualFile jarDirectory;
            final ArrayList<VirtualFile> cachedFiles = new ArrayList<VirtualFile>(this.myList.size());
            ArrayList<String> cachedUrls = new ArrayList<String>(this.myList.size());
            final ArrayList<VirtualFile> cachedDirectories = new ArrayList<VirtualFile>(this.myList.size() / 3);
            boolean allFilesAreDirs = true;
            for (VirtualFilePointer v : this.myList) {
                VirtualFile file2 = v.getFile();
                String url = v.getUrl();
                cachedUrls.add(url);
                if (file2 == null) continue;
                cachedFiles.add(file2);
                if (file2.isDirectory()) {
                    cachedDirectories.add(file2);
                    continue;
                }
                allFilesAreDirs = false;
            }
            for (VirtualFilePointer jarDirectoryPtr : this.myJarDirectories) {
                VirtualFile[] children2;
                jarDirectory = jarDirectoryPtr.getFile();
                if (jarDirectory == null) continue;
                cachedDirectories.remove(jarDirectory);
                for (VirtualFile file3 : children2 = jarDirectory.getChildren()) {
                    VirtualFile jarRoot;
                    if (file3.isDirectory() || FileTypeRegistry.getInstance().getFileTypeByFileName(file3.getNameSequence()) != ArchiveFileType.INSTANCE || (jarRoot = StandardFileSystems.jar().findFileByPath(file3.getPath() + "!/")) == null) continue;
                    cachedFiles.add(jarRoot);
                    cachedDirectories.add(jarRoot);
                }
            }
            for (VirtualFilePointer jarDirectoryPtr : this.myJarRecursiveDirectories) {
                jarDirectory = jarDirectoryPtr.getFile();
                if (jarDirectory == null) continue;
                cachedDirectories.remove(jarDirectory);
                VfsUtilCore.visitChildrenRecursively((VirtualFile)jarDirectory, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file2) {
                        VirtualFile jarRoot;
                        if (file2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!file2.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getNameSequence()) == ArchiveFileType.INSTANCE && (jarRoot = StandardFileSystems.jar().findFileByPath(file2.getPath() + "!/")) != null) {
                            cachedFiles.add(jarRoot);
                            cachedDirectories.add(jarRoot);
                            return false;
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl$1", "visitFile"));
                    }
                });
            }
            String[] urlsArray = ArrayUtilRt.toStringArray(cachedUrls);
            VirtualFile[] directories = VfsUtilCore.toVirtualFileArray(cachedDirectories);
            VirtualFile[] files2 = allFilesAreDirs ? directories : VfsUtilCore.toVirtualFileArray(cachedFiles);
            result2 = Trinity.create((Object)urlsArray, (Object)files2, (Object)directories);
        }
        this.myCachedThings = result2;
        this.myTimeStampOfCachedThings = this.myVirtualFilePointerManager.getModificationCount();
        Trinity trinity = result2;
        if (trinity == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(20);
        }
        return trinity;
    }

    @NotNull
    public VirtualFile[] getFiles() {
        VirtualFile[] virtualFileArray = (VirtualFile[])this.getOrCache().second;
        if (virtualFileArray == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(21);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getDirectories() {
        VirtualFile[] virtualFileArray = (VirtualFile[])this.getOrCache().third;
        if (virtualFileArray == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(22);
        }
        return virtualFileArray;
    }

    @Nullable
    public VirtualFilePointer findByUrl(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(23);
        }
        assert (!this.myDisposed);
        for (VirtualFilePointer pointer : ContainerUtil.concat((List[])new List[]{this.myList, this.myJarDirectories, this.myJarRecursiveDirectories})) {
            if (!url.equals(pointer.getUrl())) continue;
            return pointer;
        }
        return null;
    }

    public void clear() {
        this.dropCaches();
        this.killAll();
    }

    public int size() {
        return this.myList.size() + this.myJarDirectories.size() + this.myJarRecursiveDirectories.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualFilePointerContainerImpl)) {
            return false;
        }
        VirtualFilePointerContainerImpl impl = (VirtualFilePointerContainerImpl)((Object)o);
        return this.myList.equals(impl.myList) && this.myJarDirectories.equals(impl.myJarDirectories) && this.myJarRecursiveDirectories.equals(impl.myJarRecursiveDirectories);
    }

    public int hashCode() {
        return this.myList.hashCode();
    }

    @NotNull
    protected VirtualFilePointer create(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(24);
        }
        VirtualFilePointer virtualFilePointer = this.myVirtualFilePointerManager.create(file2, this.myParent, this.myListener);
        if (virtualFilePointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(25);
        }
        return virtualFilePointer;
    }

    @NotNull
    protected VirtualFilePointer create(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(26);
        }
        VirtualFilePointer virtualFilePointer = this.myVirtualFilePointerManager.create(url, this.myParent, this.myListener);
        if (virtualFilePointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(27);
        }
        return virtualFilePointer;
    }

    @NotNull
    protected VirtualFilePointer duplicate(@NotNull VirtualFilePointer virtualFilePointer) {
        if (virtualFilePointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(28);
        }
        VirtualFilePointer virtualFilePointer2 = this.myVirtualFilePointerManager.duplicate(virtualFilePointer, this.myParent, this.myListener);
        if (virtualFilePointer2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(29);
        }
        return virtualFilePointer2;
    }

    @NotNull
    @NonNls
    public String toString() {
        String string = "VFPContainer: " + this.myList + (this.myJarDirectories.isEmpty() ? "" : ", jars: " + this.myJarDirectories) + (this.myJarRecursiveDirectories.isEmpty() ? "" : ", jars(recursively): " + this.myJarRecursiveDirectories);
        if (string == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent) {
        if (parent == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(31);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.clone(parent, null);
        if (virtualFilePointerContainer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(32);
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (parent == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(33);
        }
        assert (!this.myDisposed);
        VirtualFilePointerContainerImpl clone = (VirtualFilePointerContainerImpl)this.myVirtualFilePointerManager.createContainer(parent, listener2);
        List toAdd = ContainerUtil.map(this.myList, p -> clone.create(p.getUrl()));
        clone.myList.addAll((Collection)toAdd);
        clone.addAllJarDirectories(ContainerUtil.map(this.myJarDirectories, VirtualFilePointer::getUrl), false);
        clone.addAllJarDirectories(ContainerUtil.map(this.myJarRecursiveDirectories, VirtualFilePointer::getUrl), true);
        VirtualFilePointerContainerImpl virtualFilePointerContainerImpl = clone;
        if (virtualFilePointerContainerImpl == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(34);
        }
        return virtualFilePointerContainerImpl;
    }

    public void dispose() {
        assert (!this.myDisposed);
        this.myDisposed = true;
        this.kill(null);
        this.clear();
    }

    public void addJarDirectory(@NotNull String directoryUrl, boolean recursively) {
        if (directoryUrl == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(35);
        }
        VirtualFilePointer pointer = this.myVirtualFilePointerManager.createDirectoryPointer(directoryUrl, recursively, this.myParent, this.myListener);
        (recursively ? this.myJarRecursiveDirectories : this.myJarDirectories).addIfAbsent((Object)pointer);
        this.myList.addIfAbsent((Object)pointer);
        this.dropCaches();
    }

    public void addAllJarDirectories(@NotNull Collection<String> directoryUrls, boolean recursively) {
        if (directoryUrls == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(36);
        }
        if (directoryUrls.isEmpty()) {
            return;
        }
        List pointers = ContainerUtil.map(directoryUrls, url -> this.myVirtualFilePointerManager.createDirectoryPointer(url, recursively, this.myParent, this.myListener));
        (recursively ? this.myJarRecursiveDirectories : this.myJarDirectories).addAllAbsent((Collection)pointers);
        this.myList.addAllAbsent((Collection)pointers);
        this.dropCaches();
    }

    public boolean removeJarDirectory(@NotNull String directoryUrl) {
        if (directoryUrl == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(37);
        }
        this.dropCaches();
        Predicate<VirtualFilePointer> filter = ptr -> FileUtil.pathsEqual((String)ptr.getUrl(), (String)directoryUrl);
        boolean removed0 = this.myList.removeIf(filter);
        boolean removed1 = this.myJarDirectories.removeIf(filter);
        boolean removed2 = this.myJarRecursiveDirectories.removeIf(filter);
        return removed0 || removed1 || removed2;
    }

    @NotNull
    public List<Pair<String, Boolean>> getJarDirectories() {
        List jars = ContainerUtil.map(this.myJarDirectories, ptr -> Pair.create((Object)ptr.getUrl(), (Object)false));
        List recJars = ContainerUtil.map(this.myJarRecursiveDirectories, ptr -> Pair.create((Object)ptr.getUrl(), (Object)true));
        List list2 = ContainerUtil.concat((List)jars, (List)recJars);
        if (list2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(38);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootChild";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElementName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myJarDirectories";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTR;
                break;
            }
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFilePointer";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryUrl";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCache";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheThings";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "duplicate";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeJarDirs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveUp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moveDown";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 38: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findByUrl";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "duplicate";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addJarDirectory";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addAllJarDirectories";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeJarDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

