/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.ide.passwordSafe.PasswordSafe;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterLoginException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterCellExecutionManager;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.HttpSession;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b\u001a\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"LOGIN_FORM_PASSWORD_FIELD_NAME", "", "LOGIN_FORM_URI_PATH", "XSRF_COOKIE_NAME", "getCredentialsAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "jupyterServer", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;", "isPasswordMemoryOnly", "", "getRememberedPasswordOrToken", "Lcom/intellij/credentialStore/OneTimeString;", "logInToJupyterServer", "", "httpSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "passwordOrToken", "rememberPasswordOrToken", "intellij.python.jupyter"})
public final class JupyterLoginKt {
    private static final String XSRF_COOKIE_NAME = "_xsrf";
    private static final String LOGIN_FORM_URI_PATH = "/login";
    private static final String LOGIN_FORM_PASSWORD_FIELD_NAME = "password";

    public static final void logInToJupyterServer(@NotNull HttpSession httpSession, @NotNull OneTimeString passwordOrToken) {
        HttpResponse response2;
        HttpResponse getResponse;
        Intrinsics.checkParameterIsNotNull((Object)httpSession, (String)"httpSession");
        Intrinsics.checkParameterIsNotNull((Object)passwordOrToken, (String)"passwordOrToken");
        URI loginUri = new URIBuilder(httpSession.getBaseURI()).setPath(LOGIN_FORM_URI_PATH).build();
        Request loginGetRequest = Request.Get((URI)loginUri);
        HttpResponse httpResponse = getResponse = httpSession.getHttpRequestsExecutor().execute(loginGetRequest).returnResponse();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponse, (String)"getResponse");
        StatusLine statusLine = httpResponse.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"getResponse.statusLine");
        switch (statusLine.getStatusCode()) {
            case 200: 
            case 302: {
                break;
            }
            default: {
                new JupyterLoginException("Logging in at " + loginUri + " failed");
            }
        }
        String xsrfCookieValue = httpSession.getCookies().get(XSRF_COOKIE_NAME);
        List loginForm = Form.form().add(XSRF_COOKIE_NAME, xsrfCookieValue).add(LOGIN_FORM_PASSWORD_FIELD_NAME, passwordOrToken.toString()).build();
        Request loginRequest = Request.Post((URI)loginUri).bodyForm((Iterable)loginForm);
        HttpResponse httpResponse2 = response2 = httpSession.getHttpRequestsExecutor().execute(loginRequest).returnResponse();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponse2, (String)"response");
        StatusLine statusLine2 = httpResponse2.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"response.statusLine");
        switch (statusLine2.getStatusCode()) {
            case 200: 
            case 302: {
                break;
            }
            case 401: 
            case 403: {
                throw (Throwable)new JupyterLoginException("Login at " + loginUri + " failed");
            }
            default: {
                throw (Throwable)new JupyterLoginException("Authentication at " + loginUri + " failed");
            }
        }
    }

    public static final void rememberPasswordOrToken(@NotNull JupyterServer jupyterServer, @NotNull OneTimeString passwordOrToken) {
        Intrinsics.checkParameterIsNotNull((Object)jupyterServer, (String)"jupyterServer");
        Intrinsics.checkParameterIsNotNull((Object)passwordOrToken, (String)"passwordOrToken");
        CredentialAttributes credentialAttributes = JupyterLoginKt.getCredentialsAttributes(jupyterServer, false);
        Credentials credentials = new Credentials(null, passwordOrToken);
        PasswordSafe.Companion.getInstance().set(credentialAttributes, credentials);
    }

    @Nullable
    public static final OneTimeString getRememberedPasswordOrToken(@NotNull JupyterServer jupyterServer) {
        Credentials credentials;
        Intrinsics.checkParameterIsNotNull((Object)jupyterServer, (String)"jupyterServer");
        CredentialAttributes credentialsAttributes = JupyterLoginKt.getCredentialsAttributes(jupyterServer, false);
        Credentials credentials2 = credentials = PasswordSafe.Companion.getInstance().get(credentialsAttributes);
        return credentials2 != null ? credentials2.getPassword() : null;
    }

    private static final CredentialAttributes getCredentialsAttributes(JupyterServer jupyterServer, boolean isPasswordMemoryOnly) {
        String key = jupyterServer.getConnectionParameters().getManaged() ? "Managed Jupyter Server" : jupyterServer.getConnectionParameters().getUrlString();
        String serviceName = CredentialAttributesKt.generateServiceName((String)"Jupyter Password or Token", (String)key);
        return new CredentialAttributes(serviceName, null, JupyterCellExecutionManager.class, isPasswordMemoryOnly);
    }
}

