/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution.core;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u001e\u0010\f\u001a\u00020\r*\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a8\u0006\u000f"}, d2={"getKernelInterpreterPathAlternatives", "", "", "interpreterPath", "getKernelSpecPath", "kernelSpec", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "resolveSymlink", "path", "getProjectInterpreterKernelSpecs", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;", "projectInterpreterPath", "isManagedServerRunningFromProjectInterpreter", "", "kernelSpecPath", "intellij.python.jupyter"})
public final class JupyterServersKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JupyterKernelSpec> getProjectInterpreterKernelSpecs(@NotNull JupyterServer $this$getProjectInterpreterKernelSpecs, @NotNull String projectInterpreterPath) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$this$getProjectInterpreterKernelSpecs, (String)"$this$getProjectInterpreterKernelSpecs");
        Intrinsics.checkParameterIsNotNull((Object)projectInterpreterPath, (String)"projectInterpreterPath");
        List<String> projectInterpreterPaths = JupyterServersKt.getKernelInterpreterPathAlternatives(projectInterpreterPath);
        List<JupyterKernelSpec> list2 = $this$getProjectInterpreterKernelSpecs.getKernelSpecs();
        if (list2 != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block6: {
                    JupyterKernelSpec kernelSpec = (JupyterKernelSpec)element$iv$iv;
                    boolean bl2 = false;
                    String kernelSpecPath = JupyterServersKt.getKernelSpecPath(kernelSpec);
                    Iterable $this$any$iv = projectInterpreterPaths;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!(Intrinsics.areEqual((Object)kernelSpecPath, (Object)it) || JupyterServersKt.isManagedServerRunningFromProjectInterpreter($this$getProjectInterpreterKernelSpecs, kernelSpecPath, it))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List<String> getKernelInterpreterPathAlternatives(String interpreterPath) {
        String resolvedInterpreterPath = JupyterServersKt.resolveSymlink(interpreterPath);
        return resolvedInterpreterPath != null && Intrinsics.areEqual((Object)resolvedInterpreterPath, (Object)interpreterPath) ^ true ? CollectionsKt.listOf((Object[])new String[]{interpreterPath, resolvedInterpreterPath}) : CollectionsKt.listOf((Object)interpreterPath);
    }

    private static final String resolveSymlink(String path) {
        String string;
        try {
            string = ((Object)Paths.get(path, new String[0]).toRealPath(new LinkOption[0])).toString();
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    private static final String getKernelSpecPath(JupyterKernelSpec kernelSpec) {
        List<String> list = kernelSpec.getArgv();
        return list != null ? list.get(0) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isManagedServerRunningFromProjectInterpreter(@NotNull JupyterServer $this$isManagedServerRunningFromProjectInterpreter, String kernelSpecPath, String projectInterpreterPath) {
        if (kernelSpecPath == null) return false;
        String string = PathUtil.getParentPath((String)projectInterpreterPath);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtil.getParentPath(projectInterpreterPath)");
        String interpreterDirectory = string;
        if (!$this$isManagedServerRunningFromProjectInterpreter.getConnectionParameters().getManaged()) return false;
        if (FileUtil.isAbsolute((String)kernelSpecPath)) return false;
        String string2 = $this$isManagedServerRunningFromProjectInterpreter.getConnectionParameters().getExecutablePath();
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)string2, (String)interpreterDirectory, (boolean)false, (int)2, null)) return false;
        return true;
    }
}

