/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LargeFileWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ThrowableRunnable;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterEvent;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebook;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.NotebookChanged;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0010B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;", "Lcom/intellij/testFramework/LightVirtualFile;", "Lcom/intellij/notebook/editor/BackedVirtualFile;", "Lcom/intellij/openapi/vfs/LargeFileWriteRequestor;", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "notebook", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;)V", "getNotebook", "()Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;", "parentFile", "getOriginFile", "getOriginalFile", "getUrl", "", "Companion", "intellij.python.jupyter"})
public final class JupyterVirtualFile
extends LightVirtualFile
implements BackedVirtualFile,
LargeFileWriteRequestor {
    private final VirtualFile parentFile;
    @NotNull
    private final JupyterNotebook notebook;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public VirtualFile getOriginFile() {
        return this.parentFile;
    }

    @NotNull
    public VirtualFile getOriginalFile() {
        return this.parentFile;
    }

    @NotNull
    public String getUrl() {
        String string = this.parentFile.getUrl();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parentFile.url");
        return string;
    }

    @NotNull
    public final JupyterNotebook getNotebook() {
        return this.notebook;
    }

    public JupyterVirtualFile(final @NotNull VirtualFile originalFile, @NotNull JupyterNotebook notebook) {
        Intrinsics.checkParameterIsNotNull((Object)originalFile, (String)"originalFile");
        Intrinsics.checkParameterIsNotNull((Object)notebook, (String)"notebook");
        super(originalFile, notebook.asSource(), originalFile.getModificationStamp());
        this.notebook = notebook;
        this.notebook.addJupyterChangeListener(new JupyterChangeListener(){

            @Override
            public void onEvent(@NotNull JupyterEvent jupyterEvent) {
                Intrinsics.checkParameterIsNotNull((Object)jupyterEvent, (String)"jupyterEvent");
                if (jupyterEvent instanceof NotebookChanged) {
                    WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(this){
                        final /* synthetic */ 1 this$0;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            Document document = FileDocumentManager.getInstance().getDocument(this.this$0.originalFile);
                            if (document == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"FileDocumentManager.getI\u2026tDocument(originalFile)!!");
                            Document document2 = document;
                            if (document2.isWritable()) {
                                document2.setText(this.this$0.this.getNotebook().asJson());
                            } else {
                                Closeable closeable = new OutputStreamWriter(this.this$0.originalFile.getOutputStream((Object)((Object)this.this$0.this)), Charsets.UTF_8);
                                boolean bl = false;
                                Throwable throwable = null;
                                try {
                                    OutputStreamWriter it = (OutputStreamWriter)closeable;
                                    boolean bl2 = false;
                                    it.write(((Object)this.this$0.this.getNotebook().asJson()).toString());
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
        });
        this.parentFile = originalFile;
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

