/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.ShellChannelBuilder;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.ShellChannel;
import com.intellij.ssh.process.SshProcess;
import com.intellij.ssh.process.SshShellProcess;
import com.jediterm.terminal.TtyConnector;
import com.jetbrains.plugins.remotesdk.console.JschProcessTtyConnector;
import com.jetbrains.plugins.remotesdk.console.SshConsoleProcessHandler;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;

public class SshTerminalDirectRunner
extends AbstractTerminalRunner<SshShellProcess> {
    private final RemoteCredentials myCredentials;
    private final Charset myDefaultCharset;

    public SshTerminalDirectRunner(Project project, RemoteCredentials credentials, Charset charset) {
        super(project);
        this.myCredentials = credentials;
        this.myDefaultCharset = charset;
    }

    protected SshShellProcess createProcess(@Nullable String directory) throws ExecutionException {
        try {
            ShellChannel channel = this.getShellChannel();
            TerminalUsageTriggerCollector.triggerSshShellStarted((Project)this.myProject);
            return new SshShellProcess(channel);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), e);
        }
    }

    @NotNull
    protected ShellChannel getShellChannel() throws RemoteSdkException {
        ShellChannel shellChannel = this.createShellChannel();
        if (shellChannel == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(0);
        }
        return shellChannel;
    }

    @NotNull
    protected final ShellChannel createShellChannel() throws RemoteSdkException {
        ShellChannel shellChannel;
        try {
            shellChannel = ((ShellChannelBuilder)RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)this.myCredentials, (Project)this.myProject).shellBuilder().withAllocatePty(true)).openChannel();
        }
        catch (SshTransportException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        if (shellChannel == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(1);
        }
        return shellChannel;
    }

    protected SshConsoleProcessHandler createProcessHandler(SshShellProcess process2) {
        return new SshConsoleProcessHandler((SshProcess<?>)process2);
    }

    protected TtyConnector createTtyConnector(SshShellProcess process2) {
        return new JschProcessTtyConnector(process2, this.myDefaultCharset);
    }

    public String runningTargetName() {
        return this.myCredentials.getHost() + ":" + this.myCredentials.getLiteralPort();
    }

    protected String getTerminalConnectionName(SshShellProcess process2) {
        SshSession session = process2.getSession();
        return session.getUserName() + "@" + session.getHost() + ":" + session.getPort();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/plugins/remotesdk/console/SshTerminalDirectRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellChannel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createShellChannel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

