/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.LengthUnit;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataType
implements Serializable {
    public static final int MAX_SIZE = Integer.MAX_VALUE;
    public static final int STAR_SIZE = 0x7FFFFFFE;
    public static final int NO_SIZE = -1;
    public static final int NO_SCALE = 0;
    public static final DataType UNKNOWN = new DataType(null, null, "unknown", -1, 0, LengthUnit.NONE, false, null, false, 0);
    @Nullable
    public final String schemaName;
    @Nullable
    public final String packageName;
    @NotNull
    public final String typeName;
    public final int size;
    public final int scale;
    @NotNull
    public final LengthUnit sizeUnit;
    public final String vagueArg;
    @Nullable
    public final String suffix;
    public final boolean sizeUnitExplicit;
    public final boolean custom;
    @Nullable
    public final List<String> enumValues;
    @Deprecated
    public final int jdbcType;

    private DataType(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, boolean sizeUnitExplicit, @Nullable String vagueArg, @Nullable String suffix, boolean custom, @Nullable List<String> enumValues, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(0);
        }
        this.schemaName = DbUtil.intern2(schemaName);
        this.packageName = DbUtil.intern2(packageName);
        this.typeName = DbUtil.intern2(typeName);
        boolean notASize = size == -1 || size == 0x7FFFFFFE || size == Integer.MAX_VALUE;
        this.size = size;
        this.scale = notASize ? 0 : scale;
        this.sizeUnit = sizeUnit != null && !notASize ? sizeUnit : LengthUnit.NONE;
        this.vagueArg = DbUtil.intern2(StringUtil.nullize((String)vagueArg));
        this.suffix = DbUtil.intern2(StringUtil.nullize((String)suffix));
        this.custom = custom;
        this.sizeUnitExplicit = sizeUnitExplicit && this.sizeUnit != LengthUnit.NONE;
        this.jdbcType = jdbcType;
        this.enumValues = enumValues == null || enumValues.isEmpty() ? null : ContainerUtil.immutableList(enumValues);
    }

    public DataType(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, boolean sizeUnitExplicit, @Nullable String suffix, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(1);
        }
        this(schemaName, null, typeName, size, scale, sizeUnit, sizeUnitExplicit, null, suffix, custom, null, jdbcType);
    }

    public DataType(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, boolean sizeUnitExplicit, @Nullable String suffix, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(2);
        }
        this(schemaName, packageName, typeName, size, scale, sizeUnit, sizeUnitExplicit, null, suffix, custom, null, jdbcType);
    }

    public DataType(@Nullable String schemaName, @NotNull String typeName, @Nullable String vagueArg, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(3);
        }
        this(schemaName, null, typeName, -1, 0, null, false, vagueArg, null, custom, null, jdbcType);
    }

    public DataType(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @Nullable String vagueArg, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(4);
        }
        this(schemaName, packageName, typeName, -1, 0, null, false, vagueArg, null, custom, null, jdbcType);
    }

    public DataType(@Nullable String schemaName, @NotNull String typeName, boolean custom, @Nullable List<String> enumValues, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(5);
        }
        this(schemaName, null, typeName, -1, 0, null, false, null, null, custom, enumValues, jdbcType);
    }

    public DataType(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, boolean custom, @Nullable List<String> enumValues, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(6);
        }
        this(schemaName, packageName, typeName, -1, 0, null, false, null, null, custom, enumValues, jdbcType);
    }

    public DataType withTypeName(@NotNull String typeName) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(7);
        }
        return new DataType(this.schemaName, this.packageName, typeName, this.size, this.scale, this.sizeUnit, this.sizeUnitExplicit, this.vagueArg, this.suffix, this.custom, this.enumValues, this.jdbcType);
    }

    @NotNull
    public String getSpecification() {
        String string = this.getSpecification(false, false);
        if (string == null) {
            DataType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getSpecification(boolean forceDefaults, boolean onlyNumbers) {
        if (this.schemaName == null && this.packageName == null && this.vagueArg == null && this.enumValues == null && this.size < 0 && this.suffix == null) {
            String string = this.typeName;
            if (string == null) {
                DataType.$$$reportNull$$$0(9);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(12);
        if (this.schemaName != null) {
            sb.append(this.schemaName).append('.');
        }
        if (this.packageName != null) {
            sb.append(this.packageName).append('.');
        }
        sb.append(this.typeName);
        if (this.vagueArg != null) {
            sb.append('(').append(this.vagueArg).append(')');
        } else if (this.enumValues != null) {
            sb.append('(');
            StringUtil.join(this.enumValues, (String)", ", (StringBuilder)sb);
            sb.append(')');
        } else if (this.size >= 0) {
            sb.append('(');
            if (!onlyNumbers && this.size == 0x7FFFFFFE) {
                sb.append('*');
            } else if (!onlyNumbers && this.size == Integer.MAX_VALUE) {
                sb.append("max");
            } else {
                sb.append(this.size);
            }
            if (this.scale != 0) {
                sb.append(',').append(this.scale);
            }
            if (this.sizeUnit != LengthUnit.NONE && (this.sizeUnit != LengthUnit.DIGIT && this.sizeUnitExplicit || forceDefaults)) {
                sb.append(' ').append(StringUtil.toLowerCase((String)this.sizeUnit.suffix));
            }
            sb.append(')');
        } else if (forceDefaults) {
            sb.append("()");
        }
        if (this.suffix != null) {
            sb.append(' ').append(this.suffix);
        }
        String string = sb.toString();
        if (string == null) {
            DataType.$$$reportNull$$$0(10);
        }
        return string;
    }

    public int getLength() {
        return this.size;
    }

    public int getPrecision() {
        return this.size;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.equals((DataType)that);
    }

    public boolean equals(@NotNull DataType that) {
        if (that == null) {
            DataType.$$$reportNull$$$0(11);
        }
        return this.jdbcType == that.jdbcType && this.equalsWithoutJdbc(that);
    }

    public boolean equalsWithoutJdbc(@NotNull DataType that) {
        if (that == null) {
            DataType.$$$reportNull$$$0(12);
        }
        if (this == that) {
            return true;
        }
        if (this.size != that.size) {
            return false;
        }
        if (this.scale != that.scale) {
            return false;
        }
        if (this.sizeUnit != that.sizeUnit) {
            return false;
        }
        if (this.custom != that.custom) {
            return false;
        }
        if (this.sizeUnitExplicit != that.sizeUnitExplicit) {
            return false;
        }
        if (!Comparing.equal((String)this.schemaName, (String)that.schemaName)) {
            return false;
        }
        if (!Comparing.equal((String)this.packageName, (String)that.packageName)) {
            return false;
        }
        if (!Comparing.equal((String)this.vagueArg, (String)that.vagueArg)) {
            return false;
        }
        if (!Comparing.equal((String)this.typeName, (String)that.typeName)) {
            return false;
        }
        if (!Comparing.equal((String)this.suffix, (String)that.suffix)) {
            return false;
        }
        return Comparing.equal(this.enumValues, that.enumValues);
    }

    public int hashCode() {
        int result = this.schemaName != null ? this.schemaName.hashCode() : 0;
        result = this.packageName != null ? 31 * result + this.packageName.hashCode() : result;
        result = 31 * result + this.typeName.hashCode();
        result = 31 * result + this.size;
        result = 31 * result + this.scale;
        result = 31 * result + this.sizeUnit.hashCode();
        result = 31 * result + (this.vagueArg != null ? this.vagueArg.hashCode() : 0);
        result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
        result = 31 * result + (this.sizeUnitExplicit ? 1 : 0);
        result = 31 * result + (this.custom ? 1 : 0);
        result = 31 * result + (this.enumValues != null ? this.enumValues.hashCode() : 0);
        result = 31 * result + this.jdbcType;
        return result;
    }

    public String toString() {
        return this.getSpecification();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/DataType";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/DataType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withTypeName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalsWithoutJdbc";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

