/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.concurrency.tool;

import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphModel;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphPresentationModel;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyTable;
import com.jetbrains.python.debugger.concurrency.tool.ConcurrencyGraphSettings;
import com.jetbrains.python.debugger.concurrency.tool.ConcurrencyStat;
import com.jetbrains.python.debugger.concurrency.tool.panels.ConcurrencyToolWindowPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyTableUtil {
    private static void setTableSettings(JBTable table) {
        table.setRowHeight(ConcurrencyGraphSettings.TABLE_ROW_HEIGHT);
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        table.setSelectionMode(0);
    }

    @NotNull
    public static JPanel createTables(@NotNull ConcurrencyGraphModel graphModel, @NotNull ConcurrencyGraphPresentationModel presentationModel, @NotNull ConcurrencyToolWindowPanel toolWindow) {
        if (graphModel == null) {
            ConcurrencyTableUtil.$$$reportNull$$$0(0);
        }
        if (presentationModel == null) {
            ConcurrencyTableUtil.$$$reportNull$$$0(1);
        }
        if (toolWindow == null) {
            ConcurrencyTableUtil.$$$reportNull$$$0(2);
        }
        JPanel tablePanel = new JPanel(new BorderLayout());
        JBTable namesTable = new JBTable((TableModel)new FixedTableModel(graphModel));
        toolWindow.setFixedTable((JTable)namesTable);
        ConcurrencyTableUtil.setTableSettings(namesTable);
        ConcurrencyGraphSettings.customizeVisualSettings(namesTable.getRowHeight());
        JScrollPane namesScrollPane = ScrollPaneFactory.createScrollPane((Component)namesTable);
        namesScrollPane.setPreferredSize(new Dimension(ConcurrencyGraphSettings.NAMES_PANEL_INITIAL_WIDTH, toolWindow.getHeight()));
        namesScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, JBColor.border()));
        tablePanel.add((Component)namesScrollPane, "Before");
        toolWindow.setNamesTable((JTable)namesTable);
        ConcurrencyTable graphTable = new ConcurrencyTable(presentationModel, new ScrollableTableModel(graphModel), toolWindow);
        ConcurrencyTableUtil.setTableSettings(graphTable);
        graphTable.setAutoResizeMode(0);
        graphTable.setSelectionModel(namesTable.getSelectionModel());
        JScrollPane graphScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)graphTable));
        graphScrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, JBColor.border()));
        graphScrollPane.getVerticalScrollBar().setModel(namesScrollPane.getVerticalScrollBar().getModel());
        toolWindow.setTableScrollPane(graphScrollPane);
        tablePanel.add((Component)graphScrollPane, "Center");
        JBTable statTable = new JBTable((TableModel)new StatTableModel(graphModel));
        ConcurrencyTableUtil.setTableSettings(statTable);
        statTable.setSelectionModel(graphTable.getSelectionModel());
        toolWindow.setStatTable((JTable)statTable);
        JScrollPane statScrollPane = ScrollPaneFactory.createScrollPane((Component)statTable);
        statScrollPane.setPreferredSize(new Dimension(ConcurrencyGraphSettings.STAT_PANEL_WIDTH, toolWindow.getHeight()));
        statScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, JBColor.border()));
        statScrollPane.getVerticalScrollBar().setModel(graphScrollPane.getVerticalScrollBar().getModel());
        tablePanel.add((Component)statScrollPane, "After");
        JPanel jPanel = tablePanel;
        if (jPanel == null) {
            ConcurrencyTableUtil.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/concurrency/tool/ConcurrencyTableUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/concurrency/tool/ConcurrencyTableUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTables";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StatTableModel
    extends AbstractTableModel {
        private final ConcurrencyGraphModel myGraphModel;

        StatTableModel(ConcurrencyGraphModel graphModel) {
            this.myGraphModel = graphModel;
        }

        @Override
        public int getRowCount() {
            return this.myGraphModel.getMaxThread();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "Waiting time (s)";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            long percents;
            double waitTime;
            String threadId = this.myGraphModel.getThreadIdByIndex(rowIndex);
            if (threadId == null) {
                waitTime = 0.0;
                percents = 0L;
            } else {
                ConcurrencyStat threadStatistics = this.myGraphModel.getStatisticsByThreadId(threadId);
                waitTime = (double)threadStatistics.getWaitTime() / 1000000.0;
                percents = threadStatistics.getWorkTime() > 0L ? threadStatistics.getWaitTime() * 100L / threadStatistics.getWorkTime() : 0L;
            }
            return String.format("%.2f (%d%%)", waitTime, percents);
        }
    }

    private static class ScrollableTableModel
    extends AbstractTableModel {
        private final ConcurrencyGraphModel myGraphModel;

        ScrollableTableModel(ConcurrencyGraphModel graphModel) {
            this.myGraphModel = graphModel;
        }

        @Override
        public int getRowCount() {
            return this.myGraphModel.getMaxThread();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return " ";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return GraphCell.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return new GraphCell();
        }
    }

    private static class FixedTableModel
    extends AbstractTableModel {
        private final ConcurrencyGraphModel myGraphModel;

        FixedTableModel(ConcurrencyGraphModel graphModel) {
            this.myGraphModel = graphModel;
        }

        @Override
        public int getRowCount() {
            return this.myGraphModel.getMaxThread();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "Name";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.myGraphModel.getThreadNameByNumber(rowIndex);
        }
    }

    public static class GraphCell {
    }
}

