/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.concurrency.tool.panels;

import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.PyConcurrencyEvent;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphModel;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphPresentationModel;
import com.jetbrains.python.debugger.concurrency.tool.ConcurrencyTableUtil;
import com.jetbrains.python.debugger.concurrency.tool.panels.ConcurrencyNotesPanel;
import com.jetbrains.python.debugger.concurrency.tool.panels.ConcurrencyStackTracePanel;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcurrencyToolWindowPanel
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    private final ConcurrencyGraphModel myGraphModel;
    @NotNull
    private final ConcurrencyGraphPresentationModel myPresentationModel;
    @NotNull
    private final Project myProject;
    private final String myType;
    private JLabel myLabel;
    @Nullable
    private ConcurrencyStackTracePanel myStackTracePanel;
    @Nullable
    private JScrollPane tableScrollPane;
    @Nullable
    private JTable myFixedTable;
    @Nullable
    private JTable myStatTable;
    @Nullable
    private JTable myNamesTable;
    @Nullable
    private ActionToolbar myToolbar;
    @Nullable
    private JPanel myTablePanel;
    @Nullable
    private JPanel myNotes;
    private static final int TOOLBAR_INDENT = 25;

    public ConcurrencyToolWindowPanel(@NotNull Project project, @NotNull ConcurrencyGraphModel graphModel, String type) {
        if (project == null) {
            ConcurrencyToolWindowPanel.$$$reportNull$$$0(0);
        }
        if (graphModel == null) {
            ConcurrencyToolWindowPanel.$$$reportNull$$$0(1);
        }
        super(false);
        this.myProject = project;
        this.myGraphModel = graphModel;
        this.myType = type;
        this.myPresentationModel = new ConcurrencyGraphPresentationModel(this.myGraphModel, this);
        this.myPresentationModel.registerListener(new ConcurrencyGraphPresentationModel.PresentationListener(){

            @Override
            public void graphChanged(int padding) {
                UIUtil.invokeLaterIfNeeded(() -> ConcurrencyToolWindowPanel.this.updateContent());
            }
        });
        UIUtil.invokeLaterIfNeeded(() -> {
            this.initMessage();
            this.updateContent();
        });
    }

    private JPanel createToolbarPanel() {
        ActionToolbar actionToolBar;
        DefaultActionGroup group = new DefaultActionGroup();
        ProcessHandler processHandler = this.myGraphModel.getLastSession() == null ? null : this.myGraphModel.getLastSession().getDebugProcess().getProcessHandler();
        group.add((AnAction)new StopProcessAction("Stop process", "Stop process", processHandler));
        group.add((AnAction)new ZoomInAction());
        group.add((AnAction)new ZoomOutAction());
        group.add((AnAction)new ScrollToTheEndToolbarAction(this.myPresentationModel));
        group.add((AnAction)new CloseToolWindowAction());
        this.myToolbar = actionToolBar = ActionManager.getInstance().createActionToolbar("PyConcurrencyVisualizer", (ActionGroup)group, false);
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)actionToolBar.getComponent(), "Center");
        return buttonsPanel;
    }

    private void initMessage() {
        this.removeAll();
        this.myLabel = new JLabel();
        this.myLabel.setHorizontalAlignment(0);
        this.myLabel.setVerticalAlignment(0);
        this.myLabel.setText("<html>The " + this.myType + " log is empty </html>");
        this.add(this.myLabel);
    }

    @Nullable
    public JTable getStatTable() {
        return this.myStatTable;
    }

    public void setStatTable(@NotNull JTable statTable) {
        if (statTable == null) {
            ConcurrencyToolWindowPanel.$$$reportNull$$$0(2);
        }
        this.myStatTable = statTable;
    }

    @Nullable
    public JTable getNamesTable() {
        return this.myNamesTable;
    }

    public void setNamesTable(@Nullable JTable namesTable) {
        this.myNamesTable = namesTable;
    }

    public void setTableScrollPane(@NotNull JScrollPane tableScrollPane) {
        if (tableScrollPane == null) {
            ConcurrencyToolWindowPanel.$$$reportNull$$$0(3);
        }
        this.tableScrollPane = tableScrollPane;
    }

    @Nullable
    public JScrollPane getTableScrollPane() {
        return this.tableScrollPane;
    }

    public void setToolbar(@NotNull ActionToolbar toolbar) {
        if (toolbar == null) {
            ConcurrencyToolWindowPanel.$$$reportNull$$$0(4);
        }
        this.myToolbar = toolbar;
    }

    public void setFixedTable(@NotNull JTable fixedTable) {
        if (fixedTable == null) {
            ConcurrencyToolWindowPanel.$$$reportNull$$$0(5);
        }
        this.myFixedTable = fixedTable;
    }

    public int getGraphPaneWidth() {
        int result = 0;
        result += this.myFixedTable == null ? 0 : this.myFixedTable.getWidth();
        result += this.myStatTable == null ? 0 : this.myStatTable.getWidth();
        return Math.max(0, this.getWidth() - (result += this.myToolbar == null ? 0 : this.myToolbar.getComponent().getWidth()) - 25);
    }

    public void showStackTrace(@Nullable PyConcurrencyEvent event) {
        ArrayList<PyStackFrameInfo> frames;
        List list = frames = event == null ? new ArrayList(0) : event.getFrames();
        if (this.myStackTracePanel == null) {
            this.myStackTracePanel = new ConcurrencyStackTracePanel(this.myProject);
            this.myStackTracePanel.buildStackTrace(frames);
            this.splitWindow((JComponent)((Object)this.myStackTracePanel));
        } else {
            this.myStackTracePanel.buildStackTrace(frames);
        }
    }

    private void splitWindow(@NotNull JComponent component) {
        if (component == null) {
            ConcurrencyToolWindowPanel.$$$reportNull$$$0(6);
        }
        if (this.myTablePanel == null || this.myNotes == null) {
            return;
        }
        this.removeAll();
        JSplitPane graphPanel = new JSplitPane(0, true);
        this.myTablePanel.add((Component)this.myNotes, "South");
        graphPanel.add((Component)this.myTablePanel, "left");
        graphPanel.add((Component)component, "right");
        graphPanel.setDividerLocation(this.getHeight() * 2 / 3);
        graphPanel.setDividerSize(this.myPresentationModel.getVisualSettings().getDividerWidth());
        this.add(graphPanel, "Center");
        this.setToolbar(this.createToolbarPanel());
        this.validate();
        this.repaint();
    }

    private void initTable() {
        this.myTablePanel = ConcurrencyTableUtil.createTables(this.myGraphModel, this.myPresentationModel, this);
        this.add(this.myTablePanel);
        this.myNotes = new ConcurrencyNotesPanel((JPanel)((Object)this));
        this.myTablePanel.add((Component)this.myNotes, "South");
        GraphAdjustmentListener listener = new GraphAdjustmentListener();
        if (this.tableScrollPane != null) {
            this.tableScrollPane.addMouseWheelListener(event -> {
                if (event.isControlDown()) {
                    int rotation = event.getWheelRotation();
                    if (rotation < 0) {
                        this.myPresentationModel.getVisualSettings().zoomIn();
                    } else if (rotation > 0) {
                        this.myPresentationModel.getVisualSettings().zoomOut();
                    }
                }
            });
            this.tableScrollPane.setWheelScrollingEnabled(false);
            this.tableScrollPane.getHorizontalScrollBar().addAdjustmentListener(listener);
            this.tableScrollPane.getVerticalScrollBar().addAdjustmentListener(listener);
        }
    }

    private void updateContent() {
        if (this.myGraphModel.getSize() == 0) {
            this.myTablePanel = null;
            this.myStackTracePanel = null;
            this.initMessage();
            return;
        }
        if (this.myTablePanel == null) {
            this.myLabel.setVisible(false);
            this.initTable();
            this.setToolbar(this.createToolbarPanel());
            this.validate();
            this.repaint();
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statTable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableScrollPane";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixedTable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/concurrency/tool/panels/ConcurrencyToolWindowPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setStatTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setTableScrollPane";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setToolbar";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setFixedTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "splitWindow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class GraphAdjustmentListener
    implements AdjustmentListener {
        private GraphAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            JScrollBar bar;
            Adjustable source = evt.getAdjustable();
            int orient = source.getOrientation();
            if (orient == 0 && ConcurrencyToolWindowPanel.this.tableScrollPane != null) {
                bar = ConcurrencyToolWindowPanel.this.tableScrollPane.getHorizontalScrollBar();
                ConcurrencyToolWindowPanel.this.myPresentationModel.getVisualSettings().updateHorizontalScrollbar(bar.getValue(), bar.getVisibleAmount(), bar.getMaximum());
            }
            if (orient == 1) {
                bar = ConcurrencyToolWindowPanel.this.tableScrollPane.getVerticalScrollBar();
                ConcurrencyToolWindowPanel.this.myPresentationModel.getVisualSettings().updateVerticalScrollbar(bar.getValue(), bar.getVisibleAmount(), bar.getMaximum());
            }
            if (ConcurrencyToolWindowPanel.this.myTablePanel != null) {
                ConcurrencyToolWindowPanel.this.myTablePanel.repaint();
            }
        }
    }

    private class ZoomOutAction
    extends AnAction
    implements DumbAware {
        ZoomOutAction() {
            super("Zoom Out", "Zoom Out", AllIcons.Graph.ZoomOut);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ZoomOutAction.$$$reportNull$$$0(0);
            }
            ConcurrencyToolWindowPanel.this.myPresentationModel.getVisualSettings().zoomOut();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/concurrency/tool/panels/ConcurrencyToolWindowPanel$ZoomOutAction", "actionPerformed"));
        }
    }

    private class ZoomInAction
    extends AnAction
    implements DumbAware {
        ZoomInAction() {
            super("Zoom In", "Zoom In", AllIcons.Graph.ZoomIn);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ZoomInAction.$$$reportNull$$$0(0);
            }
            ConcurrencyToolWindowPanel.this.myPresentationModel.getVisualSettings().zoomIn();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/concurrency/tool/panels/ConcurrencyToolWindowPanel$ZoomInAction", "actionPerformed"));
        }
    }

    private static class ScrollToTheEndToolbarAction
    extends ToggleAction
    implements DumbAware {
        private final ConcurrencyGraphPresentationModel myPresentationModel;

        ScrollToTheEndToolbarAction(@NotNull ConcurrencyGraphPresentationModel presentationModel) {
            if (presentationModel == null) {
                ScrollToTheEndToolbarAction.$$$reportNull$$$0(0);
            }
            this.myPresentationModel = presentationModel;
            String message = "Scroll to the end";
            this.getTemplatePresentation().setDescription("Scroll to the end");
            this.getTemplatePresentation().setText("Scroll to the end");
            this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.Scroll_down);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ScrollToTheEndToolbarAction.$$$reportNull$$$0(1);
            }
            return this.myPresentationModel.isScrollToTheEnd();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ScrollToTheEndToolbarAction.$$$reportNull$$$0(2);
            }
            this.myPresentationModel.setScrollToTheEnd(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentationModel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/debugger/concurrency/tool/panels/ConcurrencyToolWindowPanel$ScrollToTheEndToolbarAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CloseToolWindowAction
    extends AnAction {
        private CloseToolWindowAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ProcessHandler processHandler;
            if (e == null) {
                CloseToolWindowAction.$$$reportNull$$$0(0);
            }
            ProcessHandler processHandler2 = processHandler = ConcurrencyToolWindowPanel.this.myGraphModel.getLastSession() == null ? null : ConcurrencyToolWindowPanel.this.myGraphModel.getLastSession().getDebugProcess().getProcessHandler();
            if (processHandler != null) {
                processHandler.detachProcess();
            }
            ToolWindowManager.getInstance((Project)ConcurrencyToolWindowPanel.this.myProject).getToolWindow("Concurrent Activities Diagram").getContentManager().removeAllContents(true);
            ToolWindowManager.getInstance((Project)ConcurrencyToolWindowPanel.this.myProject).unregisterToolWindow("Concurrent Activities Diagram");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseToolWindowAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setText("Close");
            e.getPresentation().setDescription("Close");
            e.getPresentation().setIcon(AllIcons.Actions.Cancel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/debugger/concurrency/tool/panels/ConcurrencyToolWindowPanel$CloseToolWindowAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

