/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.converters.curl.parser;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ws.converters.curl.Utils;
import com.intellij.ws.converters.curl.exceptions.CurlParseException;
import com.intellij.ws.converters.curl.parser.CurlFormData;
import com.intellij.ws.rest.client.RestClientAuthData;
import com.intellij.ws.rest.client.RestClientFormBodyPart;
import com.intellij.ws.rest.client.RestClientRequest;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurlParser {
    private static final Pattern SPLIT_BY_SPACES_REGEX = Pattern.compile("[^\\s\"']+|\"(?:\\\\\"|[^\"])*\"|'(?:\\\\'|[^'])*'");
    private static final String BOUNDARY = "WebAppBoundary";
    private String myContentType;
    private String myAuthSchemes;

    @NotNull
    public RestClientRequest parseToRestClientRequest(@NotNull String inputString) throws CurlParseException {
        if (inputString == null) {
            CurlParser.$$$reportNull$$$0(0);
        }
        if (!Utils.isCurlString(inputString)) {
            throw CurlParseException.newNotCurlException();
        }
        RestClientRequest restClientRequest = new RestClientRequest();
        List<String> tokens = CurlParser.splitInCurlTokens(inputString);
        int i = 1;
        while (i < tokens.size()) {
            String currentToken = tokens.get(i);
            if (currentToken.equals("\\")) {
                ++i;
                continue;
            }
            String nextToken = null;
            if (i + 1 < tokens.size()) {
                nextToken = tokens.get(i + 1);
            }
            i += this.chooseCategory(restClientRequest, currentToken, Utils.deleteBackslashes(nextToken));
        }
        if (restClientRequest.urlBase == null) {
            throw CurlParseException.newNoUrlException();
        }
        if (this.myContentType != null) {
            this.addContentTypeHeaderToRequest(restClientRequest);
        }
        RestClientRequest restClientRequest2 = restClientRequest;
        if (restClientRequest2 == null) {
            CurlParser.$$$reportNull$$$0(1);
        }
        return restClientRequest2;
    }

    @NotNull
    private static List<String> splitInCurlTokens(@NotNull String curlString) {
        if (curlString == null) {
            CurlParser.$$$reportNull$$$0(2);
        }
        ArrayList<String> tokensList = new ArrayList<String>();
        CharSequence bombedString = StringUtil.newBombedCharSequence((CharSequence)curlString, (long)100L);
        Matcher regexMatcher = SPLIT_BY_SPACES_REGEX.matcher(bombedString);
        while (regexMatcher.find()) {
            tokensList.add(regexMatcher.group().replaceAll("^['\"]|['\"]$", ""));
        }
        ArrayList<String> arrayList = tokensList;
        if (arrayList == null) {
            CurlParser.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private int chooseCategory(@NotNull RestClientRequest request, @NotNull String currentToken, @Nullable String nextToken) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(4);
        }
        if (currentToken == null) {
            CurlParser.$$$reportNull$$$0(5);
        }
        int shift = 1;
        if (Utils.isLongOption(currentToken)) {
            shift = this.addLongOption(request, currentToken.substring(2), nextToken);
        } else if (Utils.isShortOption(currentToken)) {
            shift = this.addShortOption(request, currentToken.substring(1), nextToken);
        } else {
            CurlParser.addURL(request, currentToken);
        }
        return shift;
    }

    private int addShortOption(@NotNull RestClientRequest request, @NotNull String option, @Nullable String nextToken) {
        boolean withoutSpace;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(6);
        }
        if (option == null) {
            CurlParser.$$$reportNull$$$0(7);
        }
        if (Utils.isAlwaysSetShortOption(option)) {
            return 1;
        }
        if (!Utils.isKnownShortOption(option)) {
            throw CurlParseException.newNotSupportedOptionException(option);
        }
        if (option.length() > 1) {
            withoutSpace = true;
            nextToken = option.substring(1);
        } else {
            withoutSpace = false;
        }
        if (nextToken == null) {
            throw CurlParseException.newNoRequiredOptionDataException(option);
        }
        switch (option.charAt(0)) {
            case 'X': {
                CurlParser.addHttpMethodToRequest(request, nextToken);
                break;
            }
            case 'H': {
                this.addHeaderToRequest(request, nextToken);
                break;
            }
            case 'd': {
                this.addDataToRequest("data", request, nextToken);
                break;
            }
            case 'u': {
                this.addAuthorizationDataToRequest(request, nextToken);
                break;
            }
            case 'F': {
                this.addFormDataToRequest(request, nextToken);
            }
        }
        return withoutSpace ? 1 : 2;
    }

    private int addLongOption(@NotNull RestClientRequest request, @NotNull String option, @Nullable String nextToken) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(8);
        }
        if (option == null) {
            CurlParser.$$$reportNull$$$0(9);
        }
        if (Utils.isAlwaysSetLongOption(option)) {
            return 1;
        }
        if (this.isAuthSchemeOption(option)) {
            return 1;
        }
        if (!Utils.isKnownLongOption(option)) {
            throw CurlParseException.newNotSupportedOptionException(option);
        }
        if (nextToken == null) {
            throw CurlParseException.newNoRequiredOptionDataException(option);
        }
        if (option.startsWith("data")) {
            this.addDataToRequest(option, request, nextToken);
            return 2;
        }
        switch (option) {
            case "url": {
                CurlParser.addURL(request, nextToken);
                break;
            }
            case "request": {
                CurlParser.addHttpMethodToRequest(request, nextToken);
                break;
            }
            case "header": {
                this.addHeaderToRequest(request, nextToken);
                break;
            }
            case "user": {
                this.addAuthorizationDataToRequest(request, nextToken);
                break;
            }
            case "form": {
                this.addFormDataToRequest(request, nextToken);
            }
        }
        return 2;
    }

    private void addHeaderToRequest(@NotNull RestClientRequest request, @NotNull String header) {
        RestClientRequest.KeyValuePair keyValueHeaderPair;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(10);
        }
        if (header == null) {
            CurlParser.$$$reportNull$$$0(11);
        }
        if (StringUtil.toLowerCase((String)(keyValueHeaderPair = CurlParser.getKeyValueForHeader(header)).getKey()).equals("content-type")) {
            this.myContentType = this.myContentType != null ? Utils.updateContentTypeIfNeeded(request, keyValueHeaderPair.getValue(), this.myContentType) : keyValueHeaderPair.getValue();
        } else {
            request.headers.add(CurlParser.getKeyValueForHeader(header));
        }
    }

    private static void addHttpMethodToRequest(@NotNull RestClientRequest request, @NotNull String method) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(12);
        }
        if (method == null) {
            CurlParser.$$$reportNull$$$0(13);
        }
        if (!Utils.isValidRequestOption(method)) {
            throw CurlParseException.newInvalidMethodException(method);
        }
        request.httpMethod = method;
    }

    private void addDataToRequest(@NotNull String dataOption, @NotNull RestClientRequest request, @NotNull String data) {
        if (dataOption == null) {
            CurlParser.$$$reportNull$$$0(14);
        }
        if (request == null) {
            CurlParser.$$$reportNull$$$0(15);
        }
        if (data == null) {
            CurlParser.$$$reportNull$$$0(16);
        }
        request.httpMethod = "POST";
        String stringData = null;
        switch (dataOption) {
            case "data-urlencode": {
                stringData = Utils.encodeData(data);
                break;
            }
            case "data": 
            case "data-ascii": 
            case "data-binary": {
                if (data.startsWith("@")) {
                    String fileName = data.substring(1);
                    if (StringUtil.isNotEmpty((String)fileName)) {
                        request.filesToSend = StringUtil.isNotEmpty((String)request.filesToSend) ? request.filesToSend + File.pathSeparator + fileName : fileName;
                    }
                    request.haveFileToSend = true;
                    break;
                }
                stringData = data;
                break;
            }
            case "data-raw": {
                stringData = data;
            }
        }
        if (StringUtil.isNotEmpty((String)stringData)) {
            request.textToSend = StringUtil.isNotEmpty((String)request.textToSend) ? request.textToSend + "&" + stringData : stringData;
            request.haveTextToSend = true;
        }
        if (this.myContentType == null) {
            this.addHeaderToRequest(request, "Content-Type: application/x-www-form-urlencoded");
        }
    }

    private void addAuthorizationDataToRequest(@NotNull RestClientRequest request, @NotNull String authData) {
        String username;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(17);
        }
        if (authData == null) {
            CurlParser.$$$reportNull$$$0(18);
        }
        AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, this.myAuthSchemes == null ? "Basic" : this.myAuthSchemes);
        String password = "";
        int colonPosition = authData.indexOf(58);
        if (colonPosition < 0) {
            username = authData;
        } else {
            username = authData.substring(0, colonPosition);
            password = authData.substring(colonPosition + 1);
        }
        request.authData = new RestClientAuthData(authScope, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    private boolean isAuthSchemeOption(@NotNull String option) {
        if (option == null) {
            CurlParser.$$$reportNull$$$0(19);
        }
        switch (option) {
            case "basic": {
                this.myAuthSchemes = "Basic";
                break;
            }
            case "digest": {
                this.myAuthSchemes = "Digest";
                break;
            }
            case "ntlm": {
                this.myAuthSchemes = "NTLM";
                break;
            }
            case "negotiate": {
                this.myAuthSchemes = "Negotiate";
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void addFormDataToRequest(@NotNull RestClientRequest request, @NotNull String formData) {
        RestClientFormBodyPart restClientFormBodyPart;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(20);
        }
        if (formData == null) {
            CurlParser.$$$reportNull$$$0(21);
        }
        CurlFormData curlFormData = new CurlFormData(formData);
        String fieldName = curlFormData.getName();
        if (curlFormData.hasFileContent()) {
            File file = curlFormData.getFile();
            if (file == null) {
                throw CurlParseException.newInvalidPathException(formData);
            }
            String filename = file.getName();
            restClientFormBodyPart = RestClientFormBodyPart.create(fieldName, filename, file, curlFormData.getFormContentType()).addHeader("Content-Disposition", "form-data; name=\"" + fieldName + "\"; filename=\"" + filename + "\"");
        } else {
            restClientFormBodyPart = RestClientFormBodyPart.create(fieldName, curlFormData.getContent(), curlFormData.getFormContentType()).addHeader("Content-Disposition", "form-data; name=\"" + fieldName + "\"");
        }
        curlFormData.getHeaders().forEach(additionalHeader -> restClientFormBodyPart.addHeader(additionalHeader.getKey(), additionalHeader.getValue()));
        request.formBodyPart.add(restClientFormBodyPart);
        request.httpMethod = "POST";
        request.isFileUpload = true;
        request.multipartBoundary = BOUNDARY;
        if (this.myContentType == null) {
            this.addHeaderToRequest(request, "Content-Type: multipart/form-data");
        }
    }

    private static void addURL(@NotNull RestClientRequest request, @NotNull String currentToken) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(22);
        }
        if (currentToken == null) {
            CurlParser.$$$reportNull$$$0(23);
        }
        if (request.httpMethod == null) {
            CurlParser.addHttpMethodToRequest(request, "GET");
        }
        try {
            new URI(currentToken);
            request.urlBase = currentToken;
            request.urlPath = "";
        }
        catch (URISyntaxException e) {
            throw CurlParseException.newInvalidUrlException(currentToken);
        }
    }

    @NotNull
    private static RestClientRequest.KeyValuePair getKeyValueForHeader(@NotNull String header) {
        int colonPosition;
        if (header == null) {
            CurlParser.$$$reportNull$$$0(24);
        }
        if ((colonPosition = header.indexOf(58)) < 0) {
            RestClientRequest.KeyValuePair keyValuePair = new RestClientRequest.KeyValuePair(header.trim().replaceAll(";$", ""), "");
            if (keyValuePair == null) {
                CurlParser.$$$reportNull$$$0(25);
            }
            return keyValuePair;
        }
        String name = header.substring(0, colonPosition).trim();
        if (name.isEmpty()) {
            throw CurlParseException.newInvalidHeaderException(header);
        }
        String value = header.substring(colonPosition + 1);
        RestClientRequest.KeyValuePair keyValuePair = new RestClientRequest.KeyValuePair(name, value.trim());
        if (keyValuePair == null) {
            CurlParser.$$$reportNull$$$0(26);
        }
        return keyValuePair;
    }

    private void addContentTypeHeaderToRequest(@NotNull RestClientRequest request) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(27);
        }
        String header = "Content-Type: ";
        header = request.multipartBoundary != null ? header + this.myContentType + "; boundary=" + BOUNDARY : header + this.myContentType;
        request.headers.add(CurlParser.getKeyValueForHeader(header));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputString";
                break;
            }
            case 1: 
            case 3: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/converters/curl/parser/CurlParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curlString";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentToken";
                break;
            }
            case 7: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataOption";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authData";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/converters/curl/parser/CurlParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseToRestClientRequest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "splitInCurlTokens";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyValueForHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseToRestClientRequest";
                break;
            }
            case 1: 
            case 3: 
            case 25: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitInCurlTokens";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "chooseCategory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addShortOption";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLongOption";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addHeaderToRequest";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addHttpMethodToRequest";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addDataToRequest";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addAuthorizationDataToRequest";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAuthSchemeOption";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addFormDataToRequest";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getKeyValueForHeader";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addContentTypeHeaderToRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

