/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.hint.PsiImplementationViewElement;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PanelWithText;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.popup.NotLookupOrSearchCondition;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ShowCoveringTestsAction
extends AnAction {
    private static final Logger c;
    private final String b;
    private final LineData a;
    private static final long d;

    public ShowCoveringTestsAction(String classFQName, LineData lineData) {
        long l2 = d ^ 0x4AAB92392A52L;
        super("Show tests covering line", "Show tests covering line", PlatformIcons.TEST_SOURCE_FOLDER);
        this.b = classFQName;
        this.a = lineData;
    }

    public void actionPerformed(@NotNull AnActionEvent e10) {
        Project project;
        long l2 = d ^ 0x4FD3D3908D9EL;
        if (e10 == null) {
            ShowCoveringTestsAction.a(0);
        }
        c.assertTrue((project = e10.getProject()) != null);
        Editor editor2 = (Editor)e10.getData(CommonDataKeys.EDITOR);
        c.assertTrue(editor2 != null);
        CoverageSuitesBundle coverageSuitesBundle = CoverageDataManager.getInstance(project).getCurrentSuitesBundle();
        c.assertTrue(coverageSuitesBundle != null);
        CoverageEngine coverageEngine = coverageSuitesBundle.getCoverageEngine();
        HashSet hashSet = new HashSet();
        if (((Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> hashSet.addAll(coverageEngine.getTestsForLine(project, this.b, this.a.getLineNumber())), "Extract Information About Tests", false, project)).booleanValue()) {
            PanelWithText panelWithText;
            ComponentPopupBuilder componentPopupBuilder;
            ImplementationViewComponent implementationViewComponent;
            Object[] objectArray = ArrayUtilRt.toStringArray(hashSet);
            Arrays.sort(objectArray);
            if (objectArray.length == 0) {
                HintManager.getInstance().showErrorHint(editor2, "Failed to load covered tests");
                return;
            }
            List<PsiElement> list2 = coverageEngine.findTestsByNames((String[])objectArray, project);
            String string = "Tests covering line " + this.b + ":" + this.a.getLineNumber();
            if (!list2.isEmpty()) {
                implementationViewComponent = new ImplementationViewComponent((Collection)ContainerUtil.map(list2, PsiImplementationViewElement::new), 0);
                componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)implementationViewComponent, implementationViewComponent.getPreferredFocusableComponent()).setDimensionServiceKey(project, "ShowTestsPopup", false).setCouldPin(jBPopup -> {
                    implementationViewComponent.showInUsageView();
                    jBPopup.cancel();
                    return false;
                });
            } else {
                implementationViewComponent = null;
                panelWithText = new PanelWithText("Following test" + (objectArray.length > 1 ? "s" : "") + " could not be found: " + StringUtil.join((String[])objectArray, (String)"<br/>").replace("_", "."));
                componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panelWithText, null);
            }
            panelWithText = componentPopupBuilder.setRequestFocusCondition(project, (Condition)NotLookupOrSearchCondition.INSTANCE).setProject(project).setResizable(true).setMovable(true).setTitle(string).createPopup();
            panelWithText.showInBestPositionFor(editor2);
            if (implementationViewComponent != null) {
                implementationViewComponent.setHint((JBPopup)panelWithText, string);
            }
        }
    }

    public void update(@NotNull AnActionEvent e10) {
        Project project;
        if (e10 == null) {
            ShowCoveringTestsAction.a(1);
        }
        Presentation presentation = e10.getPresentation();
        presentation.setEnabled(false);
        if (this.a != null && this.a.getStatus() != 0 && (project = e10.getProject()) != null) {
            CoverageSuitesBundle coverageSuitesBundle = CoverageDataManager.getInstance(project).getCurrentSuitesBundle();
            presentation.setEnabled(coverageSuitesBundle.isCoverageByTestEnabled() && coverageSuitesBundle.getCoverageEngine().wasTestDataCollected(project));
        }
    }

    static {
        d = com.jetbrains.python.psi.c.a(6179492955375047760L, 117757744403586580L, MethodHandles.lookup().lookupClass()).a(19221403571111L);
        c = Logger.getInstance(ShowCoveringTestsAction.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = d ^ 0x73DAE6B5427EL;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/coverage/actions/ShowCoveringTestsAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

