/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.AgentProxyConnectorFactory;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.PromiscuousSshHostKeyVerifier;
import com.intellij.ssh.ProxyCommand;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.SshHostKeyVerifierKt;
import com.intellij.ssh.SshPasswordProvider;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.StrictHostKeyChecking;
import com.intellij.ssh.config.ConfigRepository;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigUtil;
import com.intellij.ssh.diagnostic.LoggersKt;
import com.intellij.ssh.impl.agent.CompositeIdentityRepository;
import com.intellij.ssh.legacy.SftpIdentityInfo;
import com.intellij.ssh.sockets.SocketUtils;
import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KnownHostsForPlatform;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u00b2\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a-\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0000\u00a2\u0006\u0002\u0010\u0017\u001a(\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0016H\u0002\u001a(\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0002\u001a/\u0010!\u001a\u00020\u00012\b\u0010\"\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\b\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010%\u001a\u0006\u0010&\u001a\u00020'\u001a\u001a\u0010(\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u00032\u0006\u0010*\u001a\u00020\u0003H\u0000\u001a\b\u0010+\u001a\u00020\u0013H\u0002\u001a\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0003H\u0002\u001a\u000e\u0010/\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0003\u001a\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\u0003H\u0007\u001a\u0010\u00102\u001a\u00020-2\u0006\u00101\u001a\u00020\u0003H\u0007\u001aQ\u00103\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00152\u000e\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00152\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u00032\b\u00108\u001a\u0004\u0018\u00010\u00032\b\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u0010:\u001a\u00020;\u00a2\u0006\u0002\u0010<\u001a\"\u0010=\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010>\u001a\u0004\u0018\u00010\u0013H\u0002\u001a\u0018\u0010?\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u0013H\u0002\u001a\u001c\u0010@\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020B0A2\u0006\u0010C\u001a\u00020D\u001a\u0016\u0010E\u001a\u00020\u00012\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I\u001a$\u0010J\u001a\u00020\u000f*\u00020B2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0002\u001a\f\u0010L\u001a\u00020\u000f*\u00020MH\u0007\u001a#\u0010N\u001a\u0004\u0018\u00010\u000f*\u00020B2\u0006\u0010O\u001a\u00020\u001a2\u0006\u0010P\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010Q\u001a\u000e\u0010R\u001a\u0004\u0018\u00010\u0003*\u00020SH\u0000\u001a\u001b\u0010T\u001a\u0004\u0018\u00010\u0001*\u00020\u001a2\u0006\u0010K\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010U\u001a\f\u0010V\u001a\u00020\u0003*\u00020WH\u0000\u001a\u000e\u0010X\u001a\u00020-*\u0004\u0018\u00010YH\u0002\u001a\u0016\u0010Z\u001a\u0004\u0018\u00010\u0003*\u00020\u001a2\u0006\u0010[\u001a\u00020\u0003H\u0002\u001a\f\u0010\\\u001a\u00020]*\u00020;H\u0007\u001a\n\u0010^\u001a\u00020;*\u00020]\u001a\f\u0010_\u001a\u00020\u0003*\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006`"}, d2={"DEFAULT_SERVER_ALIVE_COUNT_MAX", "", "EXEC_CHANNEL_TYPE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SFTP_CHANNEL_TYPE", "SHELL_CHANNEL_TYPE", "linuxPamPasswordPromptTranslations", "", "getLinuxPamPasswordPromptTranslations", "()Ljava/util/Set;", "linuxPamPasswordPromptTranslations$delegate", "Lkotlin/Lazy;", "addIdentities", "", "jsch", "Lcom/jcraft/jsch/JSch;", "sshDir", "Ljava/io/File;", "identities", "", "Lcom/intellij/ssh/legacy/SftpIdentityInfo;", "(Lcom/jcraft/jsch/JSch;Ljava/io/File;[Lcom/intellij/ssh/legacy/SftpIdentityInfo;)V", "addIdentitiesFromHostConfig", "hostConfig", "Lcom/intellij/ssh/config/ConfigRepository$Config;", "remoteHost", "remoteUser", "addIdentity", "info", "addIdentityFromOpenSSHConfig", "identityFile", "calcIdentitiesHashCode", "password", "agentProxyConnectorFactory", "Lcom/intellij/ssh/AgentProxyConnectorFactory;", "(Ljava/lang/String;[Lcom/intellij/ssh/legacy/SftpIdentityInfo;Lcom/intellij/ssh/AgentProxyConnectorFactory;)I", "createConfig", "Ljava/util/Properties;", "extendCSVParameter", "value", "defaultValue", "findSshDir", "isOpenPamPasswordPrompt", "", "message", "isPamUnixPasswordPrompted", "isPassphraseMayBeRequired", "privateKeyPath", "isPrivateKeyNotEncrypted", "promptKeyboardInteractive", "prompt", "echo", "", "destination", "name", "instruction", "promptProvider", "Lcom/intellij/ssh/SshPasswordProvider;", "([Ljava/lang/String;[ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ssh/SshPasswordProvider;)[Ljava/lang/String;", "setKnownHosts", "knownHostsFile", "setKnownHostsFile", "setUpSession", "Lkotlin/Pair;", "Lcom/jcraft/jsch/Session;", "sessionConfig", "Lcom/intellij/ssh/SessionConfig;", "toTimeoutInMillis", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "applyCSVParameter", "key", "applyPortForwardings", "Lcom/intellij/ssh/SshSession;", "checkConfig", "config", "s", "(Lcom/jcraft/jsch/Session;Lcom/intellij/ssh/config/ConfigRepository$Config;Ljava/lang/String;)Lkotlin/Unit;", "getEffectiveProxyCommand", "Lcom/intellij/ssh/config/OpenSSHClientConfig$HostConfig;", "getIntValue", "(Lcom/intellij/ssh/config/ConfigRepository$Config;Ljava/lang/String;)Ljava/lang/Integer;", "id", "", "isNullOrEmpty", "", "resolveHostName", "host", "toJschUserInfo", "Lcom/jcraft/jsch/UserInfo;", "toSshPasswordProvider", "unquoteSingleArgumentValue", "intellij.platform.ssh"})
@JvmName(name="SshConnectionUtil")
public final class SshConnectionUtil {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final int DEFAULT_SERVER_ALIVE_COUNT_MAX = 1000;
    private static final Logger a;
    @NotNull
    public static final String SHELL_CHANNEL_TYPE = "shell";
    @NotNull
    public static final String EXEC_CHANNEL_TYPE = "exec";
    @NotNull
    public static final String SFTP_CHANNEL_TYPE = "sftp";
    private static final Lazy b;
    private static final long c;

    static {
        c = com.jetbrains.python.psi.c.a(7449970294405983018L, -5607646733335735546L, MethodHandles.lookup().lookupClass()).a(121438111745248L);
        long l2 = c ^ 0x34661856690FL;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(SshConnectionUtil.class, (String)"intellij.platform.ssh"), "linuxPamPasswordPromptTranslations", "getLinuxPamPasswordPromptTranslations()Ljava/util/Set;"))};
        Logger logger = Logger.getInstance((String)"#com.intellij.ssh.SshConnectionUtil");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026j.ssh.SshConnectionUtil\")");
        a = LoggersKt.orWebDeploymentLogger(logger);
        b = LazyKt.lazy((Function0)linuxPamPasswordPromptTranslations.2.INSTANCE);
    }

    public static final int calcIdentitiesHashCode(@Nullable String password, @Nullable SftpIdentityInfo[] identities, @Nullable AgentProxyConnectorFactory agentProxyConnectorFactory) {
        int n2;
        String string = password;
        int n3 = string != null ? string.hashCode() : 0;
        int n4 = 31 * n3;
        if (identities != null) {
            Object[] objectArray = identities;
            int n5 = n4;
            boolean bl2 = false;
            boolean bl3 = false;
            Object[] objectArray2 = objectArray;
            boolean bl4 = false;
            int n6 = Arrays.hashCode(objectArray2);
            n4 = n5;
            n2 = n6;
        } else {
            n2 = 0;
        }
        n3 = n4 + n2;
        AgentProxyConnectorFactory agentProxyConnectorFactory2 = agentProxyConnectorFactory;
        n3 = 31 * n3 + (agentProxyConnectorFactory2 != null ? agentProxyConnectorFactory2.hashCode() : 0);
        return n3;
    }

    private static final boolean a(@Nullable byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    @NotNull
    public static final Pair<ConfigRepository.Config, Session> setUpSession(@NotNull SessionConfig sessionConfig) {
        String string;
        Integer n2;
        Object object;
        Unit unit;
        Object object2;
        int n3;
        SshHostKeyVerifier sshHostKeyVerifier;
        Object object3;
        Properties properties;
        SocketFactory socketFactory;
        SocketFactory socketFactory2;
        Unit unit2;
        String string2;
        Pair<Connector, String> pair;
        boolean bl2;
        OpenSSHClientConfig.HostConfig hostConfig;
        Object object4;
        long l2 = c ^ 0x17F5CAABEAC2L;
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        JSch jSch = new JSch();
        File file = SshConnectionUtil.b();
        SshConnectionUtil.a(jSch, file, sessionConfig.getKnownHostsFile());
        SftpIdentityInfo[] sftpIdentityInfoArray = sessionConfig.getIdentities();
        if (sftpIdentityInfoArray != null) {
            SshConnectionUtil.addIdentities(jSch, file, sftpIdentityInfoArray);
        }
        OpenSSHClientConfig openSSHClientConfig = sessionConfig.getOpenSSHConfig();
        OpenSSHClientConfig.HostConfig hostConfig2 = openSSHClientConfig != null ? openSSHClientConfig.getConfig(sessionConfig.getHost()) : null;
        jSch.setConfigRepository((ConfigRepository)null);
        Object object5 = hostConfig2;
        if (object5 == null || (object5 = SshConnectionUtil.b((ConfigRepository.Config)object5, sessionConfig.getHost())) == null) {
            object5 = object4 = sessionConfig.getHost();
        }
        if (sftpIdentityInfoArray == null && sessionConfig.getPassword() == null) {
            Unit unit3;
            OpenSSHClientConfig.HostConfig hostConfig3 = hostConfig2;
            if (hostConfig3 != null) {
                hostConfig = hostConfig3;
                boolean bl3 = false;
                bl2 = false;
                OpenSSHClientConfig.HostConfig hostConfig4 = hostConfig;
                boolean bl4 = false;
                SshConnectionUtil.a(jSch, (ConfigRepository.Config)hostConfig4, (String)object4, sessionConfig.getUsername());
                unit3 = Unit.INSTANCE;
            } else {
                unit3 = null;
            }
        }
        if ((pair = sessionConfig.getAgentProxyConnectorFactory()) != null && (pair = pair.get()) != null) {
            Pair<Connector, String> pair2 = pair;
            bl2 = false;
            boolean bl5 = false;
            Pair<Connector, String> pair3 = pair2;
            boolean bl6 = false;
            Connector connector = (Connector)pair3.component1();
            String string3 = (String)pair3.component2();
            IdentityRepository identityRepository = jSch.getIdentityRepository();
            Intrinsics.checkExpressionValueIsNotNull((Object)identityRepository, (String)"jsch.identityRepository");
            jSch.setIdentityRepository((IdentityRepository)new CompositeIdentityRepository(identityRepository, (IdentityRepository)new RemoteIdentityRepository(connector)));
            string2 = string3;
        } else {
            string2 = null;
        }
        hostConfig = string2;
        Session session = jSch.getSession(sessionConfig.getUsername(), (String)object4, sessionConfig.getPort());
        if (sessionConfig.getPassword() != null) {
            session.setPassword(sessionConfig.getPassword());
        }
        SshPasswordProvider sshPasswordProvider = sessionConfig.getSshPasswordProvider();
        if (sshPasswordProvider != null) {
            SshPasswordProvider sshPasswordProvider2 = sshPasswordProvider;
            boolean bl7 = false;
            boolean bl8 = false;
            SshPasswordProvider sshPasswordProvider3 = sshPasswordProvider2;
            boolean bl9 = false;
            Session session2 = session;
            Intrinsics.checkExpressionValueIsNotNull((Object)session2, (String)"session");
            session2.setUserInfo(SshConnectionUtil.toJschUserInfo(sshPasswordProvider3));
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        if (sessionConfig.getProxy() != null) {
            session.setProxy(sessionConfig.getProxy());
        }
        if ((socketFactory2 = sessionConfig.getSocketFactory()) == null) {
            socketFactory2 = socketFactory = SocketUtils.getSftpSocketFactory(sessionConfig.getHost());
        }
        if (socketFactory != null) {
            session.setSocketFactory(socketFactory);
        }
        if (hostConfig2 != null) {
            Session session3 = session;
            Intrinsics.checkExpressionValueIsNotNull((Object)session3, (String)"session");
            SshConnectionUtil.a(session3, (ConfigRepository.Config)hostConfig2, "KexAlgorithms", "ecdh-sha2-nistp256,ecdh-sha2-nistp384,ecdh-sha2-nistp521,diffie-hellman-group14-sha1,diffie-hellman-group-exchange-sha256,diffie-hellman-group-exchange-sha1");
            SshConnectionUtil.a(session, (ConfigRepository.Config)hostConfig2, "HostKeyAlgorithms", "ecdsa-sha2-nistp256,ecdsa-sha2-nistp384,ecdsa-sha2-nistp521,ssh-ed25519,ssh-rsa");
            SshConnectionUtil.a(session, hostConfig2, "cipher.c2s");
            SshConnectionUtil.a(session, hostConfig2, "cipher.s2c");
            SshConnectionUtil.a(session, hostConfig2, "mac.c2s");
            SshConnectionUtil.a(session, hostConfig2, "mac.s2c");
            SshConnectionUtil.a(session, hostConfig2, "compression.c2s");
            SshConnectionUtil.a(session, hostConfig2, "compression.s2c");
            SshConnectionUtil.a(session, hostConfig2, "compression_level");
            SshConnectionUtil.a(session, hostConfig2, "MaxAuthTries");
            SshConnectionUtil.a(session, hostConfig2, "ClearAllForwardings");
            SshConnectionUtil.a(session, hostConfig2, "ForwardAgent");
        }
        if ((properties = sessionConfig.getConfig()) != null && properties.size() > 0) {
            session.setConfig(properties);
        }
        if ((object3 = (sshHostKeyVerifier = SshHostKeyVerifierKt.makeHostKeyVerifier(sessionConfig))) instanceof OpenSshLikeHostKeyVerifier) {
            Session session4 = session;
            Intrinsics.checkExpressionValueIsNotNull((Object)session4, (String)"session");
            KnownHostsForPlatform knownHostsForPlatform = new KnownHostsForPlatform(jSch);
            Session session5 = session4;
            boolean bl10 = false;
            boolean bl11 = false;
            KnownHostsForPlatform knownHostsForPlatform2 = knownHostsForPlatform;
            n3 = 0;
            List<File> list2 = ((OpenSshLikeHostKeyVerifier)sshHostKeyVerifier).getKnownHostsFiles();
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            knownHostsForPlatform2.setKnownHosts(list2.get(0).getAbsolutePath());
            KnownHostsForPlatform knownHostsForPlatform3 = knownHostsForPlatform;
            session5.setHostKeyRepository((HostKeyRepository)knownHostsForPlatform3);
            StrictHostKeyChecking strictHostKeyChecking = ((OpenSshLikeHostKeyVerifier)sshHostKeyVerifier).getStrictHostKeyChecking();
            if (strictHostKeyChecking == null) {
                Intrinsics.throwNpe();
            }
            session.setConfig("StrictHostKeyChecking", strictHostKeyChecking.getOpenSshConfigOption());
        } else if (object3 instanceof PromiscuousSshHostKeyVerifier) {
            session.setConfig("StrictHostKeyChecking", "dummy-hack-value");
        }
        if ((object2 = hostConfig2) != null && (object2 = ((OpenSSHClientConfig.HostConfig)object2).getValue("HostKeyAlias")) != null) {
            object3 = object2;
            boolean bl12 = false;
            boolean bl13 = false;
            Object object6 = object3;
            boolean bl14 = false;
            Session session6 = session;
            Intrinsics.checkExpressionValueIsNotNull((Object)session6, (String)"session");
            session6.setHostKeyAlias((String)object6);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if ((object = sessionConfig.getServerAliveInterval()) == null) {
            OpenSSHClientConfig.HostConfig hostConfig5 = hostConfig2;
            object = object3 = hostConfig5 != null ? SshConnectionUtil.a(hostConfig5, "ServerAliveInterval") : null;
        }
        if (object3 != null) {
            Session session7 = session;
            Intrinsics.checkExpressionValueIsNotNull((Object)session7, (String)"session");
            session7.setServerAliveInterval(((Integer)object3).intValue());
        }
        Session session8 = session;
        Intrinsics.checkExpressionValueIsNotNull((Object)session8, (String)"session");
        Integer n4 = sessionConfig.getServerAliveCountMax();
        if (n4 == null) {
            OpenSSHClientConfig.HostConfig hostConfig6 = hostConfig2;
            n4 = hostConfig6 != null ? SshConnectionUtil.a(hostConfig6, "ServerAliveCountMax") : null;
        }
        session8.setServerAliveCountMax(n4 != null ? n4 : 1000);
        Object object7 = sessionConfig.getTimeout();
        if (object7 == null) {
            String string4;
            String string5;
            Object object8 = hostConfig2;
            if (object8 != null && (object8 = ((OpenSSHClientConfig.HostConfig)object8).getValue("ConnectTimeout")) != null) {
                Object object9 = object8;
                boolean bl15 = false;
                Object object10 = object9;
                if (object10 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = ((String)object10).toLowerCase();
                string5 = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
            } else {
                string5 = string4 = null;
            }
            if (string4 == null || Intrinsics.areEqual(string4, (Object)"none")) {
                object7 = null;
            } else {
                Object object11;
                try {
                    object11 = string4;
                    boolean bl16 = false;
                    object11 = Integer.parseInt((String)object11);
                }
                catch (NumberFormatException numberFormatException) {
                    object11 = null;
                }
                object7 = n2 = object11;
            }
        }
        if (n2 != null) {
            session.setTimeout(n2.intValue());
        }
        OpenSSHClientConfig.HostConfig hostConfig7 = hostConfig2;
        String string7 = string = hostConfig7 != null ? SshConnectionUtil.getEffectiveProxyCommand(hostConfig7) : null;
        if (string != null && Intrinsics.areEqual((Object)SshConnectionUtil.b(string), (Object)"none") ^ true) {
            String string8 = session.getUserName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"session.userName");
            session.setProxy((Proxy)new ProxyCommand(string, string8));
        }
        session.setDaemonThread(sessionConfig.getDaemonThread());
        if (a.isDebugEnabled()) {
            String string9 = "Setting up JSch ssh connection to " + (String)object4 + ':' + sessionConfig.getPort() + " for " + sessionConfig.getUsername();
            if (sessionConfig.getPassword() != null) {
                string9 = string9 + ", with password";
            }
            if (hostConfig != null) {
                string9 = string9 + ", with SSH agent " + (String)((Object)hostConfig);
            }
            if (sftpIdentityInfoArray != null) {
                string9 = string9 + ", with identities";
                for (SftpIdentityInfo sftpIdentityInfo : sftpIdentityInfoArray) {
                    string9 = string9 + " {" + sftpIdentityInfo.getPrivateKey() + ", " + sftpIdentityInfo.getPublicKey() + ", " + (sftpIdentityInfo.getPassPhrase() == null ? "no" : "***") + '}';
                }
            }
            if (sftpIdentityInfoArray == null && sessionConfig.getPassword() == null) {
                string9 = string9 + ", without identities and password, adding identities from OpenSSH config";
            }
            if (sessionConfig.getProxy() != null) {
                string9 = string9 + ", with proxy " + sessionConfig.getProxy();
            }
            if (socketFactory != null) {
                string9 = string9 + ", with socketFactory " + socketFactory;
            }
            if (object3 != null) {
                string9 = string9 + ", with keepAliveTimeout " + object3;
            }
            string9 = string9 + ", with serverAliveCountMax " + session.getServerAliveCountMax();
            string9 = string9 + ", with timeout " + n2;
            if (string != null) {
                string9 = string9 + ", with proxyCommand " + string;
            }
            string9 = string9 + ", with daemonThread " + sessionConfig.getDaemonThread();
            if (hostConfig2 != null) {
                Unit unit4;
                string9 = string9 + "\nWith openSSH config ";
                for (String string10 : new String[]{"KexAlgorithms", "HostKeyAlgorithms", "cipher.c2s", "cipher.s2c", "mac.c2s", "mac.s2c", "compression.c2s", "compression.s2c", "compression_level", "MaxAuthTries", "ClearAllForwardings", "ForwardAgent"}) {
                    Unit unit5;
                    if (hostConfig2.getValue(string10) != null) {
                        String string11;
                        boolean bl17 = false;
                        boolean bl18 = false;
                        String string12 = string11;
                        boolean bl19 = false;
                        string9 = string9 + ", " + (String)string10 + '=' + string12;
                        unit5 = Unit.INSTANCE;
                        continue;
                    }
                    unit5 = null;
                }
                String string13 = hostConfig2.getValue("HostKeyAlias");
                if (string13 != null) {
                    String string14 = string13;
                    n3 = 0;
                    boolean bl20 = false;
                    String string15 = string14;
                    boolean bl21 = false;
                    string9 = string9 + " with hostKeyAlias " + string15;
                    unit4 = Unit.INSTANCE;
                } else {
                    unit4 = null;
                }
            }
            string9 = string9 + ", with " + sshHostKeyVerifier;
            if (properties != null && properties.size() > 0) {
                string9 = string9 + "\nWith config";
                Map map2 = properties;
                int n5 = 0;
                for (Map.Entry entry : map2.entrySet()) {
                    string9 = string9 + ' ' + entry.getKey() + " = " + entry.getValue() + ',';
                }
            }
            a.debug(string9);
        }
        return new Pair((Object)hostConfig2, (Object)session);
    }

    @Nullable
    public static final String getEffectiveProxyCommand(@NotNull OpenSSHClientConfig.HostConfig $this$getEffectiveProxyCommand) {
        long l2 = c ^ 0x4F2822F164C2L;
        Intrinsics.checkParameterIsNotNull((Object)$this$getEffectiveProxyCommand, (String)"$this$getEffectiveProxyCommand");
        Iterator iterator = $this$getEffectiveProxyCommand.stream().iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            String string = (String)pair.component1();
            String string2 = (String)pair.component2();
            if (StringsKt.equals((String)"ProxyCommand", (String)string, (boolean)true)) {
                return string2;
            }
            if (!StringsKt.equals((String)"ProxyJump", (String)string, (boolean)true)) continue;
            String string3 = OpenSSHConfigUtil.toProxyCommand(OpenSSHConfigUtil.parseJump(string2));
            a.debug("Setting implicit ProxyCommand from ProxyJump: " + string3);
            return string3;
        }
        return null;
    }

    private static final void a(@NotNull Session session, ConfigRepository.Config config, String string, String string2) {
        session.setConfig(string, SshConnectionUtil.extendCSVParameter(config.getValue(string), string2));
    }

    @NotNull
    public static final String extendCSVParameter(@Nullable String value, @NotNull String defaultValue) {
        long l2 = c ^ 0x29A7AFACE15BL;
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)"defaultValue");
        String string = null;
        if (value == null) {
            string = defaultValue;
        } else if (StringsKt.startsWith$default((String)value, (String)"+", (boolean)false, (int)2, null)) {
            String string2 = value;
            int n2 = 1;
            boolean bl2 = false;
            String string3 = string2.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string3;
            string = defaultValue + "," + string4;
        } else {
            string = value;
        }
        return string;
    }

    private static final String b(@NotNull ConfigRepository.Config config, String string) {
        String string2;
        long l2 = c ^ 0x7D1B1BDD6BD1L;
        String string3 = config.getValue("HostName");
        if (string3 != null) {
            String string4 = string3;
            boolean bl2 = false;
            boolean bl3 = false;
            String string5 = string4;
            boolean bl4 = false;
            string2 = OpenSSHConfigUtil.resolveHostName(string5, string);
        } else {
            string2 = null;
        }
        return string2;
    }

    @Deprecated(message="Moved to SshSession.applyPortForwardings()")
    public static final void applyPortForwardings(@NotNull SshSession $this$applyPortForwardings) {
        long l2 = c ^ 0x72C5D8D492D6L;
        Intrinsics.checkParameterIsNotNull((Object)$this$applyPortForwardings, (String)"$this$applyPortForwardings");
        $this$applyPortForwardings.applyPortForwardings();
    }

    private static final Unit a(@NotNull Session session, ConfigRepository.Config config, String string) {
        Unit unit;
        String string2 = config.getValue(string);
        if (string2 != null) {
            String string3 = string2;
            boolean bl2 = false;
            boolean bl3 = false;
            String string4 = string3;
            boolean bl4 = false;
            session.setConfig(string, string4);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final void a(JSch jSch, ConfigRepository.Config config, String string, String string2) {
        String[] stringArray;
        long l2 = c ^ 0xF6774AA9E57L;
        if (stringArray != null) {
            Object object = stringArray = config.getValues("IdentityFile");
            boolean bl2 = false;
            Object object2 = object;
            Collection collection = new ArrayList(((String[])object).length);
            boolean bl3 = false;
            String[] stringArray2 = object2;
            int n2 = stringArray2.length;
            for (int i10 = 0; i10 < n2; ++i10) {
                String string3;
                String string4 = string3 = stringArray2[i10];
                Collection collection2 = collection;
                boolean bl4 = false;
                String string5 = SshConnectionUtil.b(string4);
                collection2.add(string5);
            }
            object = (List)collection;
            bl2 = false;
            object2 = object.iterator();
            while (object2.hasNext()) {
                collection = object2.next();
                String string6 = (String)((Object)collection);
                boolean bl5 = false;
                SshConnectionUtil.a(jSch, string6, string, string2);
            }
        }
    }

    private static final String b(@NotNull String string) {
        long l2 = c ^ 0x7B73EBFD086FL;
        String string2 = StringUtil.unquoteString((String)string, (char)'\"');
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.unquoteString(this, '\"')");
        return string2;
    }

    private static final void a(JSch jSch, String string, String string2, String string3) {
        long l2 = c ^ 0x54B18B78F3CEL;
        try {
            String string4 = OpenSSHConfigUtil.resolveIdentityFile(string, string2, string3);
            jSch.addIdentity(string4);
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug("Identity file " + string + " cannot be added and will be ignored", (Throwable)exception);
            }
            a.info("Identity file " + string + " cannot be added and will be ignored: " + exception.getMessage());
        }
    }

    @NotNull
    public static final Properties createConfig() {
        long l2 = c ^ 0x4AF172C73627L;
        Properties properties = new Properties();
        properties.setProperty("compression.s2c", "zlib,none");
        properties.setProperty("compression.c2s", "zlib,none");
        properties.setProperty("HashKnownHosts", "no");
        return properties;
    }

    public static final int toTimeoutInMillis(long timeout, @NotNull TimeUnit timeUnit) {
        long l2 = c ^ 0x3A9D02F6B623L;
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        long l3 = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        if (l3 < 0L) {
            throw (Throwable)new IllegalArgumentException("Invalid timeout value: " + l3);
        }
        if (l3 > (long)Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l3;
    }

    @Deprecated(message="Use the same function from ssh.kt")
    public static final boolean isPassphraseMayBeRequired(@NotNull String privateKeyPath) {
        long l2 = c ^ 0x4273AA3BBC34L;
        Intrinsics.checkParameterIsNotNull((Object)privateKeyPath, (String)"privateKeyPath");
        return Ssh.isPassphraseMayBeRequired(privateKeyPath, SshBackendLibrary.Companion.get());
    }

    @Deprecated(message="Use the same function from ssh.kt")
    public static final boolean isPrivateKeyNotEncrypted(@NotNull String privateKeyPath) {
        long l2 = c ^ 0x4EC47B666143L;
        Intrinsics.checkParameterIsNotNull((Object)privateKeyPath, (String)"privateKeyPath");
        return Ssh.isPrivateKeyNotEncrypted(privateKeyPath, SshBackendLibrary.Companion.get());
    }

    @NotNull
    public static final String id(@NotNull Object $this$id) {
        long l2 = c ^ 0x4BB266D8DD2L;
        Intrinsics.checkParameterIsNotNull((Object)$this$id, (String)"$this$id");
        return '@' + Integer.toHexString($this$id.hashCode());
    }

    public static final void addIdentities(@NotNull JSch jsch, @NotNull File sshDir, @Nullable SftpIdentityInfo[] identities) {
        long l2 = c ^ 0x44582C675CCEL;
        Intrinsics.checkParameterIsNotNull((Object)jsch, (String)"jsch");
        Intrinsics.checkParameterIsNotNull((Object)sshDir, (String)"sshDir");
        if (identities != null) {
            int n2 = 0;
            int n3 = identities.length;
            int n4 = n3 - 1;
            if (n2 <= n4) {
                while (true) {
                    SftpIdentityInfo sftpIdentityInfo = identities[n2];
                    SshConnectionUtil.a(jsch, sftpIdentityInfo);
                    if (n2 != n4) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            File file = new File(sshDir, "id_rsa");
            if (file.isFile() && file.canRead()) {
                SshConnectionUtil.a(jsch, new SftpIdentityInfo(file, null, null, 6, null));
            }
        }
    }

    private static final void a(JSch jSch, SftpIdentityInfo sftpIdentityInfo) {
        long l2 = c ^ 0x136E79FD7D38L;
        try {
            String string = sftpIdentityInfo.getPrivateKey() != null ? sftpIdentityInfo.getPrivateKey().getAbsolutePath() : null;
            String string2 = sftpIdentityInfo.getPublicKey() != null ? sftpIdentityInfo.getPublicKey().getAbsolutePath() : null;
            jSch.addIdentity(string, string2, sftpIdentityInfo.getPassPhrase());
        }
        catch (JSchException jSchException) {
            throw (Throwable)((Object)new SshTransportException("Failed to load identity file", jSchException));
        }
    }

    private static final File b() {
        long l2 = c ^ 0x56C0E08C77EL;
        String string = System.getProperty("vfs.sftp.sshdir");
        File file = null;
        if (string != null && (file = new File(string)).exists()) {
            return file;
        }
        File file2 = Ssh.getHomeSshDirectory().toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"getHomeSshDirectory().toFile()");
        file = file2;
        if (file.exists()) {
            return file;
        }
        if (SystemInfo.isWindows) {
            String string2 = System.getProperty("user.name");
            file = new File("C:\\cygwin\\home\\" + string2 + "\\.ssh");
            if (file.exists()) {
                return file;
            }
        }
        return new File("");
    }

    private static final void a(JSch jSch, File file, File file2) {
        long l2 = c ^ 0x7BA673147465L;
        if (file2 != null) {
            SshConnectionUtil.a(jSch, file2);
        } else {
            File file3 = new File(file, "known_hosts");
            if (file3.isFile() && file3.canRead()) {
                SshConnectionUtil.a(jSch, file3);
            }
        }
    }

    private static final void a(JSch jSch, File file) {
        long l2 = c ^ 0x63539C8570DCL;
        try {
            jSch.setKnownHosts(file.getAbsolutePath());
        }
        catch (JSchException jSchException) {
            throw (Throwable)((Object)new SshTransportException("Using of known_hosts file " + file.getAbsolutePath() + " failed", jSchException));
        }
    }

    private static final Integer a(@NotNull ConfigRepository.Config config, String string) {
        Void void_;
        String string2 = config.getValue(string);
        if (string2 != null) {
            String string3 = string2;
            boolean bl2 = false;
            boolean bl3 = false;
            String string4 = string3;
            boolean bl4 = false;
            try {
                Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            void_ = null;
        } else {
            void_ = null;
        }
        return (Integer)((Object)void_);
    }

    @Deprecated(message="JSch library will be removed")
    @NotNull
    public static final UserInfo toJschUserInfo(@NotNull SshPasswordProvider $this$toJschUserInfo) {
        long l2 = c ^ 0x2BBFD6A0465L;
        Intrinsics.checkParameterIsNotNull((Object)$this$toJschUserInfo, (String)"$this$toJschUserInfo");
        SshPasswordProvider sshPasswordProvider = $this$toJschUserInfo;
        return new UserInfo(sshPasswordProvider){
            final /* synthetic */ SshPasswordProvider $self;
            private static final long a;

            @Nullable
            public String getPassphrase() {
                return this.$self.getPassphrase();
            }

            @Nullable
            public String getPassword() {
                return this.$self.getPassword();
            }

            public boolean promptPassword(@NotNull String message) {
                long l2 = a ^ 0x19A5F4088EA9L;
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                return true;
            }

            public boolean promptPassphrase(@NotNull String message) {
                long l2 = a ^ 0xF5B8B240714L;
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                return true;
            }

            public boolean promptYesNo(@NotNull String message) {
                long l2 = a ^ 0x352C6EAFCC10L;
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                return this.$self.promptYesNo(message);
            }

            public void showMessage(@NotNull String message) {
                long l2 = a ^ 0x716AD4ABC80EL;
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.$self.showMessage(message);
            }

            @Nullable
            public String[] promptKeyboardInteractive(@Nullable String destination, @Nullable String name, @Nullable String instruction, @NotNull String[] prompt, @NotNull boolean[] echo) {
                long l2 = a ^ 0x7381E9E18D62L;
                Intrinsics.checkParameterIsNotNull((Object)prompt, (String)"prompt");
                Intrinsics.checkParameterIsNotNull((Object)echo, (String)"echo");
                return this.$self.promptKeyboardInteractive(destination, name, instruction, prompt, echo);
            }
            {
                this.$self = $captured_local_variable$0;
            }

            static {
                a = com.jetbrains.python.psi.c.a(-6613612480353189421L, -6463530436930896724L, MethodHandles.lookup().lookupClass()).a(263074469642780L);
            }
        };
    }

    private static final Set<String> a() {
        Lazy lazy = b;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl2 = false;
        return (Set)lazy.getValue();
    }

    private static final boolean a(String string) {
        long l2 = c ^ 0x51BAD89423B3L;
        return Intrinsics.areEqual((Object)string, (Object)"Password:") || Pattern.compile("^Password for [^ ]+@[^ ]+:$").matcher(string).matches();
    }

    public static final boolean isPamUnixPasswordPrompted(@NotNull String message) {
        long l2 = c ^ 0x2BCF14E7237BL;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return SshConnectionUtil.a().contains(message) || SshConnectionUtil.a(message);
    }

    @Nullable
    public static final String[] promptKeyboardInteractive(@NotNull String[] prompt, @NotNull boolean[] echo, @Nullable String destination, @Nullable String name, @Nullable String instruction, @NotNull SshPasswordProvider promptProvider) {
        long l2 = c ^ 0x2C514B90A891L;
        Intrinsics.checkParameterIsNotNull((Object)prompt, (String)"prompt");
        Intrinsics.checkParameterIsNotNull((Object)echo, (String)"echo");
        Intrinsics.checkParameterIsNotNull((Object)promptProvider, (String)"promptProvider");
        if (prompt.length == 1) {
            String string;
            boolean bl2;
            String string2;
            boolean bl3 = SshConnectionUtil.isPamUnixPasswordPrompted(prompt[0]);
            if (a.isDebugEnabled()) {
                string2 = prompt[0];
                Base64.Encoder encoder = Base64.getEncoder();
                Charset charset = Charsets.UTF_8;
                bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                string = encoder.encodeToString(byArray2);
                string2 = bl3 ? "treated" : "NOT treated";
                a.debug("Password prompt `" + prompt[0] + "` (base64 utf8 " + string + ") is " + string2 + " as unix password");
            }
            if (bl3) {
                String[] stringArray;
                String string4 = string = promptProvider.getPassword();
                if (string4 != null) {
                    string2 = string4;
                    boolean bl4 = false;
                    bl2 = false;
                    String string5 = string2;
                    boolean bl5 = false;
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = string5;
                } else {
                    stringArray = null;
                }
                return stringArray;
            }
            string = "Authenticating to " + destination + ".\n" + prompt[0];
            return promptProvider.askUserForPassword(string);
        }
        StringBuilder stringBuilder = new StringBuilder("Unsupported keyboard interactive request: ");
        stringBuilder.append("destination=\"").append(destination).append("\", ");
        stringBuilder.append("name=\"").append(name).append("\", ");
        stringBuilder.append("instruction=\"").append(instruction).append("\", ");
        if (prompt.length > 0) {
            stringBuilder.append("prompt=[\"").append(StringUtil.join((String[])prompt, (String)"\",\"")).append("\"]");
        } else {
            stringBuilder.append("prompt=[]");
        }
        a.warn(stringBuilder.toString());
        return null;
    }

    @NotNull
    public static final SshPasswordProvider toSshPasswordProvider(@NotNull UserInfo $this$toSshPasswordProvider) {
        long l2 = c ^ 0x19D43BF69C2AL;
        Intrinsics.checkParameterIsNotNull((Object)$this$toSshPasswordProvider, (String)"$this$toSshPasswordProvider");
        UserInfo userInfo = $this$toSshPasswordProvider;
        return new SshPasswordProvider(userInfo){
            final /* synthetic */ UserInfo $self;
            private static final long a;

            @Nullable
            public String getPassphrase() {
                return this.$self.getPassphrase();
            }

            @Nullable
            public String getPassword() {
                return this.$self.getPassword();
            }

            public boolean promptYesNo(@NotNull String message) {
                long l2 = a ^ 0x2A001A3D9991L;
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                return this.$self.promptYesNo(message);
            }

            public void showMessage(@NotNull String message) {
                long l2 = a ^ 0x74A6200E3CBL;
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.$self.showMessage(message);
            }

            @Nullable
            public String[] askUserForPassword(@NotNull String message) {
                long l2 = a ^ 0x5F7CFFD05100L;
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                if (this.$self instanceof SshPasswordProvider) {
                    return ((SshPasswordProvider)this.$self).askUserForPassword(message);
                }
                return null;
            }
            {
                this.$self = $captured_local_variable$0;
            }

            static {
                a = com.jetbrains.python.psi.c.a(-9197678841250358773L, -708804254349044160L, MethodHandles.lookup().lookupClass()).a(148096458248817L);
            }
        };
    }
}

