/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.filters.CompositeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GlobalCompilingVisitor {
    @NonNls
    private static final String f = "\\b(__\\$_\\w+)\\b";
    private static final Pattern d;
    private static final Set<String> g;
    private static final NodeFilter c;
    private CompileContext b;
    private final List<PsiElement> a = new SmartList();
    private int e;
    private static final long h;

    public static NodeFilter getFilter() {
        return c;
    }

    public void setHandler(PsiElement element, MatchingHandler handler) {
        MatchingHandler matchingHandler = this.b.getPattern().getHandlerSimple(element);
        if (matchingHandler instanceof SubstitutionHandler) {
            ((SubstitutionHandler)matchingHandler).setMatchHandler(handler);
        } else {
            this.b.getPattern().setHandler(element, handler);
        }
    }

    public final void handle(PsiElement element) {
        if ((!c.accepts(element) || StructuralSearchUtil.isIdentifier(element)) && this.b.getPattern().isRealTypedVar(element) && this.b.getPattern().getHandlerSimple(element) == null) {
            String string = this.b.getPattern().getTypedVarString(element);
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)this.b.getPattern().getHandler(string);
            if (substitutionHandler == null) {
                return;
            }
            this.b.getPattern().setHandler(element, substitutionHandler);
            if (this.b.getOptions().getVariableConstraint(substitutionHandler.getName()).isPartOfSearchResults()) {
                substitutionHandler.setTarget(true);
                this.b.getPattern().setTargetNode(element);
            }
        }
    }

    public CompileContext getContext() {
        return this.b;
    }

    public int getCodeBlockLevel() {
        return this.e;
    }

    public void setCodeBlockLevel(int codeBlockLevel) {
        this.e = codeBlockLevel;
    }

    public static void setFilter(MatchingHandler handler, NodeFilter filter) {
        if (handler.getFilter() != null && handler.getFilter().getClass() != filter.getClass()) {
            handler.setFilter(new CompositeFilter(filter, handler.getFilter()));
        } else {
            handler.setFilter(filter);
        }
    }

    public void setFilterSimple(PsiElement element, NodeFilter filter) {
        this.b.getPattern().getHandler(element).setFilter(filter);
    }

    public List<PsiElement> getLexicalNodes() {
        return this.a;
    }

    public void addLexicalNode(PsiElement node) {
        this.a.add(node);
    }

    void compile(PsiElement[] elements, CompileContext context) {
        if (elements.length == 0) {
            throw new MalformedPatternException();
        }
        this.e = 0;
        this.b = context;
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(context.getOptions().getFileType());
        assert (structuralSearchProfile != null);
        structuralSearchProfile.compile(elements, this);
        assert (context.getPattern().getStrategy() != null);
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(String pattern, OccurenceKind kind) {
        return this.processPatternStringWithFragments(pattern, kind, d);
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(String pattern, OccurenceKind kind, Pattern substitutionPattern) {
        String string;
        String string2;
        long l2 = h ^ 0x6774A2F1B887L;
        if (kind == OccurenceKind.LITERAL) {
            string2 = pattern.substring(1, pattern.length() - 1);
        } else if (kind == OccurenceKind.COMMENT) {
            string2 = pattern;
        } else {
            assert (false);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        Matcher matcher = substitutionPattern.matcher(string2);
        SmartList smartList = new SmartList();
        int n2 = 0;
        boolean bl2 = false;
        MatchingHandler matchingHandler = null;
        while (matcher.find()) {
            string = string2.substring(n2, matcher.start());
            if (!string.isEmpty()) {
                stringBuilder.append(StructuralSearchUtil.shieldRegExpMetaChars(string));
                bl2 = true;
                this.processTokenizedName(string, false, kind);
            }
            if ((matchingHandler = (SubstitutionHandler)this.getContext().getPattern().getHandler(matcher.group(1))) == null) {
                throw new MalformedPatternException();
            }
            smartList.add(matchingHandler);
            RegExpPredicate regExpPredicate = ((SubstitutionHandler)matchingHandler).findRegExpPredicate();
            if (regExpPredicate == null || !regExpPredicate.isWholeWords()) {
                stringBuilder.append("(.*?)");
            } else {
                stringBuilder.append(".*?\\b(").append(regExpPredicate.getRegExp()).append(")\\b.*?");
            }
            if (GlobalCompilingVisitor.isSuitablePredicate(regExpPredicate, (SubstitutionHandler)matchingHandler)) {
                this.processTokenizedName(regExpPredicate.getRegExp(), false, kind);
            }
            n2 = matcher.end();
        }
        string = string2.substring(n2);
        if (!string.isEmpty()) {
            bl2 = true;
            stringBuilder.append(StructuralSearchUtil.shieldRegExpMetaChars(string));
            this.processTokenizedName(string, false, kind);
        }
        if (bl2 && kind == OccurenceKind.LITERAL) {
            stringBuilder.insert(0, "[\"']");
            stringBuilder.append("[\"']");
        }
        if (!smartList.isEmpty()) {
            return bl2 ? new LiteralWithSubstitutionHandler(stringBuilder.toString(), (List<? extends SubstitutionHandler>)smartList, this.b.getOptions().isCaseSensitiveMatch()) : matchingHandler;
        }
        return null;
    }

    @Contract(value="null,_ -> false")
    public static boolean isSuitablePredicate(RegExpPredicate predicate, SubstitutionHandler handler) {
        return predicate != null && handler.getMinOccurs() != 0 && predicate.couldBeOptimized();
    }

    public static void addFilesToSearchForGivenWord(String word, boolean endTransaction, OccurenceKind kind, CompileContext compileContext) {
        if (!compileContext.getSearchHelper().doOptimizing()) {
            return;
        }
        if (g.contains(word)) {
            return;
        }
        if (kind == OccurenceKind.CODE) {
            compileContext.getSearchHelper().addWordToSearchInCode(word);
        } else if (kind == OccurenceKind.COMMENT) {
            compileContext.getSearchHelper().addWordToSearchInComments(word);
        } else if (kind == OccurenceKind.LITERAL) {
            compileContext.getSearchHelper().addWordToSearchInLiterals(word);
        } else if (kind == OccurenceKind.TEXT) {
            compileContext.getSearchHelper().addWordToSearchInText(word);
        }
        if (endTransaction) {
            compileContext.getSearchHelper().endTransaction();
        }
    }

    public void processTokenizedName(String name, boolean skipComments, OccurenceKind kind) {
        for (String string : StringUtil.getWordsInStringLongestFirst((String)name)) {
            GlobalCompilingVisitor.addFilesToSearchForGivenWord(string, true, kind, this.getContext());
        }
    }

    static {
        h = com.jetbrains.python.psi.c.a(3055704961464381003L, -5015770831567292186L, MethodHandles.lookup().lookupClass()).a(80831392653843L);
        long l2 = h ^ 0x78288FC870CFL;
        d = Pattern.compile(f);
        g = new HashSet<String>(Arrays.asList("Modifier", "Instance"));
        c = LexicalNodesFilter.getInstance();
        for (StructuralSearchProfile structuralSearchProfile : StructuralSearchProfile.EP_NAME.getExtensionList()) {
            g.addAll(structuralSearchProfile.getReservedWords());
        }
    }

    public static final class OccurenceKind
    extends Enum<OccurenceKind> {
        public static final /* enum */ OccurenceKind LITERAL;
        public static final /* enum */ OccurenceKind COMMENT;
        public static final /* enum */ OccurenceKind CODE;
        public static final /* enum */ OccurenceKind TEXT;
        private static final /* synthetic */ OccurenceKind[] a;

        public static OccurenceKind[] values() {
            return (OccurenceKind[])a.clone();
        }

        public static OccurenceKind valueOf(String name) {
            return Enum.valueOf(OccurenceKind.class, name);
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(-1089238502745220576L, -1268305682505454255L, MethodHandles.lookup().lookupClass()).a(275111124298941L) ^ 0x61A4B0A2A451L;
            LITERAL = new OccurenceKind();
            COMMENT = new OccurenceKind();
            CODE = new OccurenceKind();
            TEXT = new OccurenceKind();
            a = new OccurenceKind[]{LITERAL, COMMENT, CODE, TEXT};
        }
    }
}

