/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class ReplacementBuilder {
    private final String e;
    private final List<ParameterInfo> b = new SmartList();
    private final Map<String, ScriptSupport> c = new HashMap<String, ScriptSupport>();
    private final ReplaceOptions a;
    private final Project d;

    ReplacementBuilder(Project project, ReplaceOptions options) {
        ParameterInfo parameterInfo;
        PsiElement[] psiElementArray;
        this.d = project;
        this.a = options;
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "", options.getReplacement());
        this.e = template.getTemplateText();
        int n2 = 0;
        for (int i10 = 0; i10 < template.getSegmentsCount(); ++i10) {
            int n3;
            int n4 = template.getSegmentOffset(i10);
            parameterInfo = new ParameterInfo((String)psiElementArray, n4, options.getVariableDefinition((String)(psiElementArray = template.getSegmentName(i10))) != null);
            for (n3 = n4 - 1; n3 >= n2 && n3 < this.e.length() && StringUtil.isWhiteSpace((char)this.e.charAt(n3)); --n3) {
            }
            if (n3 >= 0) {
                if (this.e.charAt(n3) == ',') {
                    parameterInfo.setHasCommaBefore(true);
                }
                while (n3 > n2 && StringUtil.isWhiteSpace((char)this.e.charAt(n3 - 1))) {
                    --n3;
                }
                parameterInfo.setBeforeDelimiterPos(n3);
            }
            for (n3 = n4; n3 < this.e.length() && StringUtil.isWhiteSpace((char)this.e.charAt(n3)); ++n3) {
            }
            if (n3 < this.e.length()) {
                char c10 = this.e.charAt(n3);
                if (c10 == ';') {
                    parameterInfo.setStatementContext(true);
                } else if (c10 == ',' || c10 == ')') {
                    parameterInfo.setArgumentContext(true);
                    parameterInfo.setHasCommaAfter(c10 == ',');
                }
            }
            parameterInfo.setAfterDelimiterPos(n3);
            n2 = n4;
            this.b.add(parameterInfo);
        }
        LanguageFileType languageFileType = options.getMatchOptions().getFileType();
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(languageFileType);
        if (structuralSearchProfile != null) {
            try {
                psiElementArray = MatcherImplUtil.createTreeFromText(options.getReplacement(), PatternTreeContext.Block, languageFileType, options.getMatchOptions().getDialect(), options.getMatchOptions().getPatternContext(), project, false);
                if (psiElementArray.length > 0) {
                    parameterInfo = psiElementArray[0].getParent();
                    parameterInfo.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(PsiElement element) {
                            ParameterInfo parameterInfo;
                            super.visitElement(element);
                            String string = element.getText();
                            if (StructuralSearchUtil.isTypedVariable(string) && (parameterInfo = ReplacementBuilder.this.findParameterization(Replacer.stripTypedVariableDecoration(string))) != null && parameterInfo.getElement() == null) {
                                parameterInfo.setElement(element);
                            }
                        }
                    });
                    structuralSearchProfile.provideAdditionalReplaceOptions((PsiElement)parameterInfo, options, this);
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                throw new MalformedPatternException(incorrectOperationException.getMessage());
            }
        }
    }

    String process(MatchResult match, ReplacementInfo replacementInfo, LanguageFileType type) {
        if (this.b.isEmpty()) {
            return this.e;
        }
        StringBuilder stringBuilder = new StringBuilder(this.e);
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(type);
        assert (structuralSearchProfile != null);
        int n2 = 0;
        for (ParameterInfo parameterInfo : this.b) {
            MatchResult matchResult = replacementInfo.getNamedMatchResult(parameterInfo.getName());
            if (parameterInfo.isReplacementVariable()) {
                n2 = Replacer.insertSubstitution(stringBuilder, n2, parameterInfo, this.a(parameterInfo, match));
                continue;
            }
            if (matchResult != null) {
                n2 = structuralSearchProfile.handleSubstitution(parameterInfo, matchResult, stringBuilder, n2, replacementInfo);
                continue;
            }
            n2 = structuralSearchProfile.handleNoSubstitution(parameterInfo, n2, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private String a(ParameterInfo parameterInfo, MatchResult matchResult) {
        ScriptSupport scriptSupport = this.c.get(parameterInfo.getName());
        if (scriptSupport == null) {
            String string = this.a.getVariableDefinition(parameterInfo.getName()).getScriptCodeConstraint();
            List list2 = ContainerUtil.map(this.a.getVariableDefinitions(), replacementVariableDefinition -> replacementVariableDefinition.getName());
            scriptSupport = new ScriptSupport(this.d, StringUtil.unquoteString((String)string), parameterInfo.getName(), list2, this.a.getMatchOptions());
            this.c.put(parameterInfo.getName(), scriptSupport);
        }
        return scriptSupport.evaluate(matchResult, null);
    }

    @Nullable
    public ParameterInfo findParameterization(String name) {
        for (ParameterInfo parameterInfo : this.b) {
            if (!parameterInfo.getName().equals(name)) continue;
            return parameterInfo;
        }
        return null;
    }
}

