/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.find.FindManager;
import com.intellij.find.FindProgressIndicator;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchScriptException;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.UsageViewContext;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;

public class SearchCommand {
    protected final SearchContext mySearchContext;
    protected final Configuration myConfiguration;
    private MatchingProcess b;
    private FindUsagesProcessPresentation a;
    private static final long d = c.a(-1227114507066250297L, 6005192115334653958L, MethodHandles.lookup().lookupClass()).a(270573494747495L);

    public SearchCommand(Configuration configuration, SearchContext searchContext) {
        this.myConfiguration = configuration;
        this.mySearchContext = searchContext;
    }

    protected UsageViewContext createUsageViewContext() {
        Runnable runnable = () -> new SearchCommand(this.myConfiguration, this.mySearchContext).startSearching();
        return new UsageViewContext(this.myConfiguration, this.mySearchContext, runnable);
    }

    public void startSearching() {
        final UsageViewContext usageViewContext = this.createUsageViewContext();
        final UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        usageViewPresentation.setOpenInNewTab(FindSettings.getInstance().isShowResultsInSeparateView());
        usageViewContext.configure(usageViewPresentation);
        this.a = new FindUsagesProcessPresentation(usageViewPresentation);
        this.a.setShowNotFoundMessage(true);
        this.a.setShowPanelIfOnlyOneUsage(true);
        this.a.setProgressIndicatorFactory((Factory)new Factory<ProgressIndicator>(){

            public ProgressIndicator create() {
                FindProgressIndicator findProgressIndicator = new FindProgressIndicator(SearchCommand.this.mySearchContext.getProject(), usageViewPresentation.getScopeText());
                findProgressIndicator.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                    public void cancel() {
                        super.cancel();
                        SearchCommand.this.stopAsyncSearch();
                    }
                });
                return findProgressIndicator;
            }
        });
        PsiDocumentManager.getInstance((Project)this.mySearchContext.getProject()).commitAllDocuments();
        ConfigurableUsageTarget configurableUsageTarget = usageViewContext.getTarget();
        ((FindManagerImpl)FindManager.getInstance((Project)this.mySearchContext.getProject())).getFindUsagesManager().addToHistory(configurableUsageTarget);
        UsageViewManager.getInstance((Project)this.mySearchContext.getProject()).searchAndShowUsages(new UsageTarget[]{configurableUsageTarget}, () -> new UsageSearcher(){
            private static final long a = c.a(-5905768424411775624L, 494119359566866960L, MethodHandles.lookup().lookupClass()).a(47684823383020L);

            public void generate(@NotNull Processor<Usage> processor2) {
                if (processor2 == null) {
                    3.a(0);
                }
                SearchCommand.this.findUsages(processor2);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x18A7BA2665C4L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/structuralsearch/plugin/ui/SearchCommand$3", "generate"));
            }
        }, this.a, usageViewPresentation, new UsageViewManager.UsageViewStateListener(){
            private static final long a = c.a(-1338879202154415715L, 1394737523227569271L, MethodHandles.lookup().lookupClass()).a(202202775545675L);

            public void usageViewCreated(@NotNull UsageView usageView) {
                if (usageView == null) {
                    2.a(0);
                }
                usageViewContext.setUsageView(usageView);
                usageViewContext.configureActions();
            }

            public void findingUsagesFinished(UsageView usageView) {
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x79AAB3171E50L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/structuralsearch/plugin/ui/SearchCommand$2", "usageViewCreated"));
            }
        });
    }

    public void findUsages(final Processor<? super Usage> processor2) {
        long l2 = d ^ 0x4FE4CD1F1114L;
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setIndeterminate(false);
        MatchResultSink matchResultSink = new MatchResultSink(){
            int count;
            private static final long a = c.a(-4847050454912875554L, -1509641489234272799L, MethodHandles.lookup().lookupClass()).a(108550705553427L);

            @Override
            public void setMatchingProcess(MatchingProcess _process) {
                SearchCommand.this.b = _process;
                SearchCommand.this.findStarted();
            }

            @Override
            public void processFile(PsiFile element) {
                long l2 = a ^ 0x2192CEE269C5L;
                VirtualFile virtualFile = element.getVirtualFile();
                if (virtualFile != null) {
                    progressIndicator.setText(SSRBundle.message("looking.in.progress.message", virtualFile.getPresentableName()));
                }
            }

            @Override
            public void matchingFinished() {
                long l2 = a ^ 0x3B17CB966467L;
                if (SearchCommand.this.mySearchContext.getProject().isDisposed()) {
                    return;
                }
                SearchCommand.this.findEnded();
                progressIndicator.setText(SSRBundle.message("found.progress.message", this.count));
            }

            @Override
            public ProgressIndicator getProgressIndicator() {
                return progressIndicator;
            }

            @Override
            public void newMatch(MatchResult result) {
                UsageInfo usageInfo;
                long l2 = a ^ 0x2CDE625C6299L;
                if ("__multi_line__".equals(result.getName())) {
                    int n2 = -1;
                    int n3 = -1;
                    PsiElement psiElement = result.getMatch().getParent();
                    for (MatchResult matchResult : result.getChildren()) {
                        int n4;
                        PsiElement psiElement2 = matchResult.getMatch();
                        int n5 = psiElement2.getTextRange().getStartOffset();
                        if (n2 == -1 || n2 > n5) {
                            n2 = n5;
                        }
                        if ((n4 = n5 + psiElement2.getTextLength()) <= n3) continue;
                        n3 = n4;
                    }
                    int n6 = psiElement.getTextRange().getStartOffset();
                    int n7 = n2 - n6;
                    usageInfo = new UsageInfo(psiElement, n7, n3 - n6);
                } else {
                    PsiElement psiElement = result.getMatch();
                    if (!psiElement.isPhysical()) {
                        return;
                    }
                    usageInfo = new UsageInfo(psiElement);
                }
                UsageInfo2UsageAdapter usageInfo2UsageAdapter = new UsageInfo2UsageAdapter(usageInfo);
                SearchCommand.this.foundUsage(result, (Usage)usageInfo2UsageAdapter);
                processor2.process((Object)usageInfo2UsageAdapter);
                ++this.count;
            }
        };
        try {
            new Matcher(this.mySearchContext.getProject()).findMatches(matchResultSink, this.myConfiguration.getMatchOptions());
        }
        catch (StructuralSearchException structuralSearchException) {
            this.a.setShowNotFoundMessage(false);
            UIUtil.SSR_NOTIFICATION_GROUP.createNotification(NotificationType.ERROR).setContent(structuralSearchException instanceof StructuralSearchScriptException ? SSRBundle.message("search.script.problem", structuralSearchException.getCause()) : SSRBundle.message("search.template.problem", structuralSearchException.getMessage())).setImportant(true).notify(this.mySearchContext.getProject());
        }
    }

    public void stopAsyncSearch() {
        if (this.b != null) {
            this.b.stop();
        }
    }

    protected void findStarted() {
        StructuralSearchPlugin.getInstance(this.mySearchContext.getProject()).setSearchInProgress(true);
    }

    protected void findEnded() {
        StructuralSearchPlugin.getInstance(this.mySearchContext.getProject()).setSearchInProgress(false);
    }

    protected void foundUsage(MatchResult result, Usage usage) {
    }
}

