/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.webcore.formatter.comments.CommentLineData;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DocCommentLineDataBuilder
extends CommentLineDataBuilder {
    private final boolean c;
    private final PsiElement b;
    private final CommonCodeStyleSettings.IndentOptions d;
    private static final long e = com.jetbrains.python.psi.c.a(-6281965573759773996L, -9089138803343071261L, MethodHandles.lookup().lookupClass()).a(41736300428426L);

    public DocCommentLineDataBuilder(@NotNull PsiElement docComment, boolean alignDocComments, @NotNull CommonCodeStyleSettings settings) {
        if (docComment == null) {
            DocCommentLineDataBuilder.a(0);
        }
        if (settings == null) {
            DocCommentLineDataBuilder.a(1);
        }
        super(settings.getRootSettings());
        this.b = docComment;
        this.c = alignDocComments;
        this.d = settings.getIndentOptions() != null ? settings.getIndentOptions() : new CommonCodeStyleSettings.IndentOptions();
    }

    @Override
    public List<CommentLineData> getLines() {
        CharSequence charSequence = this.b.getNode().getChars();
        ArrayList<CommentLineData> arrayList = new ArrayList<CommentLineData>();
        int n2 = 0;
        boolean bl2 = false;
        block3: for (int i10 = 0; i10 < charSequence.length(); ++i10) {
            char c10 = charSequence.charAt(i10);
            switch (c10) {
                case '\n': {
                    if (n2 < i10) {
                        CommentLineData commentLineData = this.a(charSequence, n2, i10, bl2);
                        bl2 = commentLineData.isTagLine();
                        arrayList.add(commentLineData);
                    }
                    n2 = i10 + 1;
                    continue block3;
                }
            }
        }
        if (n2 < charSequence.length()) {
            arrayList.add(this.a(charSequence, n2, charSequence.length(), bl2));
        }
        return arrayList;
    }

    private CommentLineData a(CharSequence charSequence, int n2, int n3, boolean bl2) {
        String string = new String(CharArrayUtil.fromSequence((CharSequence)charSequence, (int)n2, (int)n3));
        CommentLineData commentLineData = this.parseLine(string);
        commentLineData.setTagLine(bl2);
        return commentLineData;
    }

    @Override
    @NotNull
    public CommentLineData parseLine(@NotNull String line2) {
        long l2 = e ^ 0x27808E952DDCL;
        if (line2 == null) {
            DocCommentLineDataBuilder.a(2);
        }
        DocCommentLineData docCommentLineData = new DocCommentLineData(line2);
        docCommentLineData.commentOffset = DocCommentLineDataBuilder.nextNonWhitespace(line2, 0);
        if (docCommentLineData.commentOffset >= 0) {
            int n2;
            if (line2.charAt(docCommentLineData.commentOffset) == '*') {
                ++docCommentLineData.commentOffset;
            }
            if ((n2 = DocCommentLineDataBuilder.nextNonWhitespace(line2, docCommentLineData.commentOffset)) >= 0) {
                char c10 = line2.charAt(n2);
                if (c10 == '@') {
                    docCommentLineData.tagStartOffset = n2;
                    int n3 = docCommentLineData.tagEndOffset = (n2 = DocCommentLineDataBuilder.nextWhitespace(line2, n2 + 1)) >= 0 ? n2 : line2.length();
                    if (docCommentLineData.tagEndOffset > docCommentLineData.tagStartOffset) {
                        docCommentLineData.tagName = line2.substring(docCommentLineData.tagStartOffset, docCommentLineData.tagEndOffset);
                    }
                    if (n2 >= 0) {
                        if ("@param".equals(docCommentLineData.tagName)) {
                            if ((n2 = DocCommentLineDataBuilder.nextNonWhitespace(line2, n2 + 1)) >= 0) {
                                boolean bl2 = line2.charAt(n2) == '$';
                                n2 = DocCommentLineDataBuilder.nextWhitespace(line2, n2);
                                if (!bl2 && n2 >= 0) {
                                    n2 = DocCommentLineDataBuilder.skipNextWord(line2, n2);
                                }
                            }
                        } else if ("@return".equals(docCommentLineData.tagName) || "@throws".equals(docCommentLineData.tagName)) {
                            n2 = DocCommentLineDataBuilder.skipNextWord(line2, n2);
                        }
                    }
                } else if (Character.isLetter(c10)) {
                    docCommentLineData.startsWithLetter = true;
                }
                if (n2 >= 0) {
                    docCommentLineData.textStartOffset = (n2 = DocCommentLineDataBuilder.nextNonWhitespace(line2, n2)) >= 0 ? n2 : -1;
                    DocCommentLineDataBuilder.a(docCommentLineData, line2);
                }
            }
        }
        DocCommentLineData docCommentLineData2 = docCommentLineData;
        if (docCommentLineData2 == null) {
            DocCommentLineDataBuilder.a(3);
        }
        return docCommentLineData2;
    }

    private static void a(@NotNull CommentLineData commentLineData, @NotNull String string) {
        if (commentLineData == null) {
            DocCommentLineDataBuilder.a(4);
        }
        if (string == null) {
            DocCommentLineDataBuilder.a(5);
        }
        if (commentLineData.textStartOffset < 0) {
            return;
        }
        int n2 = -1;
        block4: for (int i10 = commentLineData.textStartOffset; i10 < string.length(); ++i10) {
            char c10 = string.charAt(i10);
            switch (c10) {
                case '{': {
                    int n3 = i10 + 1;
                    if (n3 >= string.length() || string.charAt(n3) != '@') continue block4;
                    n2 = i10;
                    continue block4;
                }
                case '}': {
                    if (n2 >= 0) {
                        TextRange textRange = new TextRange(n2, i10);
                        commentLineData.addUnbreakableRange(textRange);
                    }
                    n2 = -1;
                }
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x5D8851898B78L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInlineTagsRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DocCommentLineData
    extends CommentLineData {
        int tagStartOffset;
        int tagEndOffset;
        String tagName;
        private boolean b;
        private static final long c = com.jetbrains.python.psi.c.a(7708290191675832128L, 2611050514524486255L, MethodHandles.lookup().lookupClass()).a(205658149671746L);

        DocCommentLineData(String line2) {
            if (line2 == null) {
                DocCommentLineData.a(0);
            }
            super(line2);
            this.tagStartOffset = -1;
            this.tagEndOffset = -1;
            this.tagName = "";
            this.b = false;
        }

        @Override
        public boolean isTagLine() {
            return this.tagStartOffset >= 0 || this.b;
        }

        @Override
        public void setTagLine(boolean tagLine) {
            this.b = tagLine;
        }

        @Override
        @NotNull
        public String getLinePrefix() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.commentOffset >= 0) {
                stringBuilder.append(this.line, 0, this.commentOffset);
                if (this.textStartOffset > this.commentOffset) {
                    if (DocCommentLineDataBuilder.this.c) {
                        StringUtil.repeatSymbol((Appendable)stringBuilder, (char)' ', (int)(this.textStartOffset - this.commentOffset - 1));
                    } else if (this.isTagLine()) {
                        StringUtil.repeatSymbol((Appendable)stringBuilder, (char)' ', (int)((DocCommentLineDataBuilder)DocCommentLineDataBuilder.this).d.CONTINUATION_INDENT_SIZE);
                    }
                }
            }
            String string = stringBuilder.toString();
            if (string == null) {
                DocCommentLineData.a(1);
            }
            return string;
        }

        @Override
        protected int getTabSize() {
            return ((DocCommentLineDataBuilder)DocCommentLineDataBuilder.this).d.TAB_SIZE;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x3052EA867445L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder$DocCommentLineData";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder$DocCommentLineData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinePrefix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

