/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.facet.AppEngineFacetType;
import com.jetbrains.appengine.run.AppEngineServerRunConfigurationType;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.lang.invoke.MethodHandles;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class AppEngineFacetConfigurator
implements DirectoryProjectConfigurator {
    private static final long a = c.a(-4340771634514179521L, -3052939017619765512L, MethodHandles.lookup().lookupClass()).a(51107894912230L);

    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef) {
        Module module2;
        Module[] moduleArray;
        if (project == null) {
            AppEngineFacetConfigurator.a(0);
        }
        if (baseDir == null) {
            AppEngineFacetConfigurator.a(1);
        }
        if (moduleRef == null) {
            AppEngineFacetConfigurator.a(2);
        }
        if ((moduleArray = ModuleManager.getInstance((Project)project).getModules()).length > 0 && AppEngineFacet.getInstance(module2 = moduleArray[0]) == null) {
            AppEngineFacetConfigurator.a(module2, baseDir);
        }
    }

    private static void a(Module module2, VirtualFile virtualFile) {
        long l2 = a ^ 0x47FD1CC3D840L;
        virtualFile.refresh(false, true);
        if (virtualFile.findChild("app.yaml") != null) {
            TemplatesService templatesService;
            AppEngineFacetConfiguration appEngineFacetConfiguration = AppEngineFacetConfiguration.fromProjectDirectory(virtualFile);
            if (StringUtil.isEmptyOrSpaces((String)appEngineFacetConfiguration.getSdkFolder())) {
                Notifications.Bus.notify((Notification)new Notification("Project Configuration", "App Engine SDK path not configured", "<a href=\"#configure\">Configure the App Engine SDK path</a>", NotificationType.WARNING, (NotificationListener)new MyNotificationListener(module2.getProject())), (Project)module2.getProject());
            }
            AppEngineFacetType.createAppEngineFacet(module2, appEngineFacetConfiguration);
            StartupManager.getInstance((Project)module2.getProject()).runWhenProjectIsInitialized(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                if (appEngineFacetConfiguration.getSdkFolder() != null) {
                    AppEngineUtil.initAppEngineModuleLibrary(module2, null, appEngineFacetConfiguration.getSdkFolder(), appEngineFacetConfiguration.getProjectRoot());
                }
            }));
            PyRunConfigurationFactory.getInstance().createRunConfiguration(module2, AppEngineServerRunConfigurationType.getInstance().getConfigurationFactory());
            VirtualFile virtualFile2 = virtualFile.findChild("templates");
            if (virtualFile2 != null && (templatesService = TemplatesService.getInstance(module2)).getTemplateFolders().size() == 0) {
                templatesService.setTemplateFolders(virtualFile2);
                templatesService.setTemplateLanguage("Django");
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = a ^ 0x61DC62EE4615L;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "moduleRef";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/appengine/AppEngineFacetConfigurator";
        objectArray[2] = "configureProject";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyNotificationListener
    implements NotificationListener {
        public Project myProject;
        private static final long a = c.a(-4365233476038418977L, -1241319932911591417L, MethodHandles.lookup().lookupClass()).a(8147699672961L);

        MyNotificationListener(Project project) {
            this.myProject = project;
        }

        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
            long l2 = a ^ 0x78E744D8984AL;
            if (notification2 == null) {
                MyNotificationListener.a(0);
            }
            if (event == null) {
                MyNotificationListener.a(1);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                notification2.expire();
                ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, "Google App Engine");
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x2EA10FF5B189L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/appengine/AppEngineFacetConfigurator$MyNotificationListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

