/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.inspection;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.appengine.lang.gql.psi.GqlEntityClassName;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlFileImpl;
import com.jetbrains.appengine.model.ModelManager;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferenceSkipperExtPoint;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyImportElementImpl;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineUnresolvedReferenceSkipper
implements PyUnresolvedReferenceSkipperExtPoint {
    private static final long a = c.a(-5548001418382149728L, 5934978368088464722L, MethodHandles.lookup().lookupClass()).a(19113963097739L);

    @Override
    public boolean unusedImportShouldBeSkipped(@NotNull PyImportedNameDefiner importNameDefiner) {
        if (importNameDefiner == null) {
            AppEngineUnresolvedReferenceSkipper.a(0);
        }
        if (AppEngineUtil.getAppEngineModule(importNameDefiner.getProject()) == null) {
            return false;
        }
        if (importNameDefiner instanceof PyImportElementImpl) {
            String string = ((PyImportElementImpl)importNameDefiner).getVisibleName();
            if (string == null) {
                return false;
            }
            ModelManager modelManager = AppEngineUnresolvedReferenceSkipper.a((PsiElement)importNameDefiner);
            if (modelManager == null || modelManager.findModel(string) == null) {
                return false;
            }
            PsiFile psiFile = importNameDefiner.getContainingFile();
            if (psiFile == null) {
                return false;
            }
            AppEngineKindSearcher appEngineKindSearcher = new AppEngineKindSearcher(string);
            psiFile.accept((PsiElementVisitor)appEngineKindSearcher);
            return appEngineKindSearcher.myShouldSkip;
        }
        return false;
    }

    @Nullable
    private static ModelManager a(@NotNull PsiElement psiElement) {
        Module module2;
        if (psiElement == null) {
            AppEngineUnresolvedReferenceSkipper.a(1);
        }
        return (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement)) != null ? ModelManager.getInstance(module2) : null;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x2AAC6EC703D4L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importNameDefiner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/appengine/inspection/AppEngineUnresolvedReferenceSkipper";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "unusedImportShouldBeSkipped";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getManager";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AppEngineKindSearcher
    extends PyRecursiveElementVisitor {
        boolean myShouldSkip;
        String myKindName;
        private static final long a = c.a(4607058897983128944L, 5555239932441755032L, MethodHandles.lookup().lookupClass()).a(190779402612808L);

        AppEngineKindSearcher(@NotNull String kindName) {
            if (kindName == null) {
                AppEngineKindSearcher.a(0);
            }
            this.myKindName = kindName;
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression stringLiteral) {
            if (this.myShouldSkip) {
                return;
            }
            if (!AppEngineUtil.isGql(stringLiteral)) {
                return;
            }
            List list2 = InjectedLanguageManager.getInstance((Project)stringLiteral.getProject()).getInjectedPsiFiles((PsiElement)stringLiteral);
            if (list2 == null) {
                return;
            }
            for (Pair pair : list2) {
                PsiElement psiElement = (PsiElement)pair.getFirst();
                if (!(psiElement instanceof GqlFileImpl)) continue;
                Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)psiElement, GqlEntityClassName.class);
                for (GqlEntityClassName gqlEntityClassName : collection) {
                    String string = gqlEntityClassName.getText();
                    if (!this.myKindName.equals(string)) continue;
                    this.myShouldSkip = true;
                    return;
                }
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x78ED343AED14L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindName", "com/jetbrains/appengine/inspection/AppEngineUnresolvedReferenceSkipper$AppEngineKindSearcher", "<init>"));
        }
    }
}

