/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SofterReference;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.model.TemplateParametersEvaluator;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoWebUrlEvaluator {
    private final Map<PsiElement, SofterReference<String>> a = Maps.newHashMap();
    private final Set<VirtualFile> b = Sets.newHashSet();
    private static final long c = com.jetbrains.python.psi.c.a(-8899914475908563103L, -3258986361388593195L, MethodHandles.lookup().lookupClass()).a(40535455361773L);

    public DjangoWebUrlEvaluator(MessageBus messageBus) {
        messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){
            private static final long a = com.jetbrains.python.psi.c.a(4086766759479714861L, -1528625236863319653L, MethodHandles.lookup().lookupClass()).a(44094088297754L);

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.a(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!DjangoWebUrlEvaluator.this.b.contains(vFileEvent.getFile())) continue;
                    DjangoWebUrlEvaluator.this.a();
                    break;
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x5587935EA984L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/django/lang/template/DjangoWebUrlEvaluator$1", "after"));
            }
        });
    }

    private void a() {
        this.a.clear();
        this.b.clear();
    }

    public static DjangoWebUrlEvaluator getInstance(Project project) {
        return (DjangoWebUrlEvaluator)ServiceManager.getService((Project)project, DjangoWebUrlEvaluator.class);
    }

    private List<NavigatablePsiElement> a(PsiElement psiElement) {
        NavigatablePsiElement navigatablePsiElement;
        ArrayList arrayList = Lists.newArrayList();
        if (psiElement instanceof PsiFile && (navigatablePsiElement = this.a((PsiFile)psiElement)) != null) {
            arrayList.add(navigatablePsiElement);
        }
        if (!arrayList.isEmpty()) {
            while (!DjangoWebUrlEvaluator.b(DjangoPsiUtil.getFile((PsiElement)arrayList.get(arrayList.size() - 1))) && (navigatablePsiElement = this.a((PsiNamedElement)DjangoPsiUtil.getFile((PsiElement)arrayList.get(arrayList.size() - 1)))) != null) {
                arrayList.add(navigatablePsiElement);
            }
        }
        return arrayList;
    }

    private static boolean b(@NotNull PsiFile psiFile) {
        Module module2;
        if (psiFile == null) {
            DjangoWebUrlEvaluator.a(0);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile)) == null) {
            return true;
        }
        String string = DjangoSettingsPy.getRootUrlconf(module2);
        if (string != null) {
            PsiFile psiFile2 = DjangoPsiUtil.findFileInRoots(string, (PsiElement)psiFile);
            return psiFile2 != null && DjangoWebUrlEvaluator.a(psiFile, psiFile2);
        }
        return true;
    }

    private static boolean a(PsiFile psiFile, PsiFile psiFile2) {
        if (psiFile != null && psiFile2 != null && psiFile.getVirtualFile() != null && psiFile2.getVirtualFile() != null) {
            return psiFile2.getVirtualFile().getPath().equals(psiFile.getVirtualFile().getPath());
        }
        return false;
    }

    @Nullable
    public String getRelativePath(PsiElement element) {
        if (!DjangoFacet.isPresent(ModuleUtilCore.findModuleForPsiElement((PsiElement)element))) {
            return null;
        }
        SofterReference<String> softerReference = this.a.get(element);
        if (softerReference != null && softerReference.get() != null) {
            return (String)softerReference.get();
        }
        List<NavigatablePsiElement> list2 = this.a(element);
        if (list2 == null || list2.size() == 0) {
            return null;
        }
        String string = DjangoWebUrlEvaluator.a(0, list2);
        if (string == null) {
            return null;
        }
        this.a.put(element, (SofterReference<String>)new SofterReference((Object)string));
        return string;
    }

    @Nullable
    private static String a(int n2, @NotNull List<NavigatablePsiElement> list2) {
        if (list2 == null) {
            DjangoWebUrlEvaluator.a(1);
        }
        if (n2 < list2.size()) {
            String string = DjangoWebUrlEvaluator.a(DjangoWebUrlEvaluator.a(list2.get(n2)));
            String string2 = DjangoWebUrlEvaluator.a(n2 + 1, list2);
            if (string != null && string2 != null) {
                return string2 + string;
            }
            return null;
        }
        return "";
    }

    @Nullable
    public String getDjangoUrlPath(PsiElement element, int port2) {
        return DjangoWebUrlEvaluator.getDjangoUrl(this.getRelativePath(element), port2);
    }

    @Nullable
    private NavigatablePsiElement a(PsiFile psiFile) {
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(psiFile.getProject(), psiFile);
        Set<NavigatablePsiElement> set = DjangoTemplateManager.getTemplateReferences(psiFile, null, typeEvalContext);
        for (NavigatablePsiElement navigatablePsiElement : set) {
            NavigatablePsiElement navigatablePsiElement2 = this.b(navigatablePsiElement);
            if (navigatablePsiElement2 == null) continue;
            this.b.add(navigatablePsiElement.getContainingFile().getVirtualFile());
            return navigatablePsiElement2;
        }
        return null;
    }

    @Nullable
    private NavigatablePsiElement b(NavigatablePsiElement navigatablePsiElement) {
        PyClass pyClass;
        Object object;
        long l2 = c ^ 0x41D55353141FL;
        if (navigatablePsiElement.getContainingFile() != null && "urls.py".equals(object = navigatablePsiElement.getContainingFile().getName())) {
            PyCallExpression pyCallExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)navigatablePsiElement, PyCallExpression.class);
            if (pyCallExpression != null && pyCallExpression.getCallee() != null && !pyCallExpression.isCallee(DjangoFQNamesProvider.URL_PATTERNS_FUNCTION, DjangoFQNamesProvider.URL_OR_RE_PATH_FUNCTION)) {
                return pyCallExpression;
            }
            return navigatablePsiElement;
        }
        object = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)navigatablePsiElement, PyFunction.class);
        if (object != null) {
            return this.a((PsiNamedElement)object);
        }
        if (TemplateParametersEvaluator.isTemplateNameInViewClass(navigatablePsiElement) && (pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)navigatablePsiElement, PyClass.class)) != null) {
            return this.a((PsiNamedElement)pyClass);
        }
        return null;
    }

    @Nullable
    private PyExpression a(PsiNamedElement psiNamedElement) {
        HashSet hashSet = Sets.newHashSet();
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiNamedElement);
        if (module2 == null) {
            return null;
        }
        DjangoModelApi djangoModelApi = DjangoModelApi.create(module2);
        if (djangoModelApi == null) {
            return null;
        }
        djangoModelApi.collectAllUrlsFromCache(hashSet);
        Ref ref = Ref.create();
        ReferencesSearch.search((PsiElement)psiNamedElement, (SearchScope)GlobalSearchScope.filesScope((Project)psiNamedElement.getProject(), (Collection)Collections2.transform((Collection)hashSet, pyFile -> pyFile != null ? pyFile.getVirtualFile() : null))).forEach(psiReference -> {
            PsiElement psiElement;
            PsiElement psiElement2;
            if (psiReference != null && PsiTreeUtil.getParentOfType((PsiElement)(psiElement2 = psiReference.resolve()), PyImportStatementBase.class) == null && (psiElement = psiReference.getElement()) instanceof PyExpression) {
                this.b.add(psiElement.getContainingFile().getVirtualFile());
                ref.set((Object)((PyExpression)psiElement));
                return true;
            }
            return false;
        });
        return (PyExpression)ref.get();
    }

    @Nullable
    private static PyExpression a(NavigatablePsiElement navigatablePsiElement) {
        PyCallExpression pyCallExpression = DjangoPsiUtil.getUrlCall((PsiElement)navigatablePsiElement, TypeEvalContext.userInitiated(navigatablePsiElement.getProject(), navigatablePsiElement.getContainingFile()));
        if (pyCallExpression != null) {
            return pyCallExpression.getArguments()[0];
        }
        PyTupleExpression pyTupleExpression = DjangoPsiUtil.getTuple((PsiElement)navigatablePsiElement);
        if (pyTupleExpression != null) {
            return pyTupleExpression.getElements()[0];
        }
        return null;
    }

    @Nullable
    private static String a(@Nullable PyExpression pyExpression) {
        String string = PyStringLiteralUtil.getStringValue((PsiElement)pyExpression);
        if (string != null) {
            string = string.replace("$", "").replace("^", "");
            string = StringUtil.trimStart((String)string, (String)"/");
        }
        return string;
    }

    @Nullable
    static String getDjangoUrl(@Nullable String path, int port2) {
        long l2 = c ^ 0x3017AB553997L;
        if (path == null) {
            return null;
        }
        return "http://localhost:" + port2 + "/" + path;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x31E81A9ACD50L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/lang/template/DjangoWebUrlEvaluator";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRootConf";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

