/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.parsing.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTagParser;
import com.jetbrains.django.lang.template.parsing.parser.Parsing;
import com.jetbrains.django.lang.template.parsing.parser.TagParserRegistry;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;

public class DjangoTemplateParsing
extends Parsing
implements DjangoTemplateTokenTypes {
    private final TagParserRegistry a;
    private static final long e = c.a(4067745675168324153L, 4512196337128947501L, MethodHandles.lookup().lookupClass()).a(46683570849339L);

    public DjangoTemplateParsing(PsiBuilder builder, TagParserRegistry tagParserRegistry) {
        super(builder);
        this.a = tagParserRegistry;
    }

    public void parse() {
        PsiBuilder.Marker marker = this.mark();
        while (!this.eof()) {
            this.parseInjection();
        }
        marker.done(XmlElementType.HTML_DOCUMENT);
    }

    public void parseInjection() {
        long l2 = e ^ 0x315A436A8818L;
        if (this.isTagInjectionStart()) {
            this.g();
        } else if (this.isExpressionInjectionStart()) {
            this.c();
        } else if (this.f()) {
            this.consumeErrorToken("{{ or {% expected");
        } else if (this.hasTokenType(TokenType.BAD_CHARACTER, new IElementType[0])) {
            this.errorToken("Unexpected symbols");
        } else {
            this.advance();
        }
    }

    private void g() {
        long l2 = e ^ 0x518725838C58L;
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.b();
        if (!this.isTagInjectionEnd()) {
            this.error("Expected %}");
        }
        while (!this.tagEnded()) {
            this.advance();
        }
        if (this.isTagInjectionEnd()) {
            this.advance();
        }
        marker.done(DjangoTemplateElementTypes.XML_TAG);
    }

    private void c() {
        long l2 = e ^ 0x60AD22835CDAL;
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseMemberLiteral();
        if (this.isExpressionInjectionEnd()) {
            this.advance();
        } else {
            this.error("Expected }}");
        }
        marker.done(DjangoTemplateElementTypes.XML_TAG);
    }

    private void b() {
        DjangoTagParser<DjangoTemplateParsing> djangoTagParser;
        long l2 = e ^ 0x4108D8A44B02L;
        PsiBuilder.Marker marker = this.mark();
        if (!this.hasTokenType(DJANGO_TAG_NAME, new IElementType[0])) {
            marker.drop();
            this.error("Tag name expected");
            return;
        }
        String string = this.myPsiBuilder.getTokenText();
        this.createTokenElement(DjangoTemplateElementTypes.TAG_NAME);
        if (this.myPsiBuilder.getTokenType() == WHITESPACE_ERROR) {
            this.myPsiBuilder.error("Whitespace expected before a string");
        }
        if ((djangoTagParser = this.a.find(string)) != null) {
            djangoTagParser.parse(this.myPsiBuilder, marker, this);
            return;
        }
        marker.drop();
        if (this.isTagInjectionEnd()) {
            return;
        }
        while (this.hasTokenType(COMMA, new IElementType[0]) || this.hasTokenType(AS, new IElementType[0]) || this.hasTokenType(AND, new IElementType[0]) || this.hasTokenType(ASSIGN, new IElementType[0]) || this.isExpressionStart()) {
            if (this.hasTokenType(AND, new IElementType[0])) {
                this.advance();
            }
            if (this.hasTokenType(ASSIGN, new IElementType[0])) {
                this.advance();
                this.parseAssignmentValue();
                continue;
            }
            if (this.hasTokenType(AS, new IElementType[0])) {
                PsiBuilder.Marker marker2 = this.myPsiBuilder.mark();
                this.advance();
                if (this.isStringLiteral() || this.isId()) {
                    this.parseNamedExpr();
                    marker2.done(DjangoTemplateElementTypes.AS_ID);
                    continue;
                }
                this.error("Id or literal expected");
                marker2.drop();
                continue;
            }
            if (this.hasTokenType(COMMA, new IElementType[0])) {
                this.advance();
            }
            if (this.parseMemberLiteral()) continue;
        }
        if (this.hasTokenType(NOT, new IElementType[0])) {
            this.createTokenElement(DjangoTemplateElementTypes.NOT);
        }
        if (this.hasTokenType(IN, new IElementType[0])) {
            this.createTokenElement(DjangoTemplateElementTypes.IN);
            if (!this.parseMemberExpr()) {
                // empty if block
            }
        }
        while (!this.tagEnded()) {
            this.advance();
        }
    }

    public boolean parseAssignmentValue() {
        long l2 = e ^ 0x2D66DEDDA328L;
        if (!this.parseExpression()) {
            this.error("Value expected");
            return false;
        }
        return true;
    }

    public boolean parseNamedExpr() {
        if (this.isId()) {
            this.createTokenElement(DjangoTemplateElementTypes.NAMED_EXPR);
            return true;
        }
        return false;
    }

    public boolean parseLogical() {
        long l2 = e ^ 0x1E42BD1DDF6EL;
        PsiBuilder.Marker marker = this.mark();
        if (!this.e()) {
            marker.drop();
            return false;
        }
        while (this.hasTokenType(AND, new IElementType[]{OR})) {
            this.advance();
            if (!this.e()) {
                this.error("Expression expected");
            }
            marker.done(DjangoTemplateElementTypes.LOGICAL);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean e() {
        long l2 = e ^ 0x37B7A24B7B5DL;
        if (!this.isExpressionStart()) {
            this.error("Expression expected");
            return false;
        }
        if (this.hasTokenType(NOT, new IElementType[0])) {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            boolean bl2 = this.isExpressionStart() ? this.parseLogical() : this.parseMemberLiteral();
            marker.done(DjangoTemplateElementTypes.NOT);
            return bl2;
        }
        return this.parseFactor();
    }

    protected boolean parseFactor() {
        return this.parseMemberLiteral();
    }

    public boolean parseMemberLiteral() {
        return this.parseMemberLiteral(true);
    }

    public boolean parseMemberLiteral(boolean raiseError) {
        long l2 = e ^ 0x180A211C9E96L;
        if (!this.isAtExpression()) {
            if (raiseError) {
                this.error("ID or literal expected");
            }
            return false;
        }
        PsiBuilder.Marker marker = this.mark();
        this.parseExpression();
        if (this.parseFilters()) {
            marker.done(DjangoTemplateElementTypes.FILTERS);
        } else {
            marker.drop();
        }
        return true;
    }

    protected boolean parseExpression() {
        long l2 = e ^ 0x4E73C8BDF67AL;
        if (!this.parseIdOrLiteral()) {
            return false;
        }
        if (this.hasTokenType(IN, new IElementType[0])) {
            this.advance();
            if (!this.parseIdOrLiteral()) {
                this.error("Expression expected after 'in'");
                return false;
            }
        }
        return true;
    }

    protected boolean isAtExpression() {
        return this.isId() || this.isLiteral();
    }

    public boolean parseId() {
        if (this.isId()) {
            this.parseMemberExpr();
            return true;
        }
        return false;
    }

    public boolean parseIdOrLiteral() {
        if (this.isId()) {
            this.parseMemberExpr();
            return true;
        }
        if (this.isLiteral()) {
            this.parseLiteral();
            return true;
        }
        return false;
    }

    public boolean parseMemberExpr() {
        return this.parseMemberExpr(DjangoTemplateElementTypes.VAR);
    }

    public boolean parseMemberExpr(IElementType elementType) {
        return this.parseMemberExpr(elementType, false);
    }

    public boolean parseMemberExpr(IElementType elementType, boolean wrapByMemberAnyway) {
        long l2 = e ^ 0x39EB8931E88AL;
        if (!this.isId()) {
            this.error("ID expected");
            return false;
        }
        PsiBuilder.Marker marker = this.mark();
        PsiBuilder.Marker marker2 = this.mark();
        this.createTokenElement(elementType);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while (this.hasTokenType(DOT, new IElementType[0]) || this.hasTokenType(INT_LITERAL, new IElementType[0]) || bl3) {
            if (this.hasTokenType(DOT, new IElementType[0])) {
                this.advance();
                bl4 = true;
            }
            if (bl4 && this.isId()) {
                if (!this.a()) {
                    this.myPsiBuilder.error("Wrong identifier");
                }
                this.createTokenElement(DjangoTemplateElementTypes.MEMBER_NAME);
                marker2.done(DjangoTemplateElementTypes.MEMBER);
                bl2 = true;
                marker2 = marker2.precede();
                bl3 = false;
                bl4 = false;
                continue;
            }
            if (bl4 && this.hasTokenType(INT_LITERAL, new IElementType[0])) {
                String string = this.myPsiBuilder.getTokenText();
                bl4 = string != null && string.endsWith(".");
                this.createTokenElement(DjangoTemplateElementTypes.NUMBER);
                marker2.done(DjangoTemplateElementTypes.MEMBER);
                bl2 = true;
                marker2 = marker2.precede();
                bl3 = true;
                continue;
            }
            if (this.hasTokenType(INT_LITERAL, new IElementType[0]) && this.myPsiBuilder.getTokenText().startsWith(".")) {
                this.createTokenElement(DjangoTemplateElementTypes.NUMBER);
                continue;
            }
            if (!bl4) break;
            this.error("ID or int literal expected");
            break;
        }
        if (wrapByMemberAnyway && !bl2) {
            marker2.done(DjangoTemplateElementTypes.MEMBER);
        } else {
            marker2.drop();
        }
        if (this.parseFilters()) {
            marker.done(DjangoTemplateElementTypes.FILTERS);
        } else {
            marker.drop();
        }
        return true;
    }

    private boolean a() {
        String string = this.myPsiBuilder.getTokenText();
        if (string == null) {
            return false;
        }
        return PyNames.isIdentifierString(string);
    }

    public boolean parseFilters() {
        boolean bl2 = false;
        while (this.hasTokenType(FILTER, new IElementType[0])) {
            this.d();
            bl2 = true;
        }
        return bl2;
    }

    private void d() {
        if (!this.hasTokenType(FILTER, new IElementType[0])) {
            return;
        }
        this.advance();
        this.parseFilterExpression();
    }

    public boolean parseFilterExpression() {
        long l2 = e ^ 0x34AD184B8BEFL;
        PsiBuilder.Marker marker = this.mark();
        if (!this.isId()) {
            this.error("Filter name expected");
            marker.drop();
            return false;
        }
        this.createTokenElement(DjangoTemplateElementTypes.FILTER_NAME);
        if (!this.parseFilterArguments()) {
            marker.drop();
            return false;
        }
        marker.done(DjangoTemplateElementTypes.FILTER);
        return true;
    }

    public boolean parseFilterArguments() {
        long l2 = e ^ 0x763E0093EAC9L;
        if (this.hasTokenType(COLON, new IElementType[0])) {
            this.advance();
            if (this.isLiteral() || this.isId()) {
                this.parseIdOrLiteral();
            } else {
                this.error("Expected filter argument");
                return false;
            }
        }
        return true;
    }

    public boolean parseStringLiteral() {
        long l2 = e ^ 0x54ABED2DF2A1L;
        if (this.isStringLiteral()) {
            this.createTokenElement(DjangoTemplateElementTypes.STRING);
            if (this.myPsiBuilder.getTokenType() == WHITESPACE_ERROR) {
                this.myPsiBuilder.error("Whitespace expected");
                this.advance();
            }
            return true;
        }
        return false;
    }

    public void parseLiteral() {
        if (this.isStringLiteral()) {
            this.parseStringLiteral();
        } else if (this.hasTokenType(INT_LITERAL, new IElementType[0])) {
            this.createTokenElement(DjangoTemplateElementTypes.NUMBER);
        }
    }

    public boolean parseComma() {
        if (",".equals(this.myPsiBuilder.getTokenText())) {
            PsiBuilder.Marker marker = this.myPsiBuilder.mark();
            this.myPsiBuilder.advanceLexer();
            marker.done(COMMA);
            return true;
        }
        return false;
    }

    public boolean parseAsExpression(boolean isMandatory) {
        long l2 = e ^ 0x273949ED50FCL;
        if (this.myPsiBuilder.getTokenType() != AS) {
            if (isMandatory) {
                this.myPsiBuilder.error("'as' keyword expected");
            }
            return false;
        }
        PsiBuilder.Marker marker = this.myPsiBuilder.mark();
        this.myPsiBuilder.advanceLexer();
        if (!this.parseNamedExpr()) {
            this.myPsiBuilder.error("Name expected");
            marker.drop();
            return false;
        }
        marker.done(DjangoTemplateElementTypes.AS_ID);
        return true;
    }

    public boolean isExpressionStart() {
        return this.hasTokenType(ID, new IElementType[]{NOT}) || this.isLiteral();
    }

    public boolean isLiteral() {
        return this.isStringLiteral() || this.hasTokenType(INT_LITERAL, new IElementType[0]);
    }

    public boolean isIdOrLiteral() {
        return this.isLiteral() || this.isId();
    }

    public boolean isId() {
        return this.hasTokenType(ID, new IElementType[0]);
    }

    public boolean isStringLiteral() {
        return this.hasTokenType(DOUBLE_QUOTED_STRING_LITERAL, new IElementType[]{SINGLE_QUOTED_STRING_LITERAL, I18N_STRING_LITERAL});
    }

    private boolean f() {
        return this.hasTokenType(DJANGO_EXPRESSION_END, new IElementType[]{DJANGO_TAG_END});
    }

    protected boolean isTagInjectionStart() {
        return this.hasTokenType(DJANGO_TAG_START, new IElementType[0]);
    }

    protected boolean isTagInjectionEnd() {
        return this.hasTokenType(DJANGO_TAG_END, new IElementType[0]);
    }

    protected boolean isExpressionInjectionStart() {
        return this.hasTokenType(DJANGO_EXPRESSION_START, new IElementType[0]);
    }

    protected boolean isExpressionInjectionEnd() {
        return this.hasTokenType(DJANGO_EXPRESSION_END, new IElementType[0]);
    }

    public void parseNameList() {
        long l2 = e ^ 0x2874675E6615L;
        while (true) {
            if (!this.hasTokenType(ID, new IElementType[0])) {
                this.error("Identifier expected");
            } else {
                PsiBuilder.Marker marker = this.mark();
                this.advance();
                marker.done(DjangoTemplateElementTypes.NAMED_EXPR);
            }
            if (this.tagEnded() || !this.hasTokenType(COMMA, new IElementType[0])) break;
            this.advance();
        }
    }

    public boolean tagEnded() {
        return this.myPsiBuilder.getTokenType() == null || this.isTagInjectionEnd() || this.isTagInjectionStart() || this.isExpressionInjectionStart() || this.h();
    }

    private boolean h() {
        return this.hasTokenType(DJANGO_LINE_END_INSIDE_TAG, new IElementType[0]);
    }
}

