/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.lang.template.psi.DjangoTagName;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.model.DjangoClosingTagTools;
import com.jetbrains.django.model.DjangoTagLibrary;
import com.jetbrains.django.model.TemplateLanguageTagLibraries;
import com.jetbrains.django.model.TemplateLanguageTagLibrary;
import com.jetbrains.django.util.DjangoTemplateUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagLibrary {
    private final Map<PyFile, CustomTagCachedData> b = ContainerUtil.createConcurrentSoftMap();
    private static final Set<String> a;
    private static final long c;

    public static boolean isUnresolvedTag(@NotNull DjangoTagName tag) {
        if (tag == null) {
            TagLibrary.a(0);
        }
        return !DjangoClosingTagTools.isStartsWithEndPrefix(tag.getTagName()) && !TagLibrary.isUnresolvedCoreTag(tag.getTagName()) && (tag.getReference() == null || tag.getReference().resolve() == null);
    }

    public static TagLibrary getInstance(Project project) {
        return (TagLibrary)ServiceManager.getService((Project)project, TagLibrary.class);
    }

    public static boolean isUnresolvedCoreTag(String tagName) {
        return a.contains(tagName);
    }

    public static boolean isIf(@NotNull String name) {
        long l2 = c ^ 0x6BDEA201FE47L;
        if (name == null) {
            TagLibrary.a(1);
        }
        return "if".equals(name) || "ifequal".equals(name) || "ifnotequal".equals(name) || "ifchanged".equals(name);
    }

    public static boolean isEndIf(@NotNull String name) {
        String string;
        if (name == null) {
            TagLibrary.a(2);
        }
        if ((string = DjangoClosingTagTools.getOpeningByClosing(name)) == null) {
            return false;
        }
        return TagLibrary.isIf(string);
    }

    public boolean isContainerFor(@NotNull String tagName, @NotNull DjangoTagName container) {
        if (tagName == null) {
            TagLibrary.a(3);
        }
        if (container == null) {
            TagLibrary.a(4);
        }
        return this.isContainerFor(container, tagName, container.getTagName());
    }

    public boolean isContainerFor(@NotNull PsiElement tag, @NotNull String tagName, @NotNull String containerName) {
        TemplateLanguageTagLibrary templateLanguageTagLibrary;
        if (tag == null) {
            TagLibrary.a(5);
        }
        if (tagName == null) {
            TagLibrary.a(6);
        }
        if (containerName == null) {
            TagLibrary.a(7);
        }
        if ((templateLanguageTagLibrary = TagLibrary.getTagLibrary(tag)) == null) {
            return false;
        }
        String[] stringArray = templateLanguageTagLibrary.getInnerTags(containerName);
        for (String string : stringArray) {
            if (!tagName.equals(string)) continue;
            return true;
        }
        for (CustomTagCachedData customTagCachedData : Lists.newArrayList(this.b.values())) {
            Set set = (Set)customTagCachedData.a.get(containerName);
            if (set == null || !set.contains(tagName)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getCustomInnerTags(@NotNull String containerName) {
        if (containerName == null) {
            TagLibrary.a(8);
        }
        HashSet hashSet = Sets.newHashSet();
        for (CustomTagCachedData customTagCachedData : Lists.newArrayList(this.b.values())) {
            Set set = (Set)customTagCachedData.a.get(containerName);
            if (set == null) continue;
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public static boolean isEmpty(@NotNull String name) {
        long l2 = c ^ 0x744B17270017L;
        if (name == null) {
            TagLibrary.a(9);
        }
        return "empty".equals(name);
    }

    public static boolean isElse(@NotNull String name) {
        long l2 = c ^ 0x542FB4902700L;
        if (name == null) {
            TagLibrary.a(10);
        }
        return "else".equals(name);
    }

    public static boolean isElif(@NotNull String name) {
        long l2 = c ^ 0x1B1B629B8BE2L;
        if (name == null) {
            TagLibrary.a(11);
        }
        return "elif".equals(name);
    }

    public static boolean isMiddle(String name) {
        long l2 = c ^ 0x1727C8E10C34L;
        return TagLibrary.isElse(name) || TagLibrary.isEmpty(name) || "plural".equals(name) || TagLibrary.isElif(name);
    }

    public boolean isPair(@NotNull DjangoTagElementImpl startTag, @NotNull DjangoTagElementImpl endTag) {
        long l2 = c ^ 0x51C52605C444L;
        if (startTag == null) {
            TagLibrary.a(12);
        }
        if (endTag == null) {
            TagLibrary.a(13);
        }
        String string = DjangoTemplateUtil.getTagName(startTag);
        String string2 = DjangoTemplateUtil.getTagName(endTag);
        if (string == null || string2 == null) {
            return false;
        }
        return TagLibrary.isStartEndTags(string, string2) || TagLibrary.isElse(string2) && TagLibrary.isIf(string) || TagLibrary.isElse(string) && TagLibrary.isEndIf(string2) || this.isContainerFor((PsiElement)startTag, string2, string) || this.isContainerFor((PsiElement)startTag, string, string2.replaceFirst("^end", ""));
    }

    public static boolean isStartEndTags(@NotNull String startTagName, @NotNull String endTagName) {
        if (startTagName == null) {
            TagLibrary.a(14);
        }
        if (endTagName == null) {
            TagLibrary.a(15);
        }
        String string = DjangoClosingTagTools.getOpeningByClosing(endTagName);
        return startTagName.equals(string);
    }

    private static void a(List<? super LookupElement> list2, String string) {
        list2.add((LookupElement)LookupElementBuilder.create((String)DjangoClosingTagTools.suggestClosingTag(string)));
    }

    public static boolean startsWithEndPrefix(@NotNull DjangoTagName tagName) {
        if (tagName == null) {
            TagLibrary.a(16);
        }
        return TagLibrary.startsWithEndPrefix(tagName.getTagName());
    }

    public static boolean startsWithEndPrefix(String tagName) {
        return tagName != null && DjangoClosingTagTools.isStartsWithEndPrefix(tagName);
    }

    public static String withoutEnd(@NotNull String name) {
        String string;
        if (name == null) {
            TagLibrary.a(17);
        }
        if ((string = DjangoClosingTagTools.getOpeningByClosing(name)) != null) {
            return string;
        }
        return name;
    }

    public boolean requiresCloseTag(DjangoTagName tagName) {
        long l2 = c ^ 0x218EB1B11C8L;
        String string = tagName.getTagName();
        if (string.startsWith("if") || TagLibrary.a(tagName, string)) {
            return true;
        }
        for (CustomTagCachedData customTagCachedData : Lists.newArrayList(this.b.values())) {
            if (!customTagCachedData.b.contains(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean a(DjangoTagName djangoTagName, String string) {
        TemplateLanguageTagLibrary templateLanguageTagLibrary = TagLibrary.getTagLibrary(djangoTagName);
        return templateLanguageTagLibrary != null && templateLanguageTagLibrary.isBlockTag(string);
    }

    @Nullable
    public static TemplateLanguageTagLibrary getTagLibrary(@NotNull PsiElement element) {
        if (element == null) {
            TagLibrary.a(18);
        }
        return (TemplateLanguageTagLibrary)TemplateLanguageTagLibraries.INSTANCE.forLanguage(element.getContainingFile().getLanguage());
    }

    @NotNull
    public static LookupElement[] getFilterLookUpElements(@NotNull PsiFile template) {
        TemplateLanguageTagLibrary templateLanguageTagLibrary;
        if (template == null) {
            TagLibrary.a(19);
        }
        if ((templateLanguageTagLibrary = TagLibrary.getTagLibrary((PsiElement)template)) == null) {
            if (LookupElement.EMPTY_ARRAY == null) {
                TagLibrary.a(20);
            }
            return LookupElement.EMPTY_ARRAY;
        }
        LookupElement[] lookupElementArray = TagLibrary.createLookupElements(templateLanguageTagLibrary.collectLoadedFilters(template));
        if (lookupElementArray == null) {
            TagLibrary.a(21);
        }
        return lookupElementArray;
    }

    public void updateCustomTagsCache(PyFile file) {
        CustomTagCachedData customTagCachedData = this.b.get(file);
        if (customTagCachedData == null || customTagCachedData.c != file.getModificationStamp()) {
            customTagCachedData = TagLibrary.a(file);
            this.b.put(file, customTagCachedData);
        }
    }

    public static LookupElement[] createLookupElements(Collection<? extends Pair<String, PyFunction>> filters) {
        ArrayList arrayList = Lists.newArrayList();
        for (Pair<String, PyFunction> pair : filters) {
            arrayList.add(LookupElementBuilder.create((Object)pair.getSecond(), (String)((String)pair.getFirst())));
        }
        return arrayList.toArray(LookupElement.EMPTY_ARRAY);
    }

    private static CustomTagCachedData a(PyFile pyFile) {
        final CustomTagCachedData customTagCachedData = new CustomTagCachedData();
        customTagCachedData.c = pyFile.getModificationStamp();
        DjangoTagLibrary.processRegisteredTags(pyFile, new DjangoTagLibrary.TagProcessor(){

            @Override
            public void processTag(String name, PyElement declaration) {
                if (declaration instanceof PyFunction) {
                    if (TagLibrary.a(name, (PyFunction)declaration)) {
                        customTagCachedData.b.add(name);
                    }
                    customTagCachedData.a.put(name, TagLibrary.a((PyFunction)declaration));
                }
            }
        });
        return customTagCachedData;
    }

    private static Set<String> a(PyFunction pyFunction) {
        InnerTagsFinder innerTagsFinder = new InnerTagsFinder();
        pyFunction.acceptChildren(innerTagsFinder);
        return innerTagsFinder.a;
    }

    private static boolean a(String string, PyFunction pyFunction) {
        long l2 = c ^ 0x34C71B4FB717L;
        EndTagNameFinder endTagNameFinder = new EndTagNameFinder("end" + string);
        pyFunction.acceptChildren(endTagNameFinder);
        return endTagNameFinder.a;
    }

    public void addInnerCompletionVariants(@Nullable PsiElement element, final List<LookupElement> result) {
        this.processPrecedingOpenedTags(element, new OpenTagProcessor(){
            private static final long a = com.jetbrains.python.psi.c.a(1906718811355313893L, 1903648431978437527L, MethodHandles.lookup().lookupClass()).a(179976001163382L);

            @Override
            public boolean process(@NotNull DjangoTagName tag, boolean open2) {
                if (tag == null) {
                    2.a(0);
                }
                if (open2) {
                    TagLibrary.this.a(tag, result);
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2586C87251A2L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/jetbrains/django/model/TagLibrary$2", "process"));
            }
        });
    }

    public boolean processTagIfNotClosed(PsiElement tagElement, Stack<DjangoTagName> closeTags, OpenTagProcessor processor2) {
        PsiElement[] psiElementArray;
        for (PsiElement psiElement : psiElementArray = PsiTreeUtil.collectElements((PsiElement)tagElement, (PsiElementFilter)new PsiElementFilter(){
            private static final long a = com.jetbrains.python.psi.c.a(7807332265874511718L, -1573804027952882816L, MethodHandles.lookup().lookupClass()).a(232214575234473L);

            public boolean isAccepted(@NotNull PsiElement element) {
                if (element == null) {
                    3.a(0);
                }
                return element instanceof DjangoTagName;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x1098E963BF40L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/django/model/TagLibrary$3", "isAccepted"));
            }
        })) {
            DjangoTagName djangoTagName = (DjangoTagName)psiElement;
            if (djangoTagName == null) continue;
            if (TagLibrary.startsWithEndPrefix(djangoTagName.getTagName())) {
                closeTags.push(djangoTagName);
                continue;
            }
            if (this.requiresCloseTag(djangoTagName)) {
                DjangoTagName djangoTagName2 = null;
                if (!closeTags.isEmpty()) {
                    djangoTagName2 = closeTags.peek();
                }
                if (djangoTagName2 == null) {
                    if (processor2.process(djangoTagName, true)) continue;
                    return false;
                }
                String string = DjangoClosingTagTools.getOpeningByClosingIfPossible(djangoTagName2.getTagName());
                if (!djangoTagName.getTagName().equals(string)) {
                    if (processor2.process(djangoTagName, true)) continue;
                    return false;
                }
                closeTags.pop();
                if (processor2.process(djangoTagName, false)) continue;
                return false;
            }
            if (processor2.process(djangoTagName, true)) continue;
            return false;
        }
        return true;
    }

    public void processPrecedingOpenedTags(PsiElement element, OpenTagProcessor processor2) {
        DjangoTagElementImpl djangoTagElementImpl = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoTagElementImpl.class);
        Stack<DjangoTagName> stack = new Stack<DjangoTagName>();
        while (((djangoTagElementImpl = (DjangoTagElementImpl)PsiTreeUtil.getPrevSiblingOfType((PsiElement)djangoTagElementImpl, DjangoTagElementImpl.class)) == null || this.processTagIfNotClosed((PsiElement)djangoTagElementImpl, stack, processor2)) && djangoTagElementImpl != null) {
        }
    }

    private void a(DjangoTagName djangoTagName, List<LookupElement> list2) {
        Iterator iterator;
        String string = djangoTagName.getTagName();
        TemplateLanguageTagLibrary templateLanguageTagLibrary = TagLibrary.getTagLibrary(djangoTagName);
        if (templateLanguageTagLibrary != null) {
            for (Object object : iterator = templateLanguageTagLibrary.getInnerTags(string)) {
                list2.add((LookupElement)LookupElementBuilder.create((String)object));
            }
            if (this.requiresCloseTag(djangoTagName)) {
                TagLibrary.a(list2, string);
            }
        }
        iterator = this.getCustomInnerTags(string);
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            list2.add((LookupElement)LookupElementBuilder.create((String)string2));
        }
    }

    public static boolean isCloseTagFor(@NotNull DjangoTagName close2, @NotNull DjangoTagName open2) {
        if (close2 == null) {
            TagLibrary.a(22);
        }
        if (open2 == null) {
            TagLibrary.a(23);
        }
        return TagLibrary.isCloseTagFor(close2.getTagName(), open2.getTagName());
    }

    public static boolean isCloseTagFor(@Nullable String closeTag, @Nullable String openTag) {
        if (openTag != null && closeTag != null) {
            return TagLibrary.isStartEndTags(openTag, closeTag);
        }
        return false;
    }

    public static boolean isDefaultTag(DjangoTagName tagName) {
        Language language = tagName.getContainingFile().getLanguage();
        String string = tagName.getTagName();
        return TagLibrary.isDefaultTag(language, string);
    }

    public static boolean isDefaultTag(Language language, String name) {
        TemplateLanguageTagLibrary templateLanguageTagLibrary;
        String string = DjangoClosingTagTools.getOpeningByClosingIfPossible(name);
        if (string != null) {
            name = string;
        }
        return (templateLanguageTagLibrary = (TemplateLanguageTagLibrary)TemplateLanguageTagLibraries.INSTANCE.forLanguage(language)).isBlockTag(name) || templateLanguageTagLibrary.getCoreTags().contains(name);
    }

    static {
        c = com.jetbrains.python.psi.c.a(-7896156766129495478L, 1533589417456595034L, MethodHandles.lookup().lookupClass()).a(124410458359573L);
        long l2 = c ^ 0x1CB72E8ADD9EL;
        a = Sets.newHashSet((Object[])new String[]{"extends", "include", "block", "empty", "else", "plural", "elif"});
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x634DE0873501L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 20: 
            case 21: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startTag";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endTag";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startTagName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endTagName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/TagLibrary";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "close";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "open";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/TagLibrary";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterLookUpElements";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolvedTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isIf";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEndIf";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isContainerFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCustomInnerTags";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isElse";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isElif";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPair";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStartEndTags";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "startsWithEndPrefix";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "withoutEnd";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTagLibrary";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFilterLookUpElements";
                break;
            }
            case 20: 
            case 21: {
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isCloseTagFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface OpenTagProcessor {
        public boolean process(@NotNull DjangoTagName var1, boolean var2);
    }

    private static class EndTagNameFinder
    extends PyRecursiveElementVisitor {
        private final String b;
        private boolean a;

        EndTagNameFinder(String name) {
            this.b = name;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.a) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            if (this.b.equals(node.getStringValue())) {
                this.a = true;
            }
        }
    }

    private static class InnerTagsFinder
    extends PyRecursiveElementVisitor {
        private final Set<String> a = Sets.newHashSet();
        private static final long b = com.jetbrains.python.psi.c.a(-1040008080085761269L, 3551888970018306519L, MethodHandles.lookup().lookupClass()).a(892000215796L);

        private InnerTagsFinder() {
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            if (InnerTagsFinder.a(node)) {
                this.a.add(node.getStringValue());
            }
        }

        private static boolean a(PyStringLiteralExpression pyStringLiteralExpression) {
            long l2 = b ^ 0x7496174E68B7L;
            PyCallExpression pyCallExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)pyStringLiteralExpression, PyCallExpression.class);
            return pyCallExpression != null && pyCallExpression.getCallee() != null && "parse".equals(pyCallExpression.getCallee().getName());
        }
    }

    private static class CustomTagCachedData {
        private long c;
        private final Set<String> b = Sets.newHashSet();
        private final Map<String, Set<String>> a = Maps.newHashMap();

        private CustomTagCachedData() {
        }
    }
}

