/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.facet.DjangoFacetType;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.testRunner.DjangoTestsRunConfiguration;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.PythonUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.buildout.BuildoutFacetConfiguration;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.io.FileFilter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoUtil {
    private static final Set<String> a;
    private static final FileType[] b;
    private static final long c;

    private DjangoUtil() {
    }

    @NotNull
    public static PyRequirement createRequirementAtLeast(int major, int minor) {
        long l2 = c ^ 0x700C792FA6FFL;
        PyRequirement pyRequirement = PyRequirementsKt.pyRequirement("Django", PyRequirementRelation.GTE, String.format("%s.%s", major, minor));
        if (pyRequirement == null) {
            DjangoUtil.a(0);
        }
        return pyRequirement;
    }

    private static boolean a(@Nullable PsiFileSystemItem psiFileSystemItem) {
        long l2 = c ^ 0x3E644FC2FA95L;
        return psiFileSystemItem instanceof PsiDirectory && ((PsiDirectory)psiFileSystemItem).findFile("manage.py") != null;
    }

    @Nullable
    public static PsiDirectory getProjectRoot(@NotNull PsiFileSystemItem folder) {
        PsiFileSystemItem psiFileSystemItem;
        if (folder == null) {
            DjangoUtil.a(1);
        }
        for (psiFileSystemItem = folder; psiFileSystemItem != null && !DjangoUtil.a(psiFileSystemItem); psiFileSystemItem = psiFileSystemItem.getParent()) {
        }
        return (PsiDirectory)psiFileSystemItem;
    }

    @Nullable
    public static Module getDjangoModule(@NotNull Project project) {
        if (project == null) {
            DjangoUtil.a(2);
        }
        return (Module)ContainerUtil.getFirstItem((List)ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(DjangoFacetType.ID));
    }

    @Nullable
    public static String getProjectRoot(@NotNull Module module2) {
        DjangoFacet djangoFacet;
        if (module2 == null) {
            DjangoUtil.a(3);
        }
        if ((djangoFacet = DjangoFacet.getInstance(module2)) != null) {
            DjangoUtil.a(djangoFacet);
            return ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootPath();
        }
        return null;
    }

    private static void a(@NotNull DjangoFacet djangoFacet) {
        long l2 = c ^ 0x7F17348E4EE8L;
        if (djangoFacet == null) {
            DjangoUtil.a(4);
        }
        if (!StringUtil.isNotEmpty((String)((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getManageFilePath()) || ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile() == null || "manage.py".equals(((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getManageFilePath())) {
            // empty if block
        }
    }

    @Nullable
    public static String findRoot(Module module2) {
        for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            ManageFileFinder manageFileFinder = new ManageFileFinder();
            VfsUtilCore.processFilesRecursively((VirtualFile)virtualFile, (Processor)manageFileFinder);
            VirtualFile virtualFile2 = manageFileFinder.a;
            if (virtualFile2 == null) continue;
            return virtualFile2.getParent().getPresentableUrl();
        }
        return null;
    }

    @Nullable
    public static PsiFileSystemItem searchFileOrFolder(String path, PsiElement contextElement) {
        PsiFile psiFile = DjangoUtil.searchFile(path, contextElement);
        if (psiFile == null) {
            psiFile = DjangoUtil.searchFolder(path, contextElement);
        }
        return psiFile;
    }

    @Nullable
    public static PsiFile searchFile(String path, PsiElement contextElement) {
        PsiFile psiFile = DjangoUtil.searchProjectFile(path, contextElement);
        if (psiFile == null) {
            psiFile = DjangoUtil.getLibraryFile(path, contextElement);
        }
        return psiFile;
    }

    @Nullable
    public static PsiDirectory searchFolder(@NotNull String path, @NotNull PsiElement contextElement) {
        PsiDirectory psiDirectory;
        if (path == null) {
            DjangoUtil.a(5);
        }
        if (contextElement == null) {
            DjangoUtil.a(6);
        }
        if ((psiDirectory = DjangoUtil.searchProjectFolder(path, contextElement, null)) == null) {
            psiDirectory = DjangoUtil.getLibraryFolder(path, contextElement);
        }
        return psiDirectory;
    }

    @Nullable
    public static PsiFile searchProjectFile(String path, @NotNull PsiElement contextElement) {
        PsiFile psiFile;
        String string;
        if (contextElement == null) {
            DjangoUtil.a(7);
        }
        PsiDirectory psiDirectory = DjangoUtil.getProjectRoot(contextElement);
        String string2 = PythonStringUtil.getFirstPrefix(path, ".");
        if (string2.equals(string = DjangoUtil.getProjectName(contextElement)) ? (psiFile = DjangoUtil.searchInProject(psiDirectory, PythonStringUtil.removeFirstPrefix(path, "."))) != null : (psiFile = DjangoUtil.searchInProject(psiDirectory, path)) != null) {
            return psiFile;
        }
        psiFile = DjangoPsiUtil.findFileInRoots(path, contextElement);
        return psiFile;
    }

    @Nullable
    public static PsiDirectory searchProjectFolder(@NotNull String path, @NotNull PsiElement contextElement, @Nullable Module withModule) {
        String string;
        String string2;
        String string3;
        PsiDirectory psiDirectory;
        PsiDirectory psiDirectory2;
        if (path == null) {
            DjangoUtil.a(8);
        }
        if (contextElement == null) {
            DjangoUtil.a(9);
        }
        if ((psiDirectory2 = DjangoPsiUtil.findFolder(psiDirectory = DjangoUtil.getProjectRoot(contextElement), string3 = (string2 = PythonStringUtil.getFirstPrefix(path, ".")).equals(string = DjangoUtil.getProjectName(contextElement)) ? PythonUtil.toFolderPath(PythonStringUtil.removeFirstPrefix(path, ".")) : PythonUtil.toFolderPath(path))) != null) {
            return psiDirectory2;
        }
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)path);
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement) == null && withModule != null ? PyResolveImportUtil.fromModule(withModule) : PyResolveImportUtil.fromFoothold(contextElement);
        return StreamEx.of(PyResolveImportUtil.resolveQualifiedName(qualifiedName, pyQualifiedNameResolveContext)).select(PsiDirectory.class).findFirst().orElse(null);
    }

    @Nullable
    public static PsiFile searchInProject(PsiDirectory djangoRoot, String appPath) {
        String string = PythonUtil.toFilePath(appPath);
        return DjangoPsiUtil.findChild(djangoRoot, string);
    }

    @Nullable
    public static PsiFile getLibraryFile(String path, PsiElement contextElement) {
        VirtualFile virtualFile = PythonUtil.findLibraryFile(PythonUtil.toFilePath(path), PythonSdkType.findPythonSdk(contextElement));
        return virtualFile != null && virtualFile.isValid() ? contextElement.getManager().findFile(virtualFile) : null;
    }

    @Nullable
    public static PsiDirectory getLibraryFolder(String path, PsiElement contextElement) {
        VirtualFile virtualFile = PythonUtil.findLibraryFile(PythonUtil.toFolderPath(path), PythonSdkType.findPythonSdk(contextElement));
        return virtualFile != null ? contextElement.getManager().findDirectory(virtualFile) : null;
    }

    @Nullable
    public static String getBuildoutRunnerScript(Module module2) {
        String string;
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        VirtualFile virtualFile3;
        BuildoutFacetConfiguration buildoutFacetConfiguration;
        String string2;
        BuildoutFacet buildoutFacet;
        long l2 = c ^ 0x5CF54253DBF0L;
        if (module2 != null && (buildoutFacet = BuildoutFacet.getInstance(module2)) != null && (string2 = (buildoutFacetConfiguration = (BuildoutFacetConfiguration)buildoutFacet.getConfiguration()).getScriptName()) != null && (virtualFile3 = LocalFileSystem.getInstance().findFileByPath(string2)) != null && (virtualFile2 = virtualFile3.getParent()) != null && "bin".equals(virtualFile2.getName()) && (virtualFile = virtualFile2.findChild(string = SystemInfo.isWindows ? "django.py" : "django")) != null) {
            return virtualFile.getPath().replace('/', File.separatorChar);
        }
        return null;
    }

    public static void addDjangoPathToEnv(@NotNull String djangoPath, Map<String, String> envs) {
        if (djangoPath == null) {
            DjangoUtil.a(10);
        }
        String string = DjangoUtil.a(djangoPath);
        PythonEnvUtil.addToPythonPath(envs, FileUtil.toSystemDependentName((String)string));
    }

    public static String getManageScript(@Nullable Module module2) {
        VirtualFile virtualFile;
        if (module2 == null) {
            return "";
        }
        DjangoFacet djangoFacet = DjangoFacet.getInstance(module2);
        if (djangoFacet != null && (virtualFile = DjangoUtil.getManageFile(module2)) != null) {
            return virtualFile.getPath();
        }
        return "";
    }

    @Nullable
    public static String getDjangoAdmin(String sdkHome) {
        long l2 = c ^ 0x241BA9665405L;
        String string = "django-admin.py";
        return PythonSdkType.getExecutablePath(sdkHome, string);
    }

    @Nullable
    public static VirtualFile getSettingsFile(@NotNull Module module2) {
        DjangoFacet djangoFacet;
        if (module2 == null) {
            DjangoUtil.a(11);
        }
        if ((djangoFacet = DjangoFacet.getInstance(module2)) == null) {
            return null;
        }
        return DjangoUtil.getSettingsFile(djangoFacet);
    }

    @Nullable
    public static VirtualFile getSettingsFile(@NotNull DjangoFacet facet) {
        VirtualFile virtualFile;
        if (facet == null) {
            DjangoUtil.a(12);
        }
        if ((virtualFile = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile()) != null) {
            return virtualFile.findFileByRelativePath(((DjangoFacetConfiguration)facet.getConfiguration()).getSettingsFilePath());
        }
        return null;
    }

    @Nullable
    public static VirtualFile getManageFile(@NotNull Module module2) {
        DjangoFacet djangoFacet;
        if (module2 == null) {
            DjangoUtil.a(13);
        }
        if ((djangoFacet = DjangoFacet.getInstance(module2)) != null) {
            if (((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getManageFilePath().isEmpty()) {
                return null;
            }
            VirtualFile virtualFile = VirtualFileUtil.findFile(((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getManageFilePath());
            if (virtualFile != null) {
                return virtualFile;
            }
            VirtualFile virtualFile2 = ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile();
            if (virtualFile2 != null) {
                return virtualFile2.findFileByRelativePath(((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getManageFilePath());
            }
        }
        return null;
    }

    public static void addDjangoSettingsToEnv(@NotNull Module module2, @NotNull Map<String, String> envs) {
        if (module2 == null) {
            DjangoUtil.a(14);
        }
        if (envs == null) {
            DjangoUtil.a(15);
        }
        DjangoUtil.addDjangoSettingsToEnv(module2, envs, true);
    }

    public static void addDjangoSettingsToEnv(@NotNull Module module2, @NotNull Map<String, String> envs, boolean addManageModule) {
        if (module2 == null) {
            DjangoUtil.a(16);
        }
        if (envs == null) {
            DjangoUtil.a(17);
        }
        DjangoUtil.a(module2, envs);
        if (addManageModule) {
            DjangoUtil.addPyCharmManageModule(module2, envs);
        }
    }

    private static Map<String, String> a(@NotNull Module module2, @NotNull Map<String, String> map2) {
        if (module2 == null) {
            DjangoUtil.a(18);
        }
        if (map2 == null) {
            DjangoUtil.a(19);
        }
        VirtualFile virtualFile = DjangoUtil.getSettingsFile(module2);
        return DjangoUtil.addSettingsModule(module2, virtualFile, map2);
    }

    public static Map<String, String> addSettingsModule(@NotNull Module module2, @Nullable VirtualFile settingsFile, @NotNull Map<String, String> envs) {
        String string;
        VirtualFile virtualFile;
        long l2 = c ^ 0x64C5A464031AL;
        if (module2 == null) {
            DjangoUtil.a(20);
        }
        if (envs == null) {
            DjangoUtil.a(21);
        }
        if (envs.containsKey("DJANGO_SETTINGS_MODULE")) {
            return envs;
        }
        if (settingsFile == null) {
            return envs;
        }
        String string2 = DjangoUtil.a(module2, settingsFile);
        if (string2 == null && (virtualFile = DjangoUtil.getManageFile(module2)) != null && (string = VirtualFileUtil.getRelativePath(virtualFile.getParent(), settingsFile)) != null) {
            string2 = FileUtilRt.getNameWithoutExtension((String)string).replace('/', '.');
        }
        if (string2 == null) {
            string2 = DjangoUtil.getImportableModule(module2, settingsFile);
        }
        envs.put("DJANGO_SETTINGS_MODULE", string2);
        return envs;
    }

    public static Map<String, String> addPyCharmManageModule(@NotNull Module module2, @NotNull Map<String, String> envs) {
        long l2 = c ^ 0x3D3B3D7F44AAL;
        if (module2 == null) {
            DjangoUtil.a(22);
        }
        if (envs == null) {
            DjangoUtil.a(23);
        }
        if (envs.containsKey("PYCHARM_DJANGO_MANAGE_MODULE")) {
            return envs;
        }
        VirtualFile virtualFile = DjangoUtil.getManageFile(module2);
        if (virtualFile != null) {
            String string = DjangoUtil.a(module2, virtualFile);
            if (string == null) {
                string = virtualFile.getNameWithoutExtension();
            }
            envs.put("PYCHARM_DJANGO_MANAGE_MODULE", string);
        }
        return envs;
    }

    @Nullable
    private static String a(@NotNull Module module2, @NotNull VirtualFile virtualFile) {
        List list2;
        String string;
        if (module2 == null) {
            DjangoUtil.a(24);
        }
        if (virtualFile == null) {
            DjangoUtil.a(25);
        }
        if ((string = DjangoUtil.getProjectRoot(module2)) == null) {
            return null;
        }
        VirtualFile virtualFile2 = VirtualFileUtil.findFile(string);
        if (virtualFile2 == null) {
            return null;
        }
        String string2 = VirtualFileUtil.getRelativePath(virtualFile2, virtualFile);
        if (string2 != null && (list2 = StringUtil.split((String)string2, (String)"/")).size() > 0) {
            list2.set(list2.size() - 1, FileUtilRt.getNameWithoutExtension((String)((String)list2.get(list2.size() - 1))));
            return StringUtil.join((Collection)list2, (String)".");
        }
        return null;
    }

    @Nullable
    public static VirtualFile getCustomTestSettingsFile(@NotNull Module module2, @NotNull DjangoTestsRunConfiguration configuration) {
        VirtualFile virtualFile;
        if (module2 == null) {
            DjangoUtil.a(26);
        }
        if (configuration == null) {
            DjangoUtil.a(27);
        }
        if (!configuration.useCustomSettings()) {
            return null;
        }
        String string = configuration.getSettingsFile();
        if (string == null || string.isEmpty()) {
            return null;
        }
        DjangoFacet djangoFacet = DjangoFacet.getInstance(module2);
        if (djangoFacet != null && (virtualFile = ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile()) != null) {
            VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(string);
            if (virtualFile2 == null) {
                virtualFile2 = LocalFileSystem.getInstance().findFileByPath(string);
            }
            return virtualFile2;
        }
        return null;
    }

    public static void addCustomTestSettingsModule(@NotNull Module module2, @NotNull Map<String, String> envs, @NotNull DjangoTestsRunConfiguration configuration) {
        VirtualFile virtualFile;
        if (module2 == null) {
            DjangoUtil.a(28);
        }
        if (envs == null) {
            DjangoUtil.a(29);
        }
        if (configuration == null) {
            DjangoUtil.a(30);
        }
        if ((virtualFile = DjangoUtil.getCustomTestSettingsFile(module2, configuration)) == null) {
            virtualFile = DjangoUtil.getSettingsFile(module2);
        }
        DjangoUtil.addSettingsModule(module2, virtualFile, envs);
    }

    public static Map<String, String> addModuleToEnv(@NotNull Module module2, @NotNull Map<String, String> envs, @Nullable VirtualFile file, @NotNull String envName) {
        if (module2 == null) {
            DjangoUtil.a(31);
        }
        if (envs == null) {
            DjangoUtil.a(32);
        }
        if (envName == null) {
            DjangoUtil.a(33);
        }
        if (file != null) {
            String string = DjangoUtil.getImportableModule(module2, file);
            envs.put(envName, string);
        }
        return envs;
    }

    public static String getSettingsModule(@NotNull Module module2) {
        VirtualFile virtualFile;
        long l2 = c ^ 0x4ADBF331CB4L;
        if (module2 == null) {
            DjangoUtil.a(34);
        }
        if ((virtualFile = DjangoUtil.getSettingsFile(module2)) != null) {
            return DjangoUtil.getImportableModule(module2, virtualFile);
        }
        return "settings";
    }

    public static String getImportableModule(@NotNull Module module2, @NotNull VirtualFile file) {
        String string;
        if (module2 == null) {
            DjangoUtil.a(35);
        }
        if (file == null) {
            DjangoUtil.a(36);
        }
        if ((string = QualifiedNameFinder.findShortestImportableName(module2, file)) == null) {
            string = FileUtilRt.getNameWithoutExtension((String)file.getName());
        }
        return string;
    }

    public static boolean isDjangoAvailable(@NotNull Module module2, String sdkHome) {
        Sdk sdk;
        long l2 = c ^ 0x132D70A49D12L;
        if (module2 == null) {
            DjangoUtil.a(37);
        }
        if ((sdk = PythonSdkType.findSdkByPath(sdkHome)) == null) {
            return false;
        }
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext = PyResolveImportUtil.fromSdk(module2.getProject(), sdk);
        List<PsiElement> list2 = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)"django"), pyQualifiedNameResolveContext);
        return !list2.isEmpty();
    }

    @NotNull
    public static List<String> getDjangoVersionParts(@NotNull PyPackage djangoPackage) {
        if (djangoPackage == null) {
            DjangoUtil.a(38);
        }
        List list2 = StringUtil.split((String)djangoPackage.getVersion(), (String)".");
        if (list2 == null) {
            DjangoUtil.a(39);
        }
        return list2;
    }

    public static StringPattern createDjangoStandardProjectFileNamePattern() {
        return StandardPatterns.string().oneOf(a);
    }

    @Nullable
    public static String getDjangoPath(Sdk sdk) {
        VirtualFile[] virtualFileArray = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        return DjangoUtil.a(virtualFileArray);
    }

    @Nullable
    private static String a(VirtualFile[] virtualFileArray) {
        long l2 = c ^ 0x446FD446831EL;
        for (VirtualFile virtualFile : virtualFileArray) {
            LocalFileSystem localFileSystem;
            if (SystemInfo.isLinux && "python-django".equals(virtualFile.getName()) && (localFileSystem = virtualFile.findChild("bin")) != null) {
                return localFileSystem.getPath();
            }
            localFileSystem = LocalFileSystem.getInstance();
            VirtualFile virtualFile2 = localFileSystem.refreshAndFindFileByIoFile(new File(virtualFile.getPath(), "django/bin"));
            if (virtualFile2 == null) continue;
            return virtualFile2.getPath();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findDjango(VirtualFile root) {
        return DjangoUtil.a(root, 3);
    }

    @Nullable
    private static VirtualFile a(final VirtualFile virtualFile, int n2) {
        final Ref ref = Ref.create();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.limit((int)n2)}){
            private static final long a = com.jetbrains.python.psi.c.a(-8820851082918013737L, -5249677867949527537L, MethodHandles.lookup().lookupClass()).a(190784331467245L);

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                VirtualFile virtualFile2;
                if (file == null) {
                    1.a(0);
                }
                if (file.isDirectory() && (virtualFile2 = DjangoUtil.findDjangoRootPackage(file)) != null) {
                    ref.set((Object)virtualFile2);
                    VirtualFileVisitor.Result result = 1.skipTo((VirtualFile)virtualFile);
                    if (result == null) {
                        1.a(1);
                    }
                    return result;
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.a(2);
                }
                return result;
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0x6AFEED48098DL;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/django/util/DjangoUtil$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/django/util/DjangoUtil$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return (VirtualFile)ref.get();
    }

    @Nullable
    public static VirtualFile findDjangoRootPackage(@NotNull VirtualFile root) {
        long l2 = c ^ 0x1A018CAFA68EL;
        if (root == null) {
            DjangoUtil.a(40);
        }
        for (VirtualFile virtualFile : root.getChildren()) {
            VirtualFile virtualFile2;
            if (!virtualFile.isDirectory() || !virtualFile.getName().equals("django") || (virtualFile2 = DjangoUtil.findDjangoBin(virtualFile)) == null) continue;
            return virtualFile;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findDjangoBin(@NotNull VirtualFile root) {
        long l2 = c ^ 0x3D74DEDAC84L;
        if (root == null) {
            DjangoUtil.a(41);
        }
        for (VirtualFile virtualFile : root.getChildren()) {
            if (!virtualFile.isDirectory() || !virtualFile.getName().equals("bin")) continue;
            for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
                if (virtualFile2.isDirectory() || !virtualFile2.getName().equals("django-admin.py")) continue;
                return virtualFile2;
            }
        }
        return null;
    }

    public static boolean isInsideDjango(VirtualFile file, @Nullable VirtualFile stopAt) {
        while (file != null) {
            if (Comparing.equal((Object)file, (Object)stopAt)) {
                return false;
            }
            if (DjangoUtil.findDjangoRootPackage(file) != null) {
                return true;
            }
            file = file.getParent();
        }
        return false;
    }

    @Nullable
    public static String getExistingFileForName(@NotNull VirtualFile root, String path) {
        VirtualFile virtualFile;
        if (root == null) {
            DjangoUtil.a(42);
        }
        if ((virtualFile = root.findFileByRelativePath(FileUtil.toSystemIndependentName((String)path))) != null) {
            return virtualFile.getName();
        }
        List<String> list2 = DjangoUtil.getFilesInRoot(root.getPath(), FileUtilRt.getNameWithoutExtension((String)path));
        if (list2.size() > 0) {
            return list2.get(0);
        }
        return null;
    }

    public static List<String> getFilesInRoot(@Nullable String projectRoot, @NotNull String name) {
        File file;
        if (name == null) {
            DjangoUtil.a(43);
        }
        ArrayList arrayList = Lists.newArrayList();
        if (projectRoot != null && (file = new File(projectRoot)).exists()) {
            for (File file2 : file.listFiles(new NameFileFilter(name))) {
                arrayList.add(file2.getName());
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Nullable
    public static String getProjectName(PsiElement elem) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)elem);
        if (module2 == null) {
            return null;
        }
        DjangoFacet djangoFacet = DjangoFacet.getInstance(module2);
        if (djangoFacet == null) {
            return null;
        }
        return ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectName();
    }

    public static boolean isDjangoTemplateDocument(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            DjangoUtil.a(44);
        }
        if (project == null) {
            DjangoUtil.a(45);
        }
        Ref ref = Ref.create((Object)false);
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null) {
                ref.set((Object)(psiFile.getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE) != null ? 1 : 0));
            }
        });
        return (Boolean)ref.get();
    }

    public static boolean isDjangoTemplateByExtension(@NotNull VirtualFile file) {
        if (file == null) {
            DjangoUtil.a(46);
        }
        return DjangoUtil.hasDjangoTemplateExtension(file.getName());
    }

    public static boolean hasDjangoTemplateExtension(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        String string = PythonStringUtil.getLastSuffix(name, ".");
        if (StringUtil.isEmpty((String)string)) {
            return false;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(string);
        for (FileType fileType2 : b) {
            if (!fileType2.equals(fileType)) continue;
            return true;
        }
        return false;
    }

    public static Presentation updateDjangoRequiredAction(AnActionEvent e10) {
        Module module2;
        Presentation presentation = e10.getPresentation();
        presentation.setEnabledAndVisible(false);
        Project project = (Project)e10.getData(CommonDataKeys.PROJECT);
        if (project != null && (module2 = DjangoUtil.getDjangoModule(project)) != null) {
            presentation.setEnabledAndVisible(true);
            return presentation;
        }
        module2 = (Module)e10.getData(LangDataKeys.MODULE);
        if (module2 != null && DjangoUtil.containsDjango(module2)) {
            presentation.setEnabledAndVisible(true);
        }
        return presentation;
    }

    public static boolean containsDjango(Module module2) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        DjangoBinSearchingPolicy djangoBinSearchingPolicy = new DjangoBinSearchingPolicy();
        String string = (String)ModuleRootManager.getInstance((Module)module2).processOrder((RootPolicy)djangoBinSearchingPolicy, null);
        if (string != null) {
            return true;
        }
        if (DjangoUtil.a(ModuleRootManager.getInstance((Module)module2).getContentRoots()) != null) {
            return true;
        }
        DjangoFacet djangoFacet = DjangoFacet.getInstance(module2);
        return djangoFacet != null && (virtualFile2 = ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile()) != null && (virtualFile = DjangoUtil.findDjangoRootPackage(virtualFile2)) != null;
    }

    @Nullable
    public static PsiDirectory getProjectRoot(@NotNull PsiElement element) {
        Project project;
        Module module2;
        if (element == null) {
            DjangoUtil.a(47);
        }
        if ((module2 = DjangoUtil.getDjangoModule(project = element.getProject())) == null) {
            return null;
        }
        VirtualFile virtualFile = VirtualFileUtil.findFile(DjangoUtil.getProjectRoot(module2));
        if (virtualFile != null) {
            return PsiManager.getInstance((Project)project).findDirectory(virtualFile);
        }
        PsiFile psiFile = DjangoPsiUtil.getFile(element);
        if (psiFile == null) {
            return null;
        }
        PsiDirectory psiDirectory = psiFile.getParent();
        return psiDirectory != null ? DjangoUtil.getProjectRoot((PsiFileSystemItem)psiDirectory) : null;
    }

    @Nullable
    public static String getDjangoPath(@NotNull Module module2) {
        String string;
        if (module2 == null) {
            DjangoUtil.a(48);
        }
        if ((string = (String)ModuleRootManager.getInstance((Module)module2).processOrder((RootPolicy)new DjangoBinSearchingPolicy(), null)) == null) {
            string = DjangoUtil.a(ModuleRootManager.getInstance((Module)module2).getContentRoots());
        }
        if (string != null) {
            String string2 = DjangoUtil.a(string);
            return FileUtil.toSystemDependentName((String)string2);
        }
        return null;
    }

    private static String a(@NotNull String string) {
        long l2 = c ^ 0x428A288221BCL;
        if (string == null) {
            DjangoUtil.a(49);
        }
        return string.substring(0, string.length() - "django/bin".length());
    }

    public static List<String> getInstalledAppLabels(Module module2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list2 = DjangoSettingsPy.getInstalledApps(module2);
        for (String string : list2) {
            arrayList.add(DjangoUtil.getAppLabelByName(string));
        }
        return arrayList;
    }

    @NotNull
    public static String getAppLabelByName(@NotNull String app) {
        String string;
        if (app == null) {
            DjangoUtil.a(50);
        }
        String string2 = (string = QualifiedName.fromDottedString((String)app).getLastComponent()) != null ? string : app;
        if (string2 == null) {
            DjangoUtil.a(51);
        }
        return string2;
    }

    public static QualifiedName appLabelToQName(Module module2, String appLabel) {
        List<String> list2 = DjangoSettingsPy.getInstalledApps(module2);
        for (String string : list2) {
            QualifiedName qualifiedName = QualifiedName.fromDottedString((String)string);
            if (!qualifiedName.endsWith(appLabel)) continue;
            return qualifiedName;
        }
        return null;
    }

    @NotNull
    public static List<PsiDirectory> getApplications(@NotNull Module module2) {
        if (module2 == null) {
            DjangoUtil.a(52);
        }
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext = PyResolveImportUtil.fromModule(module2).copyWithPlainDirectories();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)module2.getProject()).getFileIndex();
        List list2 = ((StreamEx)StreamEx.of(DjangoSettingsPy.getInstalledApps(module2)).flatMap(string -> PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)string), pyQualifiedNameResolveContext).stream()).select(PsiDirectory.class).filter(psiDirectory -> projectFileIndex.isInContent(psiDirectory.getVirtualFile()))).toList();
        if (list2 == null) {
            DjangoUtil.a(53);
        }
        return list2;
    }

    static {
        c = com.jetbrains.python.psi.c.a(7172907759423478404L, 2981618503284438558L, MethodHandles.lookup().lookupClass()).a(44088761573006L);
        long l2 = c ^ 0x7D3FA44BC29EL;
        a = ImmutableSet.of((Object)"urls.py", (Object)"manage.py", (Object)"settings.py", (Object)"views.py");
        b = new FileType[]{StdFileTypes.HTML, StdFileTypes.XHTML, StdFileTypes.XML, StdFileTypes.JS};
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x66B969AD19B8L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/util/DjangoUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 2: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoPath";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 25: 
            case 36: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoPackage";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoBin";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequirementAtLeast";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/util/DjangoUtil";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDjangoVersionParts";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppLabelByName";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplications";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDjangoModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recordUsage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "searchFolder";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "searchProjectFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "searchProjectFolder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDjangoPathToEnv";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getManageFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addDjangoSettingsToEnv";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addPyCharmSettingsModule";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsModule";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addPyCharmManageModule";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRelatedToRoot";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCustomTestSettingsFile";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addCustomTestSettingsModule";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addModuleToEnv";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsModule";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getImportableModule";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoAvailable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDjangoVersionParts";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findDjangoRootPackage";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findDjangoBin";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getExistingFileForName";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getFilesInRoot";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoTemplateDocument";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoTemplateByExtension";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getDjangoPath";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removeDjangoBin";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getAppLabelByName";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getApplications";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DjangoBinSearchingPolicy
    extends RootPolicy<String> {
        private static final long a = com.jetbrains.python.psi.c.a(4737984732718176722L, -3817075786602410073L, MethodHandles.lookup().lookupClass()).a(178305800540769L);

        @Nullable
        public String visitJdkOrderEntry(@NotNull JdkOrderEntry jdkOrderEntry, String value) {
            if (jdkOrderEntry == null) {
                DjangoBinSearchingPolicy.a(0);
            }
            if (value == null) {
                value = DjangoUtil.a(jdkOrderEntry.getRootFiles(OrderRootType.CLASSES));
            }
            return value;
        }

        @Nullable
        public String visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, String value) {
            if (libraryOrderEntry == null) {
                DjangoBinSearchingPolicy.a(1);
            }
            if (value == null) {
                value = DjangoUtil.a(libraryOrderEntry.getRootFiles(OrderRootType.CLASSES));
            }
            return value;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = a ^ 0x7B8D2D59203EL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdkOrderEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryOrderEntry";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/util/DjangoUtil$DjangoBinSearchingPolicy";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJdkOrderEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLibraryOrderEntry";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NameFileFilter
    implements FileFilter {
        private final String a;
        private static final long b = com.jetbrains.python.psi.c.a(91549027915916750L, -6012837696908920153L, MethodHandles.lookup().lookupClass()).a(123392646879636L);

        NameFileFilter(String name) {
            this.a = name;
        }

        @Override
        public boolean accept(File file) {
            long l2 = b ^ 0x6CD0BDF10EFDL;
            String string = file.getName();
            return file.isFile() && string.endsWith(".py") && string.contains("settings");
        }
    }

    private static class ManageFileFinder
    implements Processor<VirtualFile> {
        private VirtualFile a;
        private static final long b = com.jetbrains.python.psi.c.a(-1635505809517925267L, -4037031026389262161L, MethodHandles.lookup().lookupClass()).a(278246049570221L);

        private ManageFileFinder() {
        }

        public boolean process(VirtualFile file) {
            long l2 = b ^ 0x4D442DB651B6L;
            if (!file.isDirectory() && "manage.py".equals(file.getName())) {
                this.a = file;
                return false;
            }
            return true;
        }
    }
}

