/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileUtil {
    public static final char VFS_PATH_SEPARATOR = '/';
    private static final long a = c.a(-938180441326605977L, 4702345116675707859L, MethodHandles.lookup().lookupClass()).a(38583554400171L);

    private VirtualFileUtil() {
    }

    public static String buildSystemIndependentPath(@NotNull String rootPath, @NotNull String relativePath) {
        if (rootPath == null) {
            VirtualFileUtil.a(0);
        }
        if (relativePath == null) {
            VirtualFileUtil.a(1);
        }
        String string = FileUtil.toSystemIndependentName((String)rootPath);
        return string + (string.endsWith(String.valueOf('/')) ? "" : Character.valueOf('/')) + FileUtil.toSystemIndependentName((String)relativePath);
    }

    @Nullable
    public static VirtualFile findFile(String path) {
        if (!StringUtil.isEmpty((String)path)) {
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return null;
    }

    @NotNull
    public static String getAbsolutePath(@NotNull VirtualFile parent, @NotNull String relPath) {
        if (parent == null) {
            VirtualFileUtil.a(2);
        }
        if (relPath == null) {
            VirtualFileUtil.a(3);
        }
        String string = parent.getPath();
        relPath = FileUtil.toSystemIndependentName((String)relPath);
        String string2 = string.endsWith(File.separator) && relPath.startsWith(File.separator) ? string + relPath.substring(1) : (!string.endsWith(File.separator) && !relPath.startsWith(File.separator) ? string + File.separator + relPath : string + relPath);
        String string3 = FileUtil.toSystemDependentName((String)string2);
        if (string3 == null) {
            VirtualFileUtil.a(4);
        }
        return string3;
    }

    @NotNull
    public static String getRelativePath(@NotNull VirtualFile parent, @NotNull String child) {
        if (parent == null) {
            VirtualFileUtil.a(5);
        }
        if (child == null) {
            VirtualFileUtil.a(6);
        }
        String string = parent.getPath();
        if ((child = FileUtil.toSystemIndependentName((String)child)).startsWith(string)) {
            String string2 = child.substring(string.length());
            if (string2.startsWith("/") || string2.startsWith("\\")) {
                String string3 = string2.substring(1);
                if (string3 == null) {
                    VirtualFileUtil.a(7);
                }
                return string3;
            }
            String string4 = string2;
            if (string4 == null) {
                VirtualFileUtil.a(8);
            }
            return string4;
        }
        String string5 = child;
        if (string5 == null) {
            VirtualFileUtil.a(9);
        }
        return string5;
    }

    @Nullable
    public static String getRelativePath(VirtualFile parent, VirtualFile child) {
        if (parent == null || child == null) {
            return null;
        }
        return VfsUtilCore.getRelativePath((VirtualFile)child, (VirtualFile)parent, (char)'/');
    }

    public static List<VirtualFile> getHtmlFolders(VirtualFile folder) {
        if (folder == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        VirtualFileUtil.a(folder, arrayList);
        return arrayList;
    }

    private static void a(VirtualFile virtualFile, final List<VirtualFile> list2) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
            private static final long a = c.a(6881406877285343730L, 4927944807192241709L, MethodHandles.lookup().lookupClass()).a(249268033990579L);

            public boolean visitFile(@NotNull VirtualFile file) {
                long l2 = a ^ 0x72413BA96F14L;
                if (file == null) {
                    1.a(0);
                }
                for (VirtualFile virtualFile : file.getChildren()) {
                    if (virtualFile.isDirectory() || !"html".equals(virtualFile.getExtension())) continue;
                    list2.add(file);
                    break;
                }
                return true;
            }

            @NotNull
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                if (file == null) {
                    1.a(1);
                }
                List list22 = ContainerUtil.filter((Object[])file.getChildren(), virtualFile -> virtualFile.isDirectory());
                if (list22 == null) {
                    1.a(2);
                }
                return list22;
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0x5C4B3004EA0DL;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 2: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/django/util/VirtualFileUtil$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/django/util/VirtualFileUtil$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildrenIterable";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getChildrenIterable";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    public static Set<VirtualFile> getFiles(VirtualFile root, String ... names) {
        if (root == null) {
            return Collections.emptySet();
        }
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>();
        VfsUtilCore.processFilesRecursively((VirtualFile)root, virtualFile -> {
            if (ArrayUtil.contains((Object)virtualFile.getName(), (Object[])names)) {
                hashSet.add((VirtualFile)virtualFile);
            }
            return true;
        });
        return hashSet;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x155628E5A2A4L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/util/VirtualFileUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/util/VirtualFileUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildSystemIndependentPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

