/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.jetbrains.python.console.PyConsoleProcessFinishedException;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunicationUtil;
import com.jetbrains.python.console.PythonConsoleBackendServiceDisposable;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.console.protocol.CompletionOption;
import com.jetbrains.python.console.protocol.DebugValue;
import com.jetbrains.python.console.protocol.ExceedingArrayDimensionsException;
import com.jetbrains.python.console.protocol.GetArrayResponse;
import com.jetbrains.python.console.protocol.KeyboardInterruptException;
import com.jetbrains.python.console.protocol.PythonConsoleFrontendService;
import com.jetbrains.python.console.protocol.UnsupportedArrayTypeException;
import com.jetbrains.python.console.pydev.AbstractConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebugValueExecutionService;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import com.jetbrains.python.debugger.PyReferrersLoader;
import com.jetbrains.python.debugger.containerview.PyViewNumericContainerAction;
import com.jetbrains.python.debugger.pydev.GetVariableCommand;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PydevConsoleCommunication
extends AbstractConsoleCommunication
implements PyFrameAccessor {
    private static final Logger b;
    protected volatile boolean keyboardInterruption;
    protected volatile String inputReceived;
    protected volatile InterpreterResponse nextResponse;
    private final Object f = new Object();
    private volatile boolean l = false;
    private boolean c;
    private PythonDebugConsoleCommunication g;
    private boolean k = false;
    private int i = 0;
    private final Map<Integer, List<PyFrameAccessor.PyAsyncValue<String>>> h = new ConcurrentHashMap<Integer, List<PyFrameAccessor.PyAsyncValue<String>>>();
    @Nullable
    private PythonConsoleView e;
    private final List<PyFrameListener> j = ContainerUtil.createLockFreeCopyOnWriteList();
    @Nullable
    private XCompositeNode d;
    private final Object a = new Object();
    private static final long x;

    public PydevConsoleCommunication(Project project) {
        super(project);
    }

    @NotNull
    protected abstract PythonConsoleBackendServiceDisposable getPythonConsoleBackendClient();

    public boolean handshake() {
        long l2 = x ^ 0xC89F1C7098BL;
        if (!this.isCommunicationClosed()) {
            try {
                return "PyCharm".equals(this.getPythonConsoleBackendClient().handshake());
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException runtimeException) {
                return false;
            }
            catch (TException tException) {
                throw new RuntimeException(tException);
            }
        }
        return false;
    }

    public void close() {
        long l2 = x ^ 0x260FB752169FL;
        PyDebugValueExecutionService.getInstance((Project)this.myProject).sessionStopped((PyFrameAccessor)this);
        this.h.clear();
        new Task.Backgroundable(this.myProject, "Close Console Communication", true){
            private static final long a = com.jetbrains.python.psi.c.a(-5619971665755067656L, -7204402734672924020L, MethodHandles.lookup().lookupClass()).a(53601193393631L);

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.a(0);
                }
                try {
                    PydevConsoleCommunication.this.closeCommunication().get();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    b.debug((Throwable)executionException);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4AD5C1CD3E8AL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$1", "run"));
            }
        }.queue();
    }

    @NotNull
    public Future<?> closeAsync() {
        PyDebugValueExecutionService.getInstance((Project)this.myProject).sessionStopped((PyFrameAccessor)this);
        this.h.clear();
        Future<?> future2 = this.closeCommunication();
        if (future2 == null) {
            PydevConsoleCommunication.a(0);
        }
        return future2;
    }

    @NotNull
    protected abstract Future<?> closeCommunication();

    protected abstract boolean isCommunicationClosed();

    private void a(List<String> list2, boolean bl2) {
        if (this.getConsoleFile() != null) {
            PythonConsoleData pythonConsoleData = PyConsoleUtil.getOrCreateIPythonData(this.getConsoleFile());
            pythonConsoleData.setIPythonAutomagic(bl2);
            pythonConsoleData.setIPythonMagicCommands(list2);
        }
    }

    private boolean a(String string) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = virtualFile = StringUtil.isEmpty((String)string) ? null : LocalFileSystem.getInstance().findFileByPath(string);
        if (virtualFile != null) {
            ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)this.myProject).openFile(virtualFile, true));
            return true;
        }
        return false;
    }

    private void a(boolean bl2) {
        this.k = bl2;
        this.b(false);
        this.notifyCommandExecuted(bl2);
    }

    private void b(boolean bl2) {
        this.c = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object a() throws KeyboardInterruptException {
        this.waitingForInput = true;
        this.inputReceived = null;
        this.keyboardInterruption = false;
        boolean bl2 = true;
        this.nextResponse = new InterpreterResponse(false, bl2);
        this.notifyInputRequested();
        while (this.inputReceived == null) {
            if (this.keyboardInterruption) {
                this.waitingForInput = false;
                throw new KeyboardInterruptException();
            }
            Object object = this.a;
            synchronized (object) {
                try {
                    this.a.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.inputReceived;
    }

    protected Pair<String, Boolean> exec(ConsoleCommunication.ConsoleCodeFragment command) {
        boolean bl2;
        this.b(true);
        try {
            bl2 = command.isSingleLine() ? this.getPythonConsoleBackendClient().execLine(command.getText()) : this.getPythonConsoleBackendClient().execMultipleLines(command.getText());
        }
        catch (TException tException) {
            throw new RuntimeException(tException);
        }
        if (bl2) {
            this.b(false);
        }
        return Pair.create(null, (Object)bl2);
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String text2, String actTok) throws Exception {
        if (this.g != null && this.g.isSuspended()) {
            List<PydevCompletionVariant> list2 = this.g.getCompletions(text2, actTok);
            if (list2 == null) {
                PydevConsoleCommunication.a(1);
            }
            return list2;
        }
        if (this.waitingForInput) {
            List<PydevCompletionVariant> list3 = Collections.emptyList();
            if (list3 == null) {
                PydevConsoleCommunication.a(2);
            }
            return list3;
        }
        List<CompletionOption> list4 = this.getPythonConsoleBackendClient().getCompletions(text2, actTok);
        List<PydevCompletionVariant> list5 = list4.stream().map(completionOption -> PydevConsoleCommunication.b(completionOption)).collect(Collectors.toList());
        if (list5 == null) {
            PydevConsoleCommunication.a(3);
        }
        return list5;
    }

    @NotNull
    private static PydevCompletionVariant b(@NotNull CompletionOption completionOption) {
        if (completionOption == null) {
            PydevConsoleCommunication.a(4);
        }
        String string = String.join((CharSequence)" ", completionOption.arguments);
        PydevCompletionVariant pydevCompletionVariant = new PydevCompletionVariant(completionOption.name, completionOption.documentation, string, completionOption.type.getValue());
        if (pydevCompletionVariant == null) {
            PydevConsoleCommunication.a(5);
        }
        return pydevCompletionVariant;
    }

    public String getDescription(String text2) throws Exception {
        long l2 = x ^ 0x4224C333E25L;
        if (this.g != null && this.g.isSuspended()) {
            return this.g.getDescription(text2);
        }
        if (this.waitingForInput) {
            return "Unable to get description: waiting for input.";
        }
        ThrowableComputable throwableComputable = () -> this.getPythonConsoleBackendClient().getDescription(text2);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(throwableComputable, "Getting Description", true, this.myProject);
        }
        return (String)ApplicationManager.getApplication().executeOnPooledThread(() -> (String)throwableComputable.compute()).get(5L, TimeUnit.SECONDS);
    }

    public void execInterpreter(final ConsoleCommunication.ConsoleCodeFragment command, final Function<InterpreterResponse, Object> onResponseReceived) {
        long l2 = x ^ 0x4B523680D1C8L;
        if (this.g != null && this.g.isSuspended()) {
            this.g.execInterpreter(command, onResponseReceived);
            return;
        }
        this.nextResponse = null;
        if (this.waitingForInput && this.e != null && this.e.isInitialized()) {
            this.inputReceived = command.getText();
            this.waitingForInput = false;
        } else {
            new Task.Backgroundable(this.myProject, "REPL Communication", true){
                private static final long a = com.jetbrains.python.psi.c.a(-1569333680174512917L, -1012207104979485939L, MethodHandles.lookup().lookupClass()).a(273464783733975L);

                public void run(@NotNull ProgressIndicator indicator) {
                    long l2 = a ^ 0x33BDD72EB14FL;
                    if (indicator == null) {
                        2.a(0);
                    }
                    boolean bl2 = false;
                    try {
                        Pair pair = null;
                        int n2 = 0;
                        while (true) {
                            if (indicator.isCanceled()) {
                                return;
                            }
                            pair = PydevConsoleCommunication.this.exec(command);
                            String string = "Failed to read servers response";
                            if (pair.first == null || ((String)pair.first).indexOf(string) == -1 || PydevConsoleCommunication.this.l || n2 >= 3) break;
                            ++n2;
                            Thread.sleep(250L);
                            pair = Pair.create((Object)"", (Object)pair.second);
                        }
                        PydevConsoleCommunication.this.l = true;
                        boolean bl3 = (Boolean)pair.second;
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(bl3, bl2);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    catch (Exception exception) {
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, bl2);
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x372E2E75FBC6L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$2", "run"));
                }
            }.queue();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Waiting for REPL Response"){
                private static final long a = com.jetbrains.python.psi.c.a(4445694973296456417L, 7378390996718340L, MethodHandles.lookup().lookupClass()).a(5978005185326L);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    long l2 = a ^ 0x16C70A50D959L;
                    if (indicator == null) {
                        3.a(0);
                    }
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    progressIndicator.setText("Waiting for REPL response with 10s timeout");
                    progressIndicator.setIndeterminate(false);
                    long l3 = System.nanoTime();
                    while (PydevConsoleCommunication.this.nextResponse == null) {
                        if (progressIndicator.isCanceled()) {
                            b.debug("Canceled");
                            PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, false);
                        }
                        long l4 = System.nanoTime() - l3;
                        progressIndicator.setFraction((double)l4 / 1.0E10);
                        if (l4 > 10000000000L) {
                            b.debug("Timeout exceeded");
                            PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, false);
                        }
                        Object object = PydevConsoleCommunication.this.f;
                        synchronized (object) {
                            try {
                                PydevConsoleCommunication.this.f.wait(20L);
                            }
                            catch (InterruptedException interruptedException) {
                                b.error((Throwable)interruptedException);
                            }
                        }
                    }
                    if (PydevConsoleCommunication.this.nextResponse.more) {
                        PydevConsoleCommunication.this.k = true;
                        PydevConsoleCommunication.this.notifyCommandExecuted(true);
                    }
                    onResponseReceived.fun((Object)PydevConsoleCommunication.this.nextResponse);
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x609057179FDAL;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$3", "run"));
                }
            });
        }
    }

    public void interrupt() {
        if (this.waitingForInput) {
            this.keyboardInterruption = true;
            return;
        }
        try {
            this.getPythonConsoleBackendClient().interrupt();
        }
        catch (PyConsoleProcessFinishedException | CommunicationClosedException | TException throwable) {
            b.error(throwable);
        }
    }

    public boolean isExecuting() {
        return this.c;
    }

    public boolean needsMore() {
        return this.k;
    }

    public PyDebugValue evaluate(String expression, boolean execute, boolean doTrunc) throws PyDebuggerException {
        long l2 = x ^ 0x65671A9FDF4DL;
        if (!this.isCommunicationClosed()) {
            try {
                List<DebugValue> list2 = this.getPythonConsoleBackendClient().evaluate(expression);
                return PydevConsoleCommunicationUtil.createPyDebugValue(list2.iterator().next(), this);
            }
            catch (Exception exception) {
                throw new PyDebuggerException("Evaluate in console failed", (Throwable)exception);
            }
        }
        return null;
    }

    @Nullable
    public XValueChildrenList loadFrame() throws PyDebuggerException {
        long l2 = x ^ 0x24BB966795CEL;
        if (!this.isCommunicationClosed()) {
            try {
                List<DebugValue> list2 = this.getPythonConsoleBackendClient().getFrame();
                return PydevConsoleCommunicationUtil.parseVars(list2, null, this);
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException | TException throwable) {
                throw new PyDebuggerException("Get frame from console failed", throwable);
            }
        }
        return new XValueChildrenList();
    }

    public synchronized int getNextFullValueSeq() {
        ++this.i;
        return this.i;
    }

    public void loadAsyncVariablesValues(@NotNull List<PyFrameAccessor.PyAsyncValue<String>> pyAsyncValues) {
        if (pyAsyncValues == null) {
            PydevConsoleCommunication.a(6);
        }
        PyDebugValueExecutionService.getInstance((Project)this.myProject).submitTask((PyFrameAccessor)this, () -> {
            long l2 = x ^ 0x29BB83A2F5A1L;
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (PyFrameAccessor.PyAsyncValue pyAsyncValue : pyAsyncValues) {
                    arrayList.add(GetVariableCommand.composeName((PyDebugValue)pyAsyncValue.getDebugValue()));
                }
                int n2 = this.getNextFullValueSeq();
                this.h.put(n2, pyAsyncValues);
                this.getPythonConsoleBackendClient().loadFullValue(n2, arrayList);
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException | TException throwable) {
                for (PyFrameAccessor.PyAsyncValue pyAsyncValue : pyAsyncValues) {
                    PyDebugValue pyDebugValue = pyAsyncValue.getDebugValue();
                    XValueNode xValueNode = pyDebugValue.getLastNode();
                    if (xValueNode == null || xValueNode.isObsolete()) continue;
                    if (throwable.getMessage().startsWith("Timeout") || throwable.getMessage().startsWith("Console already exited")) {
                        pyDebugValue.updateNodeValueAfterLoading(xValueNode, " ", "", "Loading timed out");
                        continue;
                    }
                    b.error(throwable);
                }
            }
        });
    }

    public XValueChildrenList loadVariable(PyDebugValue var) throws PyDebuggerException {
        long l2 = x ^ 0x10964461CC7EL;
        if (!this.isCommunicationClosed()) {
            try {
                String string = var.getOffset() == 0 ? GetVariableCommand.composeName((PyDebugValue)var) : var.getOffset() + "\t" + GetVariableCommand.composeName((PyDebugValue)var);
                List<DebugValue> list2 = this.getPythonConsoleBackendClient().getVariable(string);
                return PydevConsoleCommunicationUtil.parseVars(list2, var, this);
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException runtimeException) {
                throw new PyDebuggerException(runtimeException.getLocalizedMessage(), (Throwable)runtimeException);
            }
            catch (TException tException) {
                throw new PyDebuggerException("Get variable from console failed", (Throwable)tException);
            }
        }
        return new XValueChildrenList();
    }

    public void setCurrentRootNode(@NotNull XCompositeNode node) {
        if (node == null) {
            PydevConsoleCommunication.a(7);
        }
        this.d = node;
    }

    @Nullable
    public XCompositeNode getCurrentRootNode() {
        return this.d;
    }

    public void changeVariable(PyDebugValue variable, String value) throws PyDebuggerException {
        long l2 = x ^ 0x600FD1101254L;
        if (!this.isCommunicationClosed()) {
            try {
                this.getPythonConsoleBackendClient().changeVariable(variable.getEvaluationExpression(), value);
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException | TException throwable) {
                throw new PyDebuggerException("Get change variable", throwable);
            }
        }
    }

    @Nullable
    public PyReferrersLoader getReferrersLoader() {
        return null;
    }

    public ArrayChunk getArrayItems(PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        long l2 = x ^ 0x5D979FB4F61L;
        if (!this.isCommunicationClosed()) {
            try {
                GetArrayResponse getArrayResponse = this.getPythonConsoleBackendClient().getArray(var.getName(), rowOffset, colOffset, rows, cols, format);
                return PydevConsoleCommunicationUtil.createArrayChunk(getArrayResponse, this);
            }
            catch (UnsupportedArrayTypeException unsupportedArrayTypeException) {
                throw new IllegalArgumentException(var.getType() + " is not supported", (Throwable)((Object)unsupportedArrayTypeException));
            }
            catch (ExceedingArrayDimensionsException exceedingArrayDimensionsException) {
                throw new IllegalArgumentException(var.getName() + " has more than two dimensions", (Throwable)((Object)exceedingArrayDimensionsException));
            }
            catch (Exception exception) {
                throw new PyDebuggerException("Evaluate in console failed", (Throwable)exception);
            }
        }
        return null;
    }

    @Nullable
    public XSourcePosition getSourcePositionForName(String name, String parentType) {
        return null;
    }

    @Nullable
    public XSourcePosition getSourcePositionForType(String type) {
        return null;
    }

    public void connectToDebugger(int localPort, @Nullable String debuggerHost, @NotNull Map<String, Boolean> dbgOpts, @NotNull Map<String, String> extraEnvs) throws Exception {
        long l2 = x ^ 0xF4119C2F708L;
        if (dbgOpts == null) {
            PydevConsoleCommunication.a(8);
        }
        if (extraEnvs == null) {
            PydevConsoleCommunication.a(9);
        }
        if (this.waitingForInput) {
            throw new Exception("Can't connect debugger now, waiting for input");
        }
        try {
            this.getPythonConsoleBackendClient().connectToDebugger(localPort, debuggerHost, dbgOpts, extraEnvs);
        }
        catch (PyConsoleProcessFinishedException | CommunicationClosedException | TException throwable) {
            throw new PyDebuggerException("pydevconsole failed to execute connectToDebugger", throwable);
        }
    }

    public void notifyCommandExecuted(boolean more) {
        super.notifyCommandExecuted(more);
        for (PyFrameListener pyFrameListener : this.j) {
            pyFrameListener.frameChanged();
        }
    }

    public void setDebugCommunication(PythonDebugConsoleCommunication debugCommunication) {
        this.g = debugCommunication;
    }

    public PythonDebugConsoleCommunication getDebugCommunication() {
        return this.g;
    }

    public void setConsoleView(@Nullable PythonConsoleView consoleView) {
        this.e = consoleView;
    }

    public void showNumericContainer(@NotNull PyDebugValue value) {
        if (value == null) {
            PydevConsoleCommunication.a(10);
        }
        PyViewNumericContainerAction.showNumericViewer(this.myProject, value);
    }

    public void addFrameListener(@NotNull PyFrameListener listener2) {
        if (listener2 == null) {
            PydevConsoleCommunication.a(11);
        }
        this.j.add(listener2);
    }

    @NotNull
    protected final PythonConsoleFrontendService.Iface createPythonConsoleFrontendHandler() {
        PythonConsoleFrontendHandler pythonConsoleFrontendHandler = new PythonConsoleFrontendHandler();
        if (pythonConsoleFrontendHandler == null) {
            PydevConsoleCommunication.a(12);
        }
        return pythonConsoleFrontendHandler;
    }

    static {
        x = com.jetbrains.python.psi.c.a(7166507735051635272L, 3612727698909821214L, MethodHandles.lookup().lookupClass()).a(85031285646444L);
        b = Logger.getInstance(PydevConsoleCommunication.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = x ^ 0x6B92D3B025B2L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleCommunication";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyAsyncValues";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbgOpts";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraEnvs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "closeAsync";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletions";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleCommunication";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toPydevCompletionVariant";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPythonConsoleFrontendHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toPydevCompletionVariant";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadAsyncVariablesValues";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentRootNode";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "connectToDebugger";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showNumericContainer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addFrameListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class CommunicationClosedException
    extends RuntimeException {
        protected CommunicationClosedException() {
        }
    }

    private class PythonConsoleFrontendHandler
    implements PythonConsoleFrontendService.Iface {
        private PythonConsoleFrontendHandler() {
        }

        @Override
        public void notifyFinished(boolean needsMoreInput) {
            PydevConsoleCommunication.this.a(needsMoreInput);
        }

        @Override
        public String requestInput(String path) throws KeyboardInterruptException {
            return (String)PydevConsoleCommunication.this.a();
        }

        @Override
        public void notifyAboutMagic(List<String> commands, boolean isAutoMagic) {
            PydevConsoleCommunication.this.a(commands, isAutoMagic);
        }

        @Override
        public void showConsole() {
            if (PydevConsoleCommunication.this.e != null) {
                PydevConsoleCommunication.this.e.setConsoleEnabled(true);
            }
        }

        @Override
        public void returnFullValue(int requestSeq, List<DebugValue> response) {
            block4: {
                List list2 = (List)PydevConsoleCommunication.this.h.remove(requestSeq);
                try {
                    List list3 = response.stream().map(debugValue -> PydevConsoleCommunicationUtil.createPyDebugValue(debugValue, PydevConsoleCommunication.this)).collect(Collectors.toList());
                    for (int i10 = 0; i10 < list3.size(); ++i10) {
                        PyDebugValue pyDebugValue = (PyDebugValue)list3.get(i10);
                        ((PyFrameAccessor.PyAsyncValue)list2.get(i10)).getCallback().ok((Object)pyDebugValue.getValue());
                    }
                }
                catch (Exception exception) {
                    if (list2 == null) break block4;
                    for (PyFrameAccessor.PyAsyncValue pyAsyncValue : list2) {
                        pyAsyncValue.getCallback().error(new PyDebuggerException(response.toString()));
                    }
                }
            }
        }

        @Override
        public boolean IPythonEditor(String path, String line2) {
            return PydevConsoleCommunication.this.a(path);
        }
    }
}

