/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.completion.PydevConsoleElement;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PydevConsoleRunner {
    public static final Key<ConsoleCommunication> CONSOLE_COMMUNICATION_KEY;
    public static final Key<Sdk> CONSOLE_SDK;
    public static final long q;

    @Nullable
    public static PyRemotePathMapper getPathMapper(@NotNull Project project, Sdk sdk, PyConsoleOptions.PyConsoleSettings consoleSettings) {
        PythonRemoteInterpreterManager pythonRemoteInterpreterManager;
        if (project == null) {
            PydevConsoleRunner.a(0);
        }
        if (PySdkUtil.isRemote(sdk) && (pythonRemoteInterpreterManager = PythonRemoteInterpreterManager.getInstance()) != null) {
            PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            return PydevConsoleRunner.getPathMapper(project, consoleSettings, pythonRemoteInterpreterManager, pyRemoteSdkAdditionalDataBase);
        }
        return null;
    }

    @NotNull
    public static PyRemotePathMapper getPathMapper(@NotNull Project project, PyConsoleOptions.PyConsoleSettings consoleSettings, PythonRemoteInterpreterManager instance, PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData) {
        if (project == null) {
            PydevConsoleRunner.a(1);
        }
        PyRemotePathMapper pyRemotePathMapper = instance.setupMappings(project, remoteSdkAdditionalData, null);
        PathMappingSettings pathMappingSettings = consoleSettings.getMappingSettings();
        pyRemotePathMapper.addAll(pathMappingSettings.getPathMappings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        PyRemotePathMapper pyRemotePathMapper2 = pyRemotePathMapper;
        if (pyRemotePathMapper2 == null) {
            PydevConsoleRunner.a(2);
        }
        return pyRemotePathMapper2;
    }

    @NotNull
    public static Pair<Sdk, Module> findPythonSdkAndModule(@NotNull Project project, @Nullable Module contextModule) {
        if (project == null) {
            PydevConsoleRunner.a(3);
        }
        Sdk sdk = null;
        Module module2 = null;
        PyConsoleOptions.PyConsoleSettings pyConsoleSettings = PyConsoleOptions.getInstance(project).getPythonConsoleSettings();
        String string = pyConsoleSettings.getSdkHome();
        if (string != null) {
            sdk = PythonSdkType.findSdkByPath(string);
            if (pyConsoleSettings.getModuleName() != null) {
                module2 = ModuleManager.getInstance((Project)project).findModuleByName(pyConsoleSettings.getModuleName());
            } else {
                module2 = contextModule;
                if (module2 == null && ModuleManager.getInstance((Project)project).getModules().length > 0) {
                    module2 = ModuleManager.getInstance((Project)project).getModules()[0];
                }
            }
        }
        if (sdk == null && pyConsoleSettings.isUseModuleSdk()) {
            if (contextModule != null) {
                module2 = contextModule;
            } else if (pyConsoleSettings.getModuleName() != null) {
                module2 = ModuleManager.getInstance((Project)project).findModuleByName(pyConsoleSettings.getModuleName());
            }
            if (module2 != null && PythonSdkType.findPythonSdk(module2) != null) {
                sdk = PythonSdkType.findPythonSdk(module2);
            }
        } else if (contextModule != null) {
            if (module2 == null) {
                module2 = contextModule;
            }
            if (sdk == null) {
                sdk = PythonSdkType.findPythonSdk(module2);
            }
        }
        if (sdk == null) {
            for (Module module3 : ModuleManager.getInstance((Project)project).getModules()) {
                if (PythonSdkType.findPythonSdk(module3) == null) continue;
                sdk = PythonSdkType.findPythonSdk(module3);
                module2 = module3;
                break;
            }
        }
        if (sdk == null && PythonSdkType.getAllSdks().size() > 0) {
            sdk = PythonSdkType.getAllSdks().get(0);
        }
        Pair pair = Pair.create((Object)sdk, (Object)module2);
        if (pair == null) {
            PydevConsoleRunner.a(4);
        }
        return pair;
    }

    public static String constructPyPathAndWorkingDirCommand(@NotNull Collection<String> pythonPath, @Nullable String workingDir, @NotNull String command) {
        long l2 = q ^ 0x83EB04F5136L;
        if (pythonPath == null) {
            PydevConsoleRunner.a(5);
        }
        if (command == null) {
            PydevConsoleRunner.a(6);
        }
        if (workingDir != null) {
            pythonPath.add(workingDir);
        }
        String string2 = Joiner.on((String)", ").join((Iterable)Collections2.transform(pythonPath, string -> {
            long l2 = q ^ 0x27C752CD800AL;
            return "'" + string.replace("\\", "\\\\").replace("'", "\\'") + "'";
        }));
        return command.replace("WORKING_DIR_AND_PYTHON_PATHS", string2);
    }

    public static Map<String, String> addDefaultEnvironments(Sdk sdk, Map<String, String> envs, @NotNull Project project) {
        if (project == null) {
            PydevConsoleRunner.a(7);
        }
        PydevConsoleRunner.setCorrectStdOutEncoding(envs, project);
        PythonSdkFlavor.initPythonPath(envs, true, PythonCommandLineState.getAddedPaths(sdk));
        return envs;
    }

    public static void setCorrectStdOutEncoding(@NotNull Map<String, String> envs, @NotNull Project project) {
        if (envs == null) {
            PydevConsoleRunner.a(8);
        }
        if (project == null) {
            PydevConsoleRunner.a(9);
        }
        Charset charset = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
        String string = charset.name();
        PythonEnvUtil.setPythonIOEncoding(PythonEnvUtil.setPythonUnbuffered(envs), string);
    }

    public static void setCorrectStdOutEncoding(@NotNull GeneralCommandLine commandLine, @NotNull Project project) {
        if (commandLine == null) {
            PydevConsoleRunner.a(10);
        }
        if (project == null) {
            PydevConsoleRunner.a(11);
        }
        Charset charset = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
        commandLine.setCharset(charset);
        PythonEnvUtil.setPythonIOEncoding(commandLine.getEnvironment(), charset.name());
    }

    public static boolean isInPydevConsole(PsiElement element) {
        return element instanceof PydevConsoleElement || PydevConsoleRunner.getConsoleCommunication(element) != null || PydevConsoleRunner.hasConsoleKey(element);
    }

    public static boolean hasConsoleKey(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Boolean bl2 = (Boolean)element.getContainingFile().getVirtualFile().getUserData(PythonConsoleView.CONSOLE_KEY);
        return bl2 != null && bl2 != false;
    }

    public static boolean isPythonConsole(@Nullable ASTNode element) {
        return PydevConsoleRunner.getPythonConsoleData(element) != null;
    }

    @Nullable
    public static PythonConsoleData getPythonConsoleData(@Nullable ASTNode element) {
        if (element == null || element.getPsi() == null || element.getPsi().getContainingFile() == null) {
            return null;
        }
        VirtualFile virtualFile = PydevConsoleRunnerImpl.getConsoleFile(element.getPsi().getContainingFile());
        if (virtualFile == null) {
            return null;
        }
        return (PythonConsoleData)virtualFile.getUserData(PyConsoleUtil.PYTHON_CONSOLE_DATA);
    }

    @Nullable
    public static ConsoleCommunication getConsoleCommunication(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        return psiFile != null ? (ConsoleCommunication)psiFile.getCopyableUserData(CONSOLE_COMMUNICATION_KEY) : null;
    }

    @Nullable
    public static Sdk getConsoleSdk(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        return psiFile != null ? (Sdk)psiFile.getCopyableUserData(CONSOLE_SDK) : null;
    }

    public void open();

    public void runSync(boolean var1);

    public void run(boolean var1);

    public PydevConsoleCommunication getPydevConsoleCommunication();

    public void addConsoleListener(ConsoleListener var1);

    public PythonConsoleExecuteActionHandler getConsoleExecuteActionHandler();

    public PyConsoleProcessHandler getProcessHandler();

    public PythonConsoleView getConsoleView();

    static {
        q = c.a(5849874753212746529L, -7772187580969786792L, MethodHandles.lookup().lookupClass()).a(244706785750220L);
        long l2 = q ^ 0x45F6E31E7D63L;
        CONSOLE_COMMUNICATION_KEY = new Key("PYDEV_CONSOLE_COMMUNICATION_KEY");
        CONSOLE_SDK = new Key("PYDEV_CONSOLE_SDK_KEY");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = q ^ 0x5BD8CC10E762L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findPythonSdkAndModule";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPathMapper";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPythonSdkAndModule";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "constructPyPathAndWorkingDirCommand";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultEnvironments";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCorrectStdOutEncoding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ConsoleListener {
        public void handleConsoleInitialized(@NotNull LanguageConsoleView var1);
    }
}

