/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.runners.ConsoleTitleGen;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.SplitLineAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.console.PyConsoleDebugProcess;
import com.jetbrains.python.console.PyConsoleDebugProcessHandler;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PyConsoleRootType;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationServer;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandler;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreatorKt;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.console.actions.ShowVarsAction;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyVariableViewSettings;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunParams;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PySdkUtil;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PydevConsoleRunnerImpl
implements PydevConsoleRunner {
    public static final String WORKING_DIR_AND_PYTHON_PATHS = "WORKING_DIR_AND_PYTHON_PATHS";
    public static final String CONSOLE_START_COMMAND = "import sys; print('Python %s on %s' % (sys.version, sys.platform))\nsys.path.extend([WORKING_DIR_AND_PYTHON_PATHS])\n";
    public static final String STARTED_BY_RUNNER = "startedByRunner";
    private static final Logger n;
    public static final String PYDEV_PYDEVCONSOLE_PY = "pydev/pydevconsole.py";
    public static final int PORTS_WAITING_TIMEOUT = 20000;
    public static final String PYTON_INTERPRETER_NULL = "Python interpreter is not selected. Please setup Python interpreter first.";
    private final Project c;
    private final String a;
    @Nullable
    private final String d;
    private final Consumer<? super String> g;
    @Nullable
    private final Sdk i;
    private PydevConsoleCommunication e;
    private PyConsoleProcessHandler h;
    protected PythonConsoleExecuteActionHandler myConsoleExecuteActionHandler;
    private final List<PydevConsoleRunner.ConsoleListener> o;
    private final PyConsoleType f;
    @NotNull
    private final Map<String, String> b;
    @NotNull
    protected final PyConsoleOptions.PyConsoleSettings myConsoleSettings;
    private final String[] l;
    private RemoteConsoleProcessData m;
    private String j;
    private PythonConsoleView k;
    private static final long r;

    public PydevConsoleRunnerImpl(@NotNull Project project, @Nullable Sdk sdk, @NotNull PyConsoleType consoleType, @NotNull String title, @Nullable String workingDir, @NotNull Map<String, String> environmentVariables, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Consumer<? super String> rerunAction, String ... statementsToExecute) {
        if (project == null) {
            PydevConsoleRunnerImpl.b(0);
        }
        if (consoleType == null) {
            PydevConsoleRunnerImpl.b(1);
        }
        if (title == null) {
            PydevConsoleRunnerImpl.b(2);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.b(3);
        }
        if (settingsProvider == null) {
            PydevConsoleRunnerImpl.b(4);
        }
        if (rerunAction == null) {
            PydevConsoleRunnerImpl.b(5);
        }
        this.o = ContainerUtil.createLockFreeCopyOnWriteList();
        this.j = null;
        this.c = project;
        this.i = sdk;
        this.a = title;
        this.d = workingDir;
        this.f = consoleType;
        this.b = environmentVariables;
        this.myConsoleSettings = settingsProvider;
        this.l = statementsToExecute;
        this.g = rerunAction;
    }

    public PydevConsoleRunnerImpl(@NotNull Project project, @Nullable Sdk sdk, @NotNull PyConsoleType consoleType, @Nullable String workingDir, @NotNull Map<String, String> environmentVariables, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Consumer<? super String> rerunAction, String ... statementsToExecute) {
        if (project == null) {
            PydevConsoleRunnerImpl.b(6);
        }
        if (consoleType == null) {
            PydevConsoleRunnerImpl.b(7);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.b(8);
        }
        if (settingsProvider == null) {
            PydevConsoleRunnerImpl.b(9);
        }
        if (rerunAction == null) {
            PydevConsoleRunnerImpl.b(10);
        }
        this(project, sdk, consoleType, consoleType.getTitle(), workingDir, environmentVariables, settingsProvider, rerunAction, statementsToExecute);
    }

    public void setConsoleTitle(String consoleTitle) {
        this.j = consoleTitle;
    }

    private List<AnAction> a(DefaultActionGroup defaultActionGroup) {
        long l2 = r ^ 0x454FCCA36DA0L;
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        arrayList.add(this.createRerunAction());
        arrayList.add(this.j());
        arrayList.add((AnAction)new ConsoleExecuteAction((LanguageConsoleView)this.k, (ConsoleExecuteAction.ConsoleExecuteActionHandler)this.myConsoleExecuteActionHandler, this.myConsoleExecuteActionHandler.getEmptyExecuteAction(), (Condition)this.myConsoleExecuteActionHandler));
        defaultActionGroup.addAll(arrayList);
        defaultActionGroup.add((AnAction)new ConnectDebuggerAction(this));
        DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup("Settings", true);
        defaultActionGroup2.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        defaultActionGroup2.add((AnAction)new PyVariableViewSettings.SimplifiedView(null));
        defaultActionGroup2.add((AnAction)new PyVariableViewSettings.VariablesPolicyGroup());
        defaultActionGroup.add((AnAction)defaultActionGroup2);
        defaultActionGroup.add((AnAction)new NewConsoleAction());
        arrayList.add(PyConsoleUtil.createInterruptAction(this.k));
        arrayList.add(PyConsoleUtil.createTabCompletionAction(this.k));
        arrayList.add(this.createSplitLineAction());
        return arrayList;
    }

    private List<AnAction> b(DefaultActionGroup defaultActionGroup) {
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        arrayList.add((AnAction)new SoftWrapAction(this));
        arrayList.add(PyConsoleUtil.createScrollToEndAction(this.k.getEditor()));
        arrayList.add(PyConsoleUtil.createPrintAction(this.k));
        arrayList.add((AnAction)new ShowVarsAction(this.k, this.e));
        arrayList.add(ConsoleHistoryController.getController((LanguageConsoleView)this.k).getBrowseHistory());
        defaultActionGroup.addAll(arrayList);
        return arrayList;
    }

    @Override
    public void open() {
        PythonConsoleToolWindow pythonConsoleToolWindow = PythonConsoleToolWindow.getInstance(this.c);
        if (pythonConsoleToolWindow != null && pythonConsoleToolWindow.isInitialized()) {
            pythonConsoleToolWindow.getToolWindow().activate(() -> {}, true);
        } else {
            this.runSync(true);
        }
    }

    @Override
    public void runSync(final boolean requestEditorFocus) {
        long l2 = r ^ 0x6B186E8ED46FL;
        try {
            if (this.i == null) {
                throw new ExecutionException(PYTON_INTERPRETER_NULL);
            }
            this.a(this.i);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.c, "Connecting to Console", false){
                private static final long a = com.jetbrains.python.psi.c.a(1788815716419489115L, -8107975071317307770L, MethodHandles.lookup().lookupClass()).a(260361449582143L);

                public void run(@NotNull ProgressIndicator indicator) {
                    long l2 = a ^ 0x7E93D127B348L;
                    if (indicator == null) {
                        1.a(0);
                    }
                    indicator.setText("Connecting to console...");
                    PydevConsoleRunnerImpl.this.b(PydevConsoleRunnerImpl.this.l);
                    if (requestEditorFocus) {
                        PydevConsoleRunnerImpl.this.k.requestFocus();
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x1A65E9A9BD16L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$1", "run"));
                }
            });
        }
        catch (ExecutionException executionException) {
            n.warn("Error running console", (Throwable)executionException);
            this.a((Exception)((Object)executionException));
        }
    }

    @Override
    public void run(final boolean requestEditorFocus) {
        TransactionGuard.submitTransaction((Disposable)this.c, () -> FileDocumentManager.getInstance().saveAllDocuments());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            long l2 = r ^ 0x2F8E46DA5865L;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.c, "Connecting to Console", false){
                private static final long a = com.jetbrains.python.psi.c.a(648324429416175314L, -4149225020727187379L, MethodHandles.lookup().lookupClass()).a(215576019274202L);

                public void run(@NotNull ProgressIndicator indicator) {
                    long l2 = a ^ 0x4C1C861F433AL;
                    if (indicator == null) {
                        2.a(0);
                    }
                    indicator.setText("Connecting to console...");
                    try {
                        if (PydevConsoleRunnerImpl.this.i == null) {
                            throw new ExecutionException(PydevConsoleRunnerImpl.PYTON_INTERPRETER_NULL);
                        }
                        PydevConsoleRunnerImpl.this.a(PydevConsoleRunnerImpl.this.i);
                        PydevConsoleRunnerImpl.this.b(PydevConsoleRunnerImpl.this.l);
                        if (requestEditorFocus) {
                            PydevConsoleRunnerImpl.this.k.requestFocus();
                        }
                    }
                    catch (Exception exception) {
                        n.warn("Error running console", (Throwable)exception);
                        UIUtil.invokeAndWaitIfNeeded(() -> PydevConsoleRunnerImpl.this.a(exception));
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x3C23C085B61L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$2", "run"));
                }
            });
        });
    }

    private void a(Exception exception) {
        String[] stringArray;
        long l2 = r ^ 0x4B4299A60BA0L;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{this.createRerunAction()});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PydevConsoleRunnerErrors", (ActionGroup)defaultActionGroup, false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)actionToolbar.getComponent(), "West");
        NewErrorTreeViewPanel newErrorTreeViewPanel = new NewErrorTreeViewPanel(this.c, null, false, false, null);
        String[] stringArray2 = stringArray = StringUtil.isNotEmpty((String)exception.getMessage()) ? StringUtil.splitByLines((String)exception.getMessage()) : ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (stringArray.length == 0) {
            stringArray = new String[]{"Unknown error"};
        }
        newErrorTreeViewPanel.addMessage(4, stringArray, null, -1, -1, null);
        jPanel.add((Component)newErrorTreeViewPanel, "Center");
        RunContentDescriptor runContentDescriptor = new RunContentDescriptor(null, (ProcessHandler)this.h, (JComponent)jPanel, "Error running console");
        this.showContentDescriptor(runContentDescriptor);
    }

    protected void showContentDescriptor(RunContentDescriptor contentDescriptor) {
        long l2 = r ^ 0x4D1EDEF83780L;
        ToolWindow toolWindow = PythonConsoleToolWindow.getToolWindow(this.c);
        if (toolWindow != null) {
            toolWindow.getComponent().putClientProperty(STARTED_BY_RUNNER, "true");
            PythonConsoleToolWindow.getInstance(this.c).init(toolWindow, contentDescriptor);
        } else {
            ExecutionManager.getInstance((Project)this.c).getContentManager().showRunContent(PydevConsoleRunnerImpl.k(), contentDescriptor);
        }
    }

    private static Executor k() {
        return DefaultRunExecutor.getRunExecutorInstance();
    }

    public static int findAvailablePort(@NotNull Project project, PyConsoleType consoleType) throws ExecutionException {
        if (project == null) {
            PydevConsoleRunnerImpl.b(11);
        }
        try {
            return NetUtils.findAvailableSocketPort();
        }
        catch (IOException iOException) {
            ExecutionHelper.showErrors((Project)project, Collections.singletonList(iOException), (String)consoleType.getTitle(), null);
            throw new ExecutionException((Throwable)iOException);
        }
    }

    protected GeneralCommandLine createCommandLine(@NotNull Sdk sdk, @NotNull Map<String, String> environmentVariables, @Nullable String workingDir, int port2) {
        if (sdk == null) {
            PydevConsoleRunnerImpl.b(12);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.b(13);
        }
        return this.doCreateConsoleCmdLine(sdk, environmentVariables, workingDir, port2);
    }

    protected PythonConsoleRunParams createConsoleRunParams(@Nullable String workingDir, @NotNull Sdk sdk, @NotNull Map<String, String> environmentVariables) {
        if (sdk == null) {
            PydevConsoleRunnerImpl.b(14);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.b(15);
        }
        return new PythonConsoleRunParams(this.myConsoleSettings, workingDir, sdk, environmentVariables);
    }

    @NotNull
    protected GeneralCommandLine doCreateConsoleCmdLine(@NotNull Sdk sdk, @NotNull Map<String, String> environmentVariables, @Nullable String workingDir, int port2) {
        long l2 = r ^ 0x354BD13E7929L;
        if (sdk == null) {
            PydevConsoleRunnerImpl.b(16);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.b(17);
        }
        PythonConsoleRunParams pythonConsoleRunParams = this.createConsoleRunParams(workingDir, sdk, environmentVariables);
        GeneralCommandLine generalCommandLine = PythonCommandLineState.createPythonCommandLine(this.c, pythonConsoleRunParams, false, PtyCommandLine.isEnabled() && !SystemInfo.isWindows);
        generalCommandLine.withWorkDirectory(this.d);
        ParamsGroup paramsGroup = generalCommandLine.getParametersList().getParamsGroup("Exe Options");
        if (paramsGroup != null && !pythonConsoleRunParams.getInterpreterOptions().isEmpty()) {
            paramsGroup.addParametersString(pythonConsoleRunParams.getInterpreterOptions());
        }
        PydevConsoleCli.setupPythonConsoleScriptInClientMode(generalCommandLine, sdk, port2);
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        if (generalCommandLine2 == null) {
            PydevConsoleRunnerImpl.b(18);
        }
        return generalCommandLine2;
    }

    private PythonConsoleView b(@NotNull Sdk sdk) {
        if (sdk == null) {
            PydevConsoleRunnerImpl.b(19);
        }
        PythonConsoleView pythonConsoleView = new PythonConsoleView(this.c, this.a, sdk, false);
        this.e.setConsoleFile(pythonConsoleView.getVirtualFile());
        pythonConsoleView.addMessageFilter(new PythonTracebackFilter(this.c));
        return pythonConsoleView;
    }

    @NotNull
    private CommandLineProcess c(@NotNull Sdk sdk) throws ExecutionException {
        if (sdk == null) {
            PydevConsoleRunnerImpl.b(20);
        }
        if (PySdkUtil.isRemote(sdk)) {
            GeneralCommandLine generalCommandLine = this.createCommandLine(sdk, this.b, this.d, 0);
            PythonRemoteInterpreterManager pythonRemoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
            PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            PyRemotePathMapper pyRemotePathMapper = PydevConsoleRunner.getPathMapper(this.c, sdk, this.myConsoleSettings);
            if (pythonRemoteInterpreterManager != null && pyRemoteSdkAdditionalDataBase != null && pyRemotePathMapper != null) {
                RemoteConsoleProcessData remoteConsoleProcessData;
                this.m = remoteConsoleProcessData = PythonConsoleRemoteProcessCreatorKt.createRemoteConsoleProcess(generalCommandLine, pyRemotePathMapper, this.c, pyRemoteSdkAdditionalDataBase, this.getRunnerFileFromHelpers());
                this.e = remoteConsoleProcessData.getPydevConsoleCommunication();
                CommandLineProcess commandLineProcess = new CommandLineProcess(remoteConsoleProcessData.getProcess(), remoteConsoleProcessData.getCommandLine());
                if (commandLineProcess == null) {
                    PydevConsoleRunnerImpl.b(21);
                }
                return commandLineProcess;
            }
            throw new PythonRemoteInterpreterManager.PyRemoteInterpreterExecutionException();
        }
        int n2 = PydevConsoleRunnerImpl.findAvailablePort(this.c, this.f);
        GeneralCommandLine generalCommandLine = this.createCommandLine(sdk, this.b, this.d, n2);
        Map map2 = generalCommandLine.getEnvironment();
        EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((Map)map2, (Charset)generalCommandLine.getCharset());
        PydevConsoleCommunicationServer pydevConsoleCommunicationServer = new PydevConsoleCommunicationServer(this.c, n2);
        this.e = pydevConsoleCommunicationServer;
        try {
            pydevConsoleCommunicationServer.serve();
        }
        catch (Exception exception) {
            pydevConsoleCommunicationServer.close();
            throw new ExecutionException(exception.getMessage(), (Throwable)exception);
        }
        Process process2 = generalCommandLine.createProcess();
        pydevConsoleCommunicationServer.setPythonConsoleProcess(process2);
        CommandLineProcess commandLineProcess = new CommandLineProcess(process2, generalCommandLine.getCommandLineString());
        if (commandLineProcess == null) {
            PydevConsoleRunnerImpl.b(22);
        }
        return commandLineProcess;
    }

    protected String getRunnerFileFromHelpers() {
        long l2 = r ^ 0x2249DE087B84L;
        return PYDEV_PYDEVCONSOLE_PY;
    }

    public static int getRemotePortFromProcess(@NotNull Process process2) throws ExecutionException {
        if (process2 == null) {
            PydevConsoleRunnerImpl.b(23);
        }
        Scanner scanner = new Scanner(process2.getInputStream());
        return PydevConsoleRunnerImpl.a(scanner, process2);
    }

    private static int a(Scanner scanner, Process process2) throws ExecutionException {
        long l2 = r ^ 0x7AD5E75FE276L;
        long l3 = System.currentTimeMillis();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        while (System.currentTimeMillis() - l3 < 20000L) {
            String string;
            if (scanner.hasNextLine()) {
                string = scanner.nextLine();
                stringBuilder.append(string).append("\n");
                try {
                    int n2 = Integer.parseInt(string);
                    if (bl2) {
                        n.warn("Unexpected strings in output:\n" + stringBuilder.toString());
                    }
                    return n2;
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = true;
                    continue;
                }
            }
            TimeoutUtil.sleep((long)200L);
            if (process2.exitValue() == 0) break;
            try {
                string = "Console process terminated with error:\n" + StreamUtil.readText((InputStream)process2.getErrorStream()) + stringBuilder.toString();
            }
            catch (Exception exception) {
                string = "Console process terminated with exit code " + process2.exitValue() + ", output:" + stringBuilder.toString();
            }
            throw new ExecutionException(string);
        }
        throw new ExecutionException("Couldn't read integer value from stream");
    }

    private PyConsoleProcessHandler a(Process process2, String string, @NotNull Sdk sdk) {
        long l2 = r ^ 0x3854797C93E6L;
        if (sdk == null) {
            PydevConsoleRunnerImpl.b(24);
        }
        if (PySdkUtil.isRemote(sdk)) {
            PythonRemoteInterpreterManager pythonRemoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
            if (pythonRemoteInterpreterManager != null) {
                PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
                assert (pyRemoteSdkAdditionalDataBase != null);
                this.h = pythonRemoteInterpreterManager.createConsoleProcessHandler(process2, this.k, this.e, string, StandardCharsets.UTF_8, pythonRemoteInterpreterManager.setupMappings(this.c, pyRemoteSdkAdditionalDataBase, null), this.m.getSocketProvider());
            } else {
                n.error("Can't create remote console process handler");
            }
        } else {
            this.h = new PyConsoleProcessHandler(process2, this.k, this.e, string, StandardCharsets.UTF_8);
        }
        return this.h;
    }

    private void a(@NotNull Sdk sdk) throws ExecutionException {
        if (sdk == null) {
            PydevConsoleRunnerImpl.b(25);
        }
        CommandLineProcess commandLineProcess = this.c(sdk);
        Process process2 = commandLineProcess.getProcess();
        UIUtil.invokeAndWaitIfNeeded(() -> {
            this.k = this.b(sdk);
            if (this.k != null) {
                this.k.setBorder((Border)new SideBorder(JBColor.border(), 1));
            }
            this.e.setConsoleView(this.k);
            this.h = this.a(process2, commandLineProcess.getCommandLine(), sdk);
            this.myConsoleExecuteActionHandler = this.createExecuteActionHandler();
            ProcessTerminatedListener.attach((ProcessHandler)this.h);
            final PythonConsoleView pythonConsoleView = this.k;
            this.h.addProcessListener((ProcessListener)new ProcessAdapter(){
                private static final long a = com.jetbrains.python.psi.c.a(-4653148934395867181L, -5880826275693664073L, MethodHandles.lookup().lookupClass()).a(94310440413488L);

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        3.a(0);
                    }
                    pythonConsoleView.setEditable(false);
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x3217FB5ABCADL;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/console/PydevConsoleRunnerImpl$3", "processTerminated"));
                }
            });
            this.k.attachToProcess((ProcessHandler)this.h);
            this.createContentDescriptorAndActions();
            this.h.startNotify();
        });
    }

    protected void createContentDescriptorAndActions() {
        long l2 = r ^ 0x801B0E5BD2DL;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PydevConsoleRunner", (ActionGroup)defaultActionGroup, false);
        DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup();
        ActionToolbar actionToolbar2 = ActionManager.getInstance().createActionToolbar("PydevConsoleRunner", (ActionGroup)defaultActionGroup2, false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)actionToolbar.getComponent(), "West");
        JComponent jComponent = actionToolbar2.getComponent();
        int n2 = jComponent.getBorder().getBorderInsets((Component)jComponent).left;
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, JBColor.border()), (Border)new JBEmptyBorder(n2)));
        jPanel.add((Component)jComponent, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)this.k.getComponent(), "Center");
        actionToolbar.setTargetComponent((JComponent)jPanel2);
        actionToolbar2.setTargetComponent((JComponent)jPanel2);
        if (this.j == null) {
            this.j = new ConsoleTitleGen(this.c, this.a){
                private static final long a = com.jetbrains.python.psi.c.a(4250254098007805362L, 8827888502269441223L, MethodHandles.lookup().lookupClass()).a(114679974458791L);

                @NotNull
                protected List<String> getActiveConsoles(@NotNull String consoleTitle) {
                    PythonConsoleToolWindow pythonConsoleToolWindow;
                    if (consoleTitle == null) {
                        4.a(0);
                    }
                    if ((pythonConsoleToolWindow = PythonConsoleToolWindow.getInstance(PydevConsoleRunnerImpl.this.c)) != null && pythonConsoleToolWindow.isInitialized() && pythonConsoleToolWindow.getToolWindow() != null) {
                        List<String> list2 = Lists.newArrayList((Object[])pythonConsoleToolWindow.getToolWindow().getContentManager().getContents()).stream().map(content2 -> content2.getDisplayName()).filter(string -> string.startsWith(PydevConsoleRunnerImpl.this.a)).collect(Collectors.toList());
                        if (list2 == null) {
                            4.a(1);
                        }
                        return list2;
                    }
                    List list3 = super.getActiveConsoles(consoleTitle);
                    if (list3 == null) {
                        4.a(2);
                    }
                    return list3;
                }

                private static /* synthetic */ void a(int n2) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n3;
                    String string;
                    long l2 = a ^ 0x551913BB6802L;
                    switch (n2) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            n3 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n3 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "consoleTitle";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$4";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$4";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActiveConsoles";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getActiveConsoles";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n2) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }.makeTitle();
        }
        RunContentDescriptor runContentDescriptor = new RunContentDescriptor((ExecutionConsole)this.k, (ProcessHandler)this.h, (JComponent)jPanel2, this.j, null);
        Disposer.register((Disposable)this.c, (Disposable)runContentDescriptor);
        runContentDescriptor.setFocusComputable(() -> this.k.getConsoleEditor().getContentComponent());
        runContentDescriptor.setAutoFocusContent(true);
        List<AnAction> list2 = this.a(defaultActionGroup);
        List<AnAction> list3 = this.b(defaultActionGroup2);
        list2.addAll(list3);
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(list2, (JComponent)this.k.getConsoleEditor().getComponent());
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(list2, (JComponent)jPanel2);
        this.getConsoleView().addConsoleFolding(false, false);
        this.showContentDescriptor(runContentDescriptor);
    }

    private void b(String[] stringArray) {
        long l2 = r ^ 0x22BDF79F8D70L;
        if (this.b()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                final PythonConsoleView pythonConsoleView = this.k;
                pythonConsoleView.setConsoleCommunication((ConsoleCommunication)this.e);
                pythonConsoleView.setSdk(this.i);
                pythonConsoleView.setExecutionHandler(this.myConsoleExecuteActionHandler);
                this.h.addProcessListener((ProcessListener)new ProcessAdapter(){
                    private static final long a = com.jetbrains.python.psi.c.a(3665626911414158396L, 222573296409263211L, MethodHandles.lookup().lookupClass()).a(19833981539091L);

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            5.a(0);
                        }
                        if (outputType == null) {
                            5.a(1);
                        }
                        pythonConsoleView.print(event.getText(), outputType);
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        long l2 = a ^ 0x1CB6AC86BC14L;
                        Object[] objectArray2 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$5";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                this.a();
                if (stringArray.length == 1 && stringArray[0].isEmpty()) {
                    stringArray[0] = "\t";
                }
                for (String string : stringArray) {
                    pythonConsoleView.executeStatement(string + "\n", ProcessOutputTypes.SYSTEM);
                }
                this.a((LanguageConsoleView)pythonConsoleView);
                pythonConsoleView.initialized();
            });
        } else {
            this.k.print("Couldn't connect to console process.", ProcessOutputTypes.STDERR);
            this.h.destroyProcess();
            this.k.setEditable(false);
        }
    }

    protected AnAction createRerunAction() {
        return new RestartAction(this);
    }

    private void a() {
        this.myConsoleExecuteActionHandler.setEnabled(true);
    }

    private boolean b() {
        return this.e.handshake();
    }

    private AnAction j() {
        long l2 = r ^ 0x573384EBB1FDL;
        return new DumbAwareAction("Stop Console", "Stop Python Console", AllIcons.Actions.Suspend){
            private static final long a = com.jetbrains.python.psi.c.a(-8672587558861825929L, 6429524894352389562L, MethodHandles.lookup().lookupClass()).a(117044305036680L);

            public void update(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    6.a(0);
                }
                e10.getPresentation().setEnabled(!PydevConsoleRunnerImpl.this.h());
            }

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    6.a(1);
                }
                PydevConsoleRunnerImpl.this.g();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x7296B5B47C46L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$6";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void g() {
        if (this.e != null) {
            try {
                this.i();
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected AnAction createSplitLineAction() {
        class ConsoleSplitLineAction
        extends EditorAction {
            private static final String a = "Console.SplitLine";
            private static final long b = com.jetbrains.python.psi.c.a(1151443202344036349L, -7122006991267738996L, MethodHandles.lookup().lookupClass()).a(190003604450456L);

            ConsoleSplitLineAction() {
                super((EditorActionHandler)new EditorWriteActionHandler(){
                    private final SplitLineAction a = new SplitLineAction();

                    public boolean isEnabled(Editor editor2, DataContext dataContext) {
                        return this.a.getHandler().isEnabled(editor2, dataContext);
                    }

                    public void executeWriteAction(Editor editor2, @Nullable Caret caret, DataContext dataContext) {
                        ((EditorWriteActionHandler)this.a.getHandler()).executeWriteAction(editor2, caret, dataContext);
                        editor2.getCaretModel().getCurrentCaret().moveCaretRelatively(0, 1, false, true);
                    }
                });
            }

            public void setup() {
                long l2 = b ^ 0x6835F8B4E4EDL;
                EmptyAction.setupAction((AnAction)this, (String)a, null);
            }
        }
        ConsoleSplitLineAction consoleSplitLineAction = new ConsoleSplitLineAction();
        consoleSplitLineAction.setup();
        return consoleSplitLineAction;
    }

    private void i() {
        if (!this.h.isProcessTerminated()) {
            this.e.close();
        }
    }

    private boolean h() {
        return this.h.isProcessTerminated();
    }

    @NotNull
    protected PythonConsoleExecuteActionHandler createExecuteActionHandler() {
        this.myConsoleExecuteActionHandler = new PydevConsoleExecuteActionHandler((LanguageConsoleView)this.k, (ProcessHandler)this.h, (ConsoleCommunication)this.e);
        this.myConsoleExecuteActionHandler.setEnabled(false);
        new ConsoleHistoryController((ConsoleRootType)PyConsoleRootType.Companion.getInstance(), "", (LanguageConsoleView)this.k).install();
        PythonConsoleExecuteActionHandler pythonConsoleExecuteActionHandler = this.myConsoleExecuteActionHandler;
        if (pythonConsoleExecuteActionHandler == null) {
            PydevConsoleRunnerImpl.b(26);
        }
        return pythonConsoleExecuteActionHandler;
    }

    @Override
    public PydevConsoleCommunication getPydevConsoleCommunication() {
        return this.e;
    }

    static VirtualFile getConsoleFile(PsiFile psiFile) {
        VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
        if (virtualFile instanceof LightVirtualFile) {
            virtualFile = ((LightVirtualFile)virtualFile).getOriginalFile();
        }
        return virtualFile;
    }

    @Override
    public void addConsoleListener(PydevConsoleRunner.ConsoleListener consoleListener) {
        this.o.add(consoleListener);
    }

    private void a(@NotNull LanguageConsoleView languageConsoleView) {
        if (languageConsoleView == null) {
            PydevConsoleRunnerImpl.b(27);
        }
        for (PydevConsoleRunner.ConsoleListener consoleListener : this.o) {
            consoleListener.handleConsoleInitialized(languageConsoleView);
        }
        this.o.clear();
    }

    @Override
    public PythonConsoleExecuteActionHandler getConsoleExecuteActionHandler() {
        return this.myConsoleExecuteActionHandler;
    }

    private void c() {
        long l2 = r ^ 0x3BF8526F571EL;
        new Task.Backgroundable(this.c, "Restarting Console", true){
            private static final long a = com.jetbrains.python.psi.c.a(-8861992256720011118L, -9214016219763214616L, MethodHandles.lookup().lookupClass()).a(46799154969995L);

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.a(0);
                }
                if (PydevConsoleRunnerImpl.this.h != null) {
                    UIUtil.invokeAndWaitIfNeeded(() -> PydevConsoleRunnerImpl.this.i());
                    boolean bl2 = PydevConsoleRunnerImpl.this.h.waitFor(5000L);
                    if (!bl2 && PydevConsoleRunnerImpl.this.h.canKillProcess()) {
                        PydevConsoleRunnerImpl.this.h.killProcess();
                    }
                    PydevConsoleRunnerImpl.this.h.waitFor();
                }
                GuiUtils.invokeLaterIfNeeded(() -> PydevConsoleRunnerImpl.this.g.consume((Object)PydevConsoleRunnerImpl.this.j), (ModalityState)ModalityState.defaultModalityState());
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x1B6BAA86B5D1L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$7", "run"));
            }
        }.queue();
    }

    private XDebugSession f() throws ExecutionException {
        long l2 = r ^ 0x7BBBDC79B1F2L;
        final ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
        return XDebuggerManager.getInstance((Project)this.c).startSessionAndShowTab("Python Console Debugger", PythonIcons.Python.Python, null, true, new XDebugProcessStarter(){
            private static final long a = com.jetbrains.python.psi.c.a(4667454115132911647L, 688981511254427242L, MethodHandles.lookup().lookupClass()).a(195711004527195L);

            @NotNull
            public XDebugProcess start(final @NotNull XDebugSession session) {
                long l2 = a ^ 0x2E4E75A592DL;
                if (session == null) {
                    8.a(0);
                }
                PythonDebugLanguageConsoleView pythonDebugLanguageConsoleView = new PythonDebugLanguageConsoleView(PydevConsoleRunnerImpl.this.c, PydevConsoleRunnerImpl.this.i);
                PyConsoleDebugProcessHandler pyConsoleDebugProcessHandler = new PyConsoleDebugProcessHandler(PydevConsoleRunnerImpl.this.h);
                PyConsoleDebugProcess pyConsoleDebugProcess = new PyConsoleDebugProcess(session, serverSocket, (ExecutionConsole)pythonDebugLanguageConsoleView, pyConsoleDebugProcessHandler);
                PythonDebugConsoleCommunication pythonDebugConsoleCommunication = PyDebugRunner.initDebugConsoleView(PydevConsoleRunnerImpl.this.c, pyConsoleDebugProcess, pythonDebugLanguageConsoleView, pyConsoleDebugProcessHandler, session);
                pythonDebugConsoleCommunication.addCommunicationListener(new ConsoleCommunicationListener(){

                    public void commandExecuted(boolean more) {
                        session.rebuildViews();
                    }

                    public void inputRequested() {
                    }
                });
                PydevConsoleRunnerImpl.this.e.setDebugCommunication(pythonDebugConsoleCommunication);
                pythonDebugLanguageConsoleView.attachToProcess(pyConsoleDebugProcessHandler);
                pyConsoleDebugProcess.waitForNextConnection();
                try {
                    pyConsoleDebugProcess.connect(PydevConsoleRunnerImpl.this.e);
                }
                catch (Exception exception) {
                    n.error((Throwable)exception);
                }
                PydevConsoleRunnerImpl.this.h.notifyTextAvailable("\nDebugger connected.\n", ProcessOutputTypes.STDERR);
                PyConsoleDebugProcess pyConsoleDebugProcess2 = pyConsoleDebugProcess;
                if (pyConsoleDebugProcess2 == null) {
                    8.a(1);
                }
                return pyConsoleDebugProcess2;
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0x666BC73C0794L;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$8";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$8";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Override
    public PyConsoleProcessHandler getProcessHandler() {
        return this.h;
    }

    @Override
    public PythonConsoleView getConsoleView() {
        return this.k;
    }

    public static PythonConsoleRunnerFactory factory() {
        return new PydevConsoleRunnerFactory();
    }

    static {
        r = com.jetbrains.python.psi.c.a(215229520176474994L, -4707833836362973261L, MethodHandles.lookup().lookupClass()).a(143060032534476L);
        n = Logger.getInstance(PydevConsoleRunnerImpl.class);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = r ^ 0x60F9903C345AL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 26: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentVariables";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunAction";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConsoleCmdLine";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecuteActionHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAvailablePort";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunParams";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConsoleCmdLine";
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 26: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleView";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRemotePortFromProcess";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "initAndRun";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fireConsoleInitializedEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PythonConsoleRunParams
    implements PythonRunParams {
        private final PyConsoleOptions.PyConsoleSettings a;
        private final String b;
        private final Sdk d;
        private final Map<String, String> c;
        private static final long e = com.jetbrains.python.psi.c.a(-3725651819136211793L, -5138366822667427346L, MethodHandles.lookup().lookupClass()).a(25031595060631L);

        public PythonConsoleRunParams(@NotNull PyConsoleOptions.PyConsoleSettings consoleSettings, @Nullable String workingDir, @NotNull Sdk sdk, @NotNull Map<String, String> envs) {
            long l2 = e ^ 0x6438D33ADE9EL;
            if (consoleSettings == null) {
                PythonConsoleRunParams.a(0);
            }
            if (sdk == null) {
                PythonConsoleRunParams.a(1);
            }
            if (envs == null) {
                PythonConsoleRunParams.a(2);
            }
            this.a = consoleSettings;
            this.b = workingDir;
            this.d = sdk;
            this.c = envs;
            this.c.putAll(consoleSettings.getEnvs());
            PyDebuggerSettings pyDebuggerSettings = PyDebuggerSettings.getInstance();
            if (pyDebuggerSettings.getValuesPolicy() != PyDebugValue.ValuesPolicy.SYNC) {
                this.c.put((String)PyDebugValue.POLICY_ENV_VARS.get(pyDebuggerSettings.getValuesPolicy()), "True");
            }
        }

        @Override
        public String getInterpreterOptions() {
            return this.a.getInterpreterOptions();
        }

        @Override
        public void setInterpreterOptions(String interpreterOptions) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWorkingDirectory() {
            return this.b;
        }

        @Override
        public void setWorkingDirectory(String workingDirectory) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String getSdkHome() {
            return this.d.getHomePath();
        }

        @Override
        public void setSdkHome(String sdkHome) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setModule(Module module2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getModuleName() {
            return this.a.getModuleName();
        }

        @Override
        public boolean isUseModuleSdk() {
            return this.a.isUseModuleSdk();
        }

        @Override
        public void setUseModuleSdk(boolean useModuleSdk) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPassParentEnvs() {
            return this.a.isPassParentEnvs();
        }

        @Override
        public void setPassParentEnvs(boolean passParentEnvs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getEnvs() {
            return this.c;
        }

        @Override
        public void setEnvs(Map<String, String> envs) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public PathMappingSettings getMappingSettings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean shouldAddContentRoots() {
            return this.a.shouldAddContentRoots();
        }

        @Override
        public boolean shouldAddSourceRoots() {
            return this.a.shouldAddSourceRoots();
        }

        @Override
        public void setAddContentRoots(boolean flag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAddSourceRoots(boolean flag) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = e ^ 0x3C9856885293L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleSettings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "envs";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$PythonConsoleRunParams";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NewConsoleAction
    extends AnAction
    implements DumbAware {
        private static final long a = com.jetbrains.python.psi.c.a(-4960947217174480921L, 7474238157867943573L, MethodHandles.lookup().lookupClass()).a(190986785254628L);

        NewConsoleAction() {
            long l2 = a ^ 0x7FD2C1939EDL;
            super("New Console", "Creates new python console", AllIcons.General.Add);
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                NewConsoleAction.a(0);
            }
            e10.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            Project project;
            if (e10 == null) {
                NewConsoleAction.a(1);
            }
            if ((project = (Project)e10.getData(CommonDataKeys.PROJECT)) != null) {
                PydevConsoleRunner pydevConsoleRunner = PythonConsoleRunnerFactory.getInstance().createConsoleRunner(project, (Module)e10.getData(LangDataKeys.MODULE));
                pydevConsoleRunner.run(true);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x39A33B4992F3L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$NewConsoleAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ConnectDebuggerAction
    extends ToggleAction
    implements DumbAware {
        private boolean a;
        private XDebugSession b;
        final /* synthetic */ PydevConsoleRunnerImpl this$0;
        private static final long c = com.jetbrains.python.psi.c.a(6497029305150787544L, -8147989525240089688L, MethodHandles.lookup().lookupClass()).a(197193006516967L);

        ConnectDebuggerAction(PydevConsoleRunnerImpl pydevConsoleRunnerImpl) {
            long l2 = c ^ 0x63379497FD79L;
            this.this$0 = pydevConsoleRunnerImpl;
            super("Attach Debugger", "Enables tracing of code executed in console", AllIcons.Actions.StartDebugger);
            this.a = false;
            this.b = null;
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                ConnectDebuggerAction.a(0);
            }
            return this.a;
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                ConnectDebuggerAction.a(1);
            }
            if (this.b != null) {
                e10.getPresentation().setEnabled(false);
            } else {
                super.update(e10);
                e10.getPresentation().setEnabled(true);
            }
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean state2) {
            long l2 = c ^ 0x6547E377BDC1L;
            if (e10 == null) {
                ConnectDebuggerAction.a(2);
            }
            this.a = state2;
            if (this.a) {
                try {
                    this.b = this.this$0.f();
                }
                catch (Exception exception) {
                    n.error((Throwable)exception);
                    Messages.showErrorDialog((String)"Can't connect to debugger", (String)"Error Connecting Debugger");
                }
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = c ^ 0x653BFD6E975DL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$ConnectDebuggerAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CommandLineProcess {
        @NotNull
        private final Process a;
        @Nullable
        private final String b;
        private static final long c = com.jetbrains.python.psi.c.a(-6262363159490202983L, 2616817199890460801L, MethodHandles.lookup().lookupClass()).a(268796725806806L);

        private CommandLineProcess(@NotNull Process process2, @Nullable String commandLine) {
            if (process2 == null) {
                CommandLineProcess.a(0);
            }
            this.a = process2;
            this.b = commandLine;
        }

        @NotNull
        public Process getProcess() {
            Process process2 = this.a;
            if (process2 == null) {
                CommandLineProcess.a(1);
            }
            return process2;
        }

        @Nullable
        public String getCommandLine() {
            return this.b;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0xEF5611B867BL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$CommandLineProcess";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$CommandLineProcess";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcess";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RestartAction
    extends AnAction {
        private final PydevConsoleRunnerImpl a;
        private static final long b = com.jetbrains.python.psi.c.a(8330138103221531964L, 1161170499632600912L, MethodHandles.lookup().lookupClass()).a(19512343066616L);

        private RestartAction(PydevConsoleRunnerImpl runner) {
            long l2 = b ^ 0x40BB9127B938L;
            ActionUtil.copyFrom((AnAction)this, (String)"Rerun");
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Restart);
            this.a = runner;
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                RestartAction.a(0);
            }
            this.a.c();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x2FA4115BC384L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/console/PydevConsoleRunnerImpl$RestartAction", "actionPerformed"));
        }
    }

    private class SoftWrapAction
    extends ToggleAction
    implements DumbAware {
        private boolean a;
        final /* synthetic */ PydevConsoleRunnerImpl this$0;
        private static final long b = com.jetbrains.python.psi.c.a(-2050395690090866837L, -5531507482729373152L, MethodHandles.lookup().lookupClass()).a(213621639431019L);

        SoftWrapAction(PydevConsoleRunnerImpl pydevConsoleRunnerImpl) {
            long l2 = b ^ 0x4A3966307D28L;
            this.this$0 = pydevConsoleRunnerImpl;
            super(ActionsBundle.actionText((String)"EditorToggleUseSoftWraps"), ActionsBundle.actionDescription((String)"EditorToggleUseSoftWraps"), AllIcons.Actions.ToggleSoftWrap);
            this.a = this.this$0.myConsoleSettings.isUseSoftWraps();
            this.a();
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SoftWrapAction.a(0);
            }
            return this.a;
        }

        private void a() {
            this.this$0.k.getEditor().getSettings().setUseSoftWraps(this.a);
            this.this$0.k.getConsoleEditor().getSettings().setUseSoftWraps(this.a);
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean state2) {
            if (e10 == null) {
                SoftWrapAction.a(1);
            }
            this.a = state2;
            this.a();
            this.this$0.myConsoleSettings.setUseSoftWraps(this.a);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = b ^ 0x46519B33A78EL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$SoftWrapAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

