/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.JBSplitter;
import com.intellij.util.TimeoutUtil;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.console.ConsolePromptDecorator;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PyConsoleCopyHandler;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleSourceHighlighter;
import com.jetbrains.python.console.PyConsoleStartFolding;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.completion.PythonConsoleAutopopupBlockingHandler;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.testing.PyTestsSharedKt;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonConsoleView
extends LanguageConsoleImpl
implements ObservableConsoleView,
PyCodeExecutor {
    static Key<Boolean> CONSOLE_KEY;
    private static final Logger e;
    private final ConsolePromptDecorator k;
    private final boolean c;
    private PythonConsoleExecuteActionHandler a;
    private PyConsoleSourceHighlighter i;
    private boolean f;
    private final PyHighlighter b;
    private final EditorColorsScheme d;
    private boolean j;
    private XStandaloneVariablesView h;
    private final ActionCallback g = new ActionCallback();
    private boolean l;
    @Nullable
    private String m;
    private static final long n;

    public PythonConsoleView(Project project, String title, @Nullable Sdk sdk, boolean testMode) {
        super(project, title, (Language)PythonLanguage.getInstance());
        Object object;
        this.c = testMode;
        this.l = PyConsoleOptions.getInstance(project).isShowVariableByDefault();
        VirtualFile virtualFile = this.getVirtualFile();
        virtualFile.putUserData(LanguageLevel.KEY, (Object)PythonSdkType.getLanguageLevelForSdk(sdk));
        virtualFile.putUserData(CONSOLE_KEY, (Object)true);
        this.getConsoleEditor().putUserData(PythonConsoleAutopopupBlockingHandler.REPL_KEY, new Object());
        this.getHistoryViewer().putUserData(ConsoleViewUtil.EDITOR_IS_CONSOLE_HISTORY_VIEW, (Object)true);
        super.setPrompt(null);
        this.setUpdateFoldingsEnabled(false);
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (sdk != null) {
            object = PythonSdkFlavor.getFlavor(sdk);
            if (object != null) {
                languageLevel = ((PythonSdkFlavor)object).getLanguageLevel(sdk);
            }
            this.m = sdk.getHomePath();
        }
        this.b = new PyHighlighter(languageLevel);
        this.d = this.getConsoleEditor().getColorsScheme();
        object = PyConsoleUtil.getOrCreateIPythonData(this.getVirtualFile());
        this.k = new ConsolePromptDecorator(this.getConsoleEditor(), (PythonConsoleData)object);
    }

    public void setConsoleCommunication(ConsoleCommunication communication) {
        this.getFile().putCopyableUserData(PydevConsoleRunner.CONSOLE_COMMUNICATION_KEY, (Object)communication);
        if (this.l && communication instanceof PydevConsoleCommunication) {
            this.showVariables((PydevConsoleCommunication)communication);
        }
    }

    @Nullable
    private PyConsoleStartFolding a(boolean bl2) {
        PyConsoleStartFolding pyConsoleStartFolding = new PyConsoleStartFolding(this, bl2);
        this.a.getConsoleCommunication().addCommunicationListener((ConsoleCommunicationListener)pyConsoleStartFolding);
        Editor editor2 = this.getEditor();
        if (editor2 == null) {
            return null;
        }
        editor2.getDocument().addDocumentListener((DocumentListener)pyConsoleStartFolding);
        ((FoldingModelEx)editor2.getFoldingModel()).addListener((FoldingListener)pyConsoleStartFolding, (Disposable)this);
        return pyConsoleStartFolding;
    }

    public void addConsoleFolding(boolean isDebugConsole, boolean addOnce) {
        try {
            if (isDebugConsole && this.a != null && this.getEditor() != null) {
                PyConsoleStartFolding pyConsoleStartFolding = this.a(addOnce);
                if (pyConsoleStartFolding != null) {
                    pyConsoleStartFolding.setStartLineOffset(this.getEditor().getDocument().getTextLength());
                    pyConsoleStartFolding.setNumberOfCommandToStop(2);
                }
            } else {
                this.g.doWhenDone(() -> this.a(addOnce));
            }
        }
        catch (Exception exception) {
            e.error(exception.getMessage());
        }
    }

    public void setExecutionHandler(@NotNull PythonConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (consoleExecuteActionHandler == null) {
            PythonConsoleView.a(0);
        }
        this.a = consoleExecuteActionHandler;
    }

    public PythonConsoleExecuteActionHandler getExecuteActionHandler() {
        return this.a;
    }

    public void setConsoleEnabled(boolean flag) {
        if (this.a != null) {
            this.a.setEnabled(flag);
        } else {
            this.g.doWhenDone(() -> this.a.setEnabled(flag));
        }
    }

    public void inputRequested() {
        ConsoleCommunication consoleCommunication;
        if (this.a != null && (consoleCommunication = this.a.getConsoleCommunication()) instanceof PythonDebugConsoleCommunication) {
            consoleCommunication.notifyInputRequested();
        }
    }

    public void inputReceived() {
        if (this.a != null) {
            this.a.getConsoleCommunication().notifyInputReceived();
        }
    }

    public void requestFocus() {
        this.g.doWhenDone(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getConsoleEditor().getContentComponent(), true));
    }

    @Override
    public void executeCode(final @Nullable String code, @Nullable Editor editor2) {
        this.g.doWhenDone(() -> {
            long l2 = n ^ 0x778A733A45A4L;
            if (code != null) {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Executing Code in Console...", true){
                    private static final long a = com.jetbrains.python.psi.c.a(374795883673911353L, -7741440985406323899L, MethodHandles.lookup().lookupClass()).a(227377120206243L);

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.a(0);
                        }
                        while (!(PythonConsoleView.this.a.isEnabled() && PythonConsoleView.this.a.canExecuteNow() || indicator.isCanceled())) {
                            TimeoutUtil.sleep((long)300L);
                        }
                        if (!indicator.isCanceled()) {
                            PythonConsoleView.this.executeInConsole(code);
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x382C530BC1F2L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PythonConsoleView$1", "run"));
                    }
                });
            } else {
                this.requestFocus();
            }
        });
    }

    public void executeInConsole(@NotNull String code) {
        if (code == null) {
            PythonConsoleView.a(1);
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        TransactionGuard.submitTransaction((Disposable)this, () -> {
            String string2 = code.endsWith("\n") || this.a.checkSingleLine(code) ? code : code + "\n";
            DocumentEx documentEx = this.getConsoleEditor().getDocument();
            String string3 = documentEx.getText();
            ApplicationManager.getApplication().runWriteAction(() -> {
                this.setInputText(string2);
                PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument((Document)documentEx);
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile((Document)documentEx);
                if (psiFile != null) {
                    CommandProcessor.getInstance().runUndoTransparentAction(() -> CodeStyleManager.getInstance((Project)this.getProject()).adjustLineIndent(psiFile, new TextRange(0, psiFile.getTextLength())));
                }
                int n2 = this.getConsoleEditor().getCaretModel().getOffset();
                this.getConsoleEditor().getCaretModel().moveToOffset(documentEx.getTextLength());
                this.a.runExecuteAction((LanguageConsoleView)this);
                if (!StringUtil.isEmpty((String)string3)) {
                    ApplicationManager.getApplication().runWriteAction(() -> this.setInputText(string3));
                    this.getConsoleEditor().getCaretModel().moveToOffset(n2);
                }
            });
            countDownLatch.countDown();
        });
        try {
            countDownLatch.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void executeStatement(@NotNull String statement, @NotNull Key attributes) {
        if (statement == null) {
            PythonConsoleView.a(2);
        }
        if (attributes == null) {
            PythonConsoleView.a(3);
        }
        this.print(statement, this.outputTypeForAttributes(attributes));
        this.a.processLine(statement);
    }

    public void printText(String text2, ConsoleViewContentType outputType) {
        super.print(text2, outputType);
    }

    public void print(String text2, @NotNull Key attributes) {
        if (attributes == null) {
            PythonConsoleView.a(4);
        }
        this.print(text2, this.outputTypeForAttributes(attributes));
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType outputType) {
        if (text2 == null) {
            PythonConsoleView.a(5);
        }
        if (outputType == null) {
            PythonConsoleView.a(6);
        }
        if (this.c) {
            text2 = PyTestsSharedKt.processTCMessage(text2);
        }
        this.detectIPython(text2, outputType);
        if (PyConsoleUtil.detectIPythonEnd(text2)) {
            this.f = false;
            this.i = null;
        } else if (PyConsoleUtil.detectIPythonStart(text2)) {
            this.f = true;
        } else if (this.i == null || outputType == ConsoleViewContentType.ERROR_OUTPUT) {
            if (this.j) {
                this.a(text2, outputType);
            } else {
                super.print(text2, outputType);
            }
            this.j = this.a(text2);
            if (this.i == null && this.f && PyConsoleUtil.detectSourcePrinting(text2)) {
                this.i = new PyConsoleSourceHighlighter(this, this.d, this.b);
            }
        } else {
            try {
                this.i.printHighlightedSource(text2);
            }
            catch (Exception exception) {
                e.error((Throwable)exception);
            }
        }
    }

    public void detectIPython(String text2, ConsoleViewContentType outputType) {
        VirtualFile virtualFile = this.getVirtualFile();
        if (PyConsoleUtil.detectIPythonImported(text2, outputType)) {
            PyConsoleUtil.markIPython(virtualFile);
            PythonConsoleExecuteActionHandler pythonConsoleExecuteActionHandler = this.getExecuteActionHandler();
            if (pythonConsoleExecuteActionHandler != null) {
                pythonConsoleExecuteActionHandler.updateConsoleState();
            }
        }
        if (PyConsoleUtil.detectIPythonAutomagicOn(text2)) {
            PyConsoleUtil.setIPythonAutomagic(virtualFile, true);
        }
        if (PyConsoleUtil.detectIPythonAutomagicOff(text2)) {
            PyConsoleUtil.setIPythonAutomagic(virtualFile, false);
        }
    }

    private boolean a(@NotNull String string) {
        long l2 = n ^ 0x4B1A34DAC9E3L;
        if (string == null) {
            PythonConsoleView.a(7);
        }
        return this.f && string.startsWith("File:");
    }

    private void a(@NotNull String string, @NotNull ConsoleViewContentType consoleViewContentType) {
        if (string == null) {
            PythonConsoleView.a(8);
        }
        if (consoleViewContentType == null) {
            PythonConsoleView.a(9);
        }
        if (!StringUtil.isEmpty((String)string)) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string.trim());
            if (virtualFile != null) {
                OpenFileHyperlinkInfo openFileHyperlinkInfo = new OpenFileHyperlinkInfo(this.getProject(), virtualFile, -1);
                super.printHyperlink(string, (HyperlinkInfo)openFileHyperlinkInfo);
            } else {
                super.print(string, consoleViewContentType);
            }
        }
    }

    public ConsoleViewContentType outputTypeForAttributes(Key attributes) {
        ConsoleViewContentType consoleViewContentType = attributes == ProcessOutputTypes.STDERR ? ConsoleViewContentType.ERROR_OUTPUT : (attributes == ProcessOutputTypes.SYSTEM ? ConsoleViewContentType.SYSTEM_OUTPUT : ConsoleViewContentType.getConsoleViewType((Key)attributes));
        return consoleViewContentType;
    }

    public void setSdk(Sdk sdk) {
        this.getFile().putCopyableUserData(PydevConsoleRunner.CONSOLE_SDK, (Object)sdk);
    }

    public void showVariables(PydevConsoleCommunication consoleCommunication) {
        PyStackFrame pyStackFrame = new PyStackFrame(this.getProject(), consoleCommunication, new PyStackFrameInfo("", "", "", null), null);
        final XStandaloneVariablesView xStandaloneVariablesView = new XStandaloneVariablesView(this.getProject(), (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider(), (XStackFrame)pyStackFrame);
        consoleCommunication.addCommunicationListener(new ConsoleCommunicationListener(){

            public void commandExecuted(boolean more) {
                xStandaloneVariablesView.rebuildView();
            }

            public void inputRequested() {
            }
        });
        this.h = xStandaloneVariablesView;
        Disposer.register((Disposable)this, (Disposable)xStandaloneVariablesView);
        this.b();
    }

    protected final void doAddPromptToHistory(boolean isMainPrompt) {
        String string;
        this.flushDeferredText();
        EditorEx editorEx = this.getHistoryViewer();
        DocumentEx documentEx = editorEx.getDocument();
        RangeHighlighter rangeHighlighter = this.getHistoryViewer().getMarkupModel().addRangeHighlighter(documentEx.getTextLength(), documentEx.getTextLength(), 0, null, HighlighterTargetArea.EXACT_RANGE);
        if (isMainPrompt) {
            string = this.k.getMainPrompt();
            this.print(string + " ", this.k.getPromptAttributes());
        } else {
            string = this.k.getIndentPrompt();
            this.print(string + " ", ConsoleViewContentType.USER_INPUT);
        }
        rangeHighlighter.putUserData(PyConsoleCopyHandler.PROMPT_LENGTH_MARKER, (Object)(string.length() + 1));
    }

    @NotNull
    protected String addTextRangeToHistory(@NotNull TextRange textRange, @NotNull EditorEx inputEditor, boolean preserveMarkup) {
        String string;
        EditorHighlighter editorHighlighter;
        PsiFile psiFile;
        if (textRange == null) {
            PythonConsoleView.a(10);
        }
        if (inputEditor == null) {
            PythonConsoleView.a(11);
        }
        if (inputEditor instanceof EditorWindow) {
            psiFile = ((EditorWindow)inputEditor).getInjectedFile();
            editorHighlighter = HighlighterFactory.createHighlighter((VirtualFile)psiFile.getVirtualFile(), (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)this.getProject());
            String string2 = InjectedLanguageUtil.getUnescapedText((PsiFile)psiFile, null, null);
            editorHighlighter.setText((CharSequence)string2);
            string = textRange.substring(string2);
        } else {
            string = inputEditor.getDocument().getText(textRange);
            editorHighlighter = inputEditor.getHighlighter();
        }
        psiFile = editorHighlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)editorHighlighter).getSyntaxHighlighter() : null;
        this.doAddPromptToHistory(true);
        if (psiFile != null) {
            ConsoleViewUtil.printWithHighlighting((ConsoleView)this, (String)string, (SyntaxHighlighter)psiFile, () -> this.doAddPromptToHistory(false));
        } else {
            this.print(string, ConsoleViewContentType.USER_INPUT);
        }
        this.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        String string3 = string;
        if (string3 == null) {
            PythonConsoleView.a(12);
        }
        return string3;
    }

    @NotNull
    protected JComponent createCenterComponent() {
        JComponent jComponent = super.createCenterComponent();
        this.getHistoryViewer().getSettings().setAdditionalLinesCount(0);
        this.getHistoryViewer().getSettings().setUseSoftWraps(false);
        this.getConsoleEditor().getGutter().registerTextAnnotation((TextAnnotationGutterProvider)this.k);
        this.getConsoleEditor().getGutterComponentEx().setBackground(this.getConsoleEditor().getBackgroundColor());
        this.getConsoleEditor().getGutterComponentEx().revalidate();
        this.getConsoleEditor().getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, this.getConsoleEditor().getBackgroundColor());
        JComponent jComponent2 = jComponent;
        if (jComponent2 == null) {
            PythonConsoleView.a(13);
        }
        return jComponent2;
    }

    private void b() {
        long l2 = n ^ 0x121D6D0F4B65L;
        Component component = this.getComponent(0);
        this.removeAll();
        JBSplitter jBSplitter = new JBSplitter(false, 0.6666667f);
        jBSplitter.setFirstComponent((JComponent)component);
        jBSplitter.setSecondComponent(this.h.getPanel());
        jBSplitter.setShowDividerControls(true);
        jBSplitter.setHonorComponentsMinimumSize(true);
        this.add((Component)jBSplitter, "Center");
        this.validate();
        this.repaint();
    }

    public void restoreWindow() {
        long l2 = n ^ 0x6B80A41B34FCL;
        Component component = this.getComponent(0);
        if (this.h != null && component instanceof JBSplitter) {
            JBSplitter jBSplitter = (JBSplitter)component;
            this.removeAll();
            Disposer.dispose((Disposable)this.h);
            this.h = null;
            this.add(jBSplitter.getFirstComponent(), "Center");
            this.validate();
            this.repaint();
        }
    }

    @Nullable
    public String getPrompt() {
        if (this.k == null) {
            return super.getPrompt();
        }
        return this.k.getMainPrompt();
    }

    public void setPrompt(@Nullable String prompt) {
        if (this.k == null) {
            super.setPrompt(prompt);
            return;
        }
        if (prompt != null) {
            this.k.setMainPrompt(prompt);
        }
    }

    @Nullable
    public String getSdkHomePath() {
        return this.m;
    }

    public void setPromptAttributes(@NotNull ConsoleViewContentType textAttributes) {
        if (textAttributes == null) {
            PythonConsoleView.a(14);
        }
        this.k.setPromptAttributes(textAttributes);
    }

    public boolean isInitialized() {
        return this.g.isDone();
    }

    public void initialized() {
        this.g.setDone();
    }

    public void setShowVars(boolean showVars) {
        this.l = showVars;
    }

    public boolean isShowVars() {
        return this.l;
    }

    public void whenInitialized(Runnable runnable) {
        this.g.doWhenDone(runnable);
    }

    @Nullable
    public XDebuggerTreeNode getDebuggerTreeRootNode() {
        return this.h.getTree().getRoot();
    }

    static {
        n = com.jetbrains.python.psi.c.a(6509699695869754530L, -5547998874134996631L, MethodHandles.lookup().lookupClass()).a(209506523439799L);
        long l2 = n ^ 0x43475A403E5AL;
        CONSOLE_KEY = new Key("PYDEV_CONSOLE_KEY");
        e = Logger.getInstance(PythonConsoleView.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = n ^ 0x7BEBE5282F74L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 12: 
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleExecuteActionHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputEditor";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PythonConsoleView";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PythonConsoleView";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addTextRangeToHistory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterComponent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setExecutionHandler";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeInConsole";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeStatement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectHyperlink";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTextRangeToHistory";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setPromptAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

