/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.coverage;

import com.google.common.collect.Lists;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.SimpleCoverageAnnotator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.PathMapper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.coverage.PyCoverageEngine;
import com.jetbrains.python.coverage.PyCoverageUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PyCoverageRunner
extends CoverageRunner {
    private static final Logger a;
    private PathMapper b = null;
    private static final long d;

    public void setPathMapper(PathMapper pathMapper) {
        this.b = pathMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        long l2 = d ^ 0x3A1D53C59FCCL;
        if (sessionDataFile == null) {
            PyCoverageRunner.b(0);
        }
        List<Object> list2 = Lists.newArrayList();
        String string = sessionDataFile.getAbsolutePath();
        if (sessionDataFile.getAbsolutePath().endsWith(".coverage")) {
            string = PyCoverageRunner.a(sessionDataFile.getAbsolutePath());
            try {
                list2 = PyCoverageRunner.b(string);
            }
            catch (Exception exception) {
                a.warn("Error reading syspath", (Throwable)exception);
            }
            if (baseCoverageSuite != null && baseCoverageSuite.getProject() != null) {
                list2.addAll(PyCoverageRunner.a(baseCoverageSuite.getProject()));
            }
            if (!new File(string + ".xml").exists()) {
                this.a(sessionDataFile);
            }
        }
        PyCoverageXmlOutputParser pyCoverageXmlOutputParser = new PyCoverageXmlOutputParser((List<String>)list2, this.b);
        if (!string.endsWith(".xml")) {
            string = string + ".xml";
        }
        a.info("Loading coverage data from " + string);
        try (FileReader fileReader = new FileReader(string);){
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            xMLReader.setContentHandler(pyCoverageXmlOutputParser);
            xMLReader.parse(new InputSource(fileReader));
            ProjectData projectData = pyCoverageXmlOutputParser.getProjectInfo();
            return projectData;
        }
        catch (FileNotFoundException fileNotFoundException) {
            UIUtil.invokeLaterIfNeeded(() -> {
                long l2 = d ^ 0x299F13460D63L;
                Messages.showErrorDialog((String)"Coverage results not found.", (String)"Error");
            });
            return new ProjectData();
        }
        catch (Exception exception) {
            a.error((Throwable)exception);
        }
        return new ProjectData();
    }

    private void a(@NotNull File file) {
        Sdk sdk;
        long l2 = d ^ 0x4D05177C31FDL;
        if (file == null) {
            PyCoverageRunner.b(1);
        }
        if ((sdk = PythonSdkType.findLocalCPython(null)) != null) {
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{sdk.getHomePath()});
            ParamsGroup paramsGroup = generalCommandLine.getParametersList().addParamsGroup("Coverage");
            PyCoverageUtil.addCoverageFileEnv(generalCommandLine, file.getAbsolutePath());
            PythonHelper.COVERAGEPY.addToPythonPath(generalCommandLine.getEnvironment());
            PythonHelper.COVERAGE.addToGroup(paramsGroup, generalCommandLine);
            generalCommandLine.getEnvironment().put("PYCHARM_RUN_COVERAGE_XML", "1");
            generalCommandLine.setWorkDirectory(file.getParent());
            try {
                CapturingProcessHandler capturingProcessHandler = new CapturingProcessHandler(generalCommandLine);
                ProcessOutput processOutput = capturingProcessHandler.runProcess();
                processOutput.checkSuccess(a);
            }
            catch (ExecutionException executionException) {
                a.error("Can't generate coverage xml", (Throwable)executionException);
            }
        }
    }

    private static String a(String string) {
        long l2 = d ^ 0x75995A58DCEDL;
        a.assertTrue(string.endsWith(".coverage"));
        return string.substring(0, string.length() - ".coverage".length());
    }

    private static List<String> a(@NotNull Project project) {
        if (project == null) {
            PyCoverageRunner.b(2);
        }
        final ArrayList arrayList = Lists.newArrayList();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            RootVisitorHost.visitRoots(module2, true, new RootVisitor(){

                @Override
                public boolean visitRoot(VirtualFile root, @Nullable Module module2, @Nullable Sdk sdk, boolean isModuleSource) {
                    arrayList.add(root.getPath());
                    return true;
                }
            });
        }
        return arrayList;
    }

    private static List<String> b(@NotNull String string) throws IOException {
        long l2 = d ^ 0x3E16A3B9EB90L;
        if (string == null) {
            PyCoverageRunner.b(3);
        }
        try {
            return FileUtil.loadLines((File)new File(string + ".syspath.txt"));
        }
        catch (Exception exception) {
            a.warn("Can't load syspath file", (Throwable)exception);
            return Lists.newArrayList();
        }
    }

    @Override
    @NotNull
    public String getPresentableName() {
        long l2 = d ^ 0x74610D584460L;
        if ("Python" == null) {
            PyCoverageRunner.b(4);
        }
        return "Python";
    }

    @Override
    @NotNull
    public String getId() {
        long l2 = d ^ 0x74DB0C15FBE9L;
        if ("coverage.py" == null) {
            PyCoverageRunner.b(5);
        }
        return "coverage.py";
    }

    @Override
    @NotNull
    public String getDataFileExtension() {
        long l2 = d ^ 0x3D796511E2D0L;
        if ("coverage" == null) {
            PyCoverageRunner.b(6);
        }
        return "coverage";
    }

    @Override
    @NotNull
    public String[] getDataFileExtensions() {
        long l2 = d ^ 0x37E3C5B22EEFL;
        String[] stringArray = new String[]{"xml", "coverage"};
        if (stringArray == null) {
            PyCoverageRunner.b(7);
        }
        return stringArray;
    }

    @Override
    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            PyCoverageRunner.b(8);
        }
        return engine instanceof PyCoverageEngine;
    }

    private static /* synthetic */ void a() {
        long l2 = d ^ 0x7168288EF7B2L;
        Messages.showErrorDialog((String)"Can't read coverage data.", (String)"Error");
    }

    static {
        d = c.a(6785874311296526478L, -3902863534658595594L, MethodHandles.lookup().lookupClass()).a(47732479166463L);
        a = Logger.getInstance(PyCoverageRunner.class);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x747A42224D9CL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFileName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/coverage/PyCoverageRunner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/coverage/PyCoverageRunner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFileExtension";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFileExtensions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateCoverageXml";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "projectPaths";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadSysPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PyCoverageXmlOutputParser
    extends DefaultHandler {
        final ProjectData myProjectInfo = new ProjectData();
        private String d;
        private List<LineData> b;
        private final List<String> a;
        private final PathMapper c;
        boolean myIsSource = false;
        private static final long e = com.jetbrains.python.psi.c.a(4534526592314369569L, -2222437716611699118L, MethodHandles.lookup().lookupClass()).a(267879383305505L);

        PyCoverageXmlOutputParser(List<String> sysPath, PathMapper pathMapper) {
            this.a = sysPath;
            this.c = pathMapper;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            long l2 = e ^ 0x6A6693D3DD84L;
            if ("source".equals(localName)) {
                this.myIsSource = true;
            } else if ("class".equals(localName)) {
                this.d = attributes.getValue("filename");
                this.b = Lists.newArrayList();
            } else if ("line".equals(localName)) {
                LineData lineData = new LineData(Integer.parseInt(attributes.getValue("number")), "");
                int n2 = Integer.parseInt(attributes.getValue("hits"));
                lineData.setHits(n2);
                if (attributes.getValue("missing-branches") != null) {
                    String[] stringArray;
                    for (String string : stringArray = attributes.getValue("missing-branches").split(",")) {
                        JumpData jumpData;
                        try {
                            jumpData = lineData.addJump(Integer.parseInt(string));
                        }
                        catch (NumberFormatException numberFormatException) {
                            jumpData = lineData.addJump(0);
                        }
                        jumpData.setFalseHits(n2);
                    }
                    lineData.fillArrays();
                }
                this.b.add(lineData);
            }
        }

        @Override
        public void characters(char[] ch2, int start2, int length) throws SAXException {
            if (this.myIsSource) {
                this.a.add(new String(ch2, start2, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            long l2 = e ^ 0x3F73E161831FL;
            if ("source".equals(localName)) {
                this.myIsSource = false;
            }
            if ("class".equals(localName)) {
                File file = new File(this.d);
                if (this.c != null) {
                    file = new File(this.c.convertToLocal(this.d));
                }
                if (!file.exists()) {
                    for (String string : this.a) {
                        file = new File(string, this.d);
                        if (this.c != null) {
                            file = new File(this.c.convertToLocal(file.getPath()));
                        }
                        if (!file.exists()) continue;
                        break;
                    }
                }
                ClassData classData = this.myProjectInfo.getOrCreateClassData(SimpleCoverageAnnotator.getFilePath(file.getAbsolutePath()));
                int n2 = 0;
                for (LineData object2 : this.b) {
                    if (object2.getLineNumber() <= n2) continue;
                    n2 = object2.getLineNumber();
                }
                LineData[] lineDataArray = new LineData[n2 + 1];
                Iterator<LineData> iterator = this.b.iterator();
                while (iterator.hasNext()) {
                    LineData lineData;
                    lineDataArray[lineData.getLineNumber()] = lineData = iterator.next();
                }
                classData.setLines(lineDataArray);
            }
        }

        public ProjectData getProjectInfo() {
            return this.myProjectInfo;
        }
    }
}

