/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.util.TreeChooser;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.python.PyClassTreeChooserDialog;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyExceptionBreakpointProperties;
import com.jetbrains.python.debugger.a;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExceptionBreakpointType
extends XBreakpointType<XBreakpoint<PyExceptionBreakpointProperties>, PyExceptionBreakpointProperties> {
    private static final String a = "BaseException";
    private static final long b = c.a(-8814377410518465624L, 6321329679556899998L, MethodHandles.lookup().lookupClass()).a(197127118274486L);

    public PyExceptionBreakpointType() {
        long l2 = b ^ 0x38BF1BA5D8A0L;
        super("python-exception", "Python Exception Breakpoint");
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            PyExceptionBreakpointType.a(0);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_exception_breakpoint;
        if (icon == null) {
            PyExceptionBreakpointType.a(1);
        }
        return icon;
    }

    public PyExceptionBreakpointProperties createProperties() {
        long l2 = b ^ 0x38E43C3D2E84L;
        return new PyExceptionBreakpointProperties(a);
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    public XBreakpoint<PyExceptionBreakpointProperties> addBreakpoint(Project project, JComponent parentComponent) {
        long l2 = b ^ 0x7095645F6FFFL;
        PyClassTreeChooserDialog pyClassTreeChooserDialog = new PyClassTreeChooserDialog("Select Exception Class", project, GlobalSearchScope.allScope((Project)project), new PyExceptionCachingFilter(null), null);
        pyClassTreeChooserDialog.showDialog();
        PyClass pyClass = (PyClass)pyClassTreeChooserDialog.getSelected();
        if (pyClass != null) {
            String string = pyClass.getQualifiedName();
            assert (string != null) : "Qualified name of the class shouldn't be null";
            return (XBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new PyExceptionBreakpointProperties(string)));
        }
        return null;
    }

    public String getBreakpointsDialogHelpTopic() {
        long l2 = b ^ 0x7B26775BF196L;
        return "reference.dialogs.breakpoints";
    }

    public String getDisplayText(XBreakpoint<PyExceptionBreakpointProperties> breakpoint) {
        long l2 = b ^ 0x1E155A14DB55L;
        PyExceptionBreakpointProperties pyExceptionBreakpointProperties = (PyExceptionBreakpointProperties)breakpoint.getProperties();
        if (pyExceptionBreakpointProperties != null) {
            String string = pyExceptionBreakpointProperties.getException();
            if (a.equals(string)) {
                return "Any exception";
            }
            return string;
        }
        return "";
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XBreakpoint<PyExceptionBreakpointProperties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            PyExceptionBreakpointType.a(2);
        }
        if (project == null) {
            PyExceptionBreakpointType.a(3);
        }
        return new PyDebuggerEditorsProvider();
    }

    public XBreakpoint<PyExceptionBreakpointProperties> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<PyExceptionBreakpointProperties> creator) {
        if (creator == null) {
            PyExceptionBreakpointType.a(4);
        }
        XBreakpoint xBreakpoint = creator.createBreakpoint((XBreakpointProperties)PyExceptionBreakpointType.a());
        xBreakpoint.setEnabled(true);
        return xBreakpoint;
    }

    private static PyExceptionBreakpointProperties a() {
        long l2 = b ^ 0x365C2FA144C1L;
        PyExceptionBreakpointProperties pyExceptionBreakpointProperties = new PyExceptionBreakpointProperties(a);
        pyExceptionBreakpointProperties.setNotifyOnTerminate(true);
        pyExceptionBreakpointProperties.setNotifyOnlyOnFirst(false);
        return pyExceptionBreakpointProperties;
    }

    public XBreakpointCustomPropertiesPanel<XBreakpoint<PyExceptionBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            PyExceptionBreakpointType.a(5);
        }
        return new PyExceptionBreakpointPropertiesPanel(null);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x22B534BF6D24L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyExceptionBreakpointType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyExceptionBreakpointType";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBreakpoint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomPropertiesPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PyExceptionBreakpointPropertiesPanel
    extends XBreakpointCustomPropertiesPanel<XBreakpoint<PyExceptionBreakpointProperties>> {
        private JCheckBox b;
        private JCheckBox d;
        private JCheckBox c;
        private JBLabel a;
        private static final long e = com.jetbrains.python.psi.c.a(-5855783039442947438L, 4908501072775190757L, MethodHandles.lookup().lookupClass()).a(136753797475782L);

        private PyExceptionBreakpointPropertiesPanel() {
        }

        @NotNull
        public JComponent getComponent() {
            long l2 = e ^ 0x41524D5E3556L;
            this.b = new JCheckBox("On termination");
            this.d = new JCheckBox("On raise");
            this.c = new JCheckBox("Ignore library files");
            Box box = Box.createVerticalBox();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.b, "North");
            box.add(jPanel);
            jPanel = new JPanel(new FlowLayout(0, 0, 0));
            jPanel.setBorder((Border)JBUI.Borders.empty());
            jPanel.add((Component)this.d, 0);
            this.a = new JBLabel(AllIcons.General.BalloonWarning);
            IdeTooltipManager.getInstance().setCustomTooltip((JComponent)this.a, (IdeTooltip)new TooltipWithClickableLinks.ForBrowser((JComponent)this.a, "This option may slow down the debugger"));
            this.a.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            jPanel.add((Component)this.a);
            box.add(jPanel);
            jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.c, "North");
            box.add(jPanel);
            jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)box, "Center");
            jPanel2.add(Box.createHorizontalStrut(3), "West");
            jPanel2.add(Box.createHorizontalStrut(3), "East");
            jPanel.add((Component)jPanel2, "North");
            jPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Activation policy"));
            JPanel jPanel3 = jPanel;
            if (jPanel3 == null) {
                PyExceptionBreakpointPropertiesPanel.a(0);
            }
            return jPanel3;
        }

        public void saveTo(@NotNull XBreakpoint<PyExceptionBreakpointProperties> breakpoint) {
            if (breakpoint == null) {
                PyExceptionBreakpointPropertiesPanel.a(1);
            }
            ((PyExceptionBreakpointProperties)breakpoint.getProperties()).setNotifyOnTerminate(this.b.isSelected());
            ((PyExceptionBreakpointProperties)breakpoint.getProperties()).setNotifyOnlyOnFirst(this.d.isSelected());
            ((PyExceptionBreakpointProperties)breakpoint.getProperties()).setIgnoreLibraries(this.c.isSelected());
        }

        public void loadFrom(@NotNull XBreakpoint<PyExceptionBreakpointProperties> breakpoint) {
            if (breakpoint == null) {
                PyExceptionBreakpointPropertiesPanel.a(2);
            }
            this.c.setSelected(((PyExceptionBreakpointProperties)breakpoint.getProperties()).isIgnoreLibraries());
            this.b.setSelected(((PyExceptionBreakpointProperties)breakpoint.getProperties()).isNotifyOnTerminate());
            this.d.setSelected(((PyExceptionBreakpointProperties)breakpoint.getProperties()).isNotifyOnlyOnFirst());
        }

        /* synthetic */ PyExceptionBreakpointPropertiesPanel(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0xAB20365120L;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyExceptionBreakpointType$PyExceptionBreakpointPropertiesPanel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakpoint";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyExceptionBreakpointType$PyExceptionBreakpointPropertiesPanel";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "saveTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "loadFrom";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PyExceptionCachingFilter
    implements TreeChooser.Filter<PyClass> {
        private final HashMap<Integer, Pair<WeakReference<PyClass>, Boolean>> a = Maps.newHashMap();
        private static final long b = c.a(-8349847634271479230L, -8442524302903429370L, MethodHandles.lookup().lookupClass()).a(257167717091037L);

        private PyExceptionCachingFilter() {
        }

        public boolean isAccepted(@NotNull PyClass pyClass) {
            boolean bl2;
            VirtualFile virtualFile;
            if (pyClass == null) {
                PyExceptionCachingFilter.a(0);
            }
            if ((virtualFile = pyClass.getContainingFile().getVirtualFile()) == null) {
                return false;
            }
            int n2 = pyClass.hashCode();
            Pair<WeakReference<PyClass>, Boolean> pair = this.a.get(n2);
            if (pair == null || ((WeakReference)pair.first).get() != pyClass) {
                bl2 = (Boolean)ReadAction.compute(() -> PyUtil.isExceptionClass(pyClass));
                this.a.put(n2, (Pair<WeakReference<PyClass>, Boolean>)Pair.create(new WeakReference<PyClass>(pyClass), (Object)bl2));
            } else {
                bl2 = (Boolean)pair.second;
            }
            return bl2;
        }

        /* synthetic */ PyExceptionCachingFilter(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x5BCE16D9ECEFL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/debugger/PyExceptionBreakpointType$PyExceptionCachingFilter", "isAccepted"));
        }
    }
}

