/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerEvaluator;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.psi.c;
import icons.PythonIcons;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStackFrame
extends XStackFrame {
    private static final Logger b;
    private static final Object d;
    public static final String DOUBLE_UNDERSCORE = "__";
    public static final String RETURN_VALUES_GROUP_NAME = "Return Values";
    public static final String SPECIAL_VARIABLES_GROUP_NAME = "Special Variables";
    public static final HashSet<String> HIDE_TYPES;
    public static final int DUNDER_VALUES_IND = 0;
    public static final int SPECIAL_TYPES_IND = 1;
    public static final int IPYTHON_VALUES_IND = 2;
    public static final int NUMBER_OF_GROUPS = 3;
    private final Project a;
    private final PyFrameAccessor f;
    private final PyStackFrameInfo e;
    private final XSourcePosition c;
    private static final long g;

    public PyStackFrame(@NotNull Project project, @NotNull PyFrameAccessor debugProcess, @NotNull PyStackFrameInfo frameInfo, XSourcePosition position) {
        if (project == null) {
            PyStackFrame.b(0);
        }
        if (debugProcess == null) {
            PyStackFrame.b(1);
        }
        if (frameInfo == null) {
            PyStackFrame.b(2);
        }
        this.a = project;
        this.f = debugProcess;
        this.e = frameInfo;
        this.c = position;
    }

    public Object getEqualityObject() {
        return d;
    }

    public XSourcePosition getSourcePosition() {
        return this.c;
    }

    public XDebuggerEvaluator getEvaluator() {
        return new PyDebuggerEvaluator(this.a, this.f);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        long l2 = g ^ 0x4C0372A63B04L;
        if (component == null) {
            PyStackFrame.b(3);
        }
        component.setIcon(AllIcons.Debugger.Frame);
        if (this.c == null) {
            component.append("<frame not available>", SimpleTextAttributes.GRAY_ATTRIBUTES);
            return;
        }
        VirtualFile virtualFile = this.c.getFile();
        boolean bl2 = (Boolean)ReadAction.compute(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document != null) {
                return !ProjectRootManager.getInstance((Project)this.a).getFileIndex().isInContent(virtualFile);
            }
            return true;
        });
        component.append(this.e.getName(), PyStackFrame.a(SimpleTextAttributes.REGULAR_ATTRIBUTES, bl2));
        component.append(", ", PyStackFrame.a(SimpleTextAttributes.REGULAR_ATTRIBUTES, bl2));
        component.append(this.c.getFile().getName(), PyStackFrame.a(SimpleTextAttributes.REGULAR_ATTRIBUTES, bl2));
        component.append(":", PyStackFrame.a(SimpleTextAttributes.REGULAR_ATTRIBUTES, bl2));
        component.append(Integer.toString(this.c.getLine() + 1), PyStackFrame.a(SimpleTextAttributes.REGULAR_ATTRIBUTES, bl2));
    }

    private static SimpleTextAttributes a(SimpleTextAttributes simpleTextAttributes, boolean bl2) {
        if (!bl2) {
            return simpleTextAttributes;
        }
        return PyStackFrame.getGrayAttributes(simpleTextAttributes);
    }

    protected static SimpleTextAttributes getGrayAttributes(SimpleTextAttributes attributes) {
        return (attributes.getStyle() & 2) != 0 ? SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            PyStackFrame.b(4);
        }
        if (node.isObsolete()) {
            return;
        }
        this.f.setCurrentRootNode(node);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            long l2 = g ^ 0x3A4974C251D5L;
            try {
                boolean bl2 = this.f.isCurrentFrameCached();
                XValueChildrenList xValueChildrenList = this.f.loadFrame();
                if (!node.isObsolete()) {
                    this.addChildren(node, xValueChildrenList);
                }
                if (xValueChildrenList != null && !bl2) {
                    PyDebugValue.getAsyncValues((PyFrameAccessor)this.f, (XValueChildrenList)xValueChildrenList);
                }
            }
            catch (PyDebuggerException pyDebuggerException) {
                if (!node.isObsolete()) {
                    node.setErrorMessage("Unable to display frame variables");
                }
                b.warn((Throwable)pyDebuggerException);
            }
        });
    }

    protected void addChildren(@NotNull XCompositeNode node, @Nullable XValueChildrenList children2) {
        long l2 = g ^ 0x4E00C841E4EAL;
        if (node == null) {
            PyStackFrame.b(5);
        }
        if (children2 == null) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        PyDebuggerSettings pyDebuggerSettings = PyDebuggerSettings.getInstance();
        XValueChildrenList xValueChildrenList = new XValueChildrenList();
        HashMap<String, XValue> hashMap = new HashMap<String, XValue>();
        ArrayList<Map<String, XValue>> arrayList = new ArrayList<Map<String, XValue>>();
        IntStream.range(0, 3).mapToObj(n2 -> new HashMap()).forEach(arrayList::add);
        boolean bl2 = true;
        for (int i10 = 0; i10 < children2.size(); ++i10) {
            XValue xValue = children2.getValue(i10);
            String string = children2.getName(i10);
            if (!(xValue instanceof PyDebugValue)) continue;
            PyDebugValue pyDebugValue = (PyDebugValue)xValue;
            if (pyDebugValue.isReturnedVal() && pyDebuggerSettings.isWatchReturnValues()) {
                hashMap.put(string, xValue);
                continue;
            }
            if (!pyDebuggerSettings.isSimplifiedView()) {
                xValueChildrenList.add(string, xValue);
                continue;
            }
            int n3 = -1;
            if (string.startsWith(DOUBLE_UNDERSCORE) && string.endsWith(DOUBLE_UNDERSCORE) && string.length() > 4 && !string.equals("__exception__")) {
                n3 = 0;
            } else if (pyDebugValue.isIPythonHidden()) {
                n3 = 2;
            } else if (HIDE_TYPES.contains(pyDebugValue.getType())) {
                n3 = 1;
            }
            if (n3 > -1) {
                arrayList.get(n3).put(string, xValue);
                bl2 = false;
                continue;
            }
            xValueChildrenList.add(string, xValue);
        }
        node.addChildren(xValueChildrenList, hashMap.isEmpty() && bl2);
        if (!hashMap.isEmpty()) {
            PyStackFrame.a(node, hashMap);
        }
        if (!bl2) {
            PyStackFrame.a(node, arrayList);
        }
    }

    private static void a(@NotNull XCompositeNode xCompositeNode, final Map<String, XValue> map2) {
        long l2 = g ^ 0x333CEBD0B8B1L;
        if (xCompositeNode == null) {
            PyStackFrame.b(6);
        }
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new XValueGroup(RETURN_VALUES_GROUP_NAME){
            private static final long a = com.jetbrains.python.psi.c.a(-6344225896604668686L, 5321947071867428655L, MethodHandles.lookup().lookupClass()).a(47661085603331L);

            public void computeChildren(@NotNull XCompositeNode node) {
                long l2 = a ^ 0x470C6F2458A9L;
                if (node == null) {
                    1.a(0);
                }
                XValueChildrenList xValueChildrenList = new XValueChildrenList();
                for (Map.Entry entry : map2.entrySet()) {
                    xValueChildrenList.add((String)entry.getKey() + "()", (XValue)entry.getValue());
                }
                node.addChildren(xValueChildrenList, true);
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = AllIcons.Debugger.WatchLastReturnValue;
                if (icon == null) {
                    1.a(1);
                }
                return icon;
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0x61921090A2EBL;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/debugger/PyStackFrame$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/debugger/PyStackFrame$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "computeChildren";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        xCompositeNode.addChildren(XValueChildrenList.topGroups((List)arrayList), true);
    }

    private static void a(@NotNull XCompositeNode xCompositeNode, final List<Map<String, XValue>> list2) {
        long l2 = g ^ 0x567B29103378L;
        if (xCompositeNode == null) {
            PyStackFrame.b(7);
        }
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new XValueGroup(SPECIAL_VARIABLES_GROUP_NAME){
            private static final long a = com.jetbrains.python.psi.c.a(-7948877079935855022L, 2040818013645242521L, MethodHandles.lookup().lookupClass()).a(197878672862555L);

            public void computeChildren(@NotNull XCompositeNode node) {
                if (node == null) {
                    2.a(0);
                }
                XValueChildrenList xValueChildrenList = new XValueChildrenList();
                for (Map map2 : list2) {
                    for (Map.Entry entry : map2.entrySet()) {
                        xValueChildrenList.add((String)entry.getKey(), (XValue)entry.getValue());
                    }
                }
                node.addChildren(xValueChildrenList, true);
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = PythonIcons.Python.Debug.SpecialVar;
                if (icon == null) {
                    2.a(1);
                }
                return icon;
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0x2A2728C73EBL;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/debugger/PyStackFrame$2";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/debugger/PyStackFrame$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "computeChildren";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        xCompositeNode.addChildren(XValueChildrenList.topGroups((List)arrayList), true);
    }

    public String getThreadId() {
        return this.e.getThreadId();
    }

    public String getFrameId() {
        return this.e.getId();
    }

    public String getThreadFrameId() {
        return this.e.getThreadId() + ":" + this.e.getId();
    }

    protected XSourcePosition getPosition() {
        return this.c;
    }

    static {
        g = com.jetbrains.python.psi.c.a(3562810514279072789L, 7627830114920749590L, MethodHandles.lookup().lookupClass()).a(34600802628242L);
        long l2 = g ^ 0x382C0E7FC673L;
        b = Logger.getInstance((String)"#com.jetbrains.python.pydev.PyStackFrame");
        d = new Object();
        HIDE_TYPES = new HashSet<String>(Arrays.asList("function", "type", "classobj", "module"));
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = g ^ 0x1B0ED89DA2CAL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PyStackFrame";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "customizePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addReturnedValuesGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addSpecialValuesGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

