/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.array.JBTableWithRowHeaders;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import com.jetbrains.python.psi.c;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDataViewerPanel
extends JPanel {
    private static final Logger e;
    private final Project i;
    @NotNull
    private final PyFrameAccessor g;
    private EditorTextField c;
    private JBTableWithRowHeaders j;
    private EditorTextField f;
    private JPanel d;
    private JBLabel h;
    private JBScrollPane a;
    private boolean b;
    List<Listener> myListeners;
    private static final long k;

    public PyDataViewerPanel(@NotNull Project project, @NotNull PyFrameAccessor frameAccessor) {
        long l2 = k ^ 0x9717EFF28FL;
        if (project == null) {
            PyDataViewerPanel.a(0);
        }
        if (frameAccessor == null) {
            PyDataViewerPanel.a(1);
        }
        super(new BorderLayout());
        this.i = project;
        this.g = frameAccessor;
        this.g();
        this.h.setVisible(false);
        this.h.setForeground((Color)JBColor.RED);
        this.d.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.add((Component)this.d, "Center");
        this.b = PropertiesComponent.getInstance((Project)this.i).getBoolean("python.debugger.dataview.coloredbydefault", true);
        this.myListeners = new CopyOnWriteArrayList<Listener>();
        this.b();
    }

    private void b() {
        this.g.addFrameListener(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> this.d()));
    }

    private void d() {
        AsyncArrayTableModel asyncArrayTableModel = this.getModel();
        if (asyncArrayTableModel == null) {
            return;
        }
        asyncArrayTableModel.invalidateCache();
        this.b(asyncArrayTableModel);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isShowing()) {
                asyncArrayTableModel.fireTableDataChanged();
            }
        });
    }

    private void b(@NotNull AsyncArrayTableModel asyncArrayTableModel) {
        PyDebugValue pyDebugValue;
        if (asyncArrayTableModel == null) {
            PyDataViewerPanel.a(2);
        }
        if (!(pyDebugValue = asyncArrayTableModel.getDebugValue()).isTemporary()) {
            return;
        }
        PyDebugValue pyDebugValue2 = this.b(this.c.getText());
        if (pyDebugValue2 != null) {
            asyncArrayTableModel.setDebugValue(pyDebugValue2);
        }
    }

    @NotNull
    public PyFrameAccessor getFrameAccessor() {
        PyFrameAccessor pyFrameAccessor = this.g;
        if (pyFrameAccessor == null) {
            PyDataViewerPanel.a(3);
        }
        return pyFrameAccessor;
    }

    public JBTable getTable() {
        return this.j;
    }

    public JPanel getMainPanel() {
        return this.d;
    }

    protected void createUIComponents() {
        long l2 = k ^ 0x5F0D3DFDC04CL;
        this.f = this.f();
        this.c = this.f();
        this.e();
        this.j = new JBTableWithRowHeaders(PropertiesComponent.getInstance((Project)this.i).getBoolean("python.debugger.dataview.autoresize", true));
        this.a = this.j.getScrollPane();
    }

    private void e() {
        new PyDataViewCompletionProvider().apply(this.c);
    }

    @NotNull
    private EditorTextField f() {
        EditorTextField editorTextField = new EditorTextField(EditorFactory.getInstance().createDocument((CharSequence)""), this.i, (FileType)PythonFileType.INSTANCE, false, true){

            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                editorEx.getContentComponent().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e10) {
                        if (e10.getKeyCode() == 10) {
                            PyDataViewerPanel.this.apply(PyDataViewerPanel.this.c.getText());
                        }
                    }
                });
                return editorEx;
            }
        };
        if (editorTextField == null) {
            PyDataViewerPanel.a(4);
        }
        return editorTextField;
    }

    public void apply(String name) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            PyDebugValue pyDebugValue = this.b(name);
            if (pyDebugValue == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> this.apply(pyDebugValue));
        });
    }

    public void apply(@NotNull PyDebugValue debugValue) {
        long l2 = k ^ 0x4AE91D529268L;
        if (debugValue == null) {
            PyDataViewerPanel.a(5);
        }
        this.h.setVisible(false);
        String string = debugValue.getType();
        DataViewStrategy dataViewStrategy = DataViewStrategy.getStrategy(string);
        if (dataViewStrategy == null) {
            this.a(string + " is not supported");
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                ArrayChunk arrayChunk = debugValue.getFrameAccessor().getArrayItems(debugValue, 0, 0, -1, -1, this.getFormat());
                ApplicationManager.getApplication().invokeLater(() -> this.b(arrayChunk, debugValue, dataViewStrategy));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.a(illegalArgumentException.getLocalizedMessage());
            }
            catch (PyDebuggerException pyDebuggerException) {
                e.error((Throwable)pyDebuggerException);
            }
        });
    }

    public void resize(boolean autoResize) {
        this.j.setAutoResize(autoResize);
        this.apply(this.getSliceTextField().getText());
    }

    private void b(@NotNull ArrayChunk arrayChunk, @NotNull PyDebugValue pyDebugValue, @NotNull DataViewStrategy dataViewStrategy) {
        if (arrayChunk == null) {
            PyDataViewerPanel.a(6);
        }
        if (pyDebugValue == null) {
            PyDataViewerPanel.a(7);
        }
        if (dataViewStrategy == null) {
            PyDataViewerPanel.a(8);
        }
        PyDebugValue pyDebugValue2 = arrayChunk.getValue();
        AsyncArrayTableModel asyncArrayTableModel = dataViewStrategy.createTableModel(arrayChunk.getRows(), arrayChunk.getColumns(), this, pyDebugValue2);
        asyncArrayTableModel.addToCache(arrayChunk);
        UIUtil.invokeLaterIfNeeded(() -> {
            this.j.setModel(asyncArrayTableModel);
            String string = pyDebugValue2.getName().equals(pyDebugValue.getTempName()) ? pyDebugValue.getName() : arrayChunk.getSlicePresentation();
            this.c.setText(string);
            if (this.c.getEditor() != null) {
                this.c.getCaretModel().moveToOffset(string.length());
            }
            for (Listener listener2 : this.myListeners) {
                listener2.onNameChanged(string);
            }
            this.f.setText(arrayChunk.getFormat());
            ColoredCellRenderer coloredCellRenderer = dataViewStrategy.createCellRenderer(Double.MIN_VALUE, Double.MAX_VALUE, arrayChunk);
            coloredCellRenderer.setColored(this.b);
            ((AsyncArrayTableModel)this.j.getModel()).fireTableDataChanged();
            ((AsyncArrayTableModel)this.j.getModel()).fireTableCellUpdated(0, 0);
            if (this.j.getColumnCount() > 0) {
                this.j.setDefaultRenderer(this.j.getColumnClass(0), coloredCellRenderer);
            }
            this.j.setShowColumns(dataViewStrategy.showColumnHeader());
        });
    }

    private PyDebugValue b(String string) {
        long l2 = k ^ 0x3899199B1E3FL;
        try {
            PyDebugValue pyDebugValue = this.g.evaluate(string, false, true);
            if (pyDebugValue == null || pyDebugValue.isErrorOnEval()) {
                this.a(pyDebugValue != null ? pyDebugValue.getValue() : "Failed to evaluate expression " + string);
                return null;
            }
            return pyDebugValue;
        }
        catch (PyDebuggerException pyDebuggerException) {
            this.a(pyDebuggerException.getTracebackError());
            return null;
        }
    }

    private void a(String string) {
        long l2 = k ^ 0x40E6988931A2L;
        this.h.setVisible(true);
        this.h.setText(string);
        this.j.setEmpty();
        for (Listener listener2 : this.myListeners) {
            listener2.onNameChanged("empty");
        }
    }

    public String getFormat() {
        String string = this.f.getText();
        return string.isEmpty() ? "%" : string;
    }

    public boolean isColored() {
        return this.b;
    }

    public void setColored(boolean state2) {
        this.b = state2;
        if (!this.j.isEmpty()) {
            ((ColoredCellRenderer)this.j.getDefaultRenderer(this.j.getColumnClass(0))).setColored(state2);
        }
    }

    public EditorTextField getSliceTextField() {
        return this.c;
    }

    @Nullable
    public AsyncArrayTableModel getModel() {
        TableModel tableModel = this.j.getModel();
        if (tableModel instanceof AsyncArrayTableModel) {
            return (AsyncArrayTableModel)this.j.getModel();
        }
        return null;
    }

    public void addListener(Listener listener2) {
        this.myListeners.add(listener2);
    }

    static {
        k = com.jetbrains.python.psi.c.a(3511205178036961852L, 36471045000681625L, MethodHandles.lookup().lookupClass()).a(218164900500102L);
        e = Logger.getInstance(PyDataViewerPanel.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0x578CC76F34F6L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/containerview/PyDataViewerPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDebugValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/containerview/PyDataViewerPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorField";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateDebugValue";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void g() {
        JBLabel jBLabel;
        JPanel jPanel;
        long l2 = k ^ 0x3A756E8CE912L;
        this.createUIComponents();
        this.d = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = this.a;
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jBScrollPane.setVerticalScrollBarPolicy(20);
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        EditorTextField editorTextField = this.c;
        editorTextField.setToolTipText("Current slice.");
        jPanel.add((Component)editorTextField, new GridConstraints(2, 0, 1, 3, 2, 1, 6, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 4, 1, 1, 2, 1, 3, 0, null, null, null, 0, true));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setHorizontalTextPosition(4);
        jLabel.setText("Format:");
        jLabel.setVerticalAlignment(3);
        jLabel.setVerticalTextPosition(3);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.f;
        editorTextField2.setToolTipText("Format");
        jPanel2.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(70, -1), null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 5, 0, 3, 0, 0, null, null, null));
        this.h = jBLabel = new JBLabel();
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 20), new Dimension(-1, 20), new Dimension(-1, 20)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.d;
    }

    private class PyDataViewCompletionProvider
    extends TextFieldCompletionProvider {
        private static final long a = com.jetbrains.python.psi.c.a(-2908772818667113666L, -4363617227601403298L, MethodHandles.lookup().lookupClass()).a(178346676844393L);

        private PyDataViewCompletionProvider() {
        }

        protected void addCompletionVariants(@NotNull String text2, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
            if (text2 == null) {
                PyDataViewCompletionProvider.a(0);
            }
            if (prefix == null) {
                PyDataViewCompletionProvider.a(1);
            }
            if (result == null) {
                PyDataViewCompletionProvider.a(2);
            }
            List<PyDebugValue> list2 = this.a();
            Collections.sort(list2, Comparator.comparing(XNamedValue::getName));
            for (int i10 = 0; i10 < list2.size(); ++i10) {
                PyDebugValue pyDebugValue = list2.get(i10);
                LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)pyDebugValue.getName()).withTypeText(pyDebugValue.getType(), true);
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)lookupElementBuilder, (double)(-i10)));
            }
        }

        private List<PyDebugValue> a() {
            ArrayList<PyDebugValue> arrayList = new ArrayList<PyDebugValue>();
            try {
                XValueChildrenList xValueChildrenList = PyDataViewerPanel.this.g.loadFrame();
                if (xValueChildrenList == null) {
                    return arrayList;
                }
                for (int i10 = 0; i10 < xValueChildrenList.size(); ++i10) {
                    PyDebugValue pyDebugValue = (PyDebugValue)xValueChildrenList.getValue(i10);
                    String string = pyDebugValue.getType();
                    if (DataViewStrategy.getStrategy(string) == null) continue;
                    arrayList.add(pyDebugValue);
                }
            }
            catch (Exception exception) {
                e.error((Throwable)exception);
            }
            return arrayList;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x3C79809BC03L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/containerview/PyDataViewerPanel$PyDataViewCompletionProvider";
            objectArray[2] = "addCompletionVariants";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener {
        public void onNameChanged(String var1);
    }
}

