/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.toolbox.ChainIterable;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class DocumentationBuilderKit {
    static final TagWrapper TagBold;
    static final TagWrapper TagSmall;
    static final TagWrapper TagCode;
    static final TagWrapper TagSpan;
    @NonNls
    public static final String BR = "<br>";
    @NotNull
    static final Function<String, String> ESCAPE_ONLY;
    @NotNull
    static final Function<String, String> TO_ONE_LINE_AND_ESCAPE;
    @NotNull
    static final Function<String, String> ESCAPE_AND_SAVE_NEW_LINES_AND_SPACES;
    @NotNull
    static final Function<String, String> WRAP_IN_ITALIC;
    @NotNull
    static final Function<String, String> WRAP_IN_BOLD;
    private static final long a;

    private DocumentationBuilderKit() {
    }

    static ChainIterable<String> wrapInTag(String tag, Iterable<String> content2) {
        long l2 = a ^ 0x4E7743896440L;
        return new ChainIterable<String>("<" + tag + ">").add(content2).addItem("</" + tag + ">");
    }

    static ChainIterable<String> wrapInTag(String tag, List<? extends Pair<String, String>> attributes, Iterable<String> content2) {
        long l2 = a ^ 0xF8731A95226L;
        if (attributes.size() == 0) {
            return DocumentationBuilderKit.wrapInTag(tag, content2);
        }
        StringBuilder stringBuilder = new StringBuilder("<" + tag);
        for (Pair<String, String> pair : attributes) {
            stringBuilder.append(" ").append((String)pair.first).append("=\"").append((String)pair.second).append("\"");
        }
        stringBuilder.append(">");
        return new ChainIterable<String>(stringBuilder.toString()).add(content2).addItem("</" + tag + ">");
    }

    @NonNls
    static String combUp(@NonNls String what) {
        long l2 = a ^ 0x67E5B3F07EB4L;
        return XmlStringUtil.escapeString((String)what).replace("\n", BR).replace(" ", "&nbsp;");
    }

    static ChainIterable<String> $(String ... content2) {
        return new ChainIterable<List<String>>(Arrays.asList(content2));
    }

    static {
        a = c.a(-4556938986928013613L, -1950933189059037655L, MethodHandles.lookup().lookupClass()).a(59168312921589L);
        long l2 = a ^ 0xBB41E04BDBFL;
        TagBold = new TagWrapper("b");
        TagSmall = new TagWrapper("small");
        TagCode = new TagWrapper("code");
        TagSpan = new TagWrapper("span");
        ESCAPE_ONLY = StringUtil::escapeXmlEntities;
        TO_ONE_LINE_AND_ESCAPE = string -> ESCAPE_ONLY.apply(string.replace('\n', ' '));
        ESCAPE_AND_SAVE_NEW_LINES_AND_SPACES = string -> {
            long l2 = a ^ 0x367C4650B1FCL;
            return ESCAPE_ONLY.apply((String)string).replace("\n", BR).replace(" ", "&nbsp;");
        };
        WRAP_IN_ITALIC = string -> {
            long l2 = a ^ 0x492DFD634295L;
            return "<i>" + string + "</i>";
        };
        WRAP_IN_BOLD = string -> {
            long l2 = a ^ 0x2E5D3E41FE96L;
            return "<b>" + string + "</b>";
        };
    }

    static class TagWrapper
    implements Function<Iterable<String>, Iterable<String>> {
        private final String b;
        private final List<Pair<String, String>> a = Lists.newArrayList();

        TagWrapper(String tag) {
            this.b = tag;
        }

        public TagWrapper withAttribute(String name, String value) {
            TagWrapper tagWrapper = new TagWrapper(this.b);
            tagWrapper.a.addAll(this.a);
            tagWrapper.a.add((Pair<String, String>)Pair.create((Object)name, (Object)value));
            return tagWrapper;
        }

        @Override
        public Iterable<String> apply(Iterable<String> contents) {
            return DocumentationBuilderKit.wrapInTag(this.b, this.a, contents);
        }
    }
}

